#ifndef UCONFIGMAIN_H_
#define UCONFIGMAIN_H_

#include <afxcmn.h>
#include <afxdisp.h>

#include "Iphlpapi.h"

#define WM_NP_FIND    			     WM_USER + 2000
#define WM_BEGIN_UCONFIG_DENY        WM_USER + 2001
#define WM_BEGIN_UCONFIG_ACK         WM_USER + 2002
#define WM_CLOSE_UCONFIG_BY_HTTP     WM_USER + 2003
#define WM_CLOSE_UCONFIG_ACK         WM_USER + 2004
#define WM_PC_IP_CHANGE_ACK			 WM_USER + 2005
#define WM_CHECK_PC_IP			     WM_USER + 2006

#define WAIT_UCONFIG_ACK_TIMER_ID            1
//#define WAIT_CLOSE_UCONFIG_ACK_TIMER_ID    2    
#define UCONFIG_OK_TIMER_ID                  3
#define UCONFIG_CHECK_NIC_IP_CHANGE_TIMER_ID 4
#define UCONFIG_PC_IP_CHNAGE_TIMER_ID		 5



extern int nWaitUconfigAckTimerID ;//= 0;
extern int nUconfigStatusTimerID ;//= 0;
extern int nCheckNICIPTimerID;
extern int nWaitPCIPChangeAckTimerID; //=0;




#define UCONFIGMODE_NOTREADY              0
#define UCONFIGMODE_WAITINGFOR_ACK        1
#define UCONFIGMODE_ACKED                 2 
#define UCONFIGMODE_DENIED                3

/* SYSMSG_PACKET  is used as an interface packet between device and uConfig.exe */
typedef struct 
{
	//Below is used by all: Packet Header 
    unsigned long   magic_number;       //Packet header 1
    unsigned long   version;            //Packet header 2
    unsigned long   code;               //Packet header 3: Packet type 

    //Below is used only by device for sending packets to uConfig.exe.
    unsigned long   product_id;         //used by the packet from device during NPFind mode
    char    		product_model[32];	//used by the packet from device during NPFind mode
    char    		system_name[64];    //used by the packet from device during NPFind mode
    unsigned long   ip_address;         //used by the packet from device during NPFind mode
    unsigned long   old_ip_address;     //used if the device ip is changed. 

    //Below is used by all
    unsigned char   Src_mac[8];   // sender/Source Mac: add 2 for device memeory align
    unsigned long   Src_ip;       // sender/Source mac
    unsigned char   Dest_mac[8];  //dest mac: add 2 for device memeory align
	unsigned long   Dest_ip;      //dest IP	

	//Below varant is used by uCofig.exe to device
	unsigned long   Deceiving_Host_gateway; //uconfig.exe send packet to tell device its deceiving host Gateway.
	                                   //So that device will only send a SYSMSG_CODE_NEED_NEW_ARP packet
	                                   //to uConfig.exe if device receive a arp request packet to it. 
	                                                                    
	//compex device send it to tell uconfig.exe its stutus 	                                   
    unsigned long 	bfUconfigMode;  //0--not enter uConfig mode, 1--Already enter uConfig mode                                         
	
} SYSMSG_PACKET;

//for the list items for all already searched devices information
typedef struct 
{
	unsigned long uConfigVersion;
	char    	product_model[32];
    char    	system_name[64];
	char		IP[20];
	unsigned char Mac[6];
	int     	AdatptorIndex;  //which netowrk adaptor find the compex device
	unsigned long 	bfUconfigMode;  //0--not enter uConfig mode, 1--Already enter uConfig mode          
}NP_LIST_DATA;

//for the list items for all local network information
typedef struct 
{
	char IP[20];
	char Mask[20];
	unsigned char Mac[6];
	DWORD dwIndex;
} ADAPTER_INFO;

#define CURRENT_ADAPTOR_INDEX ( NPListArray[nSelectedNPIndex]. AdatptorIndex )

extern char DefaultDeceitGateway[20];

extern char DefaultHostRouteDest[20];
extern char DefaultHostRouteMask[20];
extern char DefaultHostRouteIP[20];
extern char DefaultHostRouteInterface[20];

extern CRITICAL_SECTION  SocketCriticalSect;

extern 					NP_LIST_DATA NPListArray[100];
extern 					ADAPTER_INFO AdaptorInfoArray[10];
extern					int listensock[10];
extern char  			DeceitGatewayIP[20];

extern int    			nSelectedNPIndex ;


extern char   			strLastDestination[100];
extern int    			nLastAdaptorIndex ;

extern BOOL 			bfFindNP ;//= FALSE;
extern int              nEnterUconfigMode; //=FALSE

#define SYSMSG_PROT_VERSION     3
#define SYSMSG_UDP_PORT         7778
#define SYSMSG_MAGIC_NUMBER     0x89168ACE

#define SYSMSG_CODE_NPFIND_QUERY   		  1  //uConfig.exe send NPFind request packet to all devices
#define SYSMSG_CODE_NPFIND_REPLY   		  2  //device send responded packet to uConfig.exe'sNPFind packet
#define SYSMSG_CODE_BEGIN_UCONFIG 		  3  //uConfig.exe Send Begin uConfig command to one selected device
#define SYSMSG_CODE_CHANGE_IP     		  4  //device send the packet to tell uConfig that its ip has benn changed
#define SYSMSG_CODE_CLOSE_UCONFIG  		  5  //uConfig and device exit uConfig mode
#define SYSMSG_CODE_NEED_NEW_ARP          6  //device send the packet to tell uConfig that it receive a arp request packet,
                                             //maybe it mean uConfig need to add a deceiving arp item into 
                                             //windows arp table.
#define SYSMSG_CODE_PC_IP_CHANGED         7  //uConfig send packet to device that PC or workstations's ip is changed,

#define SYSMSG_CODE_BEGIN_UCONFIG_ACK     60  //device send the packet to tell uConfig that it has received the uConfig command
#define SYSMSG_CODE_CHANGE_IP_ACK      	  61 //uConfig.exe send the packet to tell device that it has known the device's ip has been changed.
#define SYSMSG_CODE_CLOSE_UCONFIG_ACK     62 //device send Ack to response uconfig.exe's command SYSMSG_CODE_CLOSE_UCONFIG
#define SYSMSG_CODE_PC_IP_CHANGED_ACK     63 //device send to PC/uCOnfig that it receive the packet

#define SYSMSG_CODE_BEGIN_UCONFIG_DENY 90  //device send the packet to tell uConfig that it deny enter uConfig command,ie, maybe 
                                              //device has already eneter uConfig mode by another uConfig.exe


#define FORMAT_ERROR			  		200
#define NOT_SYSMSG_CODE_REPLY     		201
#define NOT_SYSMSG_CODE_CHANGE_IP 		202
#define NPFINDPACKET_NEW     			203
#define NPFINDPACKET_BUT_ALREAYFIND     204

//#define PACKET_OK			      		300
#define SYSMSG_MSG_MAXLEN       		1514
#define MAX_DELAY_TIME_FIND_NP      	10  //

extern CRITICAL_SECTION  SocketCriticalSect;

extern void SetAllList(CListCtrl* pNPFindList, CListCtrl *pForwardListCtrl, CListCtrl	*pNetInterfaceListCtrl);

extern PIP_ADAPTER_INFO pNetAdapterInfo;
extern PFIXED_INFO pFixedInfo;
extern PMIB_IPFORWARDTABLE pIpRouteTab ; 

extern int 	NPFind(CListCtrl	*m_NPFindListCtrl, int index);
extern int SendUConfigPacket( long cmd, char *DestIP, unsigned char *DestMac, char *SourceIP, unsigned char *SourceMac, char *DeceivingHostGateway, int nAdaptorIndex);
extern BOOL GetNetAdaptorInfo(CListCtrl	*pNetInterfaceListCtrl); //works in Window 98/2000
extern BOOL GetNetAdaptorInfo2(CListCtrl	*pNetInterfaceListCtrl); //works in Window 98/2000/NT
extern BOOL GetNetAdaptorInfo3(CListCtrl	*pNetInterfaceListCtrl); //works in Window 98/2000/NT

extern BOOL GetNetworkInfo(CStatic *pMainIPConfig_StaticCtrl);
extern BOOL DoGetIpForwardTable(CListCtrl	*pForwardListCtrl, BOOL bfUpdateVariant);

extern BOOL DoSetIpForwardEntry(char* pszDest, char* pszNetMask, char* pszGateway, char* pszInterface, DWORD dwMetric = 1);
extern void DoDeleteIpForwardEntry(char* pszDest);
extern BOOL InterfaceIdxToInterfaceIp(PMIB_IPADDRTABLE pIpAddrTable, DWORD dwIndex, char str[]);
extern BOOL InterfaceIpToIdxAndMask(PMIB_IPADDRTABLE pIpAddrTable, char str[], DWORD& dwIndex, DWORD& dwMask);
extern DWORD MyGetIpAddrTable(PMIB_IPADDRTABLE& pIpAddrTable, BOOL fOrder = FALSE);
extern DWORD MyGetIpForwardTable(PMIB_IPFORWARDTABLE& pIpRouteTab, BOOL fOrder = FALSE);
extern void PrintIpForwardTable(PMIB_IPFORWARDTABLE pIpRouteTable, CListCtrl *pForwardListCtrl, BOOL bfUpdateVariant);

extern void DoSetIpNetEntry(char* pszDottedInetAddr, char* pszPhysAddr, DWORD index = 0);
extern BOOL DoDeleteIpNetEntry(char* pszDottedInetAddr, DWORD index = 0);
extern DWORD MyGetIpAddrTable(PMIB_IPADDRTABLE& pIpAddrTable, bool fOrder);

extern BOOL BeginUconfigFunc(char *IP, char *Mac);
extern char* GetDeceitGateway(char *IP, char *mask);
extern char *GetDeviceProductName( int nSelectedNPIndex);
extern void GetMemoString( int nSelectedNPIndex, char *BufString);

extern void ExitNP_UConfig();
extern BOOL BeginNPFind();

extern char *CheckDeviceVersion( int nSelectedNPIndex);

extern BOOL GetNetAdaptorInfoViaMac(char *Mac, char *IP, char *Subnet);

extern int CreateSocket(char *BindIP, int BindPort);
extern BOOL Run_IPCONFIG( char *CmdParameter);

#endif
