// uConfigDlg.cpp : implementation file
//

#include "stdafx.h"
#include "uConfig.h"
#include "resource.h"
#include "Winsock2.h"

#include "uConfigDlg.h"
#include <string.h>
#include <stdio.h>
#include "Afxmt.h"
#include "NetworkInfoDlg.h"
#include "AboutDlg.h"
#include "UconfigUsage.h"
#include "Winsock2.h"
#include "uconfiglib\uconfigmain.h"

#include "WarningDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


HANDLE hMutex; 
char *CheckMark = "##";
BOOL bfNeedOpenDefaultBrowse = FALSE;
BOOL bfNeedReRun = FALSE;

/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CUConfigDlg dialog

CUConfigDlg::CUConfigDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUConfigDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUConfigDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32	
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	
}

void CUConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUConfigDlg)
	DDX_Control(pDX, IDC_UCONFIG_STATUS, m_uConfigStatusButton);
	DDX_Control(pDX, IDOK, m_ExitButton);
	DDX_Control(pDX, IDC_UCONFIG_BUTTON, m_BeginUconfigButton);
	DDX_Control(pDX, IDC_STATIC_NP_FIND, m_SelectedNPFindInfoCtrl);
	DDX_Control(pDX, IDC_LISTCTRL_NET_ADAPTOR, m_NetAdaptorListCtrl);
	DDX_Control(pDX, IDC_LISTCTRL_FORWARD, m_ForwardListCtrl);
	DDX_Control(pDX, IDC_LISTCTRL_NP_FIND, m_NPFindListCtrl);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUConfigDlg, CDialog)
	//{{AFX_MSG_MAP(CUConfigDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_COMMAND(ID_MENU_VERSION, OnMenuVersion)
	ON_COMMAND(ID_MENU_NETWORK_INFO, OnMenuNetworkInfo)
	ON_MESSAGE(	WM_NP_FIND, OnNPFind )
	ON_MESSAGE(	WM_PC_IP_CHANGE_ACK, OnPCIPCHANGEACK )	
	ON_MESSAGE(	WM_CHECK_PC_IP, OnCheckPCIP )	
	ON_MESSAGE(	WM_BEGIN_UCONFIG_DENY, OnRecvuConfigDeny )	
	ON_MESSAGE(	WM_BEGIN_UCONFIG_ACK, OnuRecvBeginuConfigAck )	
	ON_NOTIFY(NM_CLICK, IDC_LISTCTRL_NP_FIND, OnClickListctrlNpFind)
	ON_WM_TIMER()
	ON_NOTIFY(NM_DBLCLK, IDC_LISTCTRL_NP_FIND, OnDblclkListctrlNpFind)
	ON_BN_CLICKED(IDC_UCONFIG_BUTTON, OnBeginUconfigButton)
	ON_NOTIFY(NM_DBLCLK, IDC_LISTCTRL_FORWARD, OnDblclkListctrlForward)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUConfigDlg message handlers
void CUConfigDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.


// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUConfigDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CUConfigDlg::OnInitDialog()
{
	/*SGH add: Note, the IDC_GlobleButton button must be set ownerdraw*/
	//Note, if one control is owner-draw and is connected with a variant via DoDataExchange(...),
    //then its initialization must put before CDialog::OnInitDialog();
	m_ExitButton.SubclassDlgItem( IDOK, this );
	m_ExitButton.SetColor( RGB(255, 100, 255) );

	m_uConfigStatusButton.LoadBitmaps(IDB_RBU, IDB_RBD, IDB_RBF, IDB_RBX);

	m_BeginUconfigButton.AutoLoad(IDC_UCONFIG_BUTTON, // Resource ID
                         this,               // Parent Window
                         /*IDB_GLOBE_BUTTON,*/IDB_BITMAP4 ,  // Main Bitmap Resource ID
                         IDB_GLOBE_DISABLED, // Disabled Bitmap Resource ID
                         4,                  // Frames per Second
                         0,                  // Calculate Number of Frames
                         TRUE,              // Stretch to fit
						 TRUE,               // Replace Face Color
                         IDC_CURSOR1); // Cursor Resourse ID
						 
		
	CDialog::OnInitDialog();

      
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	CString s;

	//Only allow one instance to run at the same time	
	hMutex = CreateMutex( NULL, TRUE, "uConfig" );
	if ( GetLastError() == ERROR_ALREADY_EXISTS )
	{
		SendMessage(WM_CLOSE, 0, 0);
		return FALSE;
	}


	WSADATA wsaData;
	if (WSAStartup(0x201,&wsaData) == SOCKET_ERROR) 
	{
		AfxMessageBox("WSAStartup failed with error ");
		WSACleanup();
		return -1;
	}
		
		
    // Enable the full row selection and the drag drop of headers.
	DWORD styles = LVS_EX_FULLROWSELECT | LVS_EX_HEADERDRAGDROP | LVS_OWNERDRAWFIXED;
	// Use macro since this is new and not in MFC.
	ListView_SetExtendedListViewStyleEx(m_NetAdaptorListCtrl.m_hWnd, styles, styles );
	m_NetAdaptorListCtrl.SetTextColor(RGB(0,0,255));
			
	//styles = LVS_EX_FULLROWSELECT | LVS_EX_HEADERDRAGDROP | LVS_OWNERDRAWFIXED;
	m_NPFindListCtrl.SetTextColor(RGB(0,0,255));
	ListView_SetExtendedListViewStyleEx(m_NPFindListCtrl.m_hWnd, styles, styles );

	CRect rect;	
	m_NetAdaptorListCtrl.GetClientRect( &rect );
	m_NetAdaptorListCtrl.InsertColumn( 0, "Description", LVCFMT_LEFT, rect.Width()/5 - 2, 0 );
	m_NetAdaptorListCtrl.InsertColumn( 1, "MAC", LVCFMT_LEFT, rect.Width()/5 + 6, 0 );
	m_NetAdaptorListCtrl.InsertColumn( 2, "IP", LVCFMT_LEFT, rect.Width()/5 - 2 , 1 );
	m_NetAdaptorListCtrl.InsertColumn( 3, "Mask", LVCFMT_LEFT, rect.Width()/5 - 6  , 1 );
	m_NetAdaptorListCtrl.InsertColumn( 4, "Gateway", LVCFMT_LEFT, rect.Width()/5 - 6, 1 );
	
	//NP serial device list 
	m_NPFindListCtrl.GetClientRect( &rect );
	m_NPFindListCtrl.InsertColumn( 0, "   Product Model", LVCFMT_LEFT, rect.Width()/4 - 4 , 0 );
	m_NPFindListCtrl.InsertColumn( 1, "System Name", LVCFMT_LEFT, rect.Width()/4 - 5, 0 );
	m_NPFindListCtrl.InsertColumn( 2, "MAC", LVCFMT_LEFT, rect.Width()/4 - 5, 0 );
	m_NPFindListCtrl.InsertColumn( 3, "IP", LVCFMT_LEFT, rect.Width()/4 -12, 1 );
	m_NPFindListCtrl.InsertColumn( 4, "Memo ", LVCFMT_LEFT, rect.Width()/9 , 1 );
		
	//windows route/forward list 
	m_ForwardListCtrl.GetClientRect( &rect );	
	m_ForwardListCtrl.InsertColumn( 0, "   Network Destination", LVCFMT_LEFT, rect.Width()/4 - 4, 0 );
	m_ForwardListCtrl.InsertColumn( 1, "Netmask", LVCFMT_LEFT, rect.Width()/5 -4, 0 );
	m_ForwardListCtrl.InsertColumn( 2, "Gateway", LVCFMT_LEFT, rect.Width()/5 -4, 0 );
	m_ForwardListCtrl.InsertColumn( 3, "Interface", LVCFMT_LEFT, rect.Width()/5 - 4, 1 );
	m_ForwardListCtrl.InsertColumn( 4, "Metric", LVCFMT_LEFT, rect.Width()/8 - 4, 1 );

	SetAllList(&m_NPFindListCtrl,&m_ForwardListCtrl, &m_NetAdaptorListCtrl);

	//Get every ethernet adaptor information
	GetNetAdaptorInfo3( &m_NetAdaptorListCtrl); //support windows 98/2000/NT
		
	if( m_NetAdaptorListCtrl.GetItemCount() == 0) 
	{
		AfxMessageBox("No Network Adaptor found\r\n uConfig cannot be executed.\r\n Please verify your network connections.");
		SendMessage(WM_CLOSE, 0, 0);
	}

	//check network status(mainly for windows 2000)
	int j;
	for( j= 0; j<m_NetAdaptorListCtrl.GetItemCount(); j++)
	{
		if( inet_addr(AdaptorInfoArray[j].IP) != 0) 
			break;

	}	
	if( j == m_NetAdaptorListCtrl.GetItemCount() )
	{
		AfxMessageBox("IP address was set to zero or\r\n error in IP configuration or IP conflict\r\n uConfig cannot be executed.\r\n Please verify your network connections.");
		return FALSE;
	}
	
	//Find compex NP Device		
	int kkk=m_NetAdaptorListCtrl.GetItemCount();
	if( ! BeginNPFind() )
	{
		return FALSE;
	}

	DoGetIpForwardTable( &m_ForwardListCtrl, FALSE);
	m_BeginUconfigButton.EnableWindow(FALSE);
	
	
	m_uConfigStatusButton.SetButtonState(BUTTON_ON);
	m_uConfigStatusButton.ShowWindow( SW_HIDE);
	
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
/**********************************************
wParam: the number of compex device. 
        In fact, it value is 0 or 1;
lParam: the seclect Net Adaptor No.
**********************************************/
void CUConfigDlg::OnNPFind( WPARAM wParam, LPARAM lParam )
{
	CString s;
	LV_ITEM lv_item;
	char Buf[20];
	

	if( wParam == 0)
	{   //Not Find any compex device		
		
		bfFindNP = FALSE;
		lv_item.mask = LVIF_TEXT;
		lv_item.cchTextMax = 255;

		//product model
		lv_item.iItem = 0;
		lv_item.iSubItem = 0;
		lv_item.pszText = "Not Found!";
		m_NPFindListCtrl.InsertItem( &lv_item );

		//system name
		lv_item.iSubItem = 1;
		lv_item.pszText = "Not Found!";;
		m_NPFindListCtrl.SetItem( &lv_item );
        
		//IP
		lv_item.iSubItem = 2;
		lv_item.pszText = "Not Found!";
		m_NPFindListCtrl.SetItem( &lv_item ); 
		
		//m_OKButton.EnableWindow(TRUE);
	}
	else //find compex np device
	{
		if( !bfFindNP )
		{  //first Device find
			bfFindNP = TRUE;
			m_NPFindListCtrl.SetItem(0, 0, LVIF_STATE, NULL, 0, LVIS_SELECTED, LVIS_SELECTED, 0);
			//m_OKButton.EnableWindow(TRUE);
			m_BeginUconfigButton.EnableWindow(TRUE);

			//Update the show mode of selected compex device
			//m_NPFindListCtrl.SetItem( nSelectedNPIndex, 0, LVIF_STATE, NULL, 0, LVIS_SELECTED, LVIS_SELECTED, 0);
			s.Format("Compex Products List----Current Selected %d", nSelectedNPIndex + 1);	
			m_SelectedNPFindInfoCtrl.SetWindowText(s);

			lv_item.mask = LVIF_TEXT;
			lv_item.cchTextMax = 255;
			lv_item.iItem = wParam-1;//nSelectedNPIndex;
			lv_item.iSubItem = 4;
			GetMemoString(nSelectedNPIndex, Buf);
			strcat( Buf, CheckMark);
			
			lv_item.pszText = Buf;
			m_NPFindListCtrl.SetItem( &lv_item );
		}		

	}
}

void CUConfigDlg::OnRecvuConfigDeny( WPARAM wParam, LPARAM lParam )
{	
	CString s = "This uConfig session is denied by ";
	s += GetDeviceProductName(nSelectedNPIndex);
	s += " . Please verify if another uConfig session is activate.";


	//delete the deceving arp item 
	DoDeleteIpNetEntry( DefaultDeceitGateway, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );
	
	//Delete the deceiving host route item I added for uConfig		
	DoDeleteIpForwardEntry(NPListArray[nSelectedNPIndex].IP);

	if( strlen( DefaultHostRouteDest ) > 0) 
	{  //restore the old default host route which is delete for uConfig.		   
	   DoSetIpForwardEntry( DefaultHostRouteDest, DefaultHostRouteMask, DefaultHostRouteIP, DefaultHostRouteInterface, 1);	
	}
	nEnterUconfigMode = UCONFIGMODE_NOTREADY; //For renew 
	m_BeginUconfigButton.EnableWindow( TRUE ); 

	MessageBox(s);
}

void CUConfigDlg::OnuRecvBeginuConfigAck( WPARAM wParam, LPARAM lParam )
{
	//Open default browser
	LV_ITEM lv_item;
	char Buf[20];

	lv_item.mask = LVIF_TEXT;
	lv_item.cchTextMax = 255;
	lv_item.iItem = nSelectedNPIndex;
	lv_item.iSubItem = 4;
	GetMemoString(nSelectedNPIndex, Buf);
	strcat( Buf, CheckMark);
	/*
	CString s;
	s.Format(" (%d NIC) ", CURRENT_ADAPTOR_INDEX + 1);
	strcat( Buf, s);
	*/

	lv_item.pszText = Buf;
	m_NPFindListCtrl.SetItem( &lv_item );

	m_BeginUconfigButton.EnableWindow( TRUE ); 

	if( bfNeedOpenDefaultBrowse )
	{
		CString website;
		website.Format("http://%s", NPListArray[nSelectedNPIndex].IP );
		ShellExecute( GetSafeHwnd(), "Open",website, 
			NULL,NULL, SW_SHOWNORMAL);	
		//ShowWindow(SW_SHOWMINIMIZED);		
	}
	
	if( nUconfigStatusTimerID == 0) 
	{
		m_uConfigStatusButton.ShowWindow( SW_SHOW);
		nUconfigStatusTimerID = SetTimer(UCONFIG_OK_TIMER_ID, 500, NULL); //wait for 20s
	}

	if( nCheckNICIPTimerID == 0) 
	{
		nCheckNICIPTimerID = SetTimer( UCONFIG_CHECK_NIC_IP_CHANGE_TIMER_ID, 4000, NULL); //wait for 20s
	}
}

BOOL CUConfigDlg::OnInitBeginUconfig() 
{
	char *res; 
		
	if( nEnterUconfigMode == UCONFIGMODE_NOTREADY)
	{		
		if( (res = CheckDeviceVersion(nSelectedNPIndex)) != NULL )
		{
			AfxMessageBox( res);
			return FALSE;
		}		
		
		m_BeginUconfigButton.EnableWindow( FALSE ); //Now not let click again
	
		nEnterUconfigMode = UCONFIGMODE_WAITINGFOR_ACK;
		DoGetIpForwardTable( &m_ForwardListCtrl, TRUE);
		strcpy( DefaultDeceitGateway, GetDeceitGateway(AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].Mask) );

		if( strlen( DefaultHostRouteDest ) > 0) 
		{  //there is a default host route item in the route table same with my deceitgateway for uCOnfig.
		   //So temporary delete it.
		   DoDeleteIpForwardEntry(DefaultHostRouteDest);
		}

		//Set my new host route gateway item in the route table 		
		DoSetIpForwardEntry( NPListArray[nSelectedNPIndex].IP, "255.255.255.255", DefaultDeceitGateway, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP,1);
		
		//Set deceving arp item in the arp table 
		DoSetIpNetEntry(DefaultDeceitGateway,(char *)NPListArray[nSelectedNPIndex].Mac,AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );

		for( int k= 0; k<2; k++ )
		{  //send Begin uConfig command to compex device
			SendUConfigPacket(  SYSMSG_CODE_BEGIN_UCONFIG, 
				            	NPListArray[nSelectedNPIndex].IP, 
						   		NPListArray[nSelectedNPIndex].Mac, 
						   		AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP,
						   		AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].Mac, 
						   		DefaultDeceitGateway, CURRENT_ADAPTOR_INDEX);
			Sleep(10);
		}

		if( nWaitUconfigAckTimerID != 0 )
		{
			KillTimer(WAIT_UCONFIG_ACK_TIMER_ID );
			nWaitUconfigAckTimerID = 0;
		}

		nWaitUconfigAckTimerID = SetTimer(WAIT_UCONFIG_ACK_TIMER_ID, 5000, NULL); //wait for 20s
	}

	return TRUE;
}

void CUConfigDlg::OnBeginUconfigButton() 
{
	// TODO: Add your control notification handler code here
    //Now Begin Enter uConfig mode at first
	//Get route/forward info.
	bfNeedOpenDefaultBrowse = TRUE;


	if( nEnterUconfigMode == UCONFIGMODE_NOTREADY)
	{
		OnInitBeginUconfig();
	}
	else if( nEnterUconfigMode == UCONFIGMODE_ACKED)
	{
		CString website;
		website.Format("http://%s", NPListArray[nSelectedNPIndex].IP );
		ShellExecute( GetSafeHwnd(), "Open",website, 
		NULL,NULL, SW_SHOWNORMAL);			
	}	
}



void CUConfigDlg::OnClickListctrlNpFind(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	CString s;
	LV_ITEM lv_item;
	char Buf[20];
	
	if( pNMListView->iItem < 0 || pNMListView->iItem >= m_NPFindListCtrl.GetItemCount() )
		return ;

	if( nEnterUconfigMode != UCONFIGMODE_NOTREADY)
	{   // Not allowed to modify the selected compex device for uConfig.
	    //If you want to select another device to uConfig. You must exit the uConfig and re-run again.
		m_NPFindListCtrl.SetItem( nSelectedNPIndex, 0, LVIF_STATE, NULL, 0, LVIS_SELECTED, LVIS_SELECTED, 0);
		return ;
	}

	//If not entered the uConfig mode, then allow it to select which compex device for uConfig.
	if( pNMListView->iItem >=0 && pNMListView->iItem <= m_NPFindListCtrl.GetItemCount() )
	{
		//delete old selected device mark
		lv_item.mask = LVIF_TEXT;
		lv_item.cchTextMax = 255;
		lv_item.iItem = nSelectedNPIndex;
		lv_item.iSubItem = 4;
		GetMemoString(nSelectedNPIndex, Buf);
		lv_item.pszText = Buf;
		m_NPFindListCtrl.SetItem( &lv_item );

		//renew the index of selected compex device
		nSelectedNPIndex = pNMListView->iItem;

		//add the new selected device mark
		lv_item.iItem = nSelectedNPIndex;
		lv_item.iSubItem = 4;
		GetMemoString(nSelectedNPIndex, Buf);
		strcat( Buf, CheckMark);
		
		lv_item.pszText = Buf;
		m_NPFindListCtrl.SetItem( &lv_item );

		m_NPFindListCtrl.SetItem( nSelectedNPIndex, 0, LVIF_STATE, NULL, 0, LVIS_SELECTED, LVIS_SELECTED, 0);
		s.Format("Compex Products List----Current Selected %d", nSelectedNPIndex + 1);
		m_SelectedNPFindInfoCtrl.SetWindowText(s);
	}
	
	*pResult = 0;
}

/*Enter the uConfig mode directly if it hasn't enter the uConfig mode*/
void CUConfigDlg::OnDblclkListctrlNpFind(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	LV_ITEM lv_item;
	char Buf[20];
	CString s;
	
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	if( nEnterUconfigMode != UCONFIGMODE_NOTREADY ) //not allowed now
		return;
	if( pNMListView->iItem < 0 || pNMListView->iItem >= m_NPFindListCtrl.GetItemCount() )
		return ;

	if( pNMListView->iItem >=0 && pNMListView->iItem <= m_NPFindListCtrl.GetItemCount() )
	{
		//delete old selected device mark
		lv_item.mask = LVIF_TEXT;
		lv_item.cchTextMax = 255;
		lv_item.iItem = nSelectedNPIndex;
		lv_item.iSubItem = 4;
		GetMemoString(nSelectedNPIndex, Buf);
		lv_item.pszText = Buf;
		m_NPFindListCtrl.SetItem( &lv_item );

		//renew the index of selected compex device
		nSelectedNPIndex = pNMListView->iItem;

		//add the new selected device mark
		lv_item.iItem = nSelectedNPIndex;
		lv_item.iSubItem = 4;
		GetMemoString(nSelectedNPIndex, Buf);
		strcat( Buf, CheckMark);
		
		lv_item.pszText = Buf;
		m_NPFindListCtrl.SetItem( &lv_item );

		m_NPFindListCtrl.SetItem( nSelectedNPIndex, 0, LVIF_STATE, NULL, 0, LVIS_SELECTED, LVIS_SELECTED, 0);
		s.Format("Compex Products List----Current Selected %d", nSelectedNPIndex + 1);
		m_SelectedNPFindInfoCtrl.SetWindowText(s);
	}
	
	
	if( bfFindNP && (nEnterUconfigMode == UCONFIGMODE_NOTREADY) )
	{
		bfNeedOpenDefaultBrowse = FALSE;

		nSelectedNPIndex = pNMListView->iItem; 
		OnInitBeginUconfig();
	}
	
	*pResult = 0;
}


void CUConfigDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CString s;
	
	if( nIDEvent == WAIT_UCONFIG_ACK_TIMER_ID )
	{   
		if( nWaitUconfigAckTimerID != 0) 
		{
			KillTimer( WAIT_UCONFIG_ACK_TIMER_ID );
			nWaitUconfigAckTimerID = 0;
		}
		if( nEnterUconfigMode == UCONFIGMODE_WAITINGFOR_ACK )
		{  //not receive device's ACK reponse, so refresh nEnterUconfigMode
			nEnterUconfigMode = UCONFIGMODE_NOTREADY; //For renew 
			s = "There is no response from ";
			s += GetDeviceProductName(nSelectedNPIndex);
			MessageBox(s);
			m_BeginUconfigButton.EnableWindow( TRUE ); 
		}
	}
	else if( nIDEvent == UCONFIG_OK_TIMER_ID )
	{
		static BYTE i = 0;
		if( ( i % 2 )== 0 ) 
			m_uConfigStatusButton.SetButtonState(BUTTON_ON);
		else 
			m_uConfigStatusButton.SetButtonState(BUTTON_OFF);
		i++;
	}
	else if( nIDEvent == UCONFIG_PC_IP_CHNAGE_TIMER_ID )
	{	
		if( m_BeginUconfigButton.IsWindowEnabled() )
		SendUConfigPacket(  SYSMSG_CODE_PC_IP_CHANGED, 
				            NPListArray[nSelectedNPIndex].IP, 
						   	NPListArray[nSelectedNPIndex].Mac, 
						   	AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP,
						   	AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].Mac, 
						   	DefaultDeceitGateway, CURRENT_ADAPTOR_INDEX);
	    
	}
	else if( nIDEvent == UCONFIG_CHECK_NIC_IP_CHANGE_TIMER_ID )
	{	
#if 0	
		OnCheckPCIP(0,0);
#endif
		CDialog::OnTimer(nIDEvent);

		return;
		char NIC_IP[20], NIC_NetMask[20];

		int nCurrentAdaptorIndex = CURRENT_ADAPTOR_INDEX;


	#if 0
		if(  GetNetAdaptorInfoViaMac( (char *)(AdaptorInfoArray[ nCurrentAdaptorIndex ].Mac) , NIC_IP, NIC_NetMask )  && !bfNeedReRun ) 
		{			
			if( strcmp( NIC_IP, (char*) (AdaptorInfoArray[ NPListArray[nSelectedNPIndex]. AdatptorIndex ].IP) ) != 0 )
			{	//close its old socket for the network interface's ip is changed
			
				closesocket( listensock[nCurrentAdaptorIndex]);
				listensock[nCurrentAdaptorIndex] = 0;

				//re create socket
				//strcpy( AdaptorInfoArray[ nCurrentAdaptorIndex ].IP, NIC_IP ); //cannot do it, otherwise device will cannot receive late packet
				listensock[nCurrentAdaptorIndex] = CreateSocket( NIC_IP, SYSMSG_UDP_PORT);
				
				//clear old deceit route table and arp table
				if( strlen( DefaultDeceitGateway ) > 0) 
				{  //there is a default host route item in the route table same with my deceitgateway for uCOnfig.
				   //So temporary delete it.
				   DoDeleteIpForwardEntry(DefaultDeceitGateway);
				}
				DoDeleteIpNetEntry( DefaultDeceitGateway, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );
			
				//get new decei gateway
				strcpy( DefaultDeceitGateway, GetDeceitGateway(NIC_IP, NIC_NetMask) );

				DoSetIpForwardEntry( NPListArray[nSelectedNPIndex].IP, "255.255.255.255", DefaultDeceitGateway, NIC_IP,1);
				
				//Set deceving arp item in the arp table 
				DoSetIpNetEntry(DefaultDeceitGateway,(char *)NPListArray[nSelectedNPIndex].Mac,AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );


				bfNeedReRun = TRUE;
				PostMessage(WM_CLOSE);
			}
		}
	#endif
	

	}
	
	CDialog::OnTimer(nIDEvent);
}


void CUConfigDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	if( nWaitUconfigAckTimerID != 0) 
	{
		KillTimer( WAIT_UCONFIG_ACK_TIMER_ID );
		nWaitUconfigAckTimerID = 0;
	}

	if( nCheckNICIPTimerID != 0 )
	{
		KillTimer( UCONFIG_CHECK_NIC_IP_CHANGE_TIMER_ID );
		nCheckNICIPTimerID = 0;
	}

	if( nUconfigStatusTimerID != 0) 
	{
		KillTimer( UCONFIG_OK_TIMER_ID );
		nUconfigStatusTimerID = 0;
	}

	/*First tell compex device that uConfig.exe want to terminat */
	if( bfFindNP && nEnterUconfigMode !=  UCONFIGMODE_NOTREADY)
	{
		for( int k= 0; k<10; k++ )
		{
			int res = SendUConfigPacket( SYSMSG_CODE_CLOSE_UCONFIG, NPListArray[nSelectedNPIndex].IP, 
						   NPListArray[nSelectedNPIndex].Mac, 
						   AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP,
						   AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].Mac, 
						   DefaultDeceitGateway,
						   CURRENT_ADAPTOR_INDEX );
			Sleep(3);
		}
	
		
		//delete the deceving arp item 
		DoDeleteIpNetEntry( DefaultDeceitGateway, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );
	
		//Delete the deceiving host route item I added for uConfig		
		DoDeleteIpForwardEntry(NPListArray[nSelectedNPIndex].IP);

		if( strlen( DefaultHostRouteDest ) > 0) 
		{  //restore the old default host route which is delete for uConfig.		   
		   DoSetIpForwardEntry( DefaultHostRouteDest, DefaultHostRouteMask, DefaultHostRouteIP, DefaultHostRouteInterface, 1);	
		}
	}
	
	ExitNP_UConfig();
	WSACleanup();

	CloseHandle( hMutex );	
		
	if( bfNeedReRun )
	{
		PROCESS_INFORMATION piProcInfo;
		STARTUPINFO siStartupInfo;
		//char Buf[500];
		char* FileName ="uConfig.exe";

		siStartupInfo.cb = sizeof(STARTUPINFO);
		siStartupInfo.lpReserved = NULL;
		siStartupInfo.lpDesktop = NULL;
		siStartupInfo.lpTitle = NULL;
		siStartupInfo.dwFlags = STARTF_USESHOWWINDOW;
		siStartupInfo.wShowWindow = SW_SHOWNORMAL;
		siStartupInfo.cbReserved2 = 0;
		siStartupInfo.lpReserved2 = NULL;
		
		//int len = GetCurrentDirectory(sizeof(Buf)-1, Buf);
		//if( len != 0 ) 
		Sleep(5000); //for some device reboot is too slow
		{
			CreateProcess( FileName, NULL, NULL, NULL, TRUE, NORMAL_PRIORITY_CLASS, NULL, NULL, &siStartupInfo, &piProcInfo );
		}		
	}	
}



void CUConfigDlg::OnMenuVersion() 
{
	// TODO: Add your command handler code here
	CAboutDlg	dlg;
	dlg.DoModal();
}


void CUConfigDlg::OnMenuNetworkInfo() 
{
	// TODO: Add your command handler code here
	CNetworkInfoDlg dlg;
	dlg.DoModal();	
}


/*Hi, 
  This function is only for me to terminate the uconfig and 
  rerun it in order to reboot my device 
  Method: double click the button two times at very short time
  ( 5 seconds)
*/
#define INTERVIAL_TIME 5 //SECONDS  
void CUConfigDlg::OnDblclkListctrlForward(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	static int times = 0;
	static COleDateTime LastTime, CurrentTime;


	if( times == 0) 
	{
		LastTime.GetCurrentTime();
		times ++;
		return ;
	}

	CurrentTime.GetCurrentTime();
	COleDateTimeSpan SpanTime = CurrentTime - LastTime;
	if( SpanTime.GetSeconds() > INTERVIAL_TIME )
	{  //time out
		times = 0;
		return ;
	}


	bfNeedReRun = TRUE;
	PostMessage(WM_CLOSE);	
	
	*pResult = 0;
}


void CUConfigDlg::OnPCIPCHANGEACK( WPARAM wParam, LPARAM lParam )
{
	if( nWaitPCIPChangeAckTimerID != 0) 
	{
		KillTimer(nWaitPCIPChangeAckTimerID);
		nWaitPCIPChangeAckTimerID = NULL;
	}
}

void CUConfigDlg::OnCheckPCIP( WPARAM wParam, LPARAM lParam )
{
#if 0
	char NIC_IP[20];
	char NIC_NetMask[20];

	int nCurrentAdaptorIndex = CURRENT_ADAPTOR_INDEX;
		
	if( GetNetAdaptorInfoViaMac( (char *)(AdaptorInfoArray[ nCurrentAdaptorIndex ].Mac) , NIC_IP, NIC_NetMask ) )
	{			
		if( strcmp( NIC_IP, (char*) (AdaptorInfoArray[ NPListArray[nSelectedNPIndex]. AdatptorIndex ].IP) ) != 0 &&	inet_addr( NIC_IP ) != 0 )
		{	//close its old socket for the network interface's ip is changed
					
			//re create socket
			closesocket( listensock[nCurrentAdaptorIndex]);
			listensock[nCurrentAdaptorIndex] = 0;
			listensock[nCurrentAdaptorIndex] = CreateSocket( NIC_IP, SYSMSG_UDP_PORT);
		}
		if( 1) //strcmp( NIC_IP, (char*) (AdaptorInfoArray[ NPListArray[nSelectedNPIndex]. AdatptorIndex ].IP) ) != 0 &&	inet_addr( NIC_IP ) != 0 )
		{  /*I don't know why must do it */
			//clear old deceit route table and arp table
			if( strlen( DefaultDeceitGateway ) > 0) 
			{  
			   DoDeleteIpForwardEntry(DefaultDeceitGateway);
			}
			DoDeleteIpNetEntry( DefaultDeceitGateway, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );
		
			//get new deceit gateway
			strcpy( AdaptorInfoArray[ nCurrentAdaptorIndex ].IP, NIC_IP ); //cannot do it, otherwise device will cannot receive late packet
			strcpy( AdaptorInfoArray[ nCurrentAdaptorIndex ].Mask, NIC_NetMask);
			strcpy( DefaultDeceitGateway, GetDeceitGateway(NIC_IP, NIC_NetMask) );
			DoSetIpForwardEntry( NPListArray[nSelectedNPIndex].IP, "255.255.255.255", DefaultDeceitGateway, NIC_IP,1);
			
			//Set deceving arp item in the arp table 
			DoSetIpNetEntry(DefaultDeceitGateway,(char *)NPListArray[nSelectedNPIndex].Mac,AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );

			//tell device that its ip is changed
			for( int k= 0; k<2; k++ )
			{  //send Begin uConfig command to compex device
				SendUConfigPacket(  SYSMSG_CODE_PC_IP_CHANGED, 
				            		NPListArray[nSelectedNPIndex].IP, 
						   			NPListArray[nSelectedNPIndex].Mac, 
						   			AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP,
						   			AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].Mac, 
						   			DefaultDeceitGateway, CURRENT_ADAPTOR_INDEX);
			}
			if( nWaitPCIPChangeAckTimerID == 0 )
				nWaitPCIPChangeAckTimerID = SetTimer(UCONFIG_PC_IP_CHNAGE_TIMER_ID, 500, NULL);

			//refresh adaptor list
			LV_ITEM lv_item;
			lv_item.mask = LVIF_TEXT;
			lv_item.cchTextMax = 255;
			lv_item.iItem = CURRENT_ADAPTOR_INDEX;
			lv_item.iSubItem = 2; //ip
			lv_item.pszText = AdaptorInfoArray[ CURRENT_ADAPTOR_INDEX ].IP;
			m_NetAdaptorListCtrl.SetItem( &lv_item );			
		}

		m_BeginUconfigButton.EnableWindow(TRUE);
	}		
	else 
	{	
		m_BeginUconfigButton.EnableWindow(FALSE);
		Run_IPCONFIG(" /renew");
	}
#endif
}

int CUConfigDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	
	return 0;
}
