#include "stdafx.h"
#include "stock.h"


Stock::~Stock()
{
}

Stock::Stock()
{
	nCurrentAlpha = 0;
	nNextAlpha = 0;
	nStocks = 0;

	//lastStockTime ;
	//lastAnnounceInfoTime;


	memset( &StockInfo, 0, sizeof(StockInfo));
}

void  Stock::Init()
{
	FILE *fp = fopen(MY_STOCK_FILENAME, "rb");
	if( fp == NULL )
	{
		return;
	}

	fseek(fp, 0, SEEK_END );
	ULONG len = ftell(fp);
	fseek(fp, 0, SEEK_SET );
	if( (len % sizeof(StockInfo[0].StockInfo1) )== 0 )
	{
		int res;

		nStocks = len / sizeof(StockInfo[0].StockInfo1);
		
		for(int i=0; i<nStocks; i++ )
			res = fread(&StockInfo[i].StockInfo1, sizeof(StockInfo[0].StockInfo1), 1, fp);
	}

	fp = fopen(MY_STOCK_FILENAME_TMP, "rb");
	if( fp == NULL )
	{
		return;
	}

	fseek(fp, 0, SEEK_END );
	len = ftell(fp);
	fseek(fp, 0, SEEK_SET );
	if( (len % sizeof(StockInfo[0].StockInfo2) )== 0 )
	{
		int res;

		nStocks = len / sizeof(StockInfo[0].StockInfo2);
		
		for(int i=0; i<nStocks; i++ )
			res = fread(&StockInfo[i].StockInfo2, sizeof(StockInfo[0].StockInfo2), 1, fp);
	}

	for(int i=0; i<nStocks; i++)
		StockInfo[i].StockInfo2.FlagAnnounce = 0; //just run the application */
	
	ReOrderAlphaList();


	fp = fopen(MY_STOCK_FILENAME_WARN, "rb");
	if( fp == NULL )
	{
		return;
	}

	fread(&Warning, sizeof(Warning), 1, fp);
	fclose(fp);
}


char *Stock::GetNextUrl(void)
{
	int times = 0;

	if( nStocks == 0 )
	{
		return NULL;
	}

	nCurrentAlpha = nNextAlpha;

	while(AlphaList[nCurrentAlpha].Index[0] == 0 )
	{ /*try to find a valid url */
		nCurrentAlpha ++;
		times ++;

		if( nCurrentAlpha >= STOCK_PAGES )
			nCurrentAlpha = 0;

		if( times > STOCK_PAGES )  // in case cause dead-loop here
			return NULL;

		if( nStocks == 0 )
		{ /* nStocks may be changed outside the thread */
			return NULL;
		}
	}


	if( nCurrentAlpha <= STOCK_PAGES - 2 )
	{
		strncpy(URL, url_template_alpha, URL_MAX_LENGTH);
		URL[strlen(URL)-1]='A' + nCurrentAlpha ;
	}
	else 
	{
		strncpy(URL, url_template_num, URL_MAX_LENGTH);
	}


	nNextAlpha ++;
	if( nNextAlpha >= STOCK_PAGES ) 
		nNextAlpha = 0;

	return URL;
}



BOOL Stock::AddNewStock(StockElement *pElement)
{

#if 0
	//check whether there are delete flag in the array already.
	//If yes, just reuse it.
	for(int i=0; i<nStocks; i++)
	{
		if( StockInfo[nStocks].StockInfo1.StockName[0] == 0 )
		{  //note, no need to modify nStocks in this case
			StockInfo[nStocks] = *pElement;
			return TRUE;
		}

	}
#endif

	if( nStocks <= URL_MAX_LENGTH )
	{
		StockInfo[nStocks] = *pElement;
		nStocks ++;

		return TRUE;
	}

	return FALSE; 
}

void Stock::SaveMyStock(int type)
{
	FILE *fp;
	
	if( type == SAVE_TYPE_MAIN_STOCK_INFO)
	{
		fp= fopen(MY_STOCK_FILENAME, "wb+");
	}
	else if( type == SAVE_TYPE_OTHER_STOCK_INFO)
	{
		fp= fopen(MY_STOCK_FILENAME_TMP, "wb+");
	}
	else if( type == SAVE_TYPE_WARNING)
	{
		fp= fopen(MY_STOCK_FILENAME_WARN, "wb+");
	}
	else return;

	int res;

	if( fp == NULL )
	{
		return;
	}
	
	for(int i=0; i<nStocks; i++ )
	{
		if( type == SAVE_TYPE_MAIN_STOCK_INFO )
			res = fwrite(&StockInfo[i].StockInfo1, sizeof(StockInfo[0].StockInfo1), 1, fp);
		else if( type == SAVE_TYPE_OTHER_STOCK_INFO )
			res = fwrite(&StockInfo[i].StockInfo2, sizeof(StockInfo[0].StockInfo2), 1, fp);
		else if( type == SAVE_TYPE_WARNING )
			res = fwrite(&Warning, sizeof(Warning), 1, fp);
		
	}

	
	fclose(fp);	
}


void Stock::SaveMyStock()
{
	SaveMyStock(SAVE_TYPE_MAIN_STOCK_INFO);
	SaveMyStock(SAVE_TYPE_OTHER_STOCK_INFO);
}

BOOL  Cal_P_L(StockElement* pStockElement, char *buf1, char *buf2)
{
	int SoldNum = 0;

	float f1 = 0;
	float f2 = 0;

	if( pStockElement->StockInfo1.Quantity == 0 ||
		/*pStockElement->StockInfo2.PriceLastDone == 0 ||*/
		pStockElement->StockInfo2.PriceSelling == 0 ||
		pStockElement->StockInfo1.BuyInPrice == 0 ) /*NO BUY IN AT ALL or not get related price info*/
		return FALSE;
	
	for( int i=0; i<MAX_SOLD_TIMES; i++) 
	{
		SoldNum += pStockElement->StockInfo1.QuantitySold[i];		
	}

	if( pStockElement->StockInfo1.Quantity - SoldNum == 0 ) /*All sold out already */
	{	
		f1 = 0;

		for( int i=0; i<MAX_SOLD_TIMES; i++) 
		{
			f1 += pStockElement->StockInfo1.QuantitySold[i] * pStockElement->StockInfo1.SoldPrice[i];		
		}

		f1 = f1 - pStockElement->StockInfo1.Quantity * pStockElement->StockInfo1.BuyInPrice;
		sprintf(buf1, "%.0f", f1 );
	}
	else if( pStockElement->StockInfo2.PriceLastDone != 0 )
	{
		f1 = ( pStockElement->StockInfo1.Quantity - SoldNum ) *(float) ( pStockElement->StockInfo2.PriceLastDone - pStockElement->StockInfo1.BuyInPrice );
		sprintf(buf1, "%.0f", f1 );
	}
	else
	{
		strcpy(buf1, "-");
	}

	f2 = ( pStockElement->StockInfo1.Quantity - SoldNum ) *(float) ( pStockElement->StockInfo2.PriceSelling - pStockElement->StockInfo1.BuyInPrice );
	sprintf(buf2, "%.0f", f2 );

	return TRUE;
}

void Stock::SumUp(float *AllStockCost, float *LastDoneStockSum, float *SellingStockSum)
{
	char buf1[50];
	char buf2[50];

	if( AllStockCost == NULL ||
		LastDoneStockSum == NULL || 
		SellingStockSum == NULL ) return ;

	*AllStockCost = 0;
	*LastDoneStockSum = 0;
	*SellingStockSum = 0;

	for(int i=0; i<nStocks; i++)
	{
		if( StockInfo[i].StockInfo1.Quantity != 0 )
		{
			*AllStockCost += StockInfo[i].StockInfo1.Quantity * StockInfo[i].StockInfo1.BuyInPrice;
			Cal_P_L( &StockInfo[i], buf1, buf2);

			*LastDoneStockSum += (float )atof( buf1) ;
			*SellingStockSum += (float ) atof( buf2) ;
		}
	}
}

void Stock::ReOrderAlphaList()
{
	int num;
	memset( AlphaList, 0, sizeof(AlphaList) );


	for( int i=0; i<STOCK_PAGES; i++)
	{
		num = 0;

		if(  i != STOCK_PAGES - 1)
		{
			for(int j=0; j<nStocks; j++)
			{
				if( StockInfo[j].StockInfo1.StockName[0] == 'A' + i || StockInfo[j].StockInfo1.StockName[0] == 'a' + i )
				{
					AlphaList[i].Index[num] = j + 1;	
					num ++;			
				}				
			}
		}
		else
		{
			for(int j=0; j<nStocks; j++)
			{
				if( StockInfo[j].StockInfo1.StockName[0] >='0' && StockInfo[j].StockInfo1.StockName[0] <= '9' )
				{
					AlphaList[i].Index[num] = j + 1;	
					num ++;	
				}
				
			}
		}
	}

	num = 0;
	for( i=0; i<STOCK_PAGES; i++)
	{
		for(int j=0; j<MAX_STOCK_NUM; j++)
		{
			if( AlphaList[i].Index[j] ) 
				num ++;
		}
	}

	if( num != nStocks)
	{ //error here
		num = num;
	}
}