#include "stdafx.h"
#include "curl-7.16.0\include\curl\curl.h"
#include "curl-7.16.0\include\curl\easy.h"
#include "curl_interface.h"



CURL_operations::CURL_operations() {
	// Initialize
	_defaultTimeout = 60;

	_curlGetHandle = NULL;
	_curlPostHandle = NULL;

	//init_curlPostHandle();
	init_curlGetHandle();
}

CURL_operations::~CURL_operations() {

	if(_curlGetHandle) {
		curl_easy_cleanup(_curlGetHandle);
		_curlGetHandle = NULL;
	}

	if(_curlPostHandle) {
		curl_easy_cleanup(_curlPostHandle);
		_curlPostHandle = NULL;
	}


}


int CURL_operations::init_curlGetHandle()
{
	if(_curlGetHandle)
		return 1;

	_curlGetHandle = curl_easy_init();

	if (!_curlGetHandle) 
		return 0;
	else {
		
		//curl_easy_setopt(curlHandle, CURLOPT_VERBOSE, TRUE);

		// Set a default timeout, do not signal
		curl_easy_setopt(_curlGetHandle, CURLOPT_TIMEOUT, _defaultTimeout);
		curl_easy_setopt(_curlGetHandle, CURLOPT_NOSIGNAL, TRUE);

		// We are trying to get a page
		curl_easy_setopt(_curlGetHandle, CURLOPT_HTTPGET, TRUE);

		// Data sink to collect the result of the operation
		curl_easy_setopt(_curlGetHandle, CURLOPT_WRITEFUNCTION, CURL_operations::curl_write_callback);
	} 
	return 1;
}

int CURL_operations::init_curlPostHandle()
{
	if(_curlPostHandle)
		return 1;

	_curlPostHandle = curl_easy_init();

	if (!_curlPostHandle) 
		return 0;
	else {
		
		//curl_easy_setopt(curlHandle, CURLOPT_VERBOSE, TRUE);

		// Set a default timeout, do not signal
		curl_easy_setopt(_curlPostHandle, CURLOPT_TIMEOUT, _defaultTimeout);
		curl_easy_setopt(_curlPostHandle, CURLOPT_NOSIGNAL, TRUE);

		// We are trying to get a page
		curl_easy_setopt(_curlPostHandle, CURLOPT_POST, TRUE);

		// Data sink to collect the result of the operation
		curl_easy_setopt(_curlPostHandle, CURLOPT_WRITEFUNCTION, CURL_operations::curl_write_callback);
	} 
	return 1;
}



int CURL_operations::get_page(const std::string &url, std::string& page)
{
	CURLcode res;

//	page="";				// empty the page
//	page.reserve(64*1024);	// reseve 64k for the page
	
	// haven't got handle yet
	if( !init_curlGetHandle()) 
		return -1;
	
	curl_easy_setopt(_curlGetHandle, CURLOPT_WRITEDATA, &page);
	curl_easy_setopt(_curlGetHandle, CURLOPT_URL, url.c_str());

	res = curl_easy_perform(_curlGetHandle);

	if (res == CURLE_OK)
		return page.length();
	else 
		return -1;
}
int CURL_operations::post_form(CString &url, CString& urlcoded_form, CString& after_post_page)
{
	CURLcode res;


	// haven't got handle yet
	if( !init_curlPostHandle()) 
		return -1;
	
	curl_easy_setopt(_curlPostHandle, CURLOPT_POSTFIELDS, urlcoded_form);
	curl_easy_setopt(_curlPostHandle, CURLOPT_URL, url);
	curl_easy_setopt(_curlPostHandle, CURLOPT_WRITEDATA, &after_post_page);

	res = curl_easy_perform(_curlPostHandle);

	if (res == CURLE_OK)
		return after_post_page.GetLength();
	else 
		return -1;
}





size_t CURL_operations::curl_write_callback(void *buffer, size_t size, size_t nmemb, void *userp) 
{	
		
		size_t		retVal = 0;
		
	std::string	* page = (std::string *) userp;

	size_t	realsize= size * nmemb;
	int orig_len = page->length();		

	// strange enough, '\0' appears in buffer
	int i; 
	char * p = (char *) buffer;
	char * pe = p + realsize;
		
	while(p < pe) {
		i = 0;
		while(p + i < pe && p[i] == '\0') i ++;

		p += i;
		i = 0;
		while(p + i < pe && p[i] != '\0') i ++;

		if (i)  {
			page->append((const char *)p, i);
			p += i;
		}

	}
		
//		page->append((const char *)buffer, realsize);

//		retVal = page->length() - orig_len;

	return realsize;
//		return retVal;

}
