#include "stdafx.h"
#include  "Security.h"
#include <mmsystem.h>
#include "MyMoney.h"
#include "MyMoneyDlg.h"
#include "StockEditDlg.h"

#include "gui.h"
#include "stock.h"
#include "curl-7.16.0\include\curl\curl.h"
//#include "curl_interface.h"

#include  "curl_operation.h"


extern int bfExitFlag;
extern Stock hStock;
extern LIVE_STOCK_LIST1 StockList1[30];

int GetWebPageDelayMSLeast= 100;
int	HiddenMultiplier = 3;
int GetWebPageAutoDelayMSLeast= 2000;


DWORD WINAPI GetWebPageThread( LPVOID lpParameter);
DWORD WINAPI GetWebPageAutoThread( LPVOID lpParameter);
DWORD WINAPI GetWebPageCompanyQuickInfo( LPVOID lpParameter);
BOOL GetStockChartURL(char *s, char *dst, int buffer_len);
BOOL GetGeneralAnnounceURL(char *s, char *dst, int buffer_len);
BOOL GetCorporateInformationURL(char *s, char *dst, int buffer_len);

void PlayNotifyingSound(CMyMoneyDlg *pDlg )
{
	pDlg->KillTimer(GUI_NOTIFY_SOUND_TIMER_ID);

	pDlg->SetTimer(GUI_NOTIFY_SOUND_TIMER_ID,  30 * 1000, NULL );

	PlaySound ((LPCSTR) IDR_WARNING_WAVE, AfxGetInstanceHandle(), SND_ASYNC | SND_RESOURCE | SND_LOOP);

}

/*stock name entered by user */
DWORD WINAPI GetWebPageThread( LPVOID lpParameter)
{

	CURL_operations curl;
	int nCurrentStock = 0;
	int nSubStock = 0;
	
	char *url;
	std::string web_page, web_page1, web_page2;

	char buffer[400];
	char *p;
	CMyMoneyDlg *pDlg = (CMyMoneyDlg *)lpParameter;
	CListCtrlStyled *pList = &pDlg->m_LivePriceList;
	StockElement *pStockElement;
	int index;
	unsigned int respond_len;
	BOOL bfNeedDelay;
		bfExitFlag = 1; /* mean live stock thread is running now */

	while(1)
	{	
		bfNeedDelay = TRUE;
		url = hStock.GetNextUrl();

		if( url == NULL ) 
			goto NEXT;

		if( strlen( url) <= 2)
			goto NEXT;
		
		web_page = "";	
		curl.SetTimeout(60);
		if( curl.get_page( url, web_page) < 0 )
		{
			bfNeedDelay = FALSE;
			goto NEXT;
		}

		nSubStock = 0;
		while( (nCurrentStock = hStock.AlphaList[hStock.nCurrentAlpha].Index[nSubStock] ) != 0 )
		{ /*search all  stocks in the same http page */
			nCurrentStock --;
			nSubStock ++;
			
			buffer[0] = 0;
			p = (char *)web_page.c_str();
			respond_len = strlen(p);
			
			pStockElement = &hStock.StockInfo[nCurrentStock];

			while( p = strstrii( p, (char *)hStock.StockInfo[nCurrentStock].StockInfo1.StockName) )
			{ /*reason: sometimes some stock has advertise in the http pages, so we have to avoid this kinds of advertisement*/
				if( p[strlen(hStock.StockInfo[nCurrentStock].StockInfo1.StockName)] == '<') 
				{
					break;
				}
				p += strlen(hStock.StockInfo[nCurrentStock].StockInfo1.StockName);

				if( p - web_page.c_str() >=respond_len -1 ) 
				{
					p = NULL; //error
					char buf[100];
					sprintf(buf, "Fail to get \"%s\" info from http page", hStock.StockInfo[nCurrentStock].StockInfo1.StockName );
					pDlg->SetWindowText(buf);
					break;
				}
			}

			if( p == NULL) 
			{				
				continue;
			}

		
#if 1
			if( !pDlg->m_bfHidden )
			{
				sprintf(buffer, "Updating %s", hStock.StockInfo[nCurrentStock].StockInfo1.StockName );
				//pDlg->SetWindowText(buffer);
				pDlg->SendMessage(WM_SHOW_TEXT, 1, (LPARAM) buffer );
			}
#endif
			index = nCurrentStock  ;

			/*search company quick info url */		
			{
				char *p2 = p - 20;
				
				strcpy(buffer, url_template_company_quickinfo);

				char *p3 = &buffer[strlen(buffer)];

				SearchValue( p2, p3, sizeof(buffer) - strlen(buffer)-1, "')", 1, "nw('");

				if( strlen(p3) > 1)
				{
					if( strcmp( buffer, hStock.StockInfo[index].StockInfo2.URL_Quickinfo ) != 0 )
					{
						strcpy( hStock.StockInfo[index].StockInfo2.URL_Quickinfo, buffer);
					}
				}
			}

			/*skip stock name: 0*/
			p += strlen(hStock.StockInfo[index].StockInfo1.StockName);
			//SetStockListGUI(pList, index, 0, (char *)hStock.StockInfo[index].StockInfo1.StockName);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{				
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after stock name", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}

			
			/*search remark: 1*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</td>", 1, "<td>" );
			if( strstrii(buffer, "&nbsp" ) ) 
				SetStockListGUI(pList, index, 1, "");
			else
				SetStockListGUI(pList, index, 1, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after remark", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}

			/*search last price: 2*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			hStock.StockInfo[index].StockInfo2.PriceLastDone = atof(buffer);
			SetStockListGUI(pList, index, 2, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after last done price", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}

			/*search Change price percent: 3*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 3, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after change price percent", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}


			/*search price percent:4*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 4, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after price percent", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}

			/*search volum: 5*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 5, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after volum", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}

			/*search volumn buy:6*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 6, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after volum buy", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}
			
			/*search buy:7*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 7, buffer);
			hStock.StockInfo[index].StockInfo2.PriceBuying = atof(buffer);
			if( p - web_page.c_str() >=respond_len -1 )
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after buy", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}	
	
			/*search sell:8*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 8, buffer);
			hStock.StockInfo[index].StockInfo2.PriceSelling = atof(buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after sell", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}


			/*search volum sell:9*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 9, buffer);
			if( p - web_page.c_str() >=respond_len -1 )
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after volum sell", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}	

			/*search volum high:10*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 10, buffer);
			if( p - web_page.c_str() >=respond_len -1 )
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after volum high", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}

			/*search volum low:11*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 11, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after volum low", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}

			/*search sector:12*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList, index, 12, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) 
			{
				char buf[100];
				sprintf(buf, "\"%s\": Fail to get other info after sector", hStock.StockInfo[index].StockInfo1.StockName );
				pDlg->SetWindowText(buf);
				continue;
			}

			/*search url link to company info */	
#if 1			
			char buf1[50], buf2[50];
			if( Cal_P_L(pStockElement, buf1, buf2) )
			{
				/*update my P/L1 :15 */
				SetStockListGUI(pList, index, 15, buf1);

				/*update my P/L2 :16 */				
				SetStockListGUI(pList, index, 16, buf2);
			}

			/*set Sell/buy expected status */
			if( pStockElement->StockInfo2.PriceBuying ==0 ||
				pStockElement->StockInfo2.PriceSelling == 0 )
			{
				pList->SetRowTxtColor(index, NORMAL_COLOR);
			}
			else if( pStockElement->StockInfo1.BuyInExpectedPrice !=0 &&
				pStockElement->StockInfo1.BuyInExpectedPrice >= pStockElement->StockInfo2.PriceBuying )
			{
				if( pStockElement->StockInfo1.SellExpectedPrice == 0 )
				{
					pList->SetRowTxtColor(index, NORMAL_COLOR);
				}
				else if( pStockElement->StockInfo1.SellExpectedPrice <= pStockElement->StockInfo2.PriceSelling )
				{ /*buy and sell both are ideal */
					pList->SetRowTxtColor(index, WARNING_BUY_SELL_COLOR);
					PlayNotifyingSound( pDlg);
				}
				else
				{ /*only buy price  ideal */
					pList->SetRowTxtColor(index, WARNING_BUY_COLOR);
					PlayNotifyingSound( pDlg);
				}
			}
			else if( pStockElement->StockInfo1.SellExpectedPrice !=0 &&
				pStockElement->StockInfo1.SellExpectedPrice <= pStockElement->StockInfo2.PriceSelling )
			{ /*sell price is ideal */
				pList->SetRowTxtColor(index, WARNING_SELL_COLOR);
				PlayNotifyingSound( pDlg);
			}
			else
			{ /*both buy/sell price are not  good */
				pList->SetRowTxtColor(index, NORMAL_COLOR);
			}

			sprintf(buffer, "%.3f", pStockElement->StockInfo1.BuyInExpectedPrice);
			SetStockListGUI(pList, index, 17, buffer);
			sprintf(buffer, "%.3f", pStockElement->StockInfo1.SellExpectedPrice);
			SetStockListGUI(pList, index, 18, buffer);
#endif

			if( strlen( hStock.StockInfo[index].StockInfo2.URL_Quickinfo ) )
			{				
				if( strlen( hStock.StockInfo[index].StockInfo2.URL_CorporateInformation ) <= 2 ||
					strlen( hStock.StockInfo[index].StockInfo2.URL_GeneralAnnounce ) <= 2 ||
					strlen( hStock.StockInfo[index].StockInfo2.URL_StockChart ) <= 2 )
				{ /*need to upate some url link */
					web_page1 = "";
				
					curl.SetTimeout(20);
					if( curl.get_page( hStock.StockInfo[index].StockInfo2.URL_Quickinfo, web_page1) < 0 )
						continue;
						
					buffer[0] = 0;
					p = (char *)web_page1.c_str();

					p = strstrii(p, "Listed Companies' Information" );
					if( p == NULL) 
						continue;

					GetCorporateInformationURL(p, hStock.StockInfo[index].StockInfo2.URL_CorporateInformation, URL_MAX_LENGTH );
					GetGeneralAnnounceURL(p, hStock.StockInfo[index].StockInfo2.URL_GeneralAnnounce, URL_MAX_LENGTH);					
					GetStockChartURL(p, hStock.StockInfo[index].StockInfo2.URL_StockChart, URL_MAX_LENGTH);
					
				}
			
				if( strlen(hStock.StockInfo[index].StockInfo2.URL_GeneralAnnounce) > 2 )
				{
					COleDateTime curremtnTime = COleDateTime::GetCurrentTime();

 					COleDateTimeSpan  IntervalTime = curremtnTime - hStock.StockInfo[index].StockInfo2.lastAnnounceInfoTime;
					if( hStock.StockInfo[index].StockInfo2.FlagAnnounce == 0 )
					{ //no update for first time
						hStock.StockInfo[index].StockInfo2.FlagAnnounce = 1;
					}
					//else 
						if(  (hStock.StockInfo[index].StockInfo2.FlagAnnounce ==1) ||  
						   ( hStock.StockInfo[index].StockInfo2.FlagAnnounce == 2 && IntervalTime.GetTotalSeconds() >= 60 * 2) )
					{

						web_page2= "";
						char *last = buffer;

						curl.SetTimeout(20);
						if( curl.get_page( hStock.StockInfo[index].StockInfo2.URL_GeneralAnnounce, web_page2) < 0 )
							continue;
							
						buffer[0] = 0;
						p = (char *)web_page2.c_str();
						respond_len = strlen(p);
						
						if( p = SearchValue(p, last, sizeof(buffer)-1, "</div></a></font>", 2, "?OpenDocument\"", "<div align=left>") )
						{
							char timebuf[20]={0};
							strncpy( timebuf, last, sizeof(timebuf)-1);
							if( p = SearchValue(p, last, sizeof(buffer)-1, "</a></font></td>", 1, "?OpenDocument\">") )
							
							{
								//p = SearchValue(p, &last[strlen(last)], sizeof(buffer)-1-strlen(last), "</", 3, "<FONT", "<", ">");
								
								strcpy(hStock.StockInfo[index].StockInfo2.LastAnnounce, timebuf);
								strcat( hStock.StockInfo[index].StockInfo2.LastAnnounce, ": ");
								strncat(hStock.StockInfo[index].StockInfo2.LastAnnounce, last, sizeof(hStock.StockInfo[index].StockInfo2.LastAnnounce)-1 );
								SetStockListGUI(pList, index, 20, hStock.StockInfo[index].StockInfo2.LastAnnounce);
							}

							hStock.StockInfo[index].StockInfo2.lastAnnounceInfoTime = curremtnTime;

							if( hStock.StockInfo[index].StockInfo2.FlagAnnounce != 2 ) 
								hStock.StockInfo[index].StockInfo2.FlagAnnounce = 2;
						}
					}
				}				
			}			

		}
		

NEXT:
		if( bfExitFlag ==2  ) /* main thread want to exit */
		{
			bfExitFlag = 3;
			break;
		}
	
	
		if( pDlg->m_bfHidden )
			Sleep(GetWebPageDelayMSLeast * HiddenMultiplier);
		else
			Sleep(GetWebPageDelayMSLeast );
#if 0
		if( 1 )// !pDlg->m_bfHidden )
		{
			strcpy(buffer, "                             ");
			//pDlg->SetWindowText(buffer);
			pDlg->SendMessage(WM_SHOW_TEXT, 1, (LPARAM) buffer );
		}
#endif

		while( GetWebPageDelayMSLeast < 0 )
		{ /*minus means no update */
			Sleep(10);
		}
		
	}

	return 0;
}


/*Try to get stock name automatically */
DWORD WINAPI GetWebPageAutoThread( LPVOID lpParameter)
{
	CURL_operations curl;
	
	std::string web_page;
	char buffer[100];
	char *p;
	unsigned int respond_len;

#ifdef MODLESS_DLG_AUTO_STOCK
	CAutoStockModelessDlg *pDlg = (CAutoStockModelessDlg *)lpParameter;
#else
	CMyMoneyDlg *pDlg = (CMyMoneyDlg *)lpParameter;
#endif
	CListCtrlStyled *pList[6];
	int index;
	int UrlIndex;
	char *StockURL[]={url_template_volume, url_template_value,
						url_template_gainer, url_template_gainer_percent,
						url_template_loser, url_template_loser_percent};

	pList[0] = &pDlg->m_AutoPriceListVolume;
	pList[1] = &pDlg->m_AutoPriceListValue;

	for(int i=0; i<sizeof(StockURL)/sizeof(StockURL[0])/2; i++)
	{
		for(int j=0; j<MAX_AUTO_STOCK_COUNT; j++)
		{
			SetStockListGUI(pList[0], j + (MAX_AUTO_STOCK_COUNT + 1) * i, 0, " ");
			SetStockListGUI(pList[1], j + (MAX_AUTO_STOCK_COUNT + 1) * i, 0, " ");
		}
	}

	
	bfExitFlag = 1; /* mean live stock thread is running now */
	UrlIndex = 0;
	index = 0;
	while(1)
	{
		//First Get first 20 volume stocks
		web_page = "";
		if( curl.get_page( StockURL[UrlIndex], web_page) < 0 )
			goto NEXT;
				
		buffer[0] = 0;
		p = (char *)web_page.c_str();
		respond_len = strlen(p);
		
				
		if( (p = strstrii( p, " Open dbConnection ") ) == NULL ) 
			goto NEXT;

		if( (p = strstrii( p, "<!-- Closing rsStk -->")) == NULL ) 
			goto NEXT;

		if( (p = strstrii( p, "<tr class=")) == NULL ) /*get pointer to first stock */
			goto NEXT;

		index = 0;
		while( index < MAX_AUTO_STOCK_COUNT )
		{
#if 0
			sprintf(buffer, "Updating %s", hStock.StockInfo[hStock.nCurrentStock].StockInfo1.StockName );
			pDlg->SetWindowText(buffer);
#endif							
			/*stock name: 0*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</nobr>", 1, "<td>", "<td>" );
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 0, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;
			
			/*search remark: 1*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</td>", 1, "<td>" );
			if( strstrii(buffer, "&nbsp" ) ) 
				SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 1, "");
			else
				SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 1, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;

			/*search last price: 2*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 2, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;


			/*search Change price percent: 3*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 3, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;

			/*search price percent:4*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 4, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;

			/*search volum: 5*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 5, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;

			/*search volumn buy:6*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 6, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;
			/*search buy:7*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 7, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;
			/*search sell:8*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 8, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;
			/*search volum sell:9*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 9, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;


			/*search volum high:10*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 10, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;

			/*search volum low:11*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 11, buffer);
			if( p - web_page.c_str() >=respond_len -1 ) goto NEXT;

			/*search sector:12*/
			p = SearchValue( p, buffer, sizeof(buffer)-1, "</", 1, "<td>");
			SetStockListGUI(pList[UrlIndex%2], index + (MAX_AUTO_STOCK_COUNT +1) * (UrlIndex/2) , 12, buffer);
						
			index ++;

		}
						
NEXT:	
		UrlIndex ++;
		if( UrlIndex >= sizeof(StockURL)/sizeof(StockURL[0]) )
			UrlIndex = 0 ;

		if( bfExitFlag ==2  ) /* main thread want to exit */
		{
			bfExitFlag = 3;
			break;
		}

		

		if( pDlg->m_bfHidden )
			Sleep(GetWebPageAutoDelayMSLeast);
		else
			Sleep(GetWebPageAutoDelayMSLeast * HiddenMultiplier);
#if 0
		strcpy(buffer, "                             ");
		pDlg->SetWindowText(buffer);		
#endif
	
		while( GetWebPageAutoDelayMSLeast < 0 )
		{ /*minus means no update */
			Sleep(10);
		}

	}


	return 0;
}




DWORD WINAPI GetWebPageCompanyQuickInfo( LPVOID lpParameter)
{

	return 0;
}



BOOL GetCorporateInformationURL(char *s, char *dst, int buffer_len)
{
	if( s == NULL) return FALSE;

	char *tmp = (char *) malloc(strlen(s) + 1 );

	if( tmp == NULL) return FALSE;
	strcpy( tmp, s);

	char *p = strstrii(tmp, CoporationInfoFlag1);
	if( p == NULL) 
	{
		free(tmp);
		return FALSE;
	}

	*p = 0;

	p = FindLastString(tmp, CoporationInfoFlag2);
	if( p )
	{
		p+= strlen(CoporationInfoFlag2);
	}

	if( p == NULL || strlen(p) <2 ) 
	{
		free(tmp);
		return FALSE;
	}
	

	if( strlen(p) > buffer_len-1) 
	{
		free(tmp);
		return FALSE;
	}

	if( dst )
	{
		strcpy( dst, p);
	}

	free(tmp);


	return TRUE;
}

BOOL GetGeneralAnnounceURL(char *s, char *dst, int buffer_len)
{
	if( s == NULL) return FALSE;

	char *tmp = (char *) malloc(strlen(s) + 1 );

	if( tmp == NULL) return FALSE;
	strcpy( tmp, s);

	char *p = strstrii(tmp, GeneralAnnouceFlag1);
	if( p == NULL) 
	{
		free(tmp);
		return FALSE;
	}

	*p = 0;

	p = FindLastString(tmp, GeneralAnnouceFlag2);
	if( p )
	{
		p+= strlen(GeneralAnnouceFlag2);
	}


	if( p == NULL || strlen(p) <2 ) 
	{
		free(tmp);
		return FALSE;
	}

	if( strlen(p) > buffer_len-1) 
	{
		free(tmp);
		return FALSE;
	}

	if( dst )
	{
		strcpy( dst, p);
	}

	free(tmp);


	return TRUE;
}

BOOL GetStockChartURL(char *s, char *dst, int buffer_len) //need to be implemented
{
	return TRUE;
}




