// MyMoneyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MyMoney.h"
#include "MyMoneyDlg.h"
#include "StockEditDlg.h"
#include "RefreshTimingDialog.h"
#include "EditWarningDlg.h"
#include  "Security.h"
#include <mmsystem.h>
#include "gui.h"
#include "stock.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern DWORD WINAPI GetWebPageThread( LPVOID lpParameter);
extern DWORD WINAPI GetWebPageAutoThread( LPVOID lpParameter);
extern DWORD WINAPI GetWebPageCompanyQuickInfo( LPVOID lpParameter);
extern int GetWebPageDelayMSLeast;
extern int	HiddenMultiplier;
extern int GetWebPageAutoDelayMSLeast;

int bfExitFlag = 0;
Stock hStock;
CSecurity Security;

int WindowSize_X=1440; //1024;
int WindowSize_Y=900-30; //768;
int ButtonSize = 20;
BOOL bfNeedResize = FALSE;
HANDLE Semaph = NULL;


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyMoneyDlg dialog

CMyMoneyDlg::CMyMoneyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMyMoneyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMyMoneyDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

}

void CMyMoneyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyMoneyDlg)
	DDX_Control(pDX, IDC_IDC_LIST_LIVE_PRICE, m_LivePriceList);
	DDX_Control(pDX, IDC_IDC_LIST_ATUO_PRICE_VOL_GAINER_LOSER, m_AutoPriceListVolume);
	DDX_Control(pDX, IDC_IDC_LIST_ATUO_PRICE_VALUE_GAINTERP_LOSERP, m_AutoPriceListValue);

	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyMoneyDlg, CDialog)
	//{{AFX_MSG_MAP(CMyMoneyDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_KILLFOCUS()
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_WM_TIMER()
	ON_COMMAND(ID_MENUITEM_CORP_INFO, OnMenuitemCorpInfo)
	ON_COMMAND(ID_MENUITEM_GENERAL_ANNOUNCE, OnMenuitemGeneralAnnounce)
	ON_COMMAND(ID_MENUITEM_STOCK_CHART, OnMenuitemStockChart)
	ON_NOTIFY(NM_RCLICK, IDC_IDC_LIST_LIVE_PRICE, OnRclickIdcListLivePrice)
	ON_COMMAND(ID_MENUITEM_QUICK_INFO, OnMenuitemQuickInfo)
	ON_COMMAND(ID_MENUITEM_DELETE, OnMenuitemDelete)
	ON_COMMAND(ID_MENUITEM_ADD, OnMenuitemAdd)
	ON_COMMAND(ID_MENUITEM_MODIFY, OnMenuitemModify)
	ON_COMMAND(ID_MENUITEM_NEXT, OnMenuitemNext)
	ON_NOTIFY(NM_RCLICK, IDC_IDC_LIST_ATUO_PRICE_VALUE_GAINTERP_LOSERP, OnRclickIdcListAtuoPriceValueGainterpLoserp)
	ON_NOTIFY(NM_RCLICK, IDC_IDC_LIST_ATUO_PRICE_VOL_GAINER_LOSER, OnRclickIdcListAtuoPriceVolGainerLoser)
	ON_COMMAND(ID_MENUITEM_EXIT, OnMenuitemExit)
	ON_WM_CLOSE()
	ON_COMMAND(ID_MENUITEM_ADJUST_REFRESH_TIMING, OnMenuitemAdjustRefreshTiming)
	ON_COMMAND(ID_MENUITEM_SUM_UP, OnMenuitemSumUp)
	ON_MESSAGE(WM_SHOW_TEXT, OnShowText)
	ON_COMMAND(ID_MENUITEM_WARNING, OnMenuitemWarning)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyMoneyDlg message handlers

BOOL CMyMoneyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
#ifdef NEED_PROTECT
	Semaph = CreateSemaphore(NULL, 1, 1, NULL);
	if( Semaph == NULL )
	{
		PostMessage(WM_CLOSE);
		return FALSE;
	}
#endif
	m_bfHidden = FALSE;
	m_AutoStockOnly = FALSE;
	hStock.Init();
	Security.Init("SXG");

	//ResizeWindow(TRUE);

#if 1
	HidePic();
#else
	ShowPic();
#endif

	SetTimer(GUI_WORKAROUND_TIMER_ID, 1, NULL );
	SetTimer(GUI_SHOW_TEXT_TIMER_ID, 4000, NULL );

#ifdef MODLESS_DLG_AUTO_STOCK
	m_AutoStockDlg = new CAutoStockModelessDlg(this);
	m_AutoStockDlg->Create(CAutoStockModelessDlg::IDD);
	m_AutoStockDlg->ShowWindow(SW_SHOW);
#endif
	
	InitLiveStockList1(&m_LivePriceList);

#ifdef MODLESS_DLG_AUTO_STOCK
	InitLiveStockList2(&m_AutoStockDlg->m_AutoPriceListVolume);
	InitLiveStockList2(&m_AutoStockDlg->m_AutoPriceListValue);
	
#else
	InitLiveStockList2(&this->m_AutoPriceListVolume);
	InitLiveStockList2(&this->m_AutoPriceListValue);
	
	
#endif

	
	//get stock info from database and display it in m_LivePriceList
	for( int i=0; i<hStock.nStocks; i++)
		UpdateStockElement( &m_LivePriceList, i, &hStock.StockInfo[i]);

#if 1	

	CreateThread( NULL, 20000, (LPTHREAD_START_ROUTINE )GetWebPageThread, (unsigned long *)this, 0, NULL);
#ifdef MODLESS_DLG_AUTO_STOCK
	CreateThread( NULL, 20000, (LPTHREAD_START_ROUTINE )GetWebPageAutoThread, (unsigned long *)m_AutoStockDlg, 0, NULL);
#else
	CreateThread( NULL, 20000, (LPTHREAD_START_ROUTINE )GetWebPageAutoThread, (unsigned long *)this, 0, NULL);
#endif

	CreateThread( NULL, 20000, (LPTHREAD_START_ROUTINE )GetWebPageCompanyQuickInfo, (unsigned long *)this, 0, NULL);
	
#endif
	bfNeedResize = TRUE;

	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMyMoneyDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMyMoneyDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMyMoneyDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/* curl write callback, to fill tidy's input buffer...  */
#define uint unsigned int
size_t write_cb(char *in, size_t size, size_t nmemb, char *out)
{
  uint r;
  r = size * nmemb;
//  tidyBufAppend( out, in, r );
  return(r);
}





void CMyMoneyDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	if( bfExitFlag == 1) /*another Live stock thread is running */
	{
		bfExitFlag = 2; /*notify live Stock thread to stop running */
		while( bfExitFlag == 3 ) 
		{ /*live Stock thread stop running now*/
			Sleep(10);
		}
	}

#ifdef NEED_PROTECT
	CloseHandle(Semaph);
#endif

	bfExitFlag = bfExitFlag;

	hStock.SaveMyStock(SAVE_TYPE_OTHER_STOCK_INFO);
	
}

void CMyMoneyDlg::OnSize(UINT nType, int cx, int cy) 
{

	CDialog::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	static int times = 0;

	if(bfNeedResize) // first time before it is displayed
	{
		WindowSize_X=cx;
		WindowSize_Y=cy;
		ResizeWindow(FALSE);
	}

	{
		if( cx < 100 || cy < 100 ) 
		{
			if( !m_bfHidden )
			{
				SetWindowText("");
				HidePic();
			}		
		}
	}

}


void CMyMoneyDlg::OnKillFocus(CWnd* pNewWnd) 
{
	CDialog::OnKillFocus(pNewWnd);
	
	// TODO: Add your message handler code here
	pNewWnd = pNewWnd;
	
}

void CMyMoneyDlg::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnChar(nChar, nRepCnt, nFlags);
}

void CMyMoneyDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CMyMoneyDlg::ShowPic()
{	
	if(m_AutoStockOnly )
	{ /*display auto stock list: volume/value/gainer/loser */
		m_LivePriceList.ShowWindow(SW_HIDE);

		m_AutoPriceListVolume.ShowWindow(SW_NORMAL);
		m_AutoPriceListValue.ShowWindow(SW_NORMAL);
	
	}
	else 
	{ /*only display some stocks manually entered by user */
		m_LivePriceList.ShowWindow(SW_NORMAL);

		m_AutoPriceListVolume.ShowWindow(SW_HIDE);
		m_AutoPriceListValue.ShowWindow(SW_HIDE);
	
	}

	m_bfHidden = FALSE;
	ResizeWindow(FALSE);
	
}


void CMyMoneyDlg::HidePic()
{

	m_LivePriceList.ShowWindow(SW_HIDE);

	m_AutoPriceListVolume.ShowWindow(SW_HIDE);
	m_AutoPriceListValue.ShowWindow(SW_HIDE);


	m_bfHidden = TRUE;	
}

void CMyMoneyDlg::AutoShow_Hide_Pic()
{
	if( m_bfHidden )
	{
		HidePic();
	}
	else
	{
		ShowPic();
	}
}

BOOL CMyMoneyDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
#if 0
	char buffer[100];

	sprintf(buffer,"%d_%d_%d_%d_%d" ,pMsg->hwnd, pMsg->lParam, pMsg->message, pMsg->pt.x, pMsg->pt.y);
	SetWindowText(buffer);
#endif

	KillTimer(GUI_LOST_FOCUS_TIMER_ID);
	SetTimer(GUI_LOST_FOCUS_TIMER_ID, 60 * 1000, NULL);

	if(pMsg->message == WM_KEYDOWN)
	{
		// do keydown processing here
		Security.AppendKey( pMsg->wParam);
		if( Security.KeyOk() )
		{
			if( m_bfHidden )
				m_bfHidden = FALSE;
			else
				m_bfHidden = TRUE;
			
			AutoShow_Hide_Pic();
		}		
	}
	else if( pMsg->message == WM_MOUSEMOVE)
	{
		mouse_pt.x = LOWORD(pMsg->lParam ); 
		mouse_pt.y = HIWORD(pMsg->lParam ); 				
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CMyMoneyDlg::ResizeWindow(BOOL bfAll)
{
	if( bfAll )
	{ /*resize top windown itself */
		MoveWindow(0, 0, WindowSize_X, WindowSize_Y, TRUE);

#ifdef MODLESS_DLG_AUTO_STOCK
		m_AutoStockDlg->MoveWindow(0, 0, WindowSize_X, WindowSize_Y, TRUE);
#endif
	}

#if 1
	m_LivePriceList.MoveWindow(0, 0, WindowSize_X, WindowSize_Y, TRUE);
	
	//auto
	m_AutoPriceListVolume.MoveWindow(0,					0,									WindowSize_X/2-6, (WindowSize_Y-ButtonSize), TRUE);
	m_AutoPriceListValue.MoveWindow(WindowSize_X/2,		0,									WindowSize_X/2-6,	(WindowSize_Y-ButtonSize), TRUE);
	
#endif

}

void CMyMoneyDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	if( nIDEvent == GUI_WORKAROUND_TIMER_ID )
	{
		KillTimer(GUI_WORKAROUND_TIMER_ID);
		ResizeWindow(TRUE);
	}
	else if( nIDEvent ==  GUI_LOST_FOCUS_TIMER_ID )
	{ /*hide all lists */
		if( !m_bfHidden )
		{
			HidePic();
		}		
	}
	else if( nIDEvent == GUI_NOTIFY_SOUND_TIMER_ID )
	{
		PlaySound ((LPCSTR) NULL, AfxGetInstanceHandle(), SND_PURGE );
		KillTimer(GUI_NOTIFY_SOUND_TIMER_ID);		
	}
	else if( nIDEvent == GUI_SHOW_TEXT_TIMER_ID )
	{
		CString buf;

		GetWindowText(buf);

		if( m_bfHidden ) 
		{
			if( buf.GetLength() )
				SetWindowText("");
		}
		else
		{
			static int index = 0;
			if( index == 0 )
			{
				SendMessage(WM_SHOW_TEXT, 2, (LPARAM) hStock.Warning.Notice);
				index = 1;
			}
			else if( index == 1)
			{
				unsigned int flag = LVHT_ONITEMLABEL | LVHT_ONITEMICON ;
				int nMouseOverItem = m_LivePriceList.HitTest(mouse_pt, &flag);
				index = 0;	
				if( nMouseOverItem >=0 && nMouseOverItem <= m_LivePriceList.GetItemCount()-1 ) 
				{
					char buf[500];
					sprintf(buf, "%s:%s_%s_%s_%s", hStock.StockInfo[nMouseOverItem].StockInfo1.StockName, hStock.StockInfo[nMouseOverItem].StockInfo1.Comments, hStock.StockInfo[nMouseOverItem].StockInfo1.Comments2, hStock.StockInfo[nMouseOverItem].StockInfo1.Comments3, hStock.StockInfo[nMouseOverItem].StockInfo2.LastAnnounce); 
				
					SendMessage(WM_SHOW_TEXT, 3, (LPARAM) buf);
				}
			}
		}

	}
		
	
	CDialog::OnTimer(nIDEvent);
}

void CMyMoneyDlg::OnMenuitemCorpInfo() 
{
	// TODO: Add your command handler code here	
	char cmd[URL_MAX_LENGTH];
	STARTUPINFO si = { 0, };
	si.cb = sizeof( STARTUPINFO );
	PROCESS_INFORMATION pi = { 0, }, pi2 = { 0, };

	if( nSelectedItem < 0 || nSelectedItem > m_LivePriceList.GetItemCount()-1 ) return;

	if( strlen( hStock.StockInfo[nSelectedItem].StockInfo2.URL_CorporateInformation ) <=2 ) return;

	sprintf(cmd, "iexplore.exe %s", hStock.StockInfo[nSelectedItem].StockInfo2.URL_CorporateInformation);

	CreateProcess( "c:\\Program Files\\Internet Explorer\\iexplore.exe", cmd, NULL, NULL, FALSE,
		NORMAL_PRIORITY_CLASS, NULL, NULL, &si, &pi2 );

	//ShellExecute( GetSafeHwnd(), "open", cmd, 
	//		NULL,NULL, SW_SHOWNORMAL);	
	
}

void CMyMoneyDlg::OnMenuitemGeneralAnnounce() 
{
	// TODO: Add your command handler code here
	char cmd[URL_MAX_LENGTH];
	STARTUPINFO si = { 0, };
	si.cb = sizeof( STARTUPINFO );
	PROCESS_INFORMATION pi = { 0, }, pi2 = { 0, };

	if( nSelectedItem < 0 || nSelectedItem > m_LivePriceList.GetItemCount()-1 ) return;

	if( strlen( hStock.StockInfo[nSelectedItem].StockInfo2.URL_GeneralAnnounce ) <=2 ) return;

	sprintf(cmd, "iexplore.exe %s", hStock.StockInfo[nSelectedItem].StockInfo2.URL_GeneralAnnounce);

	CreateProcess( "c:\\Program Files\\Internet Explorer\\iexplore.exe", cmd, NULL, NULL, FALSE,
		NORMAL_PRIORITY_CLASS, NULL, NULL, &si, &pi2 );
	//ShellExecute( GetSafeHwnd(), "open", cmd, 
	//		NULL,NULL, SW_SHOWNORMAL);	
	
}

void CMyMoneyDlg::OnMenuitemStockChart() 
{
	// TODO: Add your command handler code here
	
}


void CMyMoneyDlg::OnMenuitemQuickInfo() 
{
	// TODO: Add your command handler code here
	char cmd[URL_MAX_LENGTH];
	STARTUPINFO si = { 0, };
	si.cb = sizeof( STARTUPINFO );
	PROCESS_INFORMATION pi = { 0, }, pi2 = { 0, };

	if( nSelectedItem < 0 || nSelectedItem > m_LivePriceList.GetItemCount()-1 ) return;

	if( strlen( hStock.StockInfo[nSelectedItem].StockInfo2.URL_Quickinfo ) <= 2) return ;

	sprintf(cmd, "iexplore.exe %s", hStock.StockInfo[nSelectedItem].StockInfo2.URL_Quickinfo);


	CreateProcess( "c:\\Program Files\\Internet Explorer\\iexplore.exe", cmd, NULL, NULL, FALSE,
		NORMAL_PRIORITY_CLASS, NULL, NULL, &si, &pi2 );
	
}


void CMyMoneyDlg::OnMenuitemDelete() 
{
	// TODO: Add your command handler code here
	char buffer[100];

	if( nSelectedItem < 0 || nSelectedItem > m_LivePriceList.GetItemCount()-1 ) return;

	sprintf(buffer, "Are you sure to delete %s", hStock.StockInfo[nSelectedItem].StockInfo1.StockName);
	int res = MessageBox(buffer,"Some question",MB_YESNO | MB_ICONQUESTION | MB_DEFBUTTON2);
	if(res == IDYES)
	{
		memcpy( &hStock.StockInfo[nSelectedItem], 
				&hStock.StockInfo[nSelectedItem+1], 
				(hStock.nStocks - nSelectedItem -1 ) * sizeof(hStock.StockInfo[0]) );

		hStock.nStocks --;

#if 0
		m_LivePriceList.DeleteAllItems();

		for( int i=0; i<hStock.nStocks; i++)
			UpdateStockElement( &m_LivePriceList, i, &hStock.StockInfo[i]);
#else
		m_LivePriceList.DeleteItem( nSelectedItem );
#endif
		hStock.SaveMyStock();


		hStock.ReOrderAlphaList();
	}

}

void CMyMoneyDlg::OnMenuitemAdd() 
{
	// TODO: Add your command handler code here
	// TODO: Add your control notification handler code here	
	CStockEditDlg dlg;
	
	memset( &dlg.stock, 0, sizeof(dlg.stock) );
	
	if( dlg.DoModal() == IDOK)
	{
		hStock.AddNewStock( &dlg.stock);
			
		UpdateStockElement( &m_LivePriceList, hStock.nStocks-1, &hStock.StockInfo[hStock.nStocks-1]);
		
		hStock.SaveMyStock();	
		hStock.ReOrderAlphaList();
	}
	
}

void CMyMoneyDlg::OnMenuitemModify() 
{
	// TODO: Add your command handler code here
	CStockEditDlg dlg;

	if( nSelectedItem < 0 || nSelectedItem > m_LivePriceList.GetItemCount()-1 ) return;

	dlg.stock = hStock.StockInfo[nSelectedItem];

	if( dlg.DoModal() == IDOK)
	{
		hStock.StockInfo[nSelectedItem] = dlg.stock;
		UpdateStockElement( &m_LivePriceList, nSelectedItem, &hStock.StockInfo[nSelectedItem]);
		hStock.ReOrderAlphaList();	

		hStock.SaveMyStock();	
	}
}

void CMyMoneyDlg::OnMenuitemNext() 
{
	// TODO: Add your command handler code here
	if( m_AutoStockOnly )
		m_AutoStockOnly = FALSE;
	else
		m_AutoStockOnly = TRUE;

	if( !m_bfHidden)
		ShowPic();
	
}

#if 0
void CMyMoneyDlg::OnClickIdcListLivePrice(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	int pMenuID = 0;
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	if( pNMListView->iItem < 0 || pNMListView->iItem > m_LivePriceList.GetItemCount()-1 ) 
		return;


	char buf[3000];

	sprintf(buf, "%s - %s - %s", hStock.StockInfo[pNMListView->iItem].StockInfo1.Comments, 
				hStock.StockInfo[pNMListView->iItem].StockInfo1.Comments2, 
				hStock.StockInfo[pNMListView->iItem].StockInfo1.Comments3); 
	
	SetWindowText(buf);


	*pResult = 0;
}
#endif

void CMyMoneyDlg::OnRclickIdcListLivePrice(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	int pMenuID = 0;
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;	

#if 0
	if( pNMListView->iItem < 0 || pNMListView->iItem > m_LivePriceList.GetItemCount()-1 ) 
		return;
		
#endif

	nSelectedItem =  pNMListView->iItem;

	QuickInfoMenu.LoadMenu(IDR_MENU_QUICK_INFO);

	
	CMenu* pPopup = QuickInfoMenu.GetSubMenu(pMenuID);


	POINT pp;
	GetCursorPos(&pp);
	pMenuID = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
            pp.x, pp.y, this);  //TPM_LEFTBUTTON   TPM_RETURNCMD
 
    // Destroy the menu.  
    QuickInfoMenu.DestroyMenu();


	*pResult = 0;
}

void CMyMoneyDlg::OnRclickIdcListAtuoPriceValueGainterpLoserp(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	int pMenuID = 0;

	QuickInfoMenu.LoadMenu(IDR_SECOND_MENU);	
	CMenu* pPopup = QuickInfoMenu.GetSubMenu(pMenuID);


	POINT pp;
	GetCursorPos(&pp);
	pMenuID = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
            pp.x, pp.y, this);  //TPM_LEFTBUTTON   TPM_RETURNCMD
 
    // Destroy the menu.  
    QuickInfoMenu.DestroyMenu();


	*pResult = 0;
}

void CMyMoneyDlg::OnRclickIdcListAtuoPriceVolGainerLoser(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	int pMenuID = 0;

	QuickInfoMenu.LoadMenu(IDR_SECOND_MENU);	
	CMenu* pPopup = QuickInfoMenu.GetSubMenu(pMenuID);


	POINT pp;
	GetCursorPos(&pp);
	pMenuID = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
            pp.x, pp.y, this);  //TPM_LEFTBUTTON   TPM_RETURNCMD
 
    // Destroy the menu.  
    QuickInfoMenu.DestroyMenu();


	*pResult = 0;
}


void CMyMoneyDlg::OnMenuitemExit() 
{
	// TODO: Add your command handler code here
	SendMessage(WM_CLOSE);
	
}


void CMyMoneyDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	//CDialog::OnClose();
	CDialog::OnCancel();  //Enable Close with Cross bar on the right window
}

void CMyMoneyDlg::OnCancel() 
{
	// TODO: Add your message handler code here and/or call default
	
	
	//CDialog::OnCancel();  //Block ESC to close the dialog windows
}


void CMyMoneyDlg::OnMenuitemAdjustRefreshTiming() 
{
	// TODO: Add your command handler code here
	CRefreshTimingDialog dlg;

	dlg.m_HiddenMultiplier = HiddenMultiplier;
	dlg.m_RefreshAutoTiming = GetWebPageAutoDelayMSLeast;
	dlg.m_RefreshTiming = GetWebPageDelayMSLeast;

	if( dlg.DoModal() == IDOK)
	{
		HiddenMultiplier = dlg.m_HiddenMultiplier;
		GetWebPageAutoDelayMSLeast = dlg.m_RefreshAutoTiming;
		GetWebPageDelayMSLeast = dlg.m_RefreshTiming;
	}	
}

void CMyMoneyDlg::OnMenuitemSumUp() 
{
	// TODO: Add your command handler code here
	float f1, f2, f3;
	char buf[100]="";

	hStock.SumUp( &f1, &f2, &f3);

	sprintf(buf, "All:%.2f, LastDone:%.2f, Selling:%.2f", f1, f2, f3);
	MessageBox(buf);
	
}

void CMyMoneyDlg::OnShowText(WPARAM wParam, LPARAM lParam)
{
	char buf[300];
	int FromIndex = 120;
	
	memset(buf, ' ', sizeof(buf) - 1);
	buf[sizeof(buf) -1] = 0;

	if( wParam == 1) 
	{
		strncpy(buf, (char *)lParam, strlen( (char *)lParam)  -1 );
		strcpy( &buf[FromIndex], hStock.Warning.Notice );

		SetWindowText( buf);
	}
	else if( wParam == 2 )
	{
		strcpy( &buf[FromIndex], hStock.Warning.Notice );
		SetWindowText( buf);
	}
	else if( wParam == 3 )
	{
		SetWindowText( (char *) lParam);
	}

}

void CMyMoneyDlg::OnMenuitemWarning() 
{
	// TODO: Add your command handler code here

	CEditWarningDlg dlg;

	dlg.m_Warning_Notice = hStock.Warning.Notice;

	if( dlg.DoModal() == IDOK )
	{
		if( strcmp( hStock.Warning.Notice, dlg.m_Warning_Notice ) )
		{
			strncpy(hStock.Warning.Notice, dlg.m_Warning_Notice, sizeof(hStock.Warning.Notice)-1 );

			if( !m_bfHidden ) 
				hStock.SaveMyStock(SAVE_TYPE_WARNING);
		}
	}
	
}

