#ifndef _IMAGE_H
#define _IMAGE_H

/*
 * Copyright (C) 2005-2006 by egnite Software GmbH
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/*!
 * \file image.h
 *
 * \verbatim
 *
 * $Log: image.h,v $
 * Revision 1.1  2006/03/20 14:16:40  haraldkipp
 * Release 1.2.4.
 *
 *
 * \endverbatim
 */

#include <stdio.h>

#define IMAGETYPE_ANY   0
#define IMAGETYPE_BIN   1
#define IMAGETYPE_IHEX  2

typedef struct {
    FILE  *imf_fp;
    char   imf_pathname[256];
    int    imf_type;
    int    imf_end;
    unsigned long imf_seg;
    size_t imf_bcnt;
    unsigned char *imf_bptr;
    unsigned char imf_buff[256];
} IMAGEFILE;

extern IMAGEFILE *ImageOpen(char *filename);
extern IMAGEFILE *ImageCreate(char *filename, int type);
extern int ImageRead(IMAGEFILE *imf, unsigned long *addr, unsigned char *data, size_t siz);
extern int ImageClose(IMAGEFILE *imf);

#endif
