//aztech.h
#ifndef _AZTECH_H
#define _AZTECH_H

#include <stdio.h>
extern FILE* logfile;
extern FILE* binfile;

#define LOG_INIT		{ logfile = fopen("log.txt","w"); }
#define LOG_RELEASE		{ fclose(logfile); }

#define BIN_WRITE_INIT	{ binfile = fopen("bin","wb"); }
#define BIN_WRITE(s)	{ fprintf(binfile, "%c", s); }
#define BIN_WRITE_END	{ fclose(binfile); }

//#define LOG(x) { printf(x); fprintf(logfile,x);}


static unsigned long Arm7ScanChainPath(int path, int reg, unsigned long data);
int VegaLiteComWrite(int scan_path, unsigned long data);
int VegaLiteInit();
int VegaUnprotectFlash();
int VegaLiteErase();
int VegaLiteWriteSecurity();
int DoVegaFlash(int argc, char **argv, int *err);
int VegaReset();
void VegaEnterDebug();
void VegaReadFlash();
void VegaEnterFlashMode();

//void LOG(const char* fmt);
//extern void LOG(const char* fmt, va_list argList);
unsigned char reverseBitOrderLow4(unsigned char input);
unsigned char reverseBitOrder8(unsigned char input);
void jtagAddrConvert(unsigned long addr, unsigned char **output);
void reverseDWord(unsigned char* input);
void TestFunc();

#endif