//aztech.c
#include <stdlib.h>
#include <stdio.h>

#include "tap.h"
#include "aztech.h"

//8 sectors for VegaLite, for VegaBB, it's 14 sectors
//#define VEGA_PFLASH_MEMORY_SIZE_K	256*8			//256K
#define VEGA_SECTOR_NUMBER	14		// 14 for VegaBB, 8 for Vegalite
#define VEGA_PAGES_PER_SECTOR 128
#define VEGA_WORDS_PER_PAGE 32	// 32 for VegaBB, 16 for VegaLite
#define VEGA_PAGE_NUMBER (VEGA_SECTOR_NUMBER*VEGA_PAGES_PER_SECTOR)
#define VEGA_WORD_NUMBER (VEGA_PAGE_NUMBER*VEGA_WORDS_PER_PAGE)

#define ICE_DBG_CTRL        0
#define ICE_DBG_STAT        1
#define ICE_DCC_CTRL        4
#define ICE_DCC_DATA        5

FILE* logfile;
FILE* binfile;

void LOG(const char* fmt, va_list argList)
{
	va_list list;
	//va_start(list,fmt); 
	printf(fmt,argList);
	fprintf(logfile, fmt, argList);
}

void TestFunc()
{
	unsigned char buf[4] = {0};
	//unsigned char* buf
	unsigned long i,j;
/*	for(i = 0; i < 1024; i++)
	{
		JtagAddrConvert(i,buf);
		LOG("\ni=%d ",i);
		TapData(NULL,buf,32);
	}
*/
	for(i = 0; i< 1024; i++)
	{
		for(j = 0; j<4 ; j++)
		{
			buf[j] = i; //reverseBitOrder8(*tmp);
		}
		LOG("\ni=%d ",i);
		//reverse DWORD
		reverseDWord(buf);
		TapData(NULL, buf, 32);
	}
	return;
}

int DoVegaFlash(int argc, char **argv, int *err)
{
	if((argc ==1) && (strcmp(argv[0], "-t") == 0))
	{
		//testing
		TestFunc();
		return 0;
	}

	// enter DebugMode
	VegaEnterDebug();
	VegaEnterFlashMode();

	if( (argc == 1) && (strcmp(argv[0],"-r") == 0) )
	{
		//for reading, no need to unprotect the flash
		//read Flash
		//VegaUnprotectFlash();
		VegaReadFlash();
		return 0;
	}

	if( (argc == 1) && (strcmp(argv[0],"-e") == 0) )
	{
		VegaUnprotectFlash();
		VegaLiteErase();
		return 0;
	}
	if((argc == 2) && (strcmp(argv[0],"-w") == 0) )
	{
		unsigned long *image = NULL;
		int imageLen;

		VegaUnprotectFlash();
		VegaLiteErase();
		
		if ((imageLen = LoadTargetImage(argv[1], &image)) <= 0) {
			fprintf(stderr, "Failed to read %s\n", argv[1]);
			free(image);
     		return -1;
	    }

		VegaWriteFlash((char*)image,imageLen);

		free(image);

		return 0;
	}

    return 0;
}

//enter flash mode
// 1. Scan_In 0100
// 2. select path 12
void VegaEnterFlashMode()
{
    unsigned char buf[64];
	int i;

	for(i = 0; i < 62; i++)
	{
		buf[i] = 0;
	}

	buf[62] = 0x4;	//100
	buf[63] = 0x58; //01011000

	LOG("---------entering flash mode-----------\n",NULL);
	//select chain 12 (0011 --> 1100)
    Arm7SelectScanChain(0xC);
    TapData(NULL, buf, 512);

	//stay in run-test/idle for at least 100 TCK cycles.
	LOG("-->wating for 120 TCK cycle in Idle...\n",NULL);
	for(i = 0; i < 120; i++)
	{
		TapNext(0);
	}

	//select chain 13 (1011 --> 1101)  
	Arm7SelectScanChain(0xD);


	// the following 5 inputs might be option
	buf[0] = 0x4; //0100
	TapData(NULL, buf, 4);

	// the step can be ignored
/*
	// select the erase trimming latch, in the document, it only has 17 bits of the addr, i add the highest bit to be 1, which equals 255k
	// maybe adjust
	buf[0] = 0;
	buf[1] = 0xFC;	// 1111 1100
	//buf[2] = 0x33;	// 110011	--> set 18th bit to 1
	buf[2] = 0x31;	//110001	--> set 18th bit to 0
	TapData(NULL, buf, 22);

	buf[1] = 0x51;	// 01010001
	buf[2] = 0x30;	// 110000
	TapData(NULL, buf, 22);

	buf[1] = 0x51;	// 01010001
	buf[2] = 0x32;	// 110010
	TapData(NULL, buf, 22);

	buf[1] = 0x50;	// 01010000
	buf[2] = 0x0;	// 000000
	TapData(NULL, buf, 22);
*/
	//TapData(buf, NULL, 38);
	LOG("---------finish setting flash mode---------\n\n",NULL);

	return;
}

int VegaReset()
{
	
}

void VegaEnterDebug()
{
	Arm7ScanChain2(ICE_DBG_CTRL | 0x20 , 0x2);	//write, 010
}

int VegaUnprotectFlash()
{
	unsigned char buf[17] = {0};
	int i;

	LOG("\n-->starting to unprotect flash...\n",NULL);

	//might be adjusted: 0010 for addr shifting, 0100 for data shifting
	buf[0] = 0x2;	// data is shift in
	TapData(NULL,buf,4);

	// the last four bits might be adjusted, also 0010 for address shifting, 0011 for going directly to control register.
	//to clear the 128 P-Flash intermediate buffer and set the chain control register
	memset(buf,0,17);
	//buf[16] = 0x0C;	//0011
	buf[16] = 0x04; // 0010	for address
	TapData(NULL, buf, 132);

	// one sector is 2k, starting from 0 to 256k
	// set the first sector for testing
	//buf[2] = 0x30;
	//TapData(NULL, buf, 22);
	//scan in first sector addr 0x0;
	for(i=0; i < VEGA_SECTOR_NUMBER; i++)
	{
		LOG("send address, address to be sent: %d * 256K \n", i);
		buf[0] = reverseBitOrderLow4(i);
		buf[1] = 0;
		buf[2] = 0;
		buf[2] = buf[2] | 0x06; //00000110

		//scan in addr
		TapData(NULL, buf, 19);

		buf[0] = 0x80;	// 10000000,
		buf[1] = 0x70;	// 01110000
		buf[2] = 0x30;	// 110000
		TapData(NULL, buf, 22);

		buf[2] = 0x31;	//110001
		TapData(NULL, buf, 22);

		buf[2] = 0x30;	// 110000
		TapData(NULL, buf, 22);

		buf[0] = 0;
		buf[1] = 0x50; //01010000
		if(i == VEGA_SECTOR_NUMBER-1)
		{
			// no more sectors
			buf[2] = 0;	//0000
		}
		else
		{
			buf[2] = 0x10; //010000
		}
		TapData(NULL, buf, 22);
	}


	return 0;
}

int VegaWriteFlash(char* imagePtr, int imageLen)
{
	unsigned char buf[17] = {0};
	unsigned char *tmp = NULL;
	int i,j,k,len=imageLen;

	LOG("\n-->starting to write flash...\n",NULL);

	buf[0] = 0x08;	//0001
	TapData(NULL,buf,4);

	memset(buf,0,17);

	// write 40 bytes
	//set auto addr increment and auto load enable
	buf[4] = 0xCC; //11001100
	TapData(NULL,buf,40);

	buf[1] = 0x70; //01110000
	buf[2] = 0x4; //000100
	TapData(NULL,buf,22);

	memset(buf,0,17);

	// "next chain addr" may means 0011
	//116 times 0 + 0000 0011 0001 + 0011 = 15bytes 0 (120) + 0011 0001 + 0011
	//buf[15] = 0x8C; //10001100
	buf[15] = 0xB8; //10111000 according to the correction 
	//buf[16] = 0x0C; //0011
	buf[16] = 0x4; //0100
	TapData(NULL, buf, 132);

	buf[0] = 0x0;
	buf[1] = 0x0;
	//buf[2] = buf[2] | 0x1; //00000001
#if VEGA_LITE
	//this works for vega lite(80705)
	buf[2] = 0x4;	//100
	TapData(NULL, buf, 21);
#else
	//for vegabb, may need one more bit for addr.
	buf[2] = 0x8;
	TapData(NULL, buf, 22);
#endif
	// scan in addr

	tmp = imagePtr;

	/* Send data. */
	for(i = 0; i < VEGA_PAGE_NUMBER && len >0; i++)
	{
		LOG("\n...programming page %d, ", i);
		LOG(" %d bytes left\n", len);
		for(k = 0; k < VEGA_WORDS_PER_PAGE; k++)
		{
			//do not break when len <= 0, let the page be finished
			//if(len <= 0)
			//	break;
			//set data
			//only set 16 bytes, get 16 bytes from image
			memset(buf,0xFF,17);		//FF by default.
			//Reverse sequence of the whole 128 bits
			for(j = 15; j>=0 && len>0; j--)
			{
				buf[j] = reverseBitOrder8(*tmp);
				tmp++;
				len--;
			}
			buf[16] = 0x02; //0100
			TapData(NULL, buf, 132);
			//go 2 IDLE, normally only update-dr.
			TapNext(0);
		}

		LOG("-->wating for 10000 TCK cycle in Idle...\n",NULL);
	
		for(k = 0; k < 10000; k++)
		{
			TapNext(0);
		}

		//last page or the image is finished
		if(i==VEGA_PAGE_NUMBER-1 || len <= 0)
		{
			// leave write mode
			LOG("-->leaving writing mode, len = %d..\n",len);
			buf[0] = 0x0C;	//0011 - leave write mode
			TapData(NULL,buf,4);
			break;
		}
		else
		{
			buf[0] = 0x2; //0010	- further programming
			TapData(NULL,buf,4);
		}

	}

	//leaving 
	//no need to change scan chain
	//Arm7SelectScanChain(0x03);
	buf[0] = 0; //00000000
	buf[1] = 0x50; //01010000
	buf[2] = 0x20;//100000
	TapData(NULL, buf, 22);

	//scan in 36times 0 + 0000 to reset control chain 1
	memset(buf,0,17);
	TapData(NULL, buf, 40);
	
	return 0;
}

int VegaLiteErase()
{
	unsigned char buf[17] = {0};
	int i;
	unsigned long addr;

	LOG("\n-->Erasing flash...\n",NULL);
	buf[0] = 0x01;	//1000
	TapData(NULL,buf,4);

	memset(buf,0,17);

	//116 times 0 + 0000 0011 0001 + 0011 = 15bytes 0 (120) + 0011 0001 + 0011
	//last 4 bits might be adjusted 0011 for single sector erase, 0010 for multiple sector erase
	buf[15] = 0x8C; //10001100
	//buf[16] = 0x0C; //0011
	buf[16] = 0x4; //0100
	TapData(NULL, buf, 132);
	
	//for every sector erase 
	//every sector except the last
	for(i=0; i < VEGA_SECTOR_NUMBER; i++)
	{
		LOG("-->sending address, address to be sent: %d * 256K \n", i);
		//buf[0] = (unsigned char) addr;
		buf[0] = reverseBitOrderLow4(i);
		buf[1] = 0;
		buf[2] = 0;
		//buf[2] = buf[2] |  0x30; //00110000
		buf[2] = buf[2] | 0x06; //00000110

		// scan in addr
		TapData(NULL, buf, 19);
		
		if(i != VEGA_SECTOR_NUMBER-1)
		{
			buf[0] = 0x80;	// 10000000,
			buf[1] = 0x50;	// 01010000
			buf[2] = 0x30;	// 110000
			TapData(NULL, buf, 22);

			buf[2] = 0x31;	//110001
			TapData(NULL, buf, 22);

			buf[2] = 0x10;	// 010000
			TapData(NULL, buf, 22);
		}
	}

	//last sector
	//continue with 
	LOG("-->now handle the last sector\n",NULL); 

	// last address already scaned in
	//scan in 00000001 00000010 00 0011
	buf[0] = 0x80;	// 10000000,
	buf[1] = 0x40;	// 01000000
	buf[2] = 0x30;	// 110000
	
	TapData(NULL, buf, 22);

	// wait for t erase cycle, not sure how long it will take
	LOG("-->wating for 3000 TCK cycle in Idle...\n",NULL);
	TapNext(0);		// go 2 IDLE state
	for(i = 0; i < 3000; i++)
	{
		TapNext(0);
	}

	//scan in 00000001 00001010 000011
	buf[1] = 0x50;	// 01010000
	buf[2] = 0x30;	// 110000
	TapData(NULL, buf, 22);

	//scan in 00000001 00001010 000011
	buf[0] = 0;
	buf[1] = 0x50;	// 01010000
	buf[2] = 0x0;	// 000000
	TapData(NULL, buf, 22);

	return 0;
}

unsigned char reverseBitOrderLow4(unsigned char input)
{
    unsigned char mask = 1;
    unsigned char val = 0;
	unsigned char output = 0;
	int i=1;

	for(; i<=4; i++)
	{
		val = input & mask;
		if(val) //valid
		{
			output |= 1 << 4-i;
		}
		mask <<= 1;
	}
	
	return output;
}

unsigned char reverseBitOrder8(unsigned char input)
{
    unsigned char mask = 1;
    unsigned char val = 0;
	unsigned char output = 0;
	int i=1;

	for(; i<=8; i++)
	{
		val = input & mask;
		if(val) //valid
		{
			output |= 1 << 8-i;
		}
		mask <<= 1;
	}
	
	return output;
}

void reverseDWord(unsigned char* input)
{
    unsigned char mask = 1;
    //unsigned char output = 0;
	unsigned char val[4];
	int i=0;

	//reverse 4 bytes first
	for(i=0; i<4; i++)
	{
		val[3-i] = input[i];
	}

	for(i=0; i<4; i++)
	{
		input[i] = reverseBitOrder8(val[i]);
	}
	return;
}

void VegaReadFlash()
{
	unsigned char buf[17] = {0};
	unsigned char rbuf[17] = {0};
	int i = 0,j=0;

	//scan in 0010 to select chain 2
	LOG("\n-->Reading flash...\n",NULL);
	buf[0] = 0x04;	//0100
	TapData(NULL,buf,4);

	//input 0 + start addr (15 times 0 ) + 0001 = 18 times 0 + 01
	buf[0] = 0;
	//buf[2] = 0x08; //00001000
	buf[2] = 0x20; //100000, according to the correction
	TapData(NULL,buf,22);


	// write 40 bytes( 34 times 0 + 11 + 0100 )
	// to set auto addr increment and auto load enable
	memset(buf,0,17);
	buf[4] = 0x2C; //00101100
	TapData(NULL,buf,40);

	// set first read action
	buf[0] = 0x2; //0010
	TapData(NULL,buf,4);
	
	memset(buf,0,17);
	
	BIN_WRITE_INIT;
	//the stoping flag is the (129 - 132)bit, 0100(LSB) for more, 0001 for ending.
	//all words except the last one
	i = VEGA_WORD_NUMBER;
	for(i=1; i <= VEGA_WORD_NUMBER-1; i++)
	{
		LOG("reading Word %d\n",i);
		//buf[16] = 0x2; //0010
		memset(buf,0,17);
		//TapData(rbuf,buf,132); 
		TapData(rbuf,buf,128);  //read 128 first and then next chain addr
		buf[0] = 0x2; //0010
		TapData(NULL,buf,4);

		TapNext(0);
		for(j = 15; j>=0; j--)
		{
			BIN_WRITE(reverseBitOrder8(rbuf[j]));
		}
	}

	//last WORD
	LOG("reading last Word\n",i);
	memset(buf,0,17);
	//TapData(rbuf,buf,132); 
	TapData(rbuf,buf,128);  //read 128 first and then next chain addr
	for(j = 15; j>=0; j--)
	{
		BIN_WRITE(reverseBitOrder8(rbuf[j]));
	}
	
	buf[0] = 0x8; //1000
	TapData(NULL,buf,4);
	
	BIN_WRITE_END;
	
	//scan in 36times 0 + 0000 to reset control chain 1
	memset(buf,0,17);
	TapData(NULL, buf, 40);
}

void JtagAddrConvert(unsigned long addr, unsigned char **output)
{
    unsigned char mask = 1;
    unsigned char val = 0;
	int i=1;

	val = (unsigned char)reverseBitOrderLow4(addr);
	val |= (unsigned char)(reverseBitOrderLow4(addr>>4) << 4);
	output[0] = val;
	val = (unsigned char)reverseBitOrderLow4(addr>>8);
	val |= (unsigned char)reverseBitOrderLow4(addr>>12) << 4;
	output[1] = val;
	return output;
}
