#ifndef ONE_ONE_NAT_H
#define ONE_ONE_NAT_H

#include "vxworks.h"
#include <muxLib.h>
#include <iflib.h>
#include <lstLib.h>
#include <netinet/ppp/ppp.h>  //only for the value of NPPP
#include "oneonenatConstant.h"


class COneOneNAT
{
public:
	LIST 	NatList;
	END_OBJ *pLanEndObj;
	void*   LanCookie;
	char   	LanDevName[20];
	int   	LanDevUnit;
	char 	LanMac[6];
	
	ULONG   SpecialIP[MAX_SPECAIL_IP_NUM]; //network memeory order: note, SpecialIP[0] must be lan port ip
	WAN_IP_ATTR  Wan_IPs_Attr[ NPPP]; //Wan_IPs_Attr[0] only for NAPT, which maybe shared by some dhcp clients
	
	int     nOneOneNatClients;
	int     nSharingNAPTClients;
	int 	nIPPassThroughClients;
	ULONG   ulLastDefaultGatewayCheckTime;
	int     nAllowedRealNATNum;

	
public:
	COneOneNAT();
	
	BOOL			Init(char *LanDrvName,int LanUnit, ULONG *SpecailIP, int nSpecailIPNum);
	
	OneOneNATUnit*  AddOneNat(void *pDhcpClientAttr, char* service, char* UserName, char* password, int NAT_Type );
	BOOL 			DelOneNat_Private(OneOneNATUnit * pNat);
	BOOL 			DelAllNat();
	OneOneNATUnit*  FindClientViaIP_Private( ULONG ClientIP);
	OneOneNATUnit*  FindClientViaWanIP_Private( ULONG ClientIP);
	OneOneNATUnit*  FindClientViaWanEndUnit_Private( int WanUnit);
	
	OneOneNATUnit*	FindClient_Private( UCHAR *pClientMac);

	BOOL 			IsWanPPPOK( ULONG ClientIP, ULONG *priDNS,  ULONG *secDNS, int* NAT_Type);
	OneOneNATUnit * FindWanViaName_Private( char* DevName, int unit);

	BOOL 			StartNat( OneOneNATUnit* pNat );
	BOOL 			IsSpecialIP_Private( ULONG IP) ;
	BOOL			IsSpecialIPExceptLocalLanIP_Private( ULONG IP);
	BOOL 			AddSpecialIP_Private( ULONG IP );
	BOOL 			DelSpecialIP_Private( ULONG IP );
	BOOL            SynHttpDhcpTimeOut_Private( OneOneNATUnit* pNat);
	void 			PrintSpecialIP();


	//CALL by PPP stack
	BOOL 			SetOneOneNatWanIP(char* DevName, int DevUnit, ULONG LocalIP, ULONG remoteIP, ULONG mask, ULONG priDNSIP, ULONG secDNSIP );
	BOOL 			SetWanIfConnectionErrorStatus(char* DevName, int DevUnit, ULONG status );
	BOOL 			SetOneOneNatPSWError(char* DevName, int DevUnit );
	BOOL 			SetOneOneNatPPPDown(char* DevName, int DevUnit );
	
	BOOL 			CheckUserNamePassword_private( char *UserName, char *Password, int NATMode);
	BOOL 			CheckUserNamePassword_private2( char *UserName, char *Password, int NATMode);
	void 			PrintNatList( );
	BOOL 			IsNeedDisconnect_private( OneOneNATUnit* pTmpNat, int *ErrorStatus );
	BOOL 			NeedSolveDnsSpoofNegativeEffects( ULONG ClientIP, int *ppp_unit, ULONG *priDns, ULONG *secDns);
	BOOL			GetWanStatus(ULONG clientIP );
	int             GetNaptNum_Private();
	int 			GetShareLoginNum_Private();

	//To solve public ip same subnet problem caused by dhcp
	BOOL 			IsNeedToArpSpoofForSamePublicIPSubnet( char *SrcMac, ULONG IP );

	
	BOOL 			IsSharingToIndividual(/*input */ULONG OriginSrcIP, /*input */ULONG OriginDestIP, /*output */char *DestMac);
	
	BOOL 			IsIndividualToSharing_Private(/*input */ULONG OriginSrcIP, /*input */ULONG OriginDestIP);
	int 			GetAllNatNum_Private();
	

};
#endif
