#include "vxworks.h"
#include "netinet\in.h"
#include "xxxprotocol.h"
#include "dhcp\dhcp.h"
#include "stdio.h"
#include "stdlib.h"
#include "inetLib.h"
#include "sysLib.h"

#include "oneonenatconstant.h"
#include "dhcpClientinterface.h"
#include "flash_api.h"

extern BOOL bfAllInitOk;
//#define DHCP_CLIENT_DEBUG

SEM_ID dhcpNaTSem = NULL;
LOCAL LIST   dhcpClientList;
ULONG LanportNetmask = 0;
ULONG LanportIP = 0;

extern ULONG GetDhcpDNS1();
extern ULONG GetDhcpDNS2();
extern BOOL GetPerPCRedirectHomePage_Private(char* ClientMac, char *Buf, int BufferLen);

extern int GetEndTypeByName(char *EndNameUnit);
extern char *GetBrandpppSuffixName();
/**********************************************************************
 Note, In order to make less interferce, I add this file.
 When a dhcp client is assigned a ip, its client attribute will be added to here.
 When a dhcp client is released, its client attribute will be deleted here.
**********************************************************************/
BOOL DHCPNATInit()
{
	if( dhcpNaTSem == NULL )
	{
		dhcpNaTSem = semMCreate(SEM_Q_PRIORITY ); //SEM_Q_FIFO); //mutil_mute protection
		if( dhcpNaTSem == NULL)
		{
			printf("sem create error in DHCPNATInit\r\n");
			return FALSE;
		}

		lstInit( &dhcpClientList);		
	}

	/*SYSTEM_LanInfoGet( SUBNET_MASK_LONG, 0, (char *)&LanportNetmask, 4);
	if( LanportNetmask == 0 )
	{
		printf("system error: LanportNetmask = 0 in DHCPNATInit\r\n");
		LanportNetmask = inet_addr("255.255.255.0");		
	}
	else LanportNetmask = htonl(LanportNetmask);

	SYSTEM_LanInfoGet( IP_ADDR_LONG, 0, (char *)&LanportIP, 4);
	if( LanportIP == 0 )
	{
		printf("system error: LanportIP = 0 in DHCPNATInit\r\n");
		LanportIP = inet_addr("192.168.168.1");
	}
	else LanportIP = htonl(LanportIP); */

	LanportIP = GetUsingLanIP();
	LanportNetmask = GetUsingLanMask();	

	//printf("DHCPNATInit: "); PrintIP_LXX(LanportIP, FALSE); printf("/"); PrintIP_LXX(LanportNetmask, TRUE);

	return TRUE;
}

BOOL AddOneDHCPNAT(char* DHCPclientMac, ULONG DHCPclientIP, char *RootEndNameUnit)  //DHCPclientIP: network order
{
	DHCP_CLIENT_ATTR *pTmPDhcPClIent;
	
	if( dhcpNaTSem == NULL || /*pDhcpRes == NULL ||*/ !bfAllInitOk )
	{
		return FALSE;
	}

	if( semTake(dhcpNaTSem, sysClkRateGet() * 35) == ERROR) 
	{
		printf("AddOneDHCPNAT error: timeout\r\n");
		return FALSE;
	}

	if( !IsSameSubNet(DHCPclientIP, LanportIP, LanportNetmask) )
	{
		semGive(dhcpNaTSem);
		printf("AddOneDHCPNAT error: not same subnet\r\n");
		return FALSE;
	}

	//first find if it exist
	pTmPDhcPClIent = QueryDHCPNAT_Private(DHCPclientMac);
	if( pTmPDhcPClIent == NULL ) pTmPDhcPClIent = QueryDHCPNAT_Private3(DHCPclientIP);
	if( pTmPDhcPClIent != NULL )
	{  //find it already exist
		if( pTmPDhcPClIent->PrivateIPAttr.IP != DHCPclientIP )
		{
			printf("Error: AddOneDHCPNAT: old ip %s new ip %s\r\n", inet_ntoa(pTmPDhcPClIent->PrivateIPAttr.IP), inet_ntoa(DHCPclientIP) );

			//maybe it is error to do so
			pTmPDhcPClIent->PrivateIPAttr.IP = DHCPclientIP;
		}

		#ifdef DHCP_CLIENT_DEBUG
			printf("\r\nDHCPclient %02x%02x%02x%02x%02x%02x:%s is modified list.\r\n",
				DHCPclientMac[0], DHCPclientMac[1], DHCPclientMac[2], 
				DHCPclientMac[3], DHCPclientMac[4], DHCPclientMac[5], 
				inet_ntoa(PrivateIPAttr.IP) );
		#endif

		semGive(dhcpNaTSem);
		return TRUE;
	}

	pTmPDhcPClIent = (DHCP_CLIENT_ATTR *) malloc( MEM_SIZE_TO_OK(sizeof(DHCP_CLIENT_ATTR) ) );
	if( pTmPDhcPClIent == NULL)
	{		
		semGive(dhcpNaTSem);
		printf("No enough memory in AddOneDHCPNAT.\r\n");
		return FALSE;
	}

	//set initial value
	memset( pTmPDhcPClIent, 0, sizeof(DHCP_CLIENT_ATTR ) );
	//pTmPDhcPClIent->nCheckedStatus = FALSE;
	pTmPDhcPClIent->bfUsed = FALSE;
	pTmPDhcPClIent->NATStartOK = FALSE;
	pTmPDhcPClIent->Type_NAT = DHCPCLIENT_STATUS_NAPT;
	memcpy( pTmPDhcPClIent->dhcpClientMac, DHCPclientMac, 6);
	pTmPDhcPClIent->nChangePrivatePublicIP_Status = CHANGE_PRIVATE_PUBLIC_IP_STATUS_NORMAL;
	//pTmPDhcPClIent->bfHasRecvPublicDhcpPacket = 0;
	//pTmPDhcPClIent->LastHttpErr[0] = 0;

	pTmPDhcPClIent->PrivateIPAttr.IP 	  = DHCPclientIP;//network order
	pTmPDhcPClIent->PrivateIPAttr.Mask    = LanportNetmask; //network order
	pTmPDhcPClIent->PrivateIPAttr.Gateway = LanportIP;  //network order
	pTmPDhcPClIent->PrivateIPAttr.DhcpdIP = LanportIP;  //network order
	pTmPDhcPClIent->PrivateIPAttr.DNS1 	  = GetDhcpDNS1();  //network order
	pTmPDhcPClIent->PrivateIPAttr.DNS2    = GetDhcpDNS2() ;  //network order

	pTmPDhcPClIent->CurrentIPAttr = pTmPDhcPClIent->PrivateIPAttr; //set current with private for the first time
	
	//insert it to list
	lstInsert(&dhcpClientList, NULL, &pTmPDhcPClIent->Node );

	GetPerPCRedirectHomePage_Private( DHCPclientMac, pTmPDhcPClIent->redirectHomePage, sizeof(pTmPDhcPClIent->redirectHomePage) );

	//set dhcp resource pointer
	//pTmPDhcPClIent->pDhcpRes = pDhcpRes;

#ifdef DHCP_CLIENT_DEBUG
	printf("\r\nDHCPclient %02x%02x%02x%02x%02x%02x:%s is added into list.\r\n",
		DHCPclientMac[0], DHCPclientMac[1], DHCPclientMac[2], 
		DHCPclientMac[3], DHCPclientMac[4], DHCPclientMac[5], 
		inet_ntoa(DHCPclientIP) );
#endif

	memset( pTmPDhcPClIent->pppUserName, 0, sizeof(pTmPDhcPClIent->pppUserName) );
	memset( pTmPDhcPClIent->pppPassword, 0, sizeof(pTmPDhcPClIent->pppPassword) );
	
	if( IsDhcpClientSavePasword(DHCPclientMac, pTmPDhcPClIent->pppUserName, sizeof(pTmPDhcPClIent->pppUserName)-1, 
		pTmPDhcPClIent->pppPassword, sizeof(pTmPDhcPClIent->pppPassword) -1 ) )
		pTmPDhcPClIent->nSavedNamePsw = 1;

	pTmPDhcPClIent->EndType = GetEndTypeByName(RootEndNameUnit);
	//printf("pppUserName=%s, password=%s\r\n", pTmPDhcPClIent->pppUserName, pTmPDhcPClIent->pppPassword );

	semGive( dhcpNaTSem );
	
	return TRUE;	
}


BOOL DelOneDHCPNAT_Private(DHCP_CLIENT_ATTR* p)
{

	if( p == NULL ) return FALSE;

	if( p->pOneOneNAT != NULL )
		DelOneNat_Private( (OneOneNATUnit *)(p->pOneOneNAT) );
	
	lstDelete( &dhcpClientList, &p->Node );
	free (p );

	#ifdef DHCP_CLIENT_DEBUG
		printf("\r\nDHCPclient %02x%02x%02x%02x%02x%02x:%s is deleted.\r\n",
			DHCPclientMac[0], DHCPclientMac[1], DHCPclientMac[2], 
			DHCPclientMac[3], DHCPclientMac[4], DHCPclientMac[5], 
			inet_ntoa(DHCPclientIP) );
	#endif
	
	return TRUE;
}


DHCP_CLIENT_ATTR* QueryDHCPNAT_Private(char* DHCPclientMac)
{
	DHCP_CLIENT_ATTR * p;

	if( dhcpNaTSem== NULL || DHCPclientMac == NULL ) return NULL;

	p = (DHCP_CLIENT_ATTR *)lstFirst( &dhcpClientList);
	
	while( p != NULL )
	{			
		if( memcmp( p->dhcpClientMac, DHCPclientMac, 6) == 0  )
		{
			//printf("QueryDHCPNAT_Private ok\r\n");
			return p;
		}
			
		p = (DHCP_CLIENT_ATTR *) lstNext( &p->Node );		
	}

	return NULL;
}



DHCP_CLIENT_ATTR* QueryDHCPNAT_Private3( ULONG PrivateIP)//DHCPclientIP: network order
{
	DHCP_CLIENT_ATTR * p;

	if( dhcpNaTSem== NULL ) return NULL;

	p = (DHCP_CLIENT_ATTR *)lstFirst( &dhcpClientList);
	
	while( p != NULL )
	{
		if( p->PrivateIPAttr.IP == PrivateIP )
		{
			return p;
		}
			
		p = (DHCP_CLIENT_ATTR *) lstNext( &p->Node );		
	}

	return NULL;
}


DHCP_CLIENT_ATTR* QueryDHCPWithIPPassViaPublicIP_Private( ULONG publicIP )
{
	DHCP_CLIENT_ATTR * p;

	if( dhcpNaTSem== NULL ) return NULL;

	p = (DHCP_CLIENT_ATTR *)lstFirst( &dhcpClientList);
	
	while( p != NULL )
	{
		if( ( p->Type_NAT == DHCPCLIENT_STATUS_IPPASSTHROUGH) &&
			( p->CurrentIPAttr.IP == publicIP || p->NewIPAttr.IP == publicIP ))
		{
			return p;
		}
			
		p = (DHCP_CLIENT_ATTR *) lstNext( &p->Node );		
	}

	return NULL;
}





/**********************************
  IP : DHCP client IP
**********************************/
int AddDHCP_ONEONENAT_Private( ULONG IP, char* service, char* UserName, char* password, int type, int nBrowserType) //network order
{
	DHCP_CLIENT_ATTR *pDhcpClient = NULL;
	int res = AddDHCP_RESULT_ADDOK;
	
	if( dhcpNaTSem== NULL ) return AddDHCP_RESULT_SYSTEM_ERROR;

	//semTake(dhcpNaTSem, WAIT_FOREVER);

	pDhcpClient = QueryDHCPNAT_Private3( IP );
	if( pDhcpClient == NULL ) 
	{
		res = AddDHCP_RESULT_NOTDHCPIP;
		goto End;
	}

	if( pDhcpClient->pOneOneNAT != NULL ) 
	{ //already exist: maybe there are two browser exist at the same time
		printf("Already Exist Such OneOneNAT\r\n");
		res = AddDHCP_RESULT_ALREADY_EXIST;
		goto End;			
	}

	/*Note, during calling AddOneNat, the dhcpNaTSem must be locked, otherwise pDhcpClient maybe error */
	if( !AddOneNat((void *)pDhcpClient, service, UserName, password, type) )
	{
		res = AddDHCP_RESULT_ADDFAIL;
		goto End;
	}
	//only if addOneNatOk then change its type
	pDhcpClient->Browser_Type = nBrowserType;
	//printf("Browser_Type = %d\r\n", pDhcpClient->Browser_Type );
	

End:
	//printf("Leave AddDHCP_ONEONENAT\r\n");
	//semGive(dhcpNaTSem );
	return res;	
}



/*************************************************************
 mode can be:
  DHCPCLIENT_STATUS_UNDEF, 
  DHCPCLIENT_STATUS_ONEONENAT,
  DHCPCLIENT_STATUS_NAPT,  
  DHCPCLIENT_STATUS_IPPASSTHROUGH, 
************************************************************/
BOOL SetDhcpClientNatMode(ULONG IP, int mode)
{
	BOOL res = TRUE;
	DHCP_CLIENT_ATTR *pDhcPNatIf = NULL;
	
	if( dhcpNaTSem == NULL ) return FALSE;

	semTake( dhcpNaTSem, WAIT_FOREVER);

	pDhcPNatIf = QueryDHCPNAT_Private3( IP);

	if( pDhcPNatIf == NULL )
	{
		res = FALSE;
		goto END;
	}

	pDhcPNatIf->Type_NAT = mode;	

END:

	semGive( dhcpNaTSem );
	return res;
}


void PrintDHCPNAT( )//DHCPclientIP: network order
{
	DHCP_CLIENT_ATTR *p;

	OneOneNATUnit  *pNAT;   
	int i = 0;

	if( dhcpNaTSem== NULL ) return ;

	semTake( dhcpNaTSem, WAIT_FOREVER);

	p = (DHCP_CLIENT_ATTR *)lstFirst( &dhcpClientList);

	printf("DHCP Clients: %d\r\n", lstCount(&dhcpClientList) );
	while( p != NULL )
	{		
		printf("*********  %02d: ", ++i );
		ShortMemDumpXX( p->dhcpClientMac, 6);
		printf("  *******\r\n");
		printf("IP              Gateway         Subnet          PriDNS         SecDNs\r\n");
		printf("%s %s %s %s %s\r\n", inet_ntoa( p->PrivateIPAttr.IP), inet_ntoa( p->PrivateIPAttr.Gateway), inet_ntoa( p->PrivateIPAttr.Mask), inet_ntoa( p->PrivateIPAttr.DNS1), inet_ntoa( p->PrivateIPAttr.DNS2) );
		printf("%s %s %s %s %s\r\n", inet_ntoa( p->CurrentIPAttr.IP), inet_ntoa( p->CurrentIPAttr.Gateway), inet_ntoa( p->CurrentIPAttr.Mask), inet_ntoa( p->CurrentIPAttr.DNS1), inet_ntoa( p->CurrentIPAttr.DNS2) );
		printf("%s %s %s %s %s\r\n", inet_ntoa( p->NewIPAttr.IP),     inet_ntoa( p->NewIPAttr.Gateway),     inet_ntoa( p->NewIPAttr.Mask),     inet_ntoa( p->NewIPAttr.DNS1),     inet_ntoa( p->NewIPAttr.DNS2) );		
	#ifdef PPPOE_BRIDGE_SUPPORT	
		printf("NAT:Type:%ld(%d)  OS:%ld Browser:%d pppoe:%s EndType:%d\r\n", p->Type_NAT, p->nChangePrivatePublicIP_Status, p->OS_Type, p->Browser_Type, (p->bfPppoE?"Yes":"No"), p->EndType);
	#else 
		printf("NAT:Type:%ld(%d)  OS:%ld Browser:%d EndType:%d\r\n", p->Type_NAT, p->nChangePrivatePublicIP_Status, p->OS_Type, p->Browser_Type, p->EndType );
	#endif
	
		if( p->pOneOneNAT != NULL )
		{
			pNAT = (OneOneNATUnit *)p->pOneOneNAT;
			if( pNAT->pWanIPAttr != NULL )
				printf("ppp: I:%s G:%s D:%s %s\r\n", inet_ntoa(pNAT->pWanIPAttr->LocalIP),inet_ntoa(pNAT->pWanIPAttr->RealGateway), inet_ntoa(pNAT->pWanIPAttr->RealpriDNSIP), inet_ntoa(pNAT->pWanIPAttr->RealSecDNSIP));
		}		

		printf("\r\n");
		p = (DHCP_CLIENT_ATTR *) lstNext( &p->Node );		
	}

	semGive( dhcpNaTSem );

	return ;
}

BOOL SetDhcpClientInterfaceNewIP_Private(DHCP_CLIENT_ATTR *p, ULONG NewIP, ULONG NewGatewayIP, ULONG NewMask, ULONG NewDhcpdIP, ULONG NewDns1, ULONG NewDns2)
{
	if( p == NULL ) return FALSE;

	if( p->NewIPAttr.IP != NewIP )
	{		
		p->NewIPAttr.IP = NewIP;	
	}
	
	if( p->NewIPAttr.Gateway != NewGatewayIP ) 
	{
		p->NewIPAttr.Gateway = NewGatewayIP;
	}

	if( p->NewIPAttr.Mask!= NewMask )  
	{
		p->NewIPAttr.Mask = NewMask;
	}

	if( p->NewIPAttr.DhcpdIP != NewDhcpdIP )  
	{
		p->NewIPAttr.DhcpdIP = NewDhcpdIP;
	}

	if( p->NewIPAttr.DNS1!= NewDns1 )  
	{
		p->NewIPAttr.DNS1 = NewDns1;
	}


	if( p->NewIPAttr.DNS2!= NewDns2 )  
	{
		p->NewIPAttr.DNS2 = NewDns2;
	}

	return TRUE;
}


/*for ip passthrogh */
BOOL SetDhcpClientAttrStatus_private(DHCP_CLIENT_ATTR *p, int status)
{
	BOOL res = FALSE;
	OneOneNATUnit *pOneOneNAT = NULL;

	if( p == NULL) return FALSE;

	pOneOneNAT = (OneOneNATUnit *) p->pOneOneNAT;
	
	if( status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCANCEL )
	{  //Already using public ip, then it canbe set to CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCANCEL
		if( ( /*p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCHANGE ||*/ //2004.04.16 del
			p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEING ||
			p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK ) )
		{  //init for it
			p->nChangePrivatePublicIP_Status = status;
			
			p->NewIPAttr = p->PrivateIPAttr;
		}		
		else //otheriwse: already meet the condition. so accept it at once
		{
			//p->bfHasRecvPublicDhcpPacket = 0;
			p->nChangePrivatePublicIP_Status = CHANGE_PRIVATE_PUBLIC_IP_STATUS_NORMAL;
			
			//printf("set dhcpPublicIP to 0 in SetDhcpClientInterfaceStatus althoug to cancel\r\n");
		#ifndef  NEED_KEEP_LAST_IP
			p->CurrentIPAttr = p->PrivateIPAttr;
		#endif
		}
	}
	else
	{		 
		p->nChangePrivatePublicIP_Status = status;
		
		if( status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_NORMAL ) 
		{ //maybe ;
			
			
		}
		else if( status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK )
		{
			//printf("CHANGE_PRIVATE_PUBLIC_IP_STATUS_NORMAL set dhcpPublicIP to 0 in SetDhcpClientInterfaceStatus\r\n");
			p->CurrentIPAttr = p->NewIPAttr;

			memset( &p->NewIPAttr, 0, sizeof(p->NewIPAttr) );
		}
		else if( status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_CANCELOK )
		{
			p->CurrentIPAttr = p->PrivateIPAttr;
			
			//p->bfHasRecvPublicDhcpPacket = 0;		

			p->RecvLastIpPkt_IP = 0;
			p->RecvDhcpLastIP = 0;

			memset( &p->NewIPAttr, 0, sizeof(p->NewIPAttr) );
			p->nChangePrivatePublicIP_Status = CHANGE_PRIVATE_PUBLIC_IP_STATUS_NORMAL;
		}

	}

	//CHANGE some 
	if( p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCHANGE )
	{
		#ifdef NEED_SYNCHRONISE_DHCP_HTTP
			p->nHttpFreshed = 0;
		#endif

		if( pOneOneNAT != NULL )
		{
			pOneOneNAT->ulBeginChangePCIPTime = tickGet();
			
			pOneOneNAT->ulBeginSetupPPPTime = 0;
		}
	}
	else if( p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCANCEL )
	{		
		#ifdef NEED_SYNCHRONISE_DHCP_HTTP
			p->nHttpFreshed = 0;
		#endif		
	}

	if( p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK )
	{
		if( pOneOneNAT != NULL )
		{
			pOneOneNAT->ulBeginChangePCIPTime = 0;
			pOneOneNAT->ulBeginSetupPPPTime = 0;
		}
		
		p->nPPPConnecting_ClientIPChangeing = ONEONENAT_REAL_STATUS_NORMAL;
	}	
	else if( p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_NORMAL)
	{
		p->nPPPConnecting_ClientIPChangeing = ONEONENAT_REAL_STATUS_NORMAL;
	}


	//below mainly for http: browser
	if( pOneOneNAT != NULL )
	{
		if( p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEING )
		{
			if( pOneOneNAT->ulBeginChangePCIPTime_Changing == 0 )
				pOneOneNAT->ulBeginChangePCIPTime_Changing = tickGet();
		}
		else if( p->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK)
		{
			if( pOneOneNAT->ulBeginChangePCIPTime_ChangOK == 0 )
				pOneOneNAT->ulBeginChangePCIPTime_ChangOK= tickGet();
		}
	}
	
	res = TRUE;

//END:
	return res;
}

/*for ip passthrogh */
BOOL SetDhcpClientInterfaceStatus_private(char *Mac, int status)
{
	DHCP_CLIENT_ATTR * p;
	BOOL res = FALSE;

	if( dhcpNaTSem== NULL || Mac == NULL ) return res;
	//semTake( dhcpNaTSem, WAIT_FOREVER);

	p = QueryDHCPNAT_Private(Mac);
	if( p == NULL )
	{
		printf("SetDhcpClientInterfaceStatus not found\r\n");
		return FALSE;
	}

	return SetDhcpClientAttrStatus_private(p, status);
}

BOOL SetDhcpClientInterfaceStatus(char *Mac, int status)
{
	BOOL res = FALSE;
	
	if( dhcpNaTSem== NULL || Mac == NULL ) return res;

	semTake( dhcpNaTSem, WAIT_FOREVER);

	res = SetDhcpClientInterfaceStatus_private(Mac, status);

	semGive( dhcpNaTSem );
	return res;
}



static HttpStatusIDMsg HttpIDMsg[] = 
{
	{HTTP_STATUS_ID0,  HTTP_STATUS_ID0_STR},
	{HTTP_STATUS_ID1,  HTTP_STATUS_ID1_STR}, //this positin cannot be changed
	{HTTP_STATUS_ID2,  HTTP_STATUS_ID2_STR},
	{HTTP_STATUS_ID3,  HTTP_STATUS_ID3_STR},
	{HTTP_STATUS_ID4,  HTTP_STATUS_ID4_STR},
	{HTTP_STATUS_ID5,  HTTP_STATUS_ID5_STR},
	{HTTP_STATUS_ID6,  HTTP_STATUS_ID6_STR},
	{HTTP_STATUS_ID7,  HTTP_STATUS_ID7_STR},
	{HTTP_STATUS_ID8,  HTTP_STATUS_ID8_STR},
	{HTTP_STATUS_ID9,  HTTP_STATUS_ID9_STR},
	{HTTP_STATUS_ID10,  HTTP_STATUS_ID10_STR},
	{HTTP_STATUS_ID11,  HTTP_STATUS_ID11_STR},
	{HTTP_STATUS_ID12,  HTTP_STATUS_ID12_STR},
	{HTTP_STATUS_ID13,  HTTP_STATUS_ID13_STR},	
	{HTTP_STATUS_ID14,  HTTP_STATUS_ID14_STR},
	{HTTP_STATUS_ID15,  HTTP_STATUS_ID15_STR},
	{HTTP_STATUS_ID16,  HTTP_STATUS_ID16_STR}
};

char *GetHttpOneStatus(int ID)
{
	int i;

	for( i=0; i<sizeof(HttpIDMsg)/sizeof(HttpIDMsg[0]);i++)
	{
		if( HttpIDMsg[i].ID == ID ) 
			return  HttpIDMsg[i].Msg;
	}
	return HttpIDMsg[1].Msg;	//No Such Status ID
}

int GetDhcpClientNum()
{
	int num;
	if( dhcpNaTSem== NULL ) return 0;

	semTake( dhcpNaTSem, WAIT_FOREVER);

	num = lstCount(&dhcpClientList);

	semGive(dhcpNaTSem);

	return num;

	
}


BOOL SetRedirectHomePage(char* ClientMac, char *hostname, char *url)
{
	DHCP_CLIENT_ATTR *pTmPDhcPClIent;
	BOOL res = FALSE;

	if( dhcpNaTSem == NULL || ClientMac == NULL || hostname == NULL || url == NULL )
	{
		return FALSE;
	}

	semTake(dhcpNaTSem, WAIT_FOREVER);
	
	pTmPDhcPClIent = QueryDHCPNAT_Private(ClientMac);

	if( pTmPDhcPClIent == NULL ) goto END;

	if( strlen( hostname) + strlen(url) > sizeof(pTmPDhcPClIent->redirectHomePage) - 7) goto END;

	strcpy( pTmPDhcPClIent->redirectHomePage, hostname);

	//2003.04.04 delete url reason: one page maybe includes some sub http page,
	//So here it is very difficult to decide which url is the main http page.
	//So here dont' save url, but hostname
	//strcat( pTmPDhcPClIent->redirectHomePage, url);
	res = TRUE;

	//printf("redirectHomePage = %s\r\n", pTmPDhcPClIent->redirectHomePage );
	

END:
	semGive(dhcpNaTSem);

	return res;
}



BOOL SetRedirectHomePage2(ULONG clientIP, char *hostname, char *url)
{
	DHCP_CLIENT_ATTR *pTmPDhcPClIent;
	BOOL res = FALSE;

	if( dhcpNaTSem == NULL || clientIP == 0 || hostname == NULL || url == NULL )
	{
		return FALSE;
	}

	semTake(dhcpNaTSem, WAIT_FOREVER);
	
	pTmPDhcPClIent = QueryDHCPNAT_Private3(clientIP);

	if( pTmPDhcPClIent == NULL ) goto END;

	if( strlen( hostname) + strlen(url) > sizeof(pTmPDhcPClIent->redirectHomePage) - 7 -1) goto END;

	if( pTmPDhcPClIent->nChangePrivatePublicIP_Status >= CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCHANGE &&
		pTmPDhcPClIent->nChangePrivatePublicIP_Status <= CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK)
		goto END;  //not accept during changing ip
	
	memset( pTmPDhcPClIent->redirectHomePage, 0, sizeof(pTmPDhcPClIent->redirectHomePage ) );
	strncpy( pTmPDhcPClIent->redirectHomePage, hostname, sizeof(pTmPDhcPClIent->redirectHomePage) - 1);
	strcat( pTmPDhcPClIent->redirectHomePage, url);
	res = TRUE;

	//printf("redirectHomePage = %s\r\n", pTmPDhcPClIent->redirectHomePage );
	

END:
	semGive(dhcpNaTSem);

	return res;
}

BOOL IsNeedDisableGateway_Private(DHCP_CLIENT_ATTR *pDhcpClient )
{
	#ifdef PPPOE_BRIDGE_SUPPORT
	
		BOOL bfDisableGateway = FALSE;	
		ULONG ulPPPOETimeOut = sysClkRateGet() * 35; 
		ULONG ulCurrentTick ;	

		if( pDhcpClient == NULL ) goto END;
		if( !pDhcpClient->bfPppoE ) goto END;

		ulCurrentTick = tickGet();
			
		if( pDhcpClient->ulLastPppoePktTime && 
	        ulCurrentTick - pDhcpClient->ulLastPppoePktTime < ulPPPOETimeOut )
		{ //just now recv a pppoe pkt from dhcp client, so disabled dhcp client's gateway
			bfDisableGateway = TRUE;	
			//printf("disable dhcp gateway\r\n");
		}		
		else 
		{
			pDhcpClient->bfPppoE = FALSE;
			pDhcpClient->ulLastPppoePktTime = 0;
			//printf("restore dhcp gateway\r\n");
		}		
	
	END: 
		return bfDisableGateway;

	#else	
		return FALSE;	
	#endif
}

#if 0
BOOL Notify_AddDhcpClientDisableGatewayIP( char *Mac, ULONG IP )
{ 
	BOOL bfDisableGateway = FALSE;		
	DHCP_CLIENT_ATTR *pTmpDhcpClient = NULL;
	
	if( dhcpNaTSem == NULL || !bfAllInitOk ) return FALSE;

	if( semTake( dhcpNaTSem, sysClkRateGet() * 30 ) == ERROR ) return FALSE; //error
	pTmpDhcpClient = QueryDHCPNAT_Private( Mac );

	if( pTmpDhcpClient != NULL ) 
	{
		bfDisableGateway = IsNeedDisableGateway_Private(pTmpDhcpClient);
	}
	
END:		
	semGive( dhcpNaTSem );

	if( pTmpDhcpClient == NULL ) AddOneDHCPNAT( Mac, IP);
	
	return bfDisableGateway;
}
#endif

void Notify_DelDhcpClient( char *Mac)
{
	DHCP_CLIENT_ATTR *pTmpDhcpClient = NULL;

	if( IsUpgradeMode() ) return ;

	if( dhcpNaTSem == NULL || !bfAllInitOk ) return ;


	if( semTake( dhcpNaTSem, sysClkRateGet() * 10 ) == ERROR ) 
	{
		printf("Notify_DelDhcpClient timeout\r\n");
		return ; //error
	}
	
	pTmpDhcpClient = QueryDHCPNAT_Private( Mac );
	
	if( pTmpDhcpClient != NULL ) 
	{
		DelOneDHCPNAT_Private(pTmpDhcpClient);
	}

	semGive(dhcpNaTSem);
}

/*
Note, all long as QueryDHCPNAT_Private none null, it must return TRUE, else return FALSE
Note,
   For windows, if change private<-->public ip, first must send NAK
   For Mac OS.  if change private<-->public ip, no need to send NAK, otherwise it will wait 
                much long time to use new ip.
***********************************************************************************/
BOOL Notify_DhcpRenew(char *Mac, char DhcpPktType, ULONG ip_in_IPhead, ULONG *requestIP, ULONG *GatewayIP, ULONG *DhcpServeIP, ULONG *dhcpSubnet, ULONG *DNSIP1, ULONG *DNSIP2, char *RespondMsgType, char *RootEndNameUnit)
{
	DHCP_CLIENT_ATTR *pTmpDhcpClient = NULL;

	if( IsUpgradeMode() ) return TRUE;

	if( dhcpNaTSem == NULL || !bfAllInitOk ) return FALSE;
	

	if( Mac == NULL || requestIP == NULL || GatewayIP == NULL || DhcpServeIP == NULL ||
		dhcpSubnet == NULL || DNSIP1 == NULL || DNSIP2 == NULL || RespondMsgType == NULL )
	{
		printf("Notify_DhcpRenew NULL pointer\r\n");		
		return FALSE;
	}	
	
	if( semTake( dhcpNaTSem, sysClkRateGet() * 10 ) == ERROR ) 
	{
		printf("Notify_DhcpRenew timeout\r\n");
		return FALSE; //error
	}
	
	pTmpDhcpClient = QueryDHCPNAT_Private( Mac );

	if( pTmpDhcpClient == NULL ) 
	{
		semGive(dhcpNaTSem );

		//printf("add oneoneNAT\r\n");
		return AddOneDHCPNAT( Mac, *requestIP, RootEndNameUnit);
	}

	//First check if pc's change ip ok
	if( pTmpDhcpClient->NewIPAttr.IP != 0 && ip_in_IPhead == pTmpDhcpClient->NewIPAttr.IP ) //begin using required ip
	{  //PC's ip change ok
		if( pTmpDhcpClient->nChangePrivatePublicIP_Status >= CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCHANGE && 
		    pTmpDhcpClient->nChangePrivatePublicIP_Status < CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK )
		{
			SetDhcpClientAttrStatus_private( pTmpDhcpClient, CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK);
		}			
		else if( pTmpDhcpClient->nChangePrivatePublicIP_Status >= CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCANCEL && 
				 pTmpDhcpClient->nChangePrivatePublicIP_Status <= CHANGE_PRIVATE_PUBLIC_IP_STATUS_CANCELOK )
		{
			SetDhcpClientAttrStatus_private( pTmpDhcpClient, CHANGE_PRIVATE_PUBLIC_IP_STATUS_CANCELOK );
		}
	}

	//Check pc status: private ip ---- > public ip. ( not including CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK )
	if( pTmpDhcpClient->nChangePrivatePublicIP_Status >= CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCHANGE && 
		pTmpDhcpClient->nChangePrivatePublicIP_Status < CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK )
	{	//Send NAK if need be	
		if( pTmpDhcpClient->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCHANGE ) 
		{		
			#ifdef NEED_SYNCHRONISE_DHCP_HTTP
				if( pTmpDhcpClient->nHttpFreshed > 0 || pTmpDhcpClient->Browser_Type != BROWSER_TYPE_NETSCAPE )
			#endif	
				{		
					SetDhcpClientAttrStatus_private( pTmpDhcpClient, CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEING);
				}
			#ifdef NEED_SYNCHRONISE_DHCP_HTTP
				//else printf("wait for http\r\n");
			#endif	
		
		}
	
		if(pTmpDhcpClient->OS_Type != CLIENT_OS_MAC )
		{
			if( *requestIP != pTmpDhcpClient->NewIPAttr.IP && DhcpPktType == DHCPREQUEST )
			{  //still use old ip: First Send NAK: Only for window
				#ifdef NEED_SYNCHRONISE_DHCP_HTTP
					if( pTmpDhcpClient->nHttpFreshed > 0 || pTmpDhcpClient->Browser_Type != BROWSER_TYPE_NETSCAPE )
				#endif
					{
						*RespondMsgType = DHCPNAK;
						
					}

				*requestIP = pTmpDhcpClient->CurrentIPAttr.IP;
				*GatewayIP = pTmpDhcpClient->CurrentIPAttr.Gateway;
				*dhcpSubnet = pTmpDhcpClient->CurrentIPAttr.Mask;
				*DhcpServeIP = pTmpDhcpClient->CurrentIPAttr.DhcpdIP;
				//*DNSIP1 = pTmpDhcpClient->CurrentIPAttr.DNS1;
				//*DNSIP2 = pTmpDhcpClient->CurrentIPAttr.DNS2;

				goto END;
			
			}
		}

		//default process:
		*requestIP = pTmpDhcpClient->NewIPAttr.IP;
		*GatewayIP = pTmpDhcpClient->NewIPAttr.Gateway;
		*dhcpSubnet = pTmpDhcpClient->NewIPAttr.Mask;
		*DhcpServeIP = pTmpDhcpClient->NewIPAttr.DhcpdIP;
		//*DNSIP1 = pTmpDhcpClient->NewIPAttr.DNS1;
		//*DNSIP2 = pTmpDhcpClient->NewIPAttr.DNS2;		
		
		goto END;
	} //Check pc status: public ip ----> private ip. ( not including CHANGE_PRIVATE_PUBLIC_IP_STATUS_CANCELOK )
	else if( pTmpDhcpClient->nChangePrivatePublicIP_Status >= CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCANCEL && 
			 pTmpDhcpClient->nChangePrivatePublicIP_Status < CHANGE_PRIVATE_PUBLIC_IP_STATUS_CANCELOK )
	{	//During canceling stage, where is no need to synchronize with browser	
		if( pTmpDhcpClient->nChangePrivatePublicIP_Status == CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCANCEL ) 
		{
			SetDhcpClientAttrStatus_private( pTmpDhcpClient, CHANGE_PRIVATE_PUBLIC_IP_STATUS_CANCELING);
		}

		if( pTmpDhcpClient->OS_Type != CLIENT_OS_MAC )
		{
			if( *requestIP != pTmpDhcpClient->NewIPAttr.IP && DhcpPktType == DHCPREQUEST )
			{	 //still use old public ip	
				{		
					*RespondMsgType = DHCPNAK;
					
					*requestIP = pTmpDhcpClient->CurrentIPAttr.IP;	
					*GatewayIP = pTmpDhcpClient->CurrentIPAttr.Gateway;
					*dhcpSubnet = pTmpDhcpClient->CurrentIPAttr.Mask;
					*DhcpServeIP = pTmpDhcpClient->CurrentIPAttr.DhcpdIP;
					//*DNSIP1 = pTmpDhcpClient->CurrentIPAttr.DNS1;
					//*DNSIP2 = pTmpDhcpClient->CurrentIPAttr.DNS2;
					
					goto END;
				}
			}
		}
		
		//default process: 
		*requestIP = pTmpDhcpClient->NewIPAttr.IP;	
		*GatewayIP = pTmpDhcpClient->NewIPAttr.Gateway;
		*dhcpSubnet = pTmpDhcpClient->NewIPAttr.Mask;
		*DhcpServeIP = pTmpDhcpClient->NewIPAttr.DhcpdIP;
		//*DNSIP1 = pTmpDhcpClient->NewIPAttr.DNS1;
		//*DNSIP2 = pTmpDhcpClient->NewIPAttr.DNS2;

		goto END;
	}
	else
	{
		*requestIP = pTmpDhcpClient->CurrentIPAttr.IP;	
		*GatewayIP = pTmpDhcpClient->CurrentIPAttr.Gateway;
		*dhcpSubnet = pTmpDhcpClient->CurrentIPAttr.Mask;
		*DhcpServeIP = pTmpDhcpClient->CurrentIPAttr.DhcpdIP;
		//*DNSIP1 = pTmpDhcpClient->NewIPAttr.DNS1;
		//*DNSIP2 = pTmpDhcpClient->NewIPAttr.DNS2;

		
		if( *requestIP != 0 && *requestIP != pTmpDhcpClient->CurrentIPAttr.IP )
		{
			#if 1
				
				char p1[20];
				char p2[20];
				
	 			inet_ntoa_b( *(struct in_addr *)requestIP, p1);
				inet_ntoa_b( *(struct in_addr *)&pTmpDhcpClient->CurrentIPAttr.IP, p2);
				
				printf("Why ip conflicts: request %s, current ip:%s\r\n", p1, p2 );				
			#endif			
		}
				
		goto END;
	}
	
END:

	if( pTmpDhcpClient != NULL ) 
	{
		if( IsNeedDisableGateway_Private(pTmpDhcpClient) )
		{		
			if( GatewayIP != NULL ) 
			{
				*GatewayIP = 0;
	
				//printf("disable dhcp gateway\r\n");
			}
		}			
	}
	
	semGive(dhcpNaTSem );

	if( pTmpDhcpClient ) return TRUE;
	else 				 return FALSE;	
}


BOOL GetMacViaPrivateIP( ULONG IP, char *Mac)
{	
	DHCP_CLIENT_ATTR *pTmpDhcpClient = NULL;
	
	if( dhcpNaTSem == NULL || !bfAllInitOk ||Mac == NULL ) return FALSE;
	
	if( semTake( dhcpNaTSem, sysClkRateGet() * 10 ) == ERROR ) 
	{
		printf("GetMacViaPrivateIP timeout\r\n");
		return FALSE; //error
	}
		
	pTmpDhcpClient = QueryDHCPNAT_Private3( IP );

	if( pTmpDhcpClient != NULL) memcpy( Mac, pTmpDhcpClient->dhcpClientMac, 6);

	semGive( dhcpNaTSem );

	if( pTmpDhcpClient == NULL ) return FALSE;
	else return TRUE;
	
}


