#ifndef GB_PPP_USERNAME_MGR_H
#define GB_PPP_USERNAME_MGR_H

#define MAX_DHCPCLIENT_SAVE_NUM 20
#define MAX_PPPOE_USERNAME 128
#define MAX_PPPOE_PASSWORD 128

typedef struct DHCPClientPPPOEAttr
{
	char clientMac[6];
	char pppoe_userName[MAX_PPPOE_USERNAME];
	char pppoe_password[MAX_PPPOE_PASSWORD];
} DHCPClientPPPOEAttr;


typedef struct SGH_CONFIG
{
	int             cfgVersion;
	unsigned long	cfgSignature1;
    int 			nCurrentDhcpClientSavePswNum;
    DHCPClientPPPOEAttr DhcpClientAttr[MAX_DHCPCLIENT_SAVE_NUM]; //for save password
} SGH_CONFIG;



#ifdef __cplusplus
  extern "C" {
#endif

//EXPORT FUNCTION
BOOL ReadDB_PPPUserName (void);
BOOL SaveDB_PPPUserName_Private (void);
BOOL SaveDB_PPPUserName(void);

#define INPUT 
#define OUTPUT


//for dhcp client save/del username and pasword
BOOL IsDhcpClientSavePasword( INPUT char *ClientMac, OUTPUT char *UserName, int maxUserNameLen, OUTPUT char* Password, int maxPasswordLen);
BOOL SaveDhcpClientPasword( INPUT char *ClientMac, INPUT char *UserName, INPUT char* Password);
BOOL DelDhcpClientPasword( INPUT char *ClientMac);

#ifdef __cplusplus
}
#endif


#endif
