#define INPUT  
#define OUTPUT 

#include <netinet/ppp/ppp.h>  //only for the value of NPPP

#define HTTPD_LOGIN_PASS    		1
#define HTTPD_LOGIN_FAIL    		-1

//#define HTTPD_MAX_LINE_LENGTH		256
/*2004.04.12 
  Note, for some website will use cookie, which will cuase http Line longer than 256. 
  So now change it to 1024. Maybe latter need to change it to big value */   
#define HTTPD_MAX_LINE_LENGTH		1024

#define HTTPD_MAX_URL_LENGTH		256

#define HTTP_SECURITY_LEVEL_NO           0
#define HTTP_SECURITY_LEVEL_GUEST     	 1
#define HTTP_SECURITY_LEVEL_USER      	 2
#define HTTP_SECURITY_LEVEL_ADMIN     	 3
#define HTTP_SECURITY_LEVEL_SUPER     	 4
#define HTTP_SECURITY_LEVEL_SUPER_SGH  	 5


#define INET_ADDR_LEN 18

#define HTTP_DEFAULT_MAX_CONN     ( NPPP * 4 + 32 )
#define HTTP_DAEMON_PRIORITY      70
#define HTTP_DAEMON_STACK         45000
#define HTTPP_MAX_LINE_LENGTH   	128
#define SERVER_MAX_CONNECTIONS    	( 2 * NPPP)
#define HTTP_SESSION_PRIORITY   	70 
#define HTTP_SESSION_STACK      	40000

#define HTTP_FILES_MAX_BLOCKS   	150

#define WAIT_FOREVER_HTTP 0


#define ENABLEDHOMES 1
#ifdef ENABLEDHOMES
	#define HTTP_DAEMON_TCP_SOCKET    	80
#else
	#define HTTP_DAEMON_TCP_SOCKET    	81
#endif

#define HTTP_CONTENT_TYPE_OTHER         1
#define HTTP_CONTENT_TYPE_APPURLENCODE  	2
#define HTTP_CONTENT_TYPE_MULFORMDATA   	3
#define HTTP_CONTENT_TYPE_TXTPLAIN      4
#define HTTP_CONTENT_TYPE_TXTHTML       10
#define HTTP_CONTENT_TYPE_IMGGIF        11
#define HTTP_CONTENT_TYPE_IMGJPG        12
#define HTTP_CONTENT_TYPE_APPJAV        13
#define HTTP_CONTENT_TYPE_UNKNOWN       99

/*****************************************************************
 *
 *  Defines
 *
******************************************************************/
#define CR  0xD
#define LF  0xA
#define HT  0x9
#define SP  0x20


/*HTTP_FILES_SYSTEM: Used to store http files for http get command*/
typedef struct {
    char *urlName;
    char *fileData;
    int  fileLength;
    FUNCPTR updateFunction;	
	int     AccessLevel; /*the access level for user to use */
    
} HTTP_FILES_SYSTEM, *pHTTP_FILES_SYSTEM;

/*HTTP_POST_ACTION: Used to store http post command to execute the http post command*/
typedef struct  {
    char *urlName;
    FUNCPTR postFunction;
	int     AccessLevel; /*the access level for user to use */
} HTTP_POST_ACTION, *pHTTP_POST_ACTION;


/***************************************************************************
 *
 *	Structures
 *	
 ***************************************************************************/
typedef struct {
	unsigned long	httpClientIP;
	int 			status;
	int 			sock; 
	int 			id;
	int 			reserved;
	BOOL			bfOnlyOnce;//if true--mean the socket only receive one http page, then close it
	char            HostName[HTTPD_MAX_LINE_LENGTH + 1]; /*www.status or 192.168.168.1 most time if no dns spoof*/
	int             Browser_Type;
	int             OS_Type;
	
} HTTP_CONN, *pHTTP_CONN;



#ifdef __cplusplus
extern "C"   //add this for below function can be used in c++ files.
{          //but at the c++ file, must define CPP_SGH at the most top
#endif  

int 	strcmpi (const char *s1, const char *s2);
char 	*strstri(const char *s1, const char *s2);
int 	sgets (char *inBuffer, char *outLine, int bufLength);
char 	*nextstartofline (char *inString );
char 	*nextparagraph (char *inString );
char 	*strcat_num (char *inString, char *append_str, int num_copy);


#ifdef __cplusplus
}
#endif  

