/****************************************************************************
*
*    Name:            SnmpaCfg.h
*
*    Description:    Snmp Agent Configuration declarations.
*
*    Copyright:        (c) 2001 Conexant Systems Inc.
*
*    Revision:    Date:        Author:                Description:
*
*    00.00.0000    10/18/01    George G. Vlasov    Created.
*
*****************************************************************************
*    $Author: shao-gh $
*    $Revision: 1.1.1.1 $
*    $Modtime:   Dec 05 2001 15:38:22  $
****************************************************************************/

#ifndef SNMPACFG_H
#define SNMPACFG_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>
#include <bsptypes.h>

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/
//#define SNMPA_DEBUG     1

#define SNMP_COMMUNITY_SIZE_MAX             (255 + 1)

#define SNMP_SYSTEM_DESCRIPTION_SIZE_MAX    (255 + 1)
#define SNMP_SYSTEM_CONTACT_SIZE_MAX        (255 + 1)
#define SNMP_SYSTEM_NAME_SIZE_MAX           (255 + 1)
#define SNMP_SYSTEM_LOCATION_SIZE_MAX       (255 + 1)
#define SNMP_SYSTEM_SERVICES_MIN            (0)
#define SNMP_SYSTEM_SERVICES_MAX            (0x7F)
#define SNMP_SYSTEM_SERVICES_DEFAULT        (0x4F)


#define SNMP_TRAP_ADDR_MAX      (5)

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Type definitions
****************************************************************************/

typedef
struct SNMP_AGENT_TRAP_DEST_CFG
{
    IP_ADDRESS_T    IpAddress;
    DWORD           Port;
} SNMP_AGENT_TRAP_DEST_CFG;

typedef
struct SNMP_AGENT_TRAP_DEST_LIST_CFG
{
	ULONG						Count;
	SNMP_AGENT_TRAP_DEST_CFG	Array[SNMP_TRAP_ADDR_MAX];
} SNMP_AGENT_TRAP_DEST_LIST_CFG;

typedef
struct SNMP_AGENT_TRAP_CFG
{
    DWORD                           SnmpVersion;
    SNMP_AGENT_TRAP_DEST_LIST_CFG	DestList;
} SNMP_AGENT_TRAP_CFG;

typedef
struct SNMP_AGENT_COMMUNITY_CFG
{
    char    ReadOnly[SNMP_COMMUNITY_SIZE_MAX];
    char    ReadWrite[SNMP_COMMUNITY_SIZE_MAX];
    char    Trap[SNMP_COMMUNITY_SIZE_MAX];
} SNMP_AGENT_COMMUNITY_CFG;

typedef
struct SNMP_AGENT_SYSTEM_CFG
{
    char        Description[SNMP_SYSTEM_DESCRIPTION_SIZE_MAX];
    M2_OBJECTID ObjectId;
    char        Contact[SNMP_SYSTEM_CONTACT_SIZE_MAX];
    char        Name[SNMP_SYSTEM_NAME_SIZE_MAX];
    char        Location[SNMP_SYSTEM_LOCATION_SIZE_MAX];
} SNMP_AGENT_SYSTEM_CFG;

typedef
struct SNMP_AGENT_CFG
{
    SNMP_AGENT_COMMUNITY_CFG    Community;
    SNMP_AGENT_SYSTEM_CFG       System;
    SNMP_AGENT_TRAP_CFG         Trap;
} SNMP_AGENT_CFG;

extern SNMP_AGENT_CFG    g_SnmpAgentCfg;

/****************************************************************************
*  Function prototypes
****************************************************************************/

BOOL
SnmpAgentSave
(
    char*    pRegPath
);

BOOL
SnmpAgentCreateDefault
(
);

BOOL 
SnmpAgentModuleInit
(
);

#endif /* SNMPACFG_H */ 
