/****************************************************************************
*
*   Name:           PppCfg.h
*
*   Description:    Ppp Configuration implementation.
*
*   Copyright:      (c) 2001 Conexant Systems Inc.
*
*   Revision:   Date:       Author:             Description:
*
*   00.00.0000  03/26/02    George G. Vlasov    Created.
*
*****************************************************************************
*   $Author: shao-gh $
*   $Revision: 1.1.1.1 $
*   $Modtime:   Dec 09 2002 14:33:42  $
****************************************************************************/

#ifndef PPPCFG_H
#define PPPCFG_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "bspcfg.h"

#include "JxCfgMgr.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

#define PPP_CFG_ACCOUNT_MAX					(16 + 1)
#define PPP_CFG_NET_IF_MAX					(16 + 1)

#define PPP_USER_NAME_SIZE_MAX				(128 + 1)
#define PPP_PASSWORD_SIZE_MAX				(128 + 1)
#define PPP_SERVICE_NAME_SIZE_MAX			(32 + 1)

#define PPP_ACCOUNT_NAME_SIZE_MAX			(32 + 1)

/****************************************************************************
*  Type definitions
****************************************************************************/

typedef
char	PPP_ACCOUNT_NAME_T[PPP_ACCOUNT_NAME_SIZE_MAX];

typedef
char	PPP_USER_NAME_T[PPP_USER_NAME_SIZE_MAX];

typedef
char	PPP_PASSWORD_T[PPP_PASSWORD_SIZE_MAX];

typedef
char	PPP_SERVICE_NAME_T[PPP_SERVICE_NAME_SIZE_MAX];

typedef
struct PPP_CFG_ACCOUNT_T
{
	PPP_ACCOUNT_NAME_T	Name;
	PPP_USER_NAME_T		UserName;
	PPP_USER_NAME_T		Password;
} PPP_CFG_ACCOUNT_T;

typedef
enum PPP_MODE_T
{
	PPP_MODE_PPPOA, 
	PPP_MODE_PPPOE, 

	PPP_MODE_MAX 
} PPP_MODE_T;

typedef
struct PPP_CFG_NET_IF_T
{
	NET_IF_ALIAS_T		Alias;
	DWORD				Mode;
	PPP_ACCOUNT_NAME_T	AccountName;
	PPP_SERVICE_NAME_T	ServiceName;
	JX_OBJ_ID_T			NetAdapterId;
	DWORD				AuthenticationMode;
	DWORD				IdleTime;
	DWORD				AutoConnectEnabled;
	DWORD				FastConnectEnabled;
	DWORD				Mru;
	DWORD				Mtu;
	DWORD				Mss;
	DWORD				IdleTrafficFilterEnabled;
} PPP_CFG_NET_IF_T;

/****************************************************************************
*  Function prototypes
****************************************************************************/

STATUS 
PppCfgAccountAdd
(
	PPP_CFG_ACCOUNT_T*	pData
);

STATUS 
PppCfgAccountDelete
(
	char*	pAccountName
);

STATUS 
PppCfgAccountGet
(
	ULONG				Index, 
	PPP_CFG_ACCOUNT_T*	pData
);

STATUS 
PppCfgAccountSet
(
	PPP_CFG_ACCOUNT_T*	pData
);

STATUS 
PppCfgNetIfAdd
(
	PPP_CFG_NET_IF_T*	pData
);

STATUS 
PppCfgNetIfDelete
(
	char*	pAlias
);

STATUS 
PppCfgNetIfGet
(
	ULONG				Index, 
	PPP_CFG_NET_IF_T*	pData
);

STATUS 
PppCfgNetIfSet
(
	PPP_CFG_NET_IF_T*	pData
);

STATUS 
PppCfgNetIfGetByAlias
(
	char*				pAlias, 
	PPP_CFG_NET_IF_T*	pData
);

BOOL
PppModuleRegister
(
);

BOOL
PppModuleInit
(
);

#endif /* PPPCFG_H */ 
