/*
 * $Log: ktr.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:44  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:15:56  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:51:32  TTY
 * Initial revision
 *
 * 
 * 4     4/30/98 1:16p Rajive
 * Overwrote with INCLUDE v4.2.1
 * 
 * 3     4/27/98 11:42a Release Engineer
 * Additions into include for L2TP and RTM modules.
 * INCLUDE v4.2.1
 * 
 * 1     2/13/98 12:18a Release Engineer
 * code cleanup, code style changes, linted, system level test
 * INCLUDE v4.2.0
 * 
 * 2     3/27/96 7:08p Ross
 * Initial check-in with source safe.
*/
/*	$Modname: ktr.h$  $version: 1.3$      $date: 12/03/93$   */
/*
* 	$lgb$
1.0 10/11/93 ross adding version control.
1.1 10/11/93 ross
1.2 10/11/93 ross version control.
1.3 12/03/93 ross fixes for lsl version 3.0
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1998 RouterWare, Inc..									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca	*/
/************************************************************************/

enum FUNCTIONAL_GROUP_ADDRESSES
{
	NULL_GROUP_ADDRESS = 0x00000000,
	ACTIVE_MONITOR = 0x00000001,
	RING_PARAMETER_SERVER = 0x00000002,
	RING_ERROR_MONITOR = 0x00000008,
	CONFIGURATION_REPORT_SERVER_FA = 0x00000010,
	NETBIOS_ADDRESS = 0x00000080,
	BRIDGE = 0x00000100,
	FILLER = 0x10000000L
};


enum CLASS
{
	RING_STATION_CLASS,
	LLC_MANAGER_CLASS,
	CONFIGURATION_REPORT_SERVER_CLASS = 0x04,
	RING_PARAMETER_SERVER_CLASS,
	RING_ERROR_MONITOR_CLASS
};

enum MAJOR_VECTOR_COMMAND
{
	RESPONSE = 0x00, 
	BEACON = 0x02,
	CLAIM_TOKEN = 0x03,
	RING_PURGE = 0x04,
	ACTIVE_MONITOR_PRESENT = 0x05,
	STANDBY_MONITOR_PRESENT = 0x06,
	DUPLICATE_ADDRESS_TEST = 0x07,
	LOBE_MEDIA_TEST = 0x08,
	TRANSMIT_FORWARD = 0x09, /* IBM forwards */
	REMOVE_RING_STATION = 0x0b,
	CHANGE_PARAMETERS = 0x0c,
	INITIALIZE_RING_STATION = 0x0d, /* */
	REQUEST_STATION_ADDRESS = 0x0e,
	REQUEST_STATION_STATE = 0x0f,
	REQUEST_STATION_ATTACHMENT = 0x10,
	REQUEST_INITIALIZATION_MV = 0x20,
	REPORT_STATION_ADDRESS = 0x22,
	REPORT_STATION_STATE = 0x23,
	REPORT_STATION_ATTACHMENT = 0x24,
	REPORT_NEW_MONITOR = 0x25,
	REPORT_NAUN_CHANGE = 0x26,
	REPORT_NEIGHBOR_NOTIFICATION_INCOMPLETE = 0x27,
	REPORT_ACTIVE_MONITOR_ERROR = 0x28,
	REPORT_SOFT_ERROR = 0x29,
	REPORT_TRANSMIT_FORWARD = 0x2a /* maybe IBM forwards */
};

enum SUBVECTOR_TYPES
{
	BEACON_TYPE = 0x01,
	UPSTREAM_NEIGHBORS_ADDRESS = 0x02,
	LOCAL_RING_NUMBER = 0x03,
	ASSIGN_PHYSICAL_DROP_NUMBER = 0x04,
	SOFT_ERROR_REPORT_TIMER = 0x05,
	ENABLED_FUNCTION_CLASSES = 0x06,
	ALLOWED_ACCESS_PRIORITY = 0x07,
	AUTHORIZED_ENVIRONMENT = 0x08,
	CORRELATOR = 0x09,
	ADDRESS_OF_LAST_RING_POLL = 0x0a,
	PHYSICAL_DROP_NUMBER = 0x0b,
	RESPONSE_CODE = 0x20,
	RESERVED_ = 0x21,
	PRODUCT_INSTANCE_ID = 0x22,
	ADAPTER_SOFTWARE_LEVEL = 0x23,
	WRAP_DATA = 0x26,
	FRAME_FORWARD = 0x27,
	TRANSMIT_STATUS_CODE = 0x2a,
	GROUP_ADDRESS = 0x2b,
	FUNCTIONAL_ADDRESS = 0x2c,
	ISOLATING_ERROR_COUNTS = 0x2d,
	NON_ISOLATING_ERROR_COUNTS = 0x2e,
	FUNCTION_REQUEST_ID = 0x2f,
	ERROR_CODE = 0x30
};

enum FRAME_TYPE
{
	MAC_CONTROL_FRAME,
	NON_MAC_CONTROL_FRAME
};

enum PCF_ATTENTION
{
	EXPRESS_BUFFER = 0x1,
	BEACON_ATTENTION,
	CLAIM_TOKEN_ATTENTION,
	RING_PURGE_ATTENTION,
	ACTIVE_MONITOR_PRESENT_ATTENTION,
	STANDBY_MONITOR_PRESENT_ATTENTION
};

enum MAC_RESPONSE_SUBVECTOR_CODE_VALUES
{
	POSITIVE_RESPONSE_OR_ACK = 0x0001,
	MAC_FRAME_DATA_FIELD_INCOMPLETE = 0x8001,
	MAJOR_VECTOR_LENGTH_INVALID,
	MAJOR_VECTOR_COMMAND_NOT_SUPPORTED,
	INAPPROPRIATE_SOURCE_CLASS,
	SUBVECTOR_LENGTH_INVALID,
	TRANSMIT_FORWARD_FRAME_ERROR,
	REQUIRED_SUBVECTOR_MISSING,
	REQUIRED_SUBVECTOR_UNKNOWN,
	MAC_FRAME_EXCEEDS_MAXIMUM_LENGTH,
	FUNCTION_DISABLED
};

enum BROADCAST_INDICATOR_TYPE
{
	NON_BROADCAST,
	ALL_ROUTES_BROADCAST = 0x4,
	SINGLE_ROUTE_BROADCAST = 0x6,
	SINGLE_ROUTE_BROADCAST_ALL_ROUTES_BROADCAST_RETURN = 0x7
};

enum ROUTE_INFORMATION_DIRECTION
{
	LEFT_TO_RIGHT,
	RIGHT_TO_LEFT
};

enum LARGEST_FRAME
{
	_516,
	_1470,
	_2052,
	_4472,
	_8144,
	_11407,
	_17800,
	INITIAL_VALUE_OF_BROADCAST_FRAMES
};

enum TOKEN_RING_STATE
{
	OFF_LINE,
	RUNNING_DIAGNOSTICS,
	TESTING_LOBE,
	INSERTING_INTO_RING,
	BEACONING,
	INSERTED_INTO_RING_OK
};

enum TX_PRIORITY 
{
	PRIORITY_0,
	PRIORITY_1,
	PRIORITY_2,
	PRIORITY_3,
	PRIORITY_4,
	PRIORITY_5,
	PRIORITY_6,
	PRIORITY_7
};

enum REPORT_MONITOR_ERROR_TYPE
{
	MONITOR_ERROR = 0x0001,
	DUPLICATE_MONITOR = 0x0002,
	DUPLICATE_ADDRESS = 0x0003,
	_ENUM_WIDTH = 0x1000
};

/* MIB enums */

enum TOKEN_RING_COMMAND
{
	NOOP_COMMAND = 1,
	OPEN_COMMAND = 2,
	RESET_COMMAND = 3,
	CLOSE_COMMAND = 4,
	__ENUM_WIDTH = 0x10000000
};

enum RING_STATE_TYPE
{
	OPENED = 1,
	CLOSED,
	OPENING,
	CLOSING,
	OPEN_FAILURE,
	RING_FAILURE_STATE,
	___ENUM_WIDTH = 0x10000000L
};

enum RING_OPEN_STATUS_TYPE
{
	NO_OPEN = 1,
	BAD_PARAMETER = 2,
	LOBE_FAILED,
	SIGNAL_LOSS_STATUS,
	INSERTION_TIMEOUT,
	RING_FAILED,
	BEACONING_STATUS,
	DUPLICATE_MAC,
	REQUEST_FAILED,
	REMOVE_RECEIVED_STATUS,
	OPEN_SUCCESSFUL,
	____ENUM_WIDTH = 0x10000000L
};

enum RING_SPEED_TYPE
{
	UNKNOWN_SPEED = 1,
	ONE_MEGABIT = 2,
	FOUR_MEGABIT = 3,
	SIXTEEN_MEGABIT = 4,
	_____ENUM_WIDTH = 0x10000000L
};

enum BIG_BOOLEAN
{
	BIG_TRUE,
	BIG_FALSE,
	__ENUM_WIDTH_ = 0x10000000L
};

enum ADDRESS_MATCH_RECEIVE_CODES
{
	COPIED_USING_CAF,
	INTERNALLY_ADDRESSED_MATCHED,
	EXTERNALLY_MATCHED_VIA_XMATCH_OR_XFAIL_INTERFACE,
	INTERNALLY_AND_EXTERNALLY_MATCHED
};

/* rps.c */

enum RPS_CORRELATOR_TYPES
{
	INITIALIZE_RING_STATION_CORRELATOR = 0x0000,
	_________ENUM_WIDTH = 0x1000
};

#define SIZE_OF_CRC 4
