/****************************************************************************
*
*   Name:           IpRoute.h
*
*   Description:    Ip Route header file
*
*   Copyright:      (c) 2002 Conexant Systems Inc.
*
*****************************************************************************
*   $Author: shao-gh $
*   $Revision: 1.1.1.1 $
*   $Modtime:   Oct 22 2002 08:34:24  $
****************************************************************************/

#if __cplusplus
extern "C" {
#endif

#ifndef IP_ROUTE_H
#define IP_ROUTE_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "bspcfg.h"
#include "bsptypes.h"

#include "JxCfgMgr.h"
#include "IpCfg.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Type definitions
****************************************************************************/

/****************************************************************************
*  Function prototypes
****************************************************************************/

UINT32	IpRouteAdd(UINT32 dst, UINT32 gateway);
UINT32  IpRouteDefaultRouteGet(UINT32 *default_route_P);
BOOL 	IpRouteUserRouteAdd(IP_CFG_ROUTE_DATA_T* pIpCfgRoute);
BOOL 	IpRouteUserRouteDelete(IP_CFG_ROUTE_DATA_T* pIpCfgRoute);
void 	IpRouteDefaultGatewayChange( IP_CFG_GATEWAY_DATA_T* pIpCfgGateway );
UINT32 	IpRouteIfGatewayFindByIfName( char* pIfName );
BOOL 	IpRouteIfGatewayAdd( char* pAlias, UINT32 Gateway );
BOOL 	IpRouteIfGatewayDelete( char* pAlias );
UINT32 	IpRouteSetIpConfigs(UINT32 ipaddr, UINT32 netmask, char *if_name_P);
BOOL 	IpRouteStart( void );


#endif /* IP_ROUTE_H */ 

#if __cplusplus
}
#endif
