/****************************************************************************
*
*	Name:			IpFilter.h
*
*	Description:	IP Filter hooks with sequence configuration declarations.
*
*	Copyright:		(c) 2002 Conexant Systems Inc.
*
*****************************************************************************
*	$Author: shao-gh $
*	$Revision: 1.1.1.1 $
*	$Modtime:   Jan 07 2003 13:45:46  $
****************************************************************************/

#ifndef IP_FILTER_H
#define IP_FILTER_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "net/mbuf.h"
#include "netinet/in.h"
#include "netinet/ip.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Type definitions
****************************************************************************/

/* Defines the processing sequence of the IpFilterSeqHookRoutine(). */
typedef enum IP_FILTER_SEQ_T
{
    IP_FILTER_SEQ_CLIENT_FILTER,
    IP_FILTER_SEQ_FIREWALL,
    IP_FILTER_SEQ_IGMP,
    IP_FILTER_SEQ_NAT,
    IP_FILTER_SEQ_AUTO_WAN_CONNECT,
    IP_FILTER_SEQ_PPP_HALF_BRIDGE,
    IP_FILTER_SEQ_MAX
} IP_FILTER_SEQ_T;

/****************************************************************************
*  Function prototypes
****************************************************************************/

/******************************************************************************
|
|  Function:    IpFilterSeqHookAdd
|
|  Description: Add a routine, in specified sequence, to receive all internet 
|               protocol packets.
|
|               It ensures the proper sequence of the ipFilterHook process 
|               within the IpFilterSeqHook conext.
|
|               This is done by hooking IpFilterSeqHookRoutine() to the 
|               system's ipFilterHook list and maintaining a separate 
|               list of IpFilterSeqHook routines in the specified sequence 
|               within this IpFilterSeqHook context for IpFilterSeqHookRoutine() 
|               to process.
| 
|  Parameters:  FUNCPTR IpFilterSeqHook     routine to receive raw ip packets
|               IP_FILTER_SEQ_T Sequence    sequence # for this routine
|                                           !! MUST be one of defined ENUM values !!
|
|  Returns:     OK      hooked properly
|               ERROR   failed to hook
| 
*******************************************************************************/

STATUS IpFilterSeqHookAdd
(
    FUNCPTR         IpFilterSeqHook,
    IP_FILTER_SEQ_T Sequence
);

/******************************************************************************
|
|  Function:    IpFilterSeqHookDelete
|
|  Description: Delete an ip filter hook routine from IpFilterSeqHook list.
| 
|  Parameters:  FUNCPTR IpFilterSeqHook     routine to receive raw ip packets
|
|  Returns:     none
| 
*******************************************************************************/

void IpFilterSeqHookDelete 
(
    FUNCPTR IpFilterSeqHook
);

#endif /* IP_FILTER_H */ 
