#ifndef __EMAC_END_H
#define __EMAC_END_H

#ifdef __cplusplus
extern "C" {
#endif

// #define TX_SEM	1

#define MAC_MODULES 1

/*******************************************************************************
 *
 * includes
 *
 */

#include "bspcfg.h"
#include "bsptypes.h"
#include "vxWorks.h"

#include "wdLib.h"
#include "iv.h"
#include "vme.h"
#include "net/mbuf.h"
#include "net/unixLib.h"
#include "net/protosw.h"
#include "sys/socket.h"
#include "sys/ioctl.h"
#include "errno.h"
#include "memLib.h"
#include "intLib.h"
#include "net/route.h"
#include "iosLib.h"
#include "errnoLib.h"

#include "cacheLib.h"
#include "logLib.h"
#include "netLib.h"
#include "stdio.h"
#include "stdlib.h"
#include "sysLib.h"

#include "etherLib.h"
#include "net/systm.h"
#include "sys/times.h"
#include "net/if_subr.h"
#include "mac.h"

#undef    ETHER_MAP_IP_MULTICAST
#include "etherMultiLib.h"
#include "end.h"
#include "endLib.h"

#include "lstLib.h"
#include "semLib.h"

#include "netBufLib.h"

/*******************************************************************************
 * SPIPE hdrs.
 */

/* BSP */
#include "spipeBSP.h"
#include "ioctl_update.h"
#include "flash.h"

/* emac */
#include "verFeatures.h"    /* MAC HW revision, EMAC END version */

#include "emacbase.h"

/* EMAC registers & access-macros */
#include "emac_regs.h"

/* EMAC descriptors, status & access-macros */
// #include "emac_desc.h"

#include "filters.h"        /* Hashing, Address filtering & setup frame. */

#if	1	// port JEDIPHY, Bright
#include "typdef.h"
#endif

/* Define the SW unit associated with EMAC1 (HW unit 0) */
#define EMAC1               0
#define EMAC2               1
#define EMAC3               2

#define DRV_NAME            "mac"
#define DRV_NAME_LEN        5
#define EDRV_DESC           "Conexant SuperPIPE EMAC Enhanced Network Driver"
#define SOFT_CRC	/* Do a soft CRC for packets in receive queue when RO detected.
					   This is due to a HW bug where the emac will pass a corrputed frame to
					   SW and flag as good if RO occurs at last DWORD.
					*/

/* DMA Register definition */
#define DMA_BASE        0x00300000

#define DMA_TX1_PTR     ((volatile unsigned long *)(DMA_BASE))
#define DMA_TX1_CNT     ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x60))
#define DMA_TX2_PTR     ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x08))
#define DMA_TX2_CNT     ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x68))

#define DMA_RX1_PTR1    ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x04))
#define DMA_RX1_PTR2    ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x34))
#define DMA_RX1_CNT1    ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x64))
#define DMA_RX1_CNT2    ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x94))

#define DMA_RX2_PTR1    ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x0C))
#define DMA_RX2_PTR2    ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x3C))
#define DMA_RX2_CNT1    ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x6C))
#define DMA_RX2_CNT2    ((volatile unsigned long *)((BYTE *)DMA_BASE + 0x9C))

/*******************************************************************************
 * Ethernet Standards:
 *
 * 1. Ethernet Frame fields - order left to right - are:
 *    preamble[7],sfd[1],da[6],sa[6],type(or len)[2],data[var],pad[var],fcs[4].
 *    Where, [x] = length in bytes. [var] = variable length.
 *
 *    da, sa & type(or len) put together is called ethernet header.
 *
 *    ISO802.3 has length field instead of Type field.
 *    But in both cases ethernet & ISO802.3, the length of the 3rd field
 *    remains 2 bytes.
 *
 *    Ethernet address, Physical address & MAC address are synonymous.
 *
 *    ENET_HDR_REAL_SIZ: len of destination & source addr & type = 14 bytes.
 *    ETHERMTU: max length of data & pad fields = 1500 bytes.
 *    ETHERMIN: min length of data & pad fields (60-14) = 46 bytes.
 *
 * 2. MAC HW:
 *    Preamble & sfd are removed/added by Rx/Tx MAC HW before the frame
 *    is sent up/down to the protocols/cable. So as far as MAC SW (driver) goes,
 *    the frame starts from DA and ends with FCS.
 */
#define MEM_PART_SIZE       0x00200000
#define EMAC_CLUSTER_SZ     2048

#define EADDR_LEN           6           /* ethernet address length */

#define NET_SPEED_10        10000000    /* 10 Mbps        */
#define NET_SPEED_100       100000000   /* 100 Mbps    */

/* Call these in endMCastAddrAdd[Del] funcs. */
#define DRV_END_DECR_MULTI(pDrvCtrl) ((pDrvCtrl)->endObj.nMulti--)
#define DRV_END_INCR_MULTI(pDrvCtrl) ((pDrvCtrl)->endObj.nMulti++)

/* Align qty to forward(next) al-boundry.*/
#define ALIGN_FW(qty,al)    (((int)(qty) + ((al)-1)) & ~((al)-1))

#define RX_MSG_Q_LEN		128	// 64
#define RX_MSG_Q_WRAP   ( RX_MSG_Q_LEN - 1 )

#ifdef DIRECT_DMA_API
#include "emacdmarx.h"
#include "emacdmatx.h"
#else
#include "dmasrv.h"
#endif

typedef struct tx_mib
{
    unsigned long txRequest;
    unsigned long txFatalDiscard;
    unsigned long outofDmaBuffer;
    unsigned long mblkCopyFail;
    unsigned long badLen;
    unsigned long txTimeOut;
} TX_MIB;

typedef struct err_mib
{
    unsigned long resetEmacHw;
    unsigned long fatalInTask;
    unsigned long fatalInErrIsr;
    unsigned long fatalNetJobFailed;

    unsigned long E_S_RO_stat;
    unsigned long E_S_TOF_stat;
    unsigned long E_S_TUF_stat;
    unsigned long E_S_16_stat;
    unsigned long E_S_LC_stat;

    unsigned long E_S_TU_stat;
    unsigned long E_S_RWT_stat;
    unsigned long E_S_ED_stat;
    unsigned long E_S_DF_stat;
    unsigned long E_S_CD_stat;
    unsigned long E_S_ES_stat;
    unsigned long E_S_RLD_stat;
    unsigned long E_S_TF_stat;
    unsigned long E_S_TJT_stat;
    unsigned long E_S_NCRS_stat;
    unsigned long E_S_LCRS_stat;
    unsigned long E_S_CC_stat;

    unsigned long emacErrIsr;
    unsigned long fatalNetJobAdded;
} ERR_MIB;

/**********************************************************/
/* MIB's                                                  */
/**********************************************************/
typedef struct rx_mib
{
    /* hardware-maintained local mib counters between 2 good frames */
    unsigned long crcErrors;
    unsigned long alignmentErrors;
    unsigned long pktTooLong;
    unsigned long pktTooShort;
    unsigned long fifoOverflow;

    /* driver counters */
    unsigned long rxSWQ_Full ;
    unsigned long rxGood;
    unsigned long rxNetJobFailed;
    unsigned long muxRxErr;
    unsigned long clAlignErr;
    unsigned long outofMblk;
    unsigned long filteredOut;
    unsigned long badPktLen;
    unsigned long bridgeOffDrop;
#ifdef SOFT_CRC
	unsigned long bad_crc;
#endif

#ifdef EMAC_DEBUG_CNT
    unsigned long qFullNoMblk;
    unsigned long rdmaIsr;
//    unsigned long isrNoRx;
    unsigned long rxNetJobAdded;
    unsigned long rxNetJobNoAdd;

    unsigned long receiveCalls;
    unsigned long numRxPerCall;
    unsigned long gotNewMblk;
    unsigned long muxRxOk;

    /* stats from the received good frames */
    unsigned long shortest;
    unsigned long longest;
    unsigned long size32;
    unsigned long size64;
    unsigned long size128;
    unsigned long size256;
    unsigned long size512;
    unsigned long size1024;

    unsigned long rxPollFail;
    unsigned long rxPollOk;
#endif

} RX_MIB;

/* PHY link status data structure and related #defines. */
typedef struct phy_setting
{
    unsigned long   autoNegotiate;      // 0: disable,  1: enable
    unsigned long   networkSpeed;       // 0: 10M,  1: 100M
    unsigned long   duplexMode;         // 0: HDX,  1: FDX
    unsigned long   linkStatus;         // 0: down, 1: up
    unsigned long   phySettings;        // returned by PhyCheck ()
} PHY_SETTING;

#define PHY_FORCEDMODE          0
#define PHY_AUTONEGOTIATE       1
#define PHY_STAT_SPEED_10       0
#define PHY_STAT_SPEED_100      1
#define PHY_STAT_DUPLEX_HALF    0
#define PHY_STAT_DUPLEX_FULL    1
#define PHY_STAT_LINK_DOWN      0
#define PHY_STAT_LINK_UP        1


/*
 * The emacEnd driver control structure
 */

typedef struct EMAC_drv_ctrl *PRSS1161x_ADAPTER ;
/*######## CWC 07/22/02, add BUILD_BOOTROM ########*/
#if defined(JEDIPHY) || defined(BUILD_BOOTROM)  // Bright
// typedef struct EMAC_drv_ctrl *PRSS1161x_ADAPTER ;
#include "timerobj.h"

typedef struct EMAC_drv_ctrl  *PMACAPI ;
#endif

#ifdef HOMEPLUGPHY
#include "tesla.h"
#endif

typedef struct EMAC_drv_ctrl
{
    END_OBJ       endObj;             /* base class */
	 unsigned int	bridgePort;
    int           unit;           /* unit number */
    int           flags;          /* Our local flags. */

    DWORD			EndDeviceReady; /* Ready if successfully attached to protocol */

	 unsigned char      PortNetAddress[EADDR_LEN+1]; /* ethernet address */
	 ULONG              MacFilteringMode;

    /* Multicast Address Table is array */
    int         multiCount;                     /* Number of multicast address in Table */
    MAC_ADDR    multiTable[MULTI_TABLE_SIZE];   /* Multicast address table */
    UINT8       hashTable[HASH_TABLE_SIZE];     /* Multicast hash table */

    int         hw_unit;            /* physical unit number */
    char        *memBase;           /* descriptor mempool base addr */
    ULONG       memSize;            /* descriptor mempool size */
    ULONG       usrFlags;

    struct EMAC_drv_ctrl    *pOtherDrvCtrl;
    unsigned int    fatalNetJobPending;
    unsigned int    rxNetJobPending;

   /* PHY Driver support */
   PVOID		pPhy;	// PHY *pPhy
#if 1 	//JEDI
	BOOLEAN HPNA7WS;
	PVOID pHpna ;	//PHPNALLOBJ pHpna ;
#endif

#ifdef JEDIPHY	// Bright
//typedef struct def_OSTIMEROBJ
//{
	ULONG dwGrandTickerTime;				//  Grand ticker count since driver init
//	TIMER_STATE GrandTimerState;	// no need for VXWORKS
	ADAPTER_TIMER	TimerTable[ NUMBER_OF_TIMERS ];
//} OSTIMEROBJ, *POSTIMEROBJ ;
#endif

    TX_MIB 	txMIB;
    RX_MIB  rxMIB;
    ERR_MIB errMIB;

    EMACDMARX_P52_MSG   rx_q[RX_MSG_Q_LEN] ;
    UINT32          rx_q_index;     /* index to next available element when queue is not full */
    UINT32          rx_q_outdex;    /* current transmitting TxD                               */
    UINT32          rx_q_count;     /* if count is zero, then queue is empty                  */

#ifdef TX_SEM
	SEM_ID	q_sem_id;
#endif

    PHY_SETTING     phyState;
 	/* Rx structure */
#ifdef DIRECT_DMA_API
	PVOID		pDmaRxObj ;	//	 PDMARXOBJ		pDmaRxObj ;
	PVOID		pDmaTxObj ;	//	 PDMATXOBJ		pDmaTxObj ;
#else
	UINT32   DmaTxChannel ;
	UINT32   DmaRxChannel ;
#endif

	PVOID    pDmaBuffObj ;
	PVOID		pOsPk ;    //POSRXPACKOBJ	pOsPk ;

	// AlexF (02/26/02): EMAC Static Memory for Transmission
} EMAC_DRV_CTRL;


#define DRV_CTRL_SIZ    sizeof(DRV_CTRL)
#define DRV_CTRL        EMAC_DRV_CTRL


/* define for IOCTL, was decided to be 64 after talking to vxworks */
/* this is not being used by vxworks at this time but is include for */
/* completeness */
#define EMAC_MIN_BUFFER_FOR_CHAINING    ( 64 )

#define NET_SPEED_DEF                   NET_SPEED_10

/*
 * END specific defines
 */

#define END_FLAGS_ISSET(pEnd, setBits)              \
        ((pEnd)->flags & (setBits))

#define END_HADDR(pEnd)                             \
        ((pEnd)->mib2Tbl.ifPhysAddress.phyAddress)

#define END_HADDR_LEN(pEnd)                         \
        ((pEnd)->mib2Tbl.ifPhysAddress.addrLength)

#define END_MIB_SPEED_SET(pEndObj, speed)           \
        ((pEndObj)->mib2Tbl.ifSpeed=speed)


/*
 * DRV_CTRL flags & access macros
 */

#define DRV_MEMOWN      0x0001      /* TDs and RDs allocated by driver */
#define EMAC_POLLING    0x0004      /* Poll mode, io mode              */
#define FLT_PROMISC     0x0008      /* Promiscuous, rx mode            */
#define FLT_MCAST       0x0010      /* Multicast, rx mode              */

#define DRV_FLAGS_SET(setBits)          \
        (pDrvCtrl->flags |= (setBits))

#define DRV_FLAGS_ISSET(setBits)        \
        (pDrvCtrl->flags & (setBits))

#define DRV_FLAGS_CLR(clrBits)          \
        (pDrvCtrl->flags &= ~(clrBits))

#define DRV_FLAGS_GET()                 \
        (pDrvCtrl->flags)

/*
 * END Specific interfaces.
 */

/* tUsrRoot to END: The only function exported out is the load function. */
END_OBJ *emac_endLoad ( signed char *initString, void *pBSP );
int     EMAC_restart_hw ( DRV_CTRL *pDrvCtrl );

void    emac_RxJob ( DRV_CTRL *pDrvCtrl );

/**********************************************************/
/* Local definitions used for the EMAC directory          */
/**********************************************************/

#define E_S_TU      ((unsigned long)1<<31)
#define E_S_RO      ((unsigned long)1<<26)
#define E_S_RWT     ((unsigned long)1<<25)
#define E_S_TOF     ((unsigned long)1<<16)
#define E_S_TUF     ((unsigned long)1<<15)
#define E_S_ED      ((unsigned long)1<<14)
#define E_S_DF      ((unsigned long)1<<13)
#define E_S_CD      ((unsigned long)1<<12)
#define E_S_ES      ((unsigned long)1<<11)
#define E_S_RLD     ((unsigned long)1<<10)
#define E_S_TF      ((unsigned long)1<<9)
#define E_S_TJT     ((unsigned long)1<<8)
#define E_S_NCRS    ((unsigned long)1<<7)
#define E_S_LCRS    ((unsigned long)1<<6)
#define E_S_16      ((unsigned long)1<<5)
#define E_S_LC      ((unsigned long)1<<4)
#define E_S_CC      ((unsigned long)0xf<<0)


/*
   Masks for 9.6.8.2 Receive handling status bits contained in the
        SuperPIPE Silicon System Design Engineering Specification.
*/
#define BF_CRC      0x0ff00000
#define BF_ALN      0x000f0000
#define BF_LONG     0x0000f000
#define BF_RUNT     0x00000ff0
#define BF_OFLW     0x0000000f
#define BF_MASK     (BF_CRC+BF_ALN+BF_LONG+BF_RUNT+BF_OFLW)

#define GF_TS       0x00000800
#define GF_MF       0x00000400
#define GF_TL       0x00000080
#define GF_LC       0x00000040
#define GF_OFT      0x00000020
#define GF_RW       0x00000010
#define GF_DB       0x00000004
#define GF_CE       0x00000002
#define GF_OF       0x00000001
#define GF_MASK     (GF_TS+GF_MF+GF_TL+GF_LC+GF_OFT+GF_RW+GF_DB+GF_CE+GF_OF)


#ifdef __cplusplus
}
#endif

#ifdef EMAC_DEBUG_CNT
#define EMAC_DO_DEBUG_CNT(x,y)          x=x+y
#define EMAC_DO_DEBUG_CNT_IF(x,y,z)     if (z) x=x+y
#define EMAC_DO_DEBUG_STAT(x,y)         x=y
#define EMAC_DO_DEBUG_STAT_IF(x,y,z)    if (z) x=y
#else
#define EMAC_DO_DEBUG_CNT(x,y)
#define EMAC_DO_DEBUG_CNT_IF(x,y,z)
#define EMAC_DO_DEBUG_STAT(x,y)
#define EMAC_DO_DEBUG_STAT_IF(x,y,z)
#endif
#endif /* __EMAC_END_H */
