/***************************************************************************
 *   MODULE NAME    : brhook.c                                         *
 ***************************************************************************
 *   Copyright 2003 Conexant Systems, Inc. as unpublished work             *
 *   All Rights Reserved                                                   *
 *                                                                         *
 *   The information contained herein is the confidential property         *
 *   of Conexant Systems, Inc..  The use, copying, transfer or             *
 *   disclosure of such information is prohibited except by express        *
 *   written agreement with Conexant Systems, Inc..                        *
 *                                                                         *
 ***************************************************************************/

#include <Vxworks.h>
#include <taskLib.h>
#include "bspcfg.h"
#include "brhook.h"
#include "mac_table.h"
#include "emac_end.h"

#ifdef BUILD_BOOTROM
#include "tesla.h"
#endif


/***************************************************************************/
/*                          GLOBAL VARIABLE DECLARATION                    */
/***************************************************************************/
FUNCPTR BR_pHookFunc[BRHOOK_MAXNUM];
static struct _BR_HNP_MacTable BR_HNP_MacTable[BR_HNP_MACTABLE_ENTRY];


/***************************************************************************/
/*                          LOCAL FUNCTION DECLARATION                     */
/***************************************************************************/
int BR_Rcv_HomePlug(DRV_CTRL *pDrvCtrl, unsigned char *pPacket);
int BR_HNP_MacTableInit();
int BR_HNP_MacTableDelete(unsigned char *srcMac);
int BR_HNP_MacTableShow();
int BR_HNP_MacTableScan();
int BR_HNP_MacTableAddSrc(unsigned char *srcMac, unsigned char doNotTimeout);
int BR_HNP_MacTableDstSearch(unsigned char *dstMac);
int BR_HookInit();
int BR_HookAdd(unsigned char index, FUNCPTR pFunc);
int BR_HookDelete( unsigned char index );
int BR_HookIsValid( unsigned char index );
void TeslaMonTask(int drvCtrl);
void Testla_TaskCreate(int pDrvCtrl);
int BR_HNP_MacTableRefresh(DRV_CTRL *pDrvCtrl);
int BR_HNP_MacTableSendFrame(DRV_CTRL *pDrvCtrl);


extern BOOLEAN  Emac_TeslaIsBridgeInfo(TESLA_HANDLE Tesla_Adapter,	unsigned char* DataPacket );
extern void Emac_Tesla_SendBogusFrame(TESLA_HANDLE Tesla_Adapter, unsigned char *macAddr);


/***************************************************************************/
/*                          LOCAL VARIABLE DECLARATION                     */
/***************************************************************************/


/****************************************************************************

****************************************************************************/

	

#ifdef HOMEPLUGPHY
/* This task will only be created if a homeplug port present */
#define TESLA_TASK_PERSECOND	10   /* this task run 10 times per second */

void TeslaMonTask(int drvCtrl)
{
	DRV_CTRL *pDrvCtrl = (DRV_CTRL *)drvCtrl;
	int teslaTaskInterval;
	int reinit_interval;  
	int reinit_action;
	int macrefresh_interval;
//	char pingAddr[18];
	extern Tesla_Stat TeslaStat;
	int status, i;
	int	reinit_count;
	int refresh_count;
	int scan_count;

	reinit_interval = TeslaDebugControl.ReinitInterval;
	reinit_action = TeslaDebugControl.ReinitAction;
//	strcpy(pingAddr, TeslaDebugControl.PingAddr);
	macrefresh_interval = TeslaDebugControl.MacTableRefreshInterval;

#if 0
	printf("reinitInterval=%dsec\n",reinit_interval);
	printf("reinitAction=0x%x\n",reinit_action);
	printf("pingAddr=%s\n",pingAddr);
	printf("macAddr=");
	for( i=0; i<6; i++ )
		printf(":%02x",TeslaDebugControl.MacAddress[i]);
	printf("\n");
	printf("MacTableRefreshInterval=%d00ms\n",macrefresh_interval);
#endif

	if( reinit_interval == 0 )
	{
		reinit_interval = 30;     // 30 second
	}
	
	if( macrefresh_interval != 0 )
	{
		/* bridge hook for homeplug will only be setup if homeplug present */
		BR_HookAdd(BRHOOK_RCV_HOMEPLUG, (FUNCPTR)BR_Rcv_HomePlug);
	}

	reinit_count = reinit_interval * TESLA_TASK_PERSECOND;
	refresh_count = macrefresh_interval;
	scan_count = TESLA_TASK_PERSECOND;
	teslaTaskInterval = sysClkRateGet()/TESLA_TASK_PERSECOND; 	/* this task will run every 100ms */
	while(1)
	{
		/* this task will run every 100ms */
		taskDelay( teslaTaskInterval );

		/* only do it if interval isnot 0, 0 indicates disable */
		if( macrefresh_interval != 0 )
		{
			if( scan_count > 0 )
				scan_count--;
			if( scan_count == 0 )
			{
				scan_count = TESLA_TASK_PERSECOND;
				BR_HNP_MacTableScan();
			}
			  
			if( refresh_count > 0 )
				refresh_count--;
			if( refresh_count == 0 )
			{
				refresh_count = macrefresh_interval;
				if( (reinit_action & TESLA_SET_BRIDGEINFO) != 0 )
				{
//					BR_HNP_MacTableRefresh(pDrvCtrl);
					netJobAdd (( FUNCPTR ) BR_HNP_MacTableRefresh, ( int ) pDrvCtrl, 0, 0, 0, 0 );				
				}
				if( (reinit_action & TESLA_SEND_BOGUSFRAME) != 0 )
				{
//					BR_HNP_MacTableSendFrame(pDrvCtrl);
					netJobAdd (( FUNCPTR ) BR_HNP_MacTableSendFrame, ( int ) pDrvCtrl, 0, 0, 0, 0 );
				}	  
			}
		}

		/* do the following per the reinit_interval parameter in config.reg */
		if( reinit_count > 0 )
			reinit_count--;
		if( reinit_count == 0 )
		{
			reinit_count = reinit_interval * TESLA_TASK_PERSECOND;
//			printf("TeslaMonTask: %d seconds reinit\n",reinit_interval);

			if( (reinit_action & TESLA_MACTABLE) != 0 )
			{
				STRUCT_BrdgAddrTbl mac_table;
				int num_mac_entries, i;
				WEB_getMACTable(&mac_table);
	    		num_mac_entries = mac_table.currt_tbl_size;
				printf("\nTeslaMonTask:BR mac table:%d\n",num_mac_entries);
			    for (i = 0; i < num_mac_entries; i++)
			    {
			      	printf("[%d]src mac=%02X:%02X:%02X:%02X:%02X:%02X, age:%d, if=%s%d, port mac=%02X:%02X:%02X:%02X:%02X:%02X\n",
					    i,
					    mac_table.brdgAddrTblEntry[i].src_mac[0],
					    mac_table.brdgAddrTblEntry[i].src_mac[1],
					    mac_table.brdgAddrTblEntry[i].src_mac[2],
					    mac_table.brdgAddrTblEntry[i].src_mac[3],
					    mac_table.brdgAddrTblEntry[i].src_mac[4],
					    mac_table.brdgAddrTblEntry[i].src_mac[5],
					    mac_table.brdgAddrTblEntry[i].age_time,
						mac_table.brdgAddrTblEntry[i].pPort->ifName,
						mac_table.brdgAddrTblEntry[i].pPort->unit,
						mac_table.brdgAddrTblEntry[i].pPort->myMac[0],
						mac_table.brdgAddrTblEntry[i].pPort->myMac[1],
						mac_table.brdgAddrTblEntry[i].pPort->myMac[2],
						mac_table.brdgAddrTblEntry[i].pPort->myMac[3],
						mac_table.brdgAddrTblEntry[i].pPort->myMac[4],
						mac_table.brdgAddrTblEntry[i].pPort->myMac[5]
					    );
		    	}
				printf("\nBR_HNP_MacTable:\n");
				BR_HNP_MacTableShow();
			}

			if( (reinit_action & TESLA_BRIDGEINFO) != 0 )
			{
				printf("\nTeslaMonTask:request bridge info\n");
				Emac_Tesla_SendBridgeInfo(pDrvCtrl, 0, NULL);	
				taskDelay(10);
			}
		   
			if( (reinit_action & TESLA_STAT) != 0 )
			{
				Emac_TeslaSendStatsRequest(pDrvCtrl);
				taskDelay(10);
				printf("TeslaStatistic:TXACK=%d, TXNACK=%d, TXFAIL=%d, TXCLOSS=%d, TXCOLL=%d, TXCA3LAT=%d, TXCA2LAT=%d, TXCA1LAT=%d, TXCA0LAT=%d, RXBP40=%d\n",
					TeslaStat.TXACK,TeslaStat.TXNACK,TeslaStat.TXFAIL,TeslaStat.TXCLOSS,TeslaStat.TXCOLL,TeslaStat.TXCA3LAT,TeslaStat.TXCA2LAT,TeslaStat.TXCA1LAT,TeslaStat.TXCA0LAT,TeslaStat.RXBP40);
			}	

#if 0
			if( (reinit_action & TESLA_POWERUPINIT) != 0 )
			{
	        	EMACHW_ResetChip( pDrvCtrl->hw_unit );
	    		status = PhyInit( ( ULONG )EMAC_REG_ADDR ( E_DMA, pDrvCtrl->hw_unit ),
	                        pDrvCtrl->pPhy,
	                        emac_MapToPhyConn ( &pDrvCtrl->phyState ),
	                        PHY_HWOPTS_PORT_HOPPING,
	                        pDrvCtrl->pHpna) ; 	// PORT
			    if( status != PHY_STATUS_OK )
					printf("TeslaMonTask: PhyInit Failure\n");
				else
					printf("TeslaMonTask: PhyInit ok\n");
				Emac_TeslaSetup((void*)pDrvCtrl, &TeslaControl);
			}	
		
			if( (reinit_action & TESLA_RESET) != 0 )
			{
				if( PhyReset(&(((PHY*)(pDrvCtrl->pPhy))->mii_phy[ETH_MII_PHY])) == PHY_STATUS_OK )
					printf("TeslaMonTask: PhyReset ok\n");
				else
					printf("TeslaMonTask: PhyReset Failed\n");
				Emac_TeslaSetup((void*)pDrvCtrl, &TeslaControl);
			}

			if( (reinit_action & TESLA_SETUPFRAME) != 0 )
			{
				Emac_TeslaSetup((void*)pDrvCtrl, &TeslaControl);
				printf("TeslaMonTask: sent SETUP frame\n");
			}
		
			if( (reinit_action & TESLA_PING) != 0 )
			{
				if( ping(pingAddr, 1, 0) == OK )
					printf("TeslaMonTask: ping %s ok\n",pingAddr);
				else
					printf("TeslaMonTask: ping %s failed\n",pingAddr);
			}
#endif //end of 0
		
		} /* end of reinit_count==0 */
	}  /* end of while */
}	

/* if homeplug present, create tesla task, setup bridge hook for homeplug port */
void Testla_TaskCreate(int pDrvCtrl)
{
	static int emac_TeslaTaskCreated = 0;

	/* return if the task has been created */
	if( emac_TeslaTaskCreated != 0 )
		return;
	emac_TeslaTaskCreated = 1;

    if( taskSpawn("tTeslaMon",250, 0, 4000,(FUNCPTR)TeslaMonTask,(int)pDrvCtrl,0,0,0,0,0,0,0,0,0) == ERROR )
		printf("Testla_TaskCreate:task creation error\n");
	else
		printf("Testla_TaskCreate:task created\n");
}

#if 0
void Emac_TeslaSendRARP(int drvCtrl, unsigned char *dstMac)
{
	char ifname[END_NAME_MAX+10];
	struct ifnet *pIf = NULL;
	DRV_CTRL *pDrvCtrl = (DRV_CTRL *)drvCtrl;

	sprintf(ifname,"%s%d",pDrvCtrl->endObj.devObject.name,pDrvCtrl->endObj.devObject.unit);
	pIf = ifunit(ifname);

}	

/* send RARP to the ifp, src mac use the homeplug mac, dest mac use the mac in bridge mac table.
 * this src mac is learned from the ifp, so we send out to the ifp to try to get response from that src mac */
void RARPRequest(struct ifnet *ifp, unsigned char *srcMac, unsigned char *dstMac)
{
	struct sockaddr sa;
	struct mbuf *m;
	struct ether_header *eh;
	struct ether_arp *ea;
	struct arpcom *ac = (struct arpcom *)ifp;

	if ((m = mHdrClGet(M_DONTWAIT, MT_DATA, 
			   sizeof(*ea), TRUE)) == NULL)
	    return; 
	m->m_len = sizeof(*ea);
	m->m_pkthdr.len = sizeof(*ea);
	MH_ALIGN(m, sizeof(*ea));
	ea = mtod(m, struct ether_arp *);
	eh = (struct ether_header *)sa.sa_data;
	bzero((caddr_t)ea, sizeof(*ea));
	bcopy((caddr_t)etherbroadcastaddr, (caddr_t)eh->ether_dhost,
	    sizeof(eh->ether_dhost));
	eh->ether_type = htons(ETHERTYPE_REVARP);
	ea->arp_hrd = htons(ARPHRD_ETHER);
	ea->arp_pro = htons(ETHERTYPE_IP);
	ea->arp_hln = sizeof(ea->arp_sha);	/* hardware address length */
	ea->arp_pln = sizeof(ea->arp_spa);	/* protocol address length */
	ea->arp_op = htons(ARPOP_REVREQUEST);
	bcopy((caddr_t)ac->ac_enaddr, (caddr_t)ea->arp_sha,
	   sizeof(ea->arp_sha));
	bcopy((caddr_t)ac->ac_enaddr, (caddr_t)ea->arp_tha,
	   sizeof(ea->arp_tha));
	sa.sa_family = AF_UNSPEC;
	sa.sa_len = sizeof(sa);
	ifp->if_output(ifp, m, &sa, (struct rtentry *)0);
}

#endif /*0*/


int BR_HNP_MacTableInit()
{
	int i;
	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	{
		BR_HNP_MacTable[i].valid = 0;
		BR_HNP_MacTable[i].idleTimer = 0;
		BR_HNP_MacTable[i].doNotTimeout = 0;
		memset((void*)(&BR_HNP_MacTable[i].macAddr[0]), 0, 6);
	}	  
}

int BR_HNP_MacTableDelete(unsigned char *srcMac)
{
	int i;
	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	{
		if( (BR_HNP_MacTable[i].valid == 1) && (memcmp(BR_HNP_MacTable[i].macAddr, srcMac, 6) == 0) )
		{
			BR_HNP_MacTable[i].valid = 0;
			BR_HNP_MacTable[i].idleTimer = 0;
			BR_HNP_MacTable[i].doNotTimeout = 0;
			memset((void*)(&BR_HNP_MacTable[i].macAddr[0]), 0, 6);
		}
	}
	/* if not found the entry, return error */
	if( i == BR_HNP_MACTABLE_ENTRY )
		return ERROR;
	else
		return TRUE;
}

int BR_HNP_MacTableShow()
{
	int i;
	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	{
		if( BR_HNP_MacTable[i].valid == 1 )
		{
			printf("[%d]src mac:%02X:%02X:%02X:%02X:%02X:%02X,age=%d,notimeout=%d\n", i,
			BR_HNP_MacTable[i].macAddr[0],BR_HNP_MacTable[i].macAddr[1],BR_HNP_MacTable[i].macAddr[2],BR_HNP_MacTable[i].macAddr[3],BR_HNP_MacTable[i].macAddr[4],BR_HNP_MacTable[i].macAddr[5],BR_HNP_MacTable[i].idleTimer,BR_HNP_MacTable[i].doNotTimeout);
		}
	}		  
	return OK;
}

	  
int BR_HNP_MacTableScan()
{
	int i;
	taskLock();
	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	{
		if( (BR_HNP_MacTable[i].valid == 1) && (BR_HNP_MacTable[i].doNotTimeout == 0) )
		{
			/* increment all non-static entries */
			if( BR_HNP_MacTable[i].idleTimer > 0 )
				BR_HNP_MacTable[i].idleTimer--;
			if( BR_HNP_MacTable[i].idleTimer == 0 )
			{
				/* if an entry timesout, delete it */
				BR_HNP_MacTable[i].valid = 0;
				memset((void*)(&BR_HNP_MacTable[i].macAddr[0]), 0, 6);
			}	
		}
	}
	taskUnlock();
	return OK;
}

/* This will be called from tNetTask, (and tRootTask at init time) */	  
int BR_HNP_MacTableAddSrc(unsigned char *srcMac, unsigned char doNotTimeout)
{
	int i, emptyIndex=-1;
	if( srcMac == NULL )
		return ERROR;

	taskLock();
	/* check if the entry already exist */
	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	{
		if( (BR_HNP_MacTable[i].valid == 1) && (memcmp(BR_HNP_MacTable[i].macAddr, srcMac, 6) == 0) )
		{
			/* reset the idle timer if we receive a packet with this src mac again */
			BR_HNP_MacTable[i].idleTimer = BR_HNP_MACENTRY_TIMEOUT;
			taskUnlock();
			return OK;
		}
		else if( (BR_HNP_MacTable[i].valid == 0) && (emptyIndex == -1) )
		{
			emptyIndex = i;
		}	
	}
	/* if the entry does not exist, look for one available space and add it in */
//	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	if( (emptyIndex >=0) && (emptyIndex < BR_HNP_MACTABLE_ENTRY) )
	{
		i = emptyIndex;
		if( BR_HNP_MacTable[i].valid == 0)
		{
			BR_HNP_MacTable[i].valid = 1;
			BR_HNP_MacTable[i].idleTimer = BR_HNP_MACENTRY_TIMEOUT;
			BR_HNP_MacTable[i].doNotTimeout = doNotTimeout;
			memcpy(BR_HNP_MacTable[i].macAddr, srcMac, 6);
			taskUnlock();
			return OK;
//			break;
		}
	}
	else
	{
		taskUnlock();
		return ERROR;
	}
	/* if no more space to add the entry, return error */
//	if( i == BR_HNP_MACTABLE_ENTRY )
//		return ERROR;
//	else
//		return TRUE;
}
	  
int BR_HNP_MacTableDstSearch(unsigned char *dstMac)
{
	int i;
	/* check if the entry already exist */
	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	{
		if( (BR_HNP_MacTable[i].valid == 1) && (memcmp(BR_HNP_MacTable[i].macAddr, dstMac, 6) == 0) )
		{
			/* reset the idle timer if we receive a packet destinated to this mac */
			BR_HNP_MacTable[i].idleTimer = BR_HNP_MACENTRY_TIMEOUT;
			break;
		}
	}
	return OK;
}

int BR_HNP_MacTableRefresh(DRV_CTRL *pDrvCtrl)
{
	int i, j=0;
	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	{
		if( BR_HNP_MacTable[i].valid == 1 )
			j++;
	}
	if( j>0 )
		Emac_Tesla_SendBridgeInfo(pDrvCtrl, j, &BR_HNP_MacTable);
	return OK;
}

int BR_HNP_MacTableSendFrame(DRV_CTRL *pDrvCtrl)
{
	int i;
	for( i=0; i < BR_HNP_MACTABLE_ENTRY; i++ )
	{
		if( BR_HNP_MacTable[i].valid == 1 )
		{
			Emac_Tesla_SendBogusFrame(pDrvCtrl, BR_HNP_MacTable[i].macAddr);
		}
	}
}
			  

int BR_HookInit()
{
	int i, j;
	for( i=0; i < BRHOOK_MAXNUM; i++ )
	{
		BR_pHookFunc[i] = NULL;
	}	
}
	  
int BR_HookAdd(unsigned char index, FUNCPTR pFunc)
{
	if( (pFunc == NULL) || (index >= BRHOOK_MAXNUM) )
	{
		return ERROR;
	}
	BR_pHookFunc[index] = pFunc;
	return OK;
}

int BR_HookDelete( unsigned char index )
{
	if( index > BRHOOK_MAXNUM )
		return ERROR;
	BR_pHookFunc[index] = NULL;
	return OK;
}	

int BR_HookIsValid( unsigned char index )
{
	if( index > BRHOOK_MAXNUM )
		return ERROR;
	if( BR_pHookFunc[index] != NULL )
		return TRUE;
	else
		return FALSE;
}


/* a return of TRUE indicate this routine eats the packet, FALSE indicates pass on the packet */
int BR_Rcv_HomePlug(DRV_CTRL *pDrvCtrl, unsigned char *pPacket)
{
	unsigned char srcMac[6], dstMac[6];

	/* the packet is received from the homeplug port */
	if( PhyActiveHOMEPLUG( pDrvCtrl->pPhy) )
	{
		memcpy(dstMac, pPacket, 6);
		/* scan the hnp mactable using the dst mac of this packet, if found set the idletimer to 0 */
		BR_HNP_MacTableDstSearch(dstMac);
	}
	/* if the packet is received from a non-homeplug port */
	else
	{
		memcpy(srcMac, pPacket+6, 6);
		/* add the src mac into the hnp mactable */
		BR_HNP_MacTableAddSrc(srcMac, FALSE);
	}
	return FALSE;	  
}

int Emac_Tesla_StaticMac(DRV_CTRL *pDrvCtrl)
{
   	BR_HNP_MacTableAddSrc(pDrvCtrl->PortNetAddress, TRUE);
}	

int BRHookModuleInit()
{
	BR_HNP_MacTableInit();
	BR_HookInit();
}
	  
#endif /* end of HOMEPLUGPHY */
	  















