/****************************************************************************
* $Header: E:/WorkCVS/NP66/hasbani/APPS/EMAC/OSUTIL.H,v 1.1.1.1 2004/04/01 09:10:05 shao-gh Exp $
*
*  Copyright(c)2000  Conexant Systems
*
*****************************************************************************/
/*
 *  Module Name: OSUTIL.h : OS_DEPENDENT
 * this header file define all the OS dependent services required by HPNALL
 * and PHY
 */

#if !defined(OSUTIL_H_)
#define	OSUTIL_H_

#if defined(NDIS_MINIPORT_DRIVER)

#include <ndis.h>
//---------------------------------------------------------------
// NIDS Data Type
//---------------------------------------------------------------

// #define HANDLE		NDIS_HANDLE			// NDIS handle 
#define STATUS		NDIS_STATUS
#define SUCCESS		NT_SUCCESS		// ((NT_STATUS)(Status) >= 0)
#define FAILURE		NDIS_STATUS_FAILURE

#define H20_ALLOC_MEM(_pbuffer, _length) NdisAllocateMemoryWithTag( \
    (PVOID*)(_pbuffer), \
    (_length), \
    'TXNC')

#define H20_FREE_MEM(_buffer,_length) NdisFreeMemory((_buffer), (_length), 0)
#define H20_ZERO_MEM(_buffer,_length) NdisZeroMemory((_buffer), (_length))

#ifndef  MOVE_MEMORY
#define MOVE_MEMORY(Destination,Source,Length)   \
                         \
    NdisMoveMemory((PVOID)(Destination),     \
               (PVOID)(Source),      \
               (ULONG)(Length)       \
              )              

#endif

#ifndef  ZERO_MEMORY
#define ZERO_MEMORY(_buffer,_length) NdisZeroMemory((_buffer), (_length))
#endif

#elif defined(LINUX_DRIVER)
#include "linuxinc.h"

// PORT
#define AcquireSpinLock( pLock, flags) spin_lock_irqsave( pLock, flags) 
#define ReleaseSpinLock( pLock, flags) spin_unlock_irqrestore( pLock, flags )

// #define HANDLE		NDIS_HANDLE			// NDIS handle 
typedef int STATUS ;
#define SUCCESS(Status)		((STATUS)(Status) != 0)
#define FAILURE		0

#define H20_ALLOC_MEM(_pbuffer, _length) *(_pbuffer) = (void *)kmalloc( \
    (_length), \
    GFP_KERNEL )

#define H20_FREE_MEM(_buffer,_length) kfree( _buffer ) 
#define H20_ZERO_MEM(_buffer,_length) memset((_buffer), 0, (_length))

#ifndef  MOVE_MEMORY
#define MOVE_MEMORY(Destination,Source,Length)   \
                         \
    memcpy((PVOID)(Destination),     \
               (PVOID)(Source),      \
               (ULONG)(Length)       \
              )              \

#endif

#ifndef  ZERO_MEMORY
#define ZERO_MEMORY(_buffer,_length) memset((_buffer), 0, (_length))
#endif

#elif defined(VXWORKS_DRIVER)
#include "vxwinc.h"

// #define HANDLE		NDIS_HANDLE			// NDIS handle 
// typedef int STATUS ;
#define SUCCESS(Status)		((STATUS)(Status) != 0)
#define FAILURE		0

#define H20_ALLOC_MEM(_pbuffer, _length) *(_pbuffer) = (void *)malloc((_length))

#define H20_FREE_MEM(_buffer,_length) free( (_buffer) ) 
#define H20_ZERO_MEM(_buffer,_length) memset((_buffer), 0, (_length))

#ifndef  MOVE_MEMORY
#define MOVE_MEMORY(Destination,Source,Length)   \
                         \
    memcpy((PVOID)(Destination),     \
               (PVOID)(Source),      \
               (ULONG)(Length)       \
              )              \

#endif

#ifndef  ZERO_MEMORY
#define ZERO_MEMORY(_buffer,_length) memset((_buffer), 0, (_length))
#endif
#endif	

#endif
