#ifndef _XXXPROTOCAL_SGH_H_
#define _XXXPROTOCAL_SGH_H_

#include "in.h"
#include "netBufLib.h"
#include "netinet/ip.h"
#include "netinet/if_ether.h"

#define BLK_MEM_ALIGN 2
#define MAC_HEADER_LEN 14

typedef struct ip IP;

#define IP_PACKET   0x0800
#define ARP_PACKET 0x0806

#define ARP_REQUEST   1
#define ARP_REPLY      2


#define Max(t1, t2) ( (t1>=t2) ? t1: t2)
#define Min(t1, t2) ( (t1>=t2) ? t2: t1)
#define IsZeroMac(Addr)  (  (Addr[0] == 0)&&\
							(Addr[1] == 0)&&\
							(Addr[2] == 0)&&\
							(Addr[3] == 0)&&\
							(Addr[4] == 0)&&\
							(Addr[5] == 0)  )
#define IP_VERSION		4
#define IP_MINHLEN		5
#define IP_TTL1			255  /*already defined */

#define IP_IMMED		0x40
#define IP_PRIO			0x20
#define IP_NORMAL		0x00


#define HTTP_PORT 			 80
#define FTP_COMMAND_PORT	 21
#define NNTP_PORT           119
#define DHCPS_PORT           67
#define DHCPC_PORT           68
#define NETBIOS_NAME_PORT       137
#define NETBIOS_DATAGRAM_PORT  	138
#define NETBIOS_SESSION_PORT	 139



/**Define constant for IP/TCP/UDP/header ****/
#define IPMHLEN			20
#define IP_HLEN(pip)	( pip->ip_hl * 4 )
#define IP_LEN(pip)	    ( ntohs (pip->ip_len ) )
#define IP_MAXLEN		1500 /*need to further */
#define TCP_HLEN(pTcp) (((pTcp)->offset & 0xf0) >> 2) 


#define UDP_HLEN 		8
#define IP_MINHLEN		5
#define UDP_MAX_LEN ( IP_MAXLEN - (IP_MINHLEN<<2) - UDP_HLEN )
#define TCP_MAX_LEN ( IP_MAXLEN - (IP_MINHLEN<<2) - UDP_HLEN )



/******Define contant for IP's protocal type ****/
#define IP_PROTO_ICMP  1  /*??? 1 or 2 */
#define IP_PROTO_TCP   6
#define IP_PROTO_EGP   8
#define IP_PROTO_UDP   17
#define IP_PROTO_OSPF  89


/*Assigned UDP prot numbers*/
#define UDP_ECHO 			7
#define UDP_DISCARD			9
#define UDP_TIME 			37
#define UDP_PORT_BOOTP_S	67
#define UDP_PORT_BOOTP_C	68
#define UDP_TFTP			69
#define UDP_RIP				520


#define UDP_HLEN 		8
#define UDP_MAX_LEN ( IP_MAXLEN - (IP_MINHLEN<<2) - UDP_HLEN )
#define TCP_MAX_LEN ( IP_MAXLEN - (IP_MINHLEN<<2) - UDP_HLEN )

#define DHCPDISCOVER 	1 /*CLIENT*/
#define DHCPOFFER 	 	2
#define DHCPREQUEST 	3 /*CLIENT*/
#define DHCPDECLINE		4  /*CLIENT*/
#define DHCPACK		 	5
#define DHCPNACK	 	6
#define DHCPRELEASE  	7 /*CLIENT*/

#define HWLEN 6
#define IPLEN  4
#define UDP_ALEN IPLEN

#define MAX_DHCP_OPTION_LEN 312 /*accoring to tornado's definition */

extern u_char ZERO_IP_ADDR[ 4 ];
extern u_char ZERO_HW_ADDR[ 6 ];
extern u_char BROADCAST_HW_ADDR[ 6 ];
extern u_char BROADCAST_IP_ADDR[4];



/***Define constant for DHCP ***/
#define DHCPDISCOVER 	1 /*CLIENT*/
#define DHCPOFFER 	 	2
#define DHCPREQUEST 	3 /*CLIENT*/
#define DHCPDECLINE		4
#define DHCPACK		 	5
#define DHCPNACK	 	6
#define DHCPRELEASE  	7 /*CLIENT*/


/*Define constant for TCP setup/close*****/
#define IsTcpFin(u)   	(  ((u)&0x01) == 0x01  )
#define IsTcpSyn(u)   	(  ((u)&0x02) == 0x02 )
#define IsTcpReset(u) 	(  ((u)&0x04) == 0x04 )
#define IsTcpPush(u)  	(  ((u)&0x08) == 0x08 )
#define IsTcpAck(u)   	(  ((u)&0x10) == 0x10 )
#define IsTcpUrg(u)   	(  ((u)&0x20) == 0x20 )
#define IsTcpOnlySyn(u)	(  (u) == 0x02 )
#define IsTcpOnlyAck(u)  (  (u) == 0x10 )
#define IsTcpOnlyReset(u) (  (u) == 0x04 )

/*Define constant for TCP/IP/UDP's checksum ****/
#define CHECKSUM_CHECK 			1
#define CHECKSUM_CALCULATE 		2



#if 1
typedef struct ARP
{
    USHORT  hardware_type;
    USHORT  protocol_type;
    u_char   hardware_addr_len;
    char     protocol_addr_len;
    USHORT  opcode;
    char     sender_mac[6];
    struct	in_addr   sender_ip;
    char     target_mac[6];
    struct	in_addr  target_ip;
} __attribute__((__packed__)) ARP;

#endif


typedef struct TCP_STRU

{
	unsigned short src_port;
	unsigned short dst_port;
	
	unsigned long  seq;
	unsigned long  seq_ack;
	
    u_char offset;/*high 4 byte: HLEN, low 4 byte:reserved */
    u_char code;
    unsigned short window;
    
    unsigned short chsum; /*include PSEUDO_HEADER, TCP header and Tcp data */
    unsigned short urgptr;

   /* u_char ic_data[1500]; */ /*data area of TCP message */
	
} __attribute__ ((packed)) TCP;


typedef struct UDP_STRU
{
	unsigned short src_port;
	unsigned short dst_port;
	
 	unsigned short len;   /*includes udp header itself*/
    unsigned short chsum; /*include PSEUDO_HEADER, TCP header and Tcp data */

    u_char data[1]; /*data area of TCP message */
	
} __attribute__ ((packed)) UDP;


/*the psudo_header for the checksum of tcp*/


/* It is defined in other place, so here remark it.*/
typedef struct PSEUDO_IP_HEADER

{
    ULONG       source_ip_address;
    ULONG       destination_ip_address;
    USHORT      protocol;
    USHORT      length;
} __attribute__ ((packed)) PSEUDO_IP_HEADER;

#define ICMP_ECHO_REPLY   0 /*echo reply */
#define ICMP_DESTUR   3  /*destinatin unreachable */
#define ICMP_SRCQ	  4 /*source quench*/
#define ICMP_ECHO_REQUEST  8 /*echo request */

#define ICMP_PADLEN 3 /*pad length(0ctets) */
typedef struct ICMP_STRU
{
	u_char type; /*tpe of message(ICT_* above*/
	u_char code; 
	unsigned short cksum;/*checksum of ICMP header +data*/
	union 
	{
		struct 
		{ 
			unsigned short ic1_id;  /*for echo type, a message id */
			unsigned short ic1_seq;/*for echo type, a seq. number */
		}ic1;

		u_char ic2_gw[4]; /*for redirect, gateway*/

		struct
		{
			char ic3_ptr; /*pointer for ICT_PARAMP */
			char ic3_pad[ICMP_PADLEN];
		}ic3;

		int ic4_mbz; /*must be zero */
	}icu;

	u_char ic_data[1]; /*data area of ICMP message */
			

}__attribute__ ((packed)) ICMP;

/*DHCP struct */
typedef struct DHCP_OPTION
{
	u_char code;
	u_char len;
	u_char Message;/*1-dhcpdiscover 2-dhcpoffer 3-dhcprequest 4-dhcpdecline 5-dhcpack 6-dhcpnack 7-dhcprelease*/
} __attribute__ ((packed)) DHCP_Option;

typedef struct DHCP_STRU
{
	u_char Op;  /*operation: 1-requst, 2-respond */
	u_char HType;/*Hardware type: 1-10M*/
	u_char HLen;  /*Hardware address type: 6*/
	u_char Hops; /*0*/
	unsigned long  TransactionID;
	unsigned short seconds;  /*0*/
	unsigned short  Flags;    /*0--request server unicast response. 1<<7  -- resquest server brocast response */
	
	/*
	u_char ClientIP[IPLEN];
	u_char YourIP[IPLEN];
	u_char ServerIP[IPLEN];
	u_char RouterIP[IPLEN];
	*/
	struct in_addr ClientIP;
	struct in_addr YourIP;
	struct in_addr ServerIP;
	struct in_addr RouterIP;
	u_char ClientHw[16];
	u_char ServerName[64];
	u_char StartupFileName[128];

	char options[ MAX_DHCP_OPTION_LEN ];

	
}__attribute__ ((packed)) DHCP;

/* DNS header structure */
typedef struct DNS_HEADER {
    USHORT  id;
    UCHAR   flag1;
    UCHAR   flag2;
    USHORT  qCount;
    USHORT  anCount;
    USHORT  auCount;
    USHORT  adCount;
}__attribute__ ((packed)) DNS;

typedef struct DNS_ANSWER {
    USHORT  Name;
    USHORT  Type;
    USHORT  Class;
    ULONG   TTL;
    USHORT  Len;
    ULONG   IP;
} __attribute__ ((packed)) DNS_ANSWER;




#define IsZeroHWAddr(s) ( s[0] == 0 && s[1] == 0 && s[2] == 0 && s[3] == 0 && s[4] == 0 && s[5] == 0 )
#define IsZeroIPAddr(s) ( s[0] == 0 && s[1] == 0 && s[2] == 0 && s[3] == 0 )
#define IsSameIP(s1,s2) ( s1[0] == s2[0] && s1[1] == s2[1] && s1[2] == s2[2] && s1[3] == s2[3] )
#define IsSameHw(s1,s2) ( s1[0] == s2[0] && s1[1] == s2[1] && s1[2] == s2[2] && s1[3] == s2[3] && s1[4] == s2[4] && s1[5] == s2[5])

#define HTTP_PORT 			80
#define FTP_COMMAND_PORT 21

#ifndef DNS_PORT
#define DNS_PORT           0x35
#endif


extern u_char ZERO_HW_ADDR[ 6 ];
extern u_char ZERO_IP_ADDR[ 4 ];
extern u_char BROADCAST_HW_ADDR[ 6 ];
extern u_char BROADCAST_IP_ADDR[4];




typedef struct UDP_STRU1
{
	unsigned short src_port;
	unsigned short dst_port;
	unsigned short len; /*include first four short header(8 bytes) and data len */
	unsigned short checksum; /*it's checksum is calculated when CapIPHeader */
	char data[UDP_MAX_LEN];
} __attribute__ ((packed)) UDP_SELF;



#define ETH_PPPOE_DISCOVERY 	0x8863
#define ETH_PPPOE_SESSION   	0x8864

#define PPP_IP_PKT              0x21

#define PPPOE_OVERHEAD_LEN 		6  /* ver_type(1), code(1), session(2), length(2) */
#define PPP_TYPE_LEN         	2 

typedef struct PPPHeader
{
	USHORT type;
	unsigned char payload[1]; /* A bit of room to spare */
}PPPHeader;

typedef struct PPPoEHeader
{    
	struct ether_header ethHdr;	/* Ethernet header */

	#ifdef PACK_BITFIELDS_REVERSED
		unsigned int type:4;	/* PPPoE Type (must be 1) */    
		unsigned int ver:4;		/* PPPoE Version (must be 1) */
	#else    
		unsigned int ver:4;		/* PPPoE Version (must be 1) */    
		unsigned int type:4;	/* PPPoE Type (must be 1) */
	#endif   
	
	unsigned int code:8;	/* PPPoE code */    
	unsigned int session:16;	/* PPPoE session */
	unsigned int length:16;	/* Payload length */    
	
	PPPHeader pppHdr;
	
} __attribute__((__packed__)) PPPoEHeader;




#ifdef __cplusplus
extern "C" {
#endif

	/*Functions all outside use**********************/
	void Cal_Checksum_IP(struct ip* pip);
	BOOL Check_Checksum_TCP(struct ip* pip);
	BOOL Cal_Checksum_TCP(struct ip* pip);

	BOOL Check_Checksum_UDP(struct ip* pip);
	BOOL Cal_Checksum_UDP(struct ip* pip);

	BOOL IsArpPacket(char *MacFrameHeader);
	BOOL IsIPPacket(char *MacFrameHeader);
	BOOL IsTcpPacket(char *MacFrameHeader);
	BOOL IsUdpPacket(char *MacFrameHeader);
	BOOL IsDNSPacket(char *MacFrameHeader);  //sgh
	BOOL ChangeDNSFormatHostName_To_RealString(char *DsnFormatHostName, char *HostNameBuf, int MaxHostNameBufLen );
	BOOL ChangeRealString_To_DNSFormatHostName(char *HostName,char *DsnFormatHostNameBuf, int MaxBufLen );
	

	TCP* GetTcpHeader(struct ip *pip);

	BOOL IsSameTcpPacket(struct ip* pip1, struct ip* pip2);

	BOOL IsArpReply(char *pMacFramePacket );
	BOOL IsSameSubNet(ULONG srcIP, ULONG stardardIP, ULONG netmask);

	void Cal_CheckSum_IP(struct ip * pip);
	BOOL Cal_Checksum_TCP(struct ip* pip);
	BOOL Cal_Checksum_ICMP(struct ip* pip);
	BOOL Check_Checksum_ICMP(struct ip* pip);
	void DifferentialChecksumDataXXX(u_short *cksum, u_short *newValue, u_short *oldValue, int n);

	BOOL ChangeTwoIP(struct in_addr *IP1, struct in_addr *IP2);


	BOOL IsHwBroadCast(char *MacAddr);
	BOOL  IsHwMulcastCast(char *MacAddr);

	BOOL ChangeTcpMTU( IP* IPHeader, unsigned short nLessMTU, BOOL bfCalChksum);

	DNS *MakeDNSRespondPacket(short dnsID, char* ZoneReqName, ULONG domainIP, int *ResultLen, ULONG TTL);

	
	BOOL IsDNSQueryPacket(char *MacFrameHeader, char** zoneReqName, USHORT* ID);/*netwok order*/
	BOOL IsDNSQueryPacket2( IP* pip);
	char* IsDNSRespondPacket(char *MacFrameHeader );
	char* IsDnsRespondPacket2( IP *pIPHeader );
	BOOL IsMsNeighbourhoodPacket(char *MacFrameHeader);

	BOOL IsHttpPacketFromHttpClient( char *MacFrameHeader );

	BOOL IsDhcpRequestPkt(char *MacFrameHeader);
	BOOL IsDhcpRespondPkt(char *MacFrameHeader);

	
	/*type: 1-- arp request, 
		   2--arp respond */
	M_BLK_ID CreateArpMblk( char *pSenderMac, ULONG senderIP, char *pTargetMac, ULONG TargetIP, unsigned short type );



#ifdef __cplusplus
}
#endif




#endif
