#ifndef SGH_MEMMGRM_H_
#define SGH_MEMMGRM_H_
#include "vxworks.h"
#ifdef __cplusplus
extern "C" {
#endif

typedef struct MMM_CFG
{
	size_t nBlockSize;
	size_t nBlockNum;
	BOOL bfFixed;
}MMM_CFG;

BOOL mmm_init(MMM_CFG* pmmmCfg);


#define MMM_MODE_LEV0      1  /*memory block size must be matched completely, otherwise return NULL*/
#define MMM_MODE_LEV1	   2  /*try to get memory as long as mmm have and the block is not fixed*/
#define MMM_MODE_LEV2	   3  /*try to get memory as long as mmm have even if it is fixed */
/*nMode: MMM_MODE_LEV0
         MMM_MODE_LEV1
         MMM_MODE_LEV2
*/
void *mmm_malloc( size_t nBytes, char *ModuleName, int nMode);
void *mmm_realloc( void *pBlock, size_t nBytes, char *ModuleName, int nMode );
void mmm_free( void *ptr, char *ModuleName);


/* 1--show simple used memory blocks; 2---show detail used memory blocks*/
void mmm_ShowUsedMem(int nType);

/* 1--show simple free memory blocks; 2---show detail free memory blocks*/
void mmm_ShowFreeMem(int nType); 

/*show used memory according to its modulenamt */
void mmm_ShowViaModuleName(char *ModuleName, int nType);


#ifdef __cplusplus
}
#endif

#endif
