#ifndef ONEONENATFTP_H
#define ONEONENATFTP_H

#include <lstLib.h>
#include "xxxprotocol.h"

#define INPUT 
#define OUTPUT

typedef struct FTP_LIST
{
	NODE   	Node; /*for LIST */
	
	USHORT  SrcPort;  //network order according to lan port side
	USHORT  DstPort;  //network order according to lan port side
	ULONG   LastSequence_PORTCommand; //network order
	ULONG   LastPktTime;
	int     DeltaLen;    //host order
	int     OldDeltaLen; //host order: it is used just when the ftp packet is port command packet
	BOOL    bfNeedDel;
	int		nNeedDelFtp;
	int 	FtpStatus;
	BOOL    bfDirectionRecvFtpPortCommandFromLanPort; //TRUE--from lan, otherwise from wan

	int     ReleasetSourceTime; /*after this time, the ftp nat resource will be release */	
	
} FTP_LIST;

#ifdef __cplusplus
  extern "C" {
#endif


BOOL LanFtpCheck( INPUT LIST *pFtpList, INPUT IP *IPHeader, INPUT ULONG NewIP, int *PacketDeltLen);
BOOL WanFtpCheck( INPUT LIST *pFtpList, INPUT IP *IPHeader,  INPUT ULONG NewIP);
void PrintFtp(INPUT LIST* pFtpList);
void CheckFtpList(INPUT LIST *pFtpList );
void DeleteAllFtpList(INPUT LIST *pFtpList );

#ifdef __cplusplus
}
#endif


#endif
