#ifndef ONEONENATCONSTANT_H
#define ONEONENATCONSTANT_H

#include <lstLib.h>

#define INPUT
#define OUTPUT

#define SOFT_SAR_END_NAME "ss"
#define SOFT_SAR_END_UNIT 0

#define LAN_END_NAME "br"
#define LAN_END_UNIT  0
#define LAN_END_NAME_UNIT "br0"

#define RTL_END_NAME "rtl"
#define RTL_END_UNIT  0

#define WLAN_END_NAME "wlan"
#define WLAN_END_UNIT  0

#define USB_END_NAME "ui"
#define USB_END_UNIT  0

#define EMAC1_END_NAME "mac"
#define EMAC1_END_UNIT  0

//#define VIRTUAL_END_NAME "VMac"


/********************************************************************

	1.   First define compile option
	
**********************************************************************/


/********************************************************************
**********************************************************************/

/**********************************************
if wan ppp session hasnot setup, then router maybe will spoof 
dns and tcp (or http). It mainly depend on below macro:
1) if define NEED_SPOOF, then it will spoof dns request packet and tcp ( or http ) packet
2) if define SPOOF_HTTP_ONLY, then it will only spoof http packet, not other tcp packets
3) if define NEED_SPOOF_AGAIN_IF_WAN_NOT_OK, and when wan adsl down or ppp drop, router will spoof again

   disconnect it.

4) Of course, for we spoof dns with lan port ip, so later if wan ppp is ok. But pc will still use the spoofed ip.
   So here we need to solve the negative affects mainly caused by spoof. It had better define
   SUPPORT_SOLVE_NEGATIVE_DNS_SPOOF
5) In order to dns spoof with real website ip, not lan port ip. maybe we need to setup a 
   simple database for storing some website's website. If so, we need to define
   SUPPORT_SNOOF_DATABASE_NAT.
6) for need dns spoof, so maybe it is ok to setup a dns databse for lookup   
****************************************************/
#define NEED_SPOOF
#define SPOOF_HTTP_ONLY 
#define NEED_SPOOF_AGAIN_IF_WAN_NOT_OK
#define SUPPORT_SOLVE_NEGATIVE_DNS_SPOOF
#define SUPPORT_SNOOF_DATABASE_NAT  //hasnot finished yet???
#define SUPPORT_DNS_DATABASE
#define SUPPORT_BROWSER_PROXY


/******************************************
  When ppp session hasnot setup, router will send dhcp client with lan port ip as its dns server ip. 
  Some OS, such as win 98  will remember it even later router inform it with true dns server from ISP.
  In this situation, it had better use proxy dns to relay dsn request packet.
******************************************/
#define NEED_SGH_PROXY_DNS


/*****************************************************
 For Lan port works in different mode: some pc use private ip, some use public ip.
 In principle, They cannot talk between PC with private IP and PC with public IP.
 So if define SUPPORT_LANPORT_TALK_NOT_SAME_SUBNET, then they can talk with each other.
*****************************************************/
#define SUPPORT_LANPORT_TALK_NOT_SAME_SUBNET      //2003.08.04 sgh delete: reason, win XP not support it, eps for neighbourhood
    #ifdef SUPPORT_LANPORT_TALK_NOT_SAME_SUBNET
		#define SUPPORT_MS_NEIGHBOUR

		#ifdef SUPPORT_MS_NEIGHBOUR
			//#define SUPPORT_MS_NEIGHBOUR_BROADCASE /*NOT WORK in win XP */
			#define SUPPORT_MS_NEIGHBOUR_UNICAST
		#endif		
		
	#endif


/*2003.12.19 add to support the communicatin between individual login and public login VIA NAT */
//#define SUPPORT_INDIVIDUAL_SHARING_COMMUNICATION 


/*For easily debug, here sgh add telnet to add a terminal to monitor router status */
#define SUPPORT_SGH_TELNET   

#if 0
/*if define NEED_FRAGEMENT_BIG_PACKET, then need to fragment big packet 
  for adding pppoe header. If not, then do not need to fragment big packet. 
  If so, big packets will be discarded by some ISP  */ 
#define NEED_FRAGEMENT_BIG_PACKET 
#endif

/******************************************************************************
  Mac os only support same subnet gateway when mac os works at dhcp mode.
  If we need to support mac os, then it needs to define SUPPORT_SAME_SUBNET_DHCP_GATEWAY
******************************************************************************/
#define SUPPORT_SAME_SUBNET_DHCP_GATEWAY 


/***********************************************
 suppose local domain is www.leus  
***********************************************/
#define SUPPORT_LOCAL_DOMAIN_SPOOF    
#define preName "www."
#define mainHostName1  "leus"
#define localHostName1 (preName mainHostName1) 



/*check adsl status before ppp connect. If adsl link not up, then reject user's login */
#define NEED_CHECK_ADSL_BEFORE_PPPOECONNECT  


/****************************************************************************
  Let pppoe packet pass through from lan port to adsl
****************************************************************************/
#define PPPOE_BRIDGE_SUPPORT 


/****************************************************************************
  Hijack pc's mac address as wan port's pppoe's mac address
****************************************************************************/
#define HIJACK_PC_MAC


//#define HTTP_ONESESSION_HTTP_ONLY //I don't know why it will cause browser seems hangs if refresh too much times

/************************************************************************
  Will refresh http page until adsl ok before begin connect ppp
************************************************************************/
#define NEED_REFRESH_HTM_UNTIL_ADSL_OK_BEFORE_CONNECT


/************************************************************************
 Malaysia suggest to only one interface is accessible, ie,
  if Ethernet(rtl) link up, then disable usb.
  Otherwise, enable usb.
  Note, if want to use ethernet, then must connect cable with ethernet port before
        power on
************************************************************************/
//#define Malaysia_NEED_ONLY_ONE_INTERFACE

/***********************************************************
 in old firmware, if pc works in ip passthrough mode, when ppp is ok, then 
 pc's ip will be changed to public ip. But if ip is disconnect, then its ip
 will be changed to its private. 
 Now if use this option, the public ip will be kept even if ppp is disconnected.

 If define AUTOMATIC_CONNECT_IF_PPPDOWN, then router will automatically connect pp
 if ppp down
***********************************************************/
//#define NEED_KEEP_LAST_IP   

#ifdef NEED_KEEP_LAST_IP   
	#define AUTOMATIC_CONNECT_IF_PPPDOWN	 //now not support ok for http sychronize
#endif

#define AUTOMATIC_CONNECT_IF_PPPDOWN	 //now not support ok for http sychronize

/*if define NEED_UPGRADEMODE_FIRMWARE, then it need to reboot sytem to enter a special mode
  for upgrading firmware */
#define NEED_UPGRADEMODE_FIRMWARE     



/*****************************************************
 During changing ip from private ip to public ip, or public ip to private ip, 
 windows ip will be zero about 1 ~ 3 seconds. During this time, if natscape want to 
 get http page from router, then there will be a warning dialog. In order to avoid 
 it, we use the option to synchronise the dhcp and http, ie. during that time, browser 
 not refresh http page. Now only for natscape in index1.htm . 
*****************************************************/
#define NEED_SYNCHRONISE_DHCP_HTTP



/**********************************************************************
 If pc works in not-sharing mode, maybe the pc's ip is same subnet with remote pc's ip,
 So need to arp spoof to let them communicate with each other
 ??? I don't know why it will cause usb cannot work,
    but rtl/wlan ok
*********************************************************/
#define NEED_ARP_SPOOF_FOR_PUBLIC_IP_SAME_SUBNET     

/*******************************************
 Some user will ping router's lan port ip with large icmp packet.
 If define the macro, then router will discard the packet
******************************************/
//#define LAN_IP_NOT_SUPPORT_LARGE_ICMP


/******************************************
 There are three NAT option: Sharing login Sharing, Disabling Sharing, IP passthrough mode.
 If use this option, then it will only support Sharing NAPT, IP passthrough mode.
******************************************/
#define NOT_SUPPORT_DisablingSharing_MODE

//#define SUPPORT_ISP_CFG  //I think it is not good to do so.


#define SEM_CHECK_DEBUG


#define USE_LOCAL_FUN  /*if define it, then it will use some function copied from conexna't user_init.c */

#define WAN_SUPPORT_DHCP


/******************************************************************************

	2	 Second begin defines some variants
 
******************************************************************************/

#define LESS_TCP_MTU_NUM 12

//must be accorded with onoonenat.h
#define DHCPCLIENT_STATUS_UNDEF 		0
#define DHCPCLIENT_STATUS_NAPT 			1
#define DHCPCLIENT_STATUS_ONEONENAT     2
#define DHCPCLIENT_STATUS_IPPASSTHROUGH 3

//must be accord with dhcp_nat_interface.c
#define AddDHCP_RESULT_ADDOK		     0x00 //Must be 0 
#define AddDHCP_RESULT_ALREADY_EXIST     0x01 //Must be 0 
#define AddDHCP_RESULT_NOTDHCPIP     	 0x02
#define AddDHCP_RESULT_ADDFAIL		     0x03
#define AddDHCP_RESULT_SYSTEM_ERROR		 0x04

#define WAN_CONNECTION_STAUTS_NOT_RECV_RESPONSE   			0x0
#define WAN_CONNECTION_STAUTS_OK				   			0x1
#define WAN_CONNECTION_STAUTS_NO_DNSIP          			0x2
#define WAN_CONNECTION_STAUTS_NO_IP          				0x4
#define WAN_CONNECTION_STAUTS_DOWN           				0x8
#define WAN_CONNECTION_STAUTS_PPP_PASSWORD_ERROR            0x10
#define WAN_CONNECTION_STAUTS_TIMEOUT           			0x20


#define MAC_LEN   			 6
#define MAX_SPECAIL_IP_NUM   51


#define MAX_MTU_ONEONTNAT (1460- 40 )  /*2--ppp header, 7 pppoe header */


#define DIRECTION_LAN_SIDE  1
#define DIRECTION_WAN_SIDE 2

typedef struct WAN_IP_ATTR
{
	char   WanIfName[32];
	int    WanIfUnit;

	char   LowEndName[32];
	int    LowEndUnit;
	
	BOOL   bfHaveIP;

	ULONG  LocalIP;  /*network order */
	ULONG  Gateway;  /*maybe adjusted for dhcp requirement*/
	ULONG  priDNSIP;
	ULONG  secDNSIP;
	BOOL   bfUsed;
	ULONG  ulLastShutDownTime;	
	int    npppStatus;
	int    DNSproxyIndex;
	int    NAT_Type;


	//ULONG RealMask;  //no use to keep it
	ULONG RealGateway; /*real remote ppp ip */
	ULONG RealpriDNSIP;
	ULONG RealSecDNSIP;
	ULONG  nWanIPErrorTimes;

	
} WAN_IP_ATTR;


typedef struct OneOneNATUnit
{
	NODE   	Node; /*for LIST */

	BOOL 	bfStarted;  //TRUE- is used, FALSE- free
	//int 	WanMode;
	
	UCHAR 	WanMac[   MAC_LEN ]; /*NAPT use ss0 mac, but other use pc's mac*/

	char   	WanPPPName[20]; //for ip hook
	int 	WanPPPunit;
	int   	WanDrvUnit;  //for ip hook: which is same with its ppp unit
	int   	LowLevelVmacUnit;  //for ip hook: which is same with its ppp unit

	LIST    FtpList; //
	

	WAN_IP_ATTR  *pWanIPAttr;

	ULONG  ulLastRecvPktTime;	
	ULONG  AlreadyConnecedOk;

	int   nWanStatus_ForSpoofingTCP; //for tcp/dns spoof: 0--ok, 1--adsl down, 2--ppp down, 3--pc ip hasnot change ok
	void*  pDhcpClientAttr; //2003.3.13 add for easiness between dhcpclientAttr and OneOneNatUnit


	ULONG  ulBeginSetupPPPTime;//the time begin add to oneonenatlist
	ULONG  ulBeginChangePCIPTime;  //the time begin get ppp ip, and change it to needchange
	ULONG  ulBeginChangePCIPTime_Changing;  //the time begin get ppp ip
	ULONG  ulBeginChangePCIPTime_ChangOK;        //the time begin get ppp ip	

	int   nNeedOpenManagerHtm;     // 1 need open, 0-not open, 2--already open
	BOOL  bfRecvPktAready;
	

	//int    DSL1483Status;	
	
} OneOneNATUnit;


#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_NOREADY  	   0
#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_NORMAL    		1
#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_NOTFOUND  		2
#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_WAITING_PPP_IP       3

#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCHANGE 		 11
#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEING        12
#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK   	     13

#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCANCEL 21
#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_CANCELING    	22
#define CHANGE_PRIVATE_PUBLIC_IP_STATUS_CANCELOK     	23

//must be accord with hwIo.h
typedef enum HW_IO_MODEM_STATUS_CODES_E
{
	HW_IO_MODEM_STATUS_START					= 0,

	HW_IO_MODEM_STATUS_DOWN						= 0,
	HW_IO_MODEM_STATUS_ACTIVATION,					// 1
	HW_IO_MODEM_STATUS_TRANSCEIVER_TRAINING,
	HW_IO_MODEM_STATUS_CHANNEL_ANALYSIS,
	HW_IO_MODEM_STATUS_EXCHANGE,
	HW_IO_MODEM_STATUS_ACTIVATED,					// 5
	HW_IO_MODEM_STATUS_WAITING_INIT,
	HW_IO_MODEM_STATUS_INITIALIZING,
	HW_IO_MODEM_STATUS_UNKNOWN,

	HW_IO_MODEM_STATUS_END							// 9

} HW_IO_MODEM_STATUS_CODES_T;

#define CHECK_USERPSW_RES_SYSTEM_ERR        		0
#define CHECK_USERPSW_RES_OK               			1
#define CHECK_USERPSW_RES_NAPTSHARINGE_ERR		  	2
#define CHECK_USERPSW_RES_SAME_USER_ERR      		3 /*Same username but different password*/
#define CHECK_USERPSW_RES_SAME_USER_PSW_ERR    		4 /*Same username and password*/


#define CLIENT_OS_UNKNOW    0
#define CLIENT_OS_WIN       1  //windows
#define CLIENT_OS_MAC       2  //mac os


#define ONEONENAT_REAL_STATUS_NORMAL         0
#define ONEONENAT_REAL_STATUS_PPPCONNECTING  1
#define ONEONENAT_REAL_STATUS_PCIPSETTING    2


#define BROWSER_TYPE_UNKNOWN    0 
#define BROWSER_TYPE_IE   		1 
#define BROWSER_TYPE_NETSCAPE   2


#define END_TYPE_UNKNOWN    0 
#define END_TYPE_USB        1
#define END_TYPE_RTL	    2
#define END_TYPE_WLAN   	4 
#define END_TYPE_EMAC       8


typedef struct LanRootEndsAttr
{
	char *AliasName;
	char *Name;
	int  unit;
	int  EndType;
	int  nExist;
}LanRootEndsAttr;


#define MAX_PPP_USER_NAME_LEN 256
#define MAX_PPP_PASSWORD_LEN  32


typedef struct ISP_CFG
{
	ULONG Flag1;
	short VPI;
	short VCI;
	ULONG bfNeedRestore;	
	
}ISP_CFG;


#define MEM_BASIC_SIZE  32
#define MEM_SIZE_TO_OK(x) ( ( (x)/MEM_BASIC_SIZE + 2 ) * MEM_BASIC_SIZE )

#define WaitBrowserTimeOut1 ( sysClkRateGet() * 10 )  /*CHANGE_PRIVATE_PUBLIC_IP_STATUS_NEEDCHANGE */
#define WaitBrowserTimeOut2 ( sysClkRateGet() * 15 ) /*CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEING*/
/*a little longer, for netscape it will wait bout 30 seconds to refresh status page. 
  So it must be longer that netscape's wait time, otherwise netscape will be a warning diagbox.
  see variant WaitPCToChangeIPSeconds in index.c*/
#define WaitBrowserTimeOut3 ( sysClkRateGet() * 100 ) /*CHANGE_PRIVATE_PUBLIC_IP_STATUS_CHANGEOK*/

#define WAIT_PPP_GETIP_TimeOut 	    ( sysClkRateGet() * 15 )
#define WAIT_IPChangeTimeOut	    ( sysClkRateGet() * 60 )

 
#endif
