#ifndef __DHCP_NAT_INTERFACE_H
#define __DHCP_NAT_INTERFACE_H

#include "vxworks.h"
#include <muxLib.h>
#include <iflib.h>
#include <lstLib.h>
#include <semlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define HTTP_STATUS_ID0 	0 //Default
#define HTTP_STATUS_ID1 	1 //No Such Status ID!
#define HTTP_STATUS_ID2 	2 //please wait
#define HTTP_STATUS_ID3 	3 //connection faild
#define HTTP_STATUS_ID4 	4 //connected 
#define HTTP_STATUS_ID5 	5 //username passwrd error from ISP
#define HTTP_STATUS_ID6 	6 //conntion fail for wan recv no pkt at all
#define HTTP_STATUS_ID7 	7 //user is aready used
#define HTTP_STATUS_ID8 	8 //please power down and repower
#define HTTP_STATUS_ID9 	9 //adsl  not ready
#define HTTP_STATUS_ID10 	10 //not dhcp mode
#define HTTP_STATUS_ID11 	11//sharing NAT's user/psw conflict
#define HTTP_STATUS_ID12 	12//ppp Server no respond
#define HTTP_STATUS_ID13	13//ppp down or ppp error
#define HTTP_STATUS_ID14	14//System error
#define HTTP_STATUS_ID15	15//UserName or Password cannot be blank
#define HTTP_STATUS_ID16	16//disconnect by force, for example, user disconnect the ppp session


#define HTTP_STATUS_ID0_STR   ""
#define HTTP_STATUS_ID1_STR   "No such status ID!"
#define HTTP_STATUS_ID2_STR   "Please wait"
#define HTTP_STATUS_ID3_STR   "Connection attempt failed, later try again"
#define HTTP_STATUS_ID4_STR   "Connected"
#define HTTP_STATUS_ID5_STR   "Authentication failed: Check username and password"
#define HTTP_STATUS_ID6_STR   "Connection timeout. View Log for detailed reason"
#define HTTP_STATUS_ID7_STR   "Account in use by another PC"
#define HTTP_STATUS_ID8_STR   "Please power down and repower the modem"
#define HTTP_STATUS_ID9_STR   "Modem not ready. Check ADSL line connection"
#define HTTP_STATUS_ID10_STR  "Check if DHCP enabled on PC"
#define HTTP_STATUS_ID11_STR  "Account conflicts with another shared-login PC"//"Check username and password" //"Account conflicts in sharing NAPT"
#define HTTP_STATUS_ID12_STR  "PPP server no response"
#define HTTP_STATUS_ID13_STR  "ppp connection down"
#define HTTP_STATUS_ID14_STR  "System error, please reboot system"
#define HTTP_STATUS_ID15_STR  "Please enter username and password"
#define HTTP_STATUS_ID16_STR  "" /*user disconnect the ppp session */


typedef struct HttpStatusIDMsg
{
	int ID;
	char *Msg;
} HttpStatusIDMsg;
typedef struct DhcpClientIPAttr
{
	ULONG IP;  		// client private ip: network order
	ULONG Mask;  	//client mask/subnet: network order
	ULONG Gateway;  //client gateway: network order
	ULONG DhcpdIP;  //dhcp server ip: network order
	ULONG DNS1;  	//client pri dns: network order
	ULONG DNS2;  	//client sec dns: network order	
}DhcpClientIPAttr;

typedef struct DHCP_CLIENT_ATTR
{	
	NODE Node;  
	
	BOOL bfUsed;
	BOOL NATStartOK;	
	char dhcpClientMac[6];
	char reserved[2];

	DhcpClientIPAttr PrivateIPAttr;
	DhcpClientIPAttr NewIPAttr;
	DhcpClientIPAttr CurrentIPAttr;

	int nPPPConnecting_ClientIPChangeing;
	int nChangePrivatePublicIP_Status;
	//BOOL bfHasRecvPublicDhcpPacket;
	//ULONG RecvArpLastIP;
	ULONG RecvLastIpPkt_IP;
	ULONG RecvDhcpLastIP;
	ULONG RecvDhcpLastCiaddrIP;
	ULONG RecvDhcpLastRequestIP;

	//0--not ready  1-- manager windows is opened. 2--mananget windows is dismised.
	int   nHttpFreshed; //for synchromise btween dhcpd and httpd during changing ip 0--wait, 1--not wait
	int   nLastHttpStatusID;

	ULONG nLastRequestTime;
	char  redirectHomePage[100];
	
	ULONG Type_NAT;
	ULONG OS_Type; //From HTTP request packet, maybe can know client's OS
	int   Browser_Type; //Note, only be changed when call addoneoneNAT during ppp connect
	int   EndType;//wlan, ui, mac and so on

	void *pOneOneNAT; //point to oneoneNAT or NULL, 2003.04.03 add
	//char *pDhcpRes; //Pointer to Dhcp Resource


	int  nSavedNamePsw;

	char pppUserName[MAX_PPP_USER_NAME_LEN];
	char pppPassword[MAX_PPP_PASSWORD_LEN];

#ifdef PPPOE_BRIDGE_SUPPORT
	//if user is running pppoe client insteady of browser. 
	//then dhcp server need set dhcp client's no gateway
	BOOL bfPppoE;
	ULONG ulLastPppoePktTime; //ticks
#endif	
	
} DHCP_CLIENT_ATTR;

//called by DHCP Server
BOOL AddOneDHCPNAT(char* Mac, ULONG IP, char *RootEndNameUnit);  //DHCPclientIP: network order

BOOL QueryDHCPClient( ULONG DHCPclientIP, int* clientStatus);//DHCPclientIP: network order
BOOL SetDhcpClientNatMode(ULONG IP, int mode);

DHCP_CLIENT_ATTR* QueryDHCPNAT_Private(char* Mac/*, ULONG DHCPclientIP*/);  //DHCPclientIP: network order
DHCP_CLIENT_ATTR* QueryDHCPNAT_Private3(ULONG DHCPclientIP); //DHCPclientIP: network order

BOOL IsDHCPNATChecked_Private(DHCP_CLIENT_ATTR*pDhcpNatIf);
BOOL SetDHCPNAT_unChecked_Private(DHCP_CLIENT_ATTR *pDhcpNatIf);
BOOL SetDHCPNAT_Checked_Private(DHCP_CLIENT_ATTR *pDhcpNatIf);

//FOR IP PASSTHROUGH
DHCP_CLIENT_ATTR* QueryDHCPWithIPPassViaPrivateIP_Private(ULONG DHCPclientIP); //DHCPclientIP: network order
DHCP_CLIENT_ATTR* QueryDHCPWithIPPassViaPublicIP_Private( ULONG publicIP );
BOOL SetDhcpClientAttrStatus_private(DHCP_CLIENT_ATTR *p, int status);
BOOL SetDhcpClientInterfaceStatus( char *Mac, int status);
BOOL SetDhcpClientInterfaceStatus_private( char *Mac, int status);

char *GetHttpOneStatus(int ID);
int GetDhcpClientNum();
BOOL GetMacViaPrivateIP( ULONG IP, char *Mac);
BOOL SetRedirectHomePage2(ULONG clientIP, char *hostname, char *url);
BOOL SetRedirectHomePage(char* ClientMac, char *hostname, char *url);
BOOL SetDhcpClientInterfaceNewIP_Private(DHCP_CLIENT_ATTR *p, ULONG NewIP, ULONG NewGatewayIP, ULONG NewMask, ULONG NewDhcpdIP, ULONG NewDns1, ULONG NewDns2);

#ifdef __cplusplus
}
#endif


#endif	
