/*
Store PPP username/passowrd and its mac address of NIC
*/
#include "vxworks.h"
#include "stdio.h"
#include "iolib.h"
#include "semlib.h"

#include "DB_UserName.h"
#include "np66files.h"

#define CFG_SIGNATURE1     0x43784131

long GetFileSize( FILE* fd);

LOCAL SGH_CONFIG SGHConfig={0};

LOCAL SGH_CONFIG *pSGHConfig = &SGHConfig;
LOCAL SEM_ID SghCfgFileSem = NULL;

/* Read data from file pppSecurityFileName */
BOOL ReadDB_PPPUserName (void)
{ 
    int i;
    char *p;
    FILE* fd_d = NULL;
    int  fileLen, nReadFileLen;
    BOOL bfNeedSaveCfg = FALSE;
	
	SghCfgFileSem = semMCreate(SEM_Q_FIFO); //mutil_mute protection
	if( SghCfgFileSem == NULL ) 
	{
		printf("semMCreate error in semMCreate\r\n");
		return FALSE;
	}
	
	semTake(SghCfgFileSem, WAIT_FOREVER);
	
	if( (fd_d=fopen(pppSecurityFileName, "rb")) == NULL )
	{ //if file not exist, then use default value to it

		DefaultDB_PPPUserName_Private();
		SaveDB_PPPUserName_Private();

		semGive(SghCfgFileSem);
		//printf("The file %s not exist, so prepare to create it.\r\n", pppSecurityFileName);
		return TRUE;
	}

	//get file data length
	fileLen = GetFileSize( fd_d );
	if( fileLen < 0 )
	{  //use default value		
		fclose( fd_d );
		
		DefaultDB_PPPUserName_Private();
		SaveDB_PPPUserName_Private();

		semGive(SghCfgFileSem);
		return TRUE;
	}

	//get the minmun between sizeof( SGH_CONFIG ) and fileLen
	nReadFileLen = ( sizeof( SGH_CONFIG ) > fileLen ) ? fileLen : sizeof( SGH_CONFIG ) ;

	//read config 	
	if( fread( pSGHConfig, nReadFileLen , 1, fd_d ) != 1 )
	{		
		fclose( fd_d );
		
		DefaultDB_PPPUserName_Private();
		SaveDB_PPPUserName_Private();

		semGive(SghCfgFileSem);
		printf("fread error 1 in ReadDB_PPPUserName\r\n");
		return TRUE;
	}
	fclose( fd_d );


    //begin parse the file data 
    if ( pSGHConfig->cfgVersion != 2 )

    {    
		DefaultDB_PPPUserName_Private();
		SaveDB_PPPUserName_Private();
	
    	semGive(SghCfgFileSem);
	 	return TRUE;
    }

    if( pSGHConfig->cfgSignature1 != CFG_SIGNATURE1) 
	{
		//printf("CFG_SIGNATURE1 error\r\n");
		DefaultDB_PPPUserName_Private();
		SaveDB_PPPUserName_Private();
		
		semGive(SghCfgFileSem);
		return TRUE;
	}

	if( pSGHConfig->nCurrentDhcpClientSavePswNum >MAX_DHCPCLIENT_SAVE_NUM )
	{
		DefaultDB_PPPUserName_Private();
		SaveDB_PPPUserName_Private();
		
		semGive(SghCfgFileSem);
		return TRUE;
	}

	semGive(SghCfgFileSem);

	return TRUE;
   
}

BOOL DefaultDB_PPPUserName_Private (void)
{
	pSGHConfig->cfgVersion = 2;

	//check saved dhcp client number 
	pSGHConfig->cfgSignature1 = CFG_SIGNATURE1;
	pSGHConfig->nCurrentDhcpClientSavePswNum = 0;
	memset(pSGHConfig->DhcpClientAttr, 0, sizeof( pSGHConfig->DhcpClientAttr) );
}

BOOL SaveDB_PPPUserName_Private()
{
	FILE *fd_d;
	int num;

	if( pSGHConfig == NULL ) return FALSE;

	//printf("SaveDB_PPPUserName ... \r\n");
	if( (fd_d=fopen(pppSecurityFileName, "wb")) == NULL )
	{
		//printf("create file %s error in SaveDB_PPPUserName\r\n", pppSecurityFileName );
		return FALSE;		
	}

	//fwitre config
	if( (num = fwrite( pSGHConfig, sizeof( SGH_CONFIG ), 1, fd_d ) ) != 1 )
	{
		fclose( fd_d );
		printf("fwrite file %s error 1 in SaveDB_PPPUserName: %d\r\n", pppSecurityFileName, num );
		return FALSE;
	}

	fclose( fd_d );
	
	//printf("SaveDB_PPPUserName ok\r\n");

	return TRUE;   
}



/* Decide if the ClientMac is stored in the flash file. 
   if TRUE, then get its UserName and password.
*/
BOOL IsDhcpClientSavePasword( INPUT char *ClientMac, OUTPUT char *UserName, int maxUserNameLen, OUTPUT char* Password, int maxPasswordLen)
{
	int i;

	if( SghCfgFileSem == NULL ) return FALSE;
	
	if( semTake(SghCfgFileSem, sysClkRateGet() * 5) == ERROR)
	{ //TIMEOUT
		return FALSE;
	}

	if( pSGHConfig == NULL || ClientMac == NULL ) 
	{
		semGive(SghCfgFileSem);
		return FALSE;
	}

	for( i=0; i<pSGHConfig->nCurrentDhcpClientSavePswNum; i++)
	{
		if( memcmp( pSGHConfig->DhcpClientAttr[i].clientMac, ClientMac, 6) == 0 )
		{
			if( UserName != NULL )
			{
				strncpy(UserName, pSGHConfig->DhcpClientAttr[i].pppoe_userName, maxUserNameLen);
				UserName[maxUserNameLen-1] = 0;
			}
			if( Password != NULL )
			{
				strncpy(Password, pSGHConfig->DhcpClientAttr[i].pppoe_password, maxPasswordLen);
				Password[maxPasswordLen-1] = 0;
			}
			
			semGive(SghCfgFileSem);
			return TRUE;
		}			
	}

	semGive(SghCfgFileSem);
	
	return FALSE;		
}

/* Save dhcp clients username and password 
   In principle, the newest added dhcp clients is put at the last 
*/
BOOL SaveDhcpClientPasword( INPUT char *ClientMac, INPUT char *UserName, INPUT char* Password)
{
	BOOL bfNeedWriteFile = FALSE;
	int index, i;

	if( pSGHConfig == NULL || ClientMac == NULL  || UserName == NULL || Password == NULL ) 
	{
		return FALSE;
	}
	if( SghCfgFileSem == NULL ) return FALSE;

	if( strlen(UserName) >= MAX_PPPOE_USERNAME || 
		strlen(Password) >= MAX_PPPOE_PASSWORD ) return FALSE;

	if( ClientMac[0] & 1 ) return FALSE;
	if( ClientMac[0] == 0 && ClientMac[1] == 0 && ClientMac[2] == 0 &&
		ClientMac[3] == 0 && ClientMac[4] == 0 && ClientMac[5] == 0 ) return FALSE;
			
	if( semTake(SghCfgFileSem, sysClkRateGet() * 5) == ERROR ) return FALSE;

	for( i=0; i<pSGHConfig->nCurrentDhcpClientSavePswNum; i++)
	{
		if( memcmp( pSGHConfig->DhcpClientAttr[i].clientMac, ClientMac, 6) == 0 )
		{ //find 
			//printf("Find the dhcp client\r\n");
			if( strcmp( UserName, pSGHConfig->DhcpClientAttr[i].pppoe_userName) != 0 )
			{
				strcpy( pSGHConfig->DhcpClientAttr[i].pppoe_userName, UserName);
				bfNeedWriteFile = TRUE;
			}
			
			if( strcmp( Password, pSGHConfig->DhcpClientAttr[i].pppoe_password) != 0 )
			{
				strcpy( pSGHConfig->DhcpClientAttr[i].pppoe_password, Password);
				bfNeedWriteFile = TRUE;
			}

			goto END;
		}
			
	}

	if( pSGHConfig->nCurrentDhcpClientSavePswNum < MAX_DHCPCLIENT_SAVE_NUM )
	{  //have empty room
		//printf("Not Find the dhcp client, but have empty room\r\n");
		index = pSGHConfig->nCurrentDhcpClientSavePswNum;
		
		memcpy( pSGHConfig->DhcpClientAttr[ index].clientMac, ClientMac, 6);
		strcpy(pSGHConfig->DhcpClientAttr[ index].pppoe_userName, UserName );
		strcpy(pSGHConfig->DhcpClientAttr[ index].pppoe_password, Password);
		pSGHConfig->nCurrentDhcpClientSavePswNum ++;
		bfNeedWriteFile = TRUE;
		
		goto END;			
	}
	else 
	{
		//no empty room, so delete first, then add it at last 
		memcpy( &pSGHConfig->DhcpClientAttr[0], 
		         &pSGHConfig->DhcpClientAttr[ 1], 
		         (MAX_DHCPCLIENT_SAVE_NUM -1) * sizeof(DHCPClientPPPOEAttr) ); //move ahead

		index = MAX_DHCPCLIENT_SAVE_NUM -1;
		
		memcpy( pSGHConfig->DhcpClientAttr[ index].clientMac, ClientMac, 6);
		strcpy(pSGHConfig->DhcpClientAttr[ index].pppoe_userName, UserName );
		strcpy(pSGHConfig->DhcpClientAttr[ index].pppoe_password, Password);
		bfNeedWriteFile = TRUE;
	}

END:
	
	if( bfNeedWriteFile ) 
	{
		SaveDB_PPPUserName_Private();
		taskDelay(2); /*for file system */
	}
			
	semGive(SghCfgFileSem);

	return TRUE;
	
}


BOOL DelDhcpClientPasword( INPUT char *ClientMac)
{
	BOOL bfNeedWriteFile = FALSE;
	int i;

	if( pSGHConfig == NULL || ClientMac == NULL ) return FALSE;

	if( SghCfgFileSem == NULL ) return FALSE;
	
	if( semTake(SghCfgFileSem, sysClkRateGet() * 5) == ERROR ) return FALSE;

	for( i=0; i<pSGHConfig->nCurrentDhcpClientSavePswNum; i++)
	{
		if( memcmp( pSGHConfig->DhcpClientAttr[i].clientMac, ClientMac, 6) == 0 )
		{ //find 
			memcpy( &pSGHConfig->DhcpClientAttr[i], 
	         		&pSGHConfig->DhcpClientAttr[ i + 1], 
	         		(pSGHConfig->nCurrentDhcpClientSavePswNum -i -1 ) * sizeof(DHCPClientPPPOEAttr) );

			//clear the last one
			memset(&pSGHConfig->DhcpClientAttr[pSGHConfig->nCurrentDhcpClientSavePswNum - 1],
				    0, sizeof(DHCPClientPPPOEAttr) );

			pSGHConfig->nCurrentDhcpClientSavePswNum --;

			bfNeedWriteFile = TRUE;

			goto END;
		}			
	}

END:	

	if( bfNeedWriteFile ) 
	{
		SaveDB_PPPUserName_Private();
		taskDelay(2); /*for file system */
	}
			
	semGive(SghCfgFileSem);

	return TRUE;
}


void ShowSavedDhcpClient()
{
	int i;
	
	if( semTake(SghCfgFileSem, sysClkRateGet() * 5) == ERROR ) return ;

	if( pSGHConfig == NULL )
	{
		printf("pSGHConfig is NULL\r\n");
		semGive(SghCfgFileSem);
		return ;
	}

	printf("Show SavedDHCP client : %d\r\n", pSGHConfig->nCurrentDhcpClientSavePswNum);
	
	for( i=0; i<pSGHConfig->nCurrentDhcpClientSavePswNum; i++)
	{
		printf("DHCP client: ");
		ShortMemDumpXX(pSGHConfig->DhcpClientAttr[i].clientMac, 6);
		
		printf(" UserName = %s password = %s\r\n", pSGHConfig->DhcpClientAttr[i].pppoe_userName, pSGHConfig->DhcpClientAttr[i].pppoe_password );
	}

	semGive(SghCfgFileSem);
}
