/* user_int.h - example application to demonstrate form evaluation */

/* Project: Embedded HTTP Server, Version 1.0.4
 *
 * Copyright (c) 1996/97, 3Soft GmbH
 *
 * 3Soft GmbH, Wetterkreuz 19a
 * D-91058 Erlangen, Germany
 * infohttp@dreisoft.de, http://www.dreisoft.de
 */

/*
modification history
--------------------
01a,31oct96,ck    written
*/

/*
DESCRIPTION

NOMANUAL
*/

#include "bspcfg.h"		/* in bsp directory */
#include "flash.h"
#ifdef NAT_ENABLE
#include "nat_freebsd/h/nat_session_cfg.h"
#endif

#define HOST_NAME_LEN	20
#define INET_ADDR_LEN	18
#define MAC_STRLEN		18
#define IP_STRLEN		INET_ADDR_LEN
#define META_BUF_LEN	512
#define URL_LEN			128
#define SNMP_STRLEN		128

typedef struct web_rip_struct
{
	short	enable;
	short	supplier_flag;
	short	gateway_flag;
	short	multicast_flag;
	long	interval;
} WEB_RIP_STRUCT;

#ifdef DHCPS_ENABLE
typedef struct web_dhcps_struct
{
	char    start_IP[IP_STRLEN];
	char    end_IP[IP_STRLEN];
	char    preferred_DNS_server[IP_STRLEN];
	char    alt_DNS_server[IP_STRLEN];
	short	server_enable;
	ULONG	lease_time;
	short	reset_address_pool;
	short	dns_option;
	short	dhcp_pool_mode;
} WEB_DHCPS_STRUCT;
#endif

#ifdef NAT_ENABLE
typedef struct web_nat_struct
{
	short	enable;
	char	user_ip_string[IP_STRLEN];
	char	svc_name[FLASH_STRLEN];
	short	entry_option;
	short	vc;
	short	session_option;
	char	session_name[FLASH_STRLEN];
	NAT_SESSION_INFO_T	pSessionInfo;
	NAT_SESSION_INFO_T	pSessionInfo1;
	NAT_SESSION_ENTRY_T	pSessionEntry;
	NAT_SESSION_ENTRY_T pSessionEntry1;
} WEB_NAT_STRUCT;
#endif

#ifdef PPP_ENABLE
#if (defined(OEM_WEBREDIRECT) && !defined(CNXT_WEBREDIRECT))
enum PPP_ACTION_E
{
	PPP_ACTION_DUAL = 0,
	PPP_ACTION_CONNECT,
	PPP_ACTION_DISCONNECT
};
#else
enum PPP_ACTION_E
{
	PPP_ACTION_CONNECT = 0,
	PPP_ACTION_DISCONNECT,
	PPP_ACTION_DUAL
};
#endif

enum PPP_STATUS_E
{
	PPP_CONNECT = 0,
	PPP_DISCONNECT,
	PPP_WORKING,
	PPP_IDLE,
	PPP_OK,
	PPP_ERROR,
	PPP_NA,
	CONNECTED,
	NOT_CONNECTED,
	PPP_INITIAL,
	PPP_VC_DISABLED
};

#endif // PPP_ENABLE

typedef enum DIAG_HELP_INDEX_E
{
    DIAG_HELP_INDEX_ETHERNETLAN = 0,
    DIAG_HELP_INDEX_DSL,
    DIAG_HELP_INDEX_F5SEGMENT,
    DIAG_HELP_INDEX_F5ENDTOEND,
    DIAG_HELP_INDEX_ETHERNETAAL5,
    DIAG_HELP_INDEX_PPPOECONNECTION,
    DIAG_HELP_INDEX_PPPOE,
    DIAG_HELP_INDEX_PPP,
    DIAG_HELP_INDEX_IPOVERPPP,
    DIAG_HELP_INDEX_IPOVERETHERNET,
    DIAG_HELP_INDEX_PINGGATEWAY,
    DIAG_HELP_INDEX_PINGPRIMARYDNS,
    DIAG_HELP_INDEX_QUERYDNS,
    DIAG_HELO_INDEX_PINGHOST
} DIAG_HELP_INDEX_T;

typedef struct WAN_test_result
{
    UINT32  ATMF5SegmentLoopBack;
    UINT32  ATMF5EndToEndLoopBack;
    UINT32  ATMAAL5;
    UINT32  PPPOE;
	UINT32  PPPOE_PADOReceived;
	UINT32	PPPOE_PADSReceived;
    UINT32  PPP;
    UINT32  IP;
    UINT32  Gateway;//ping gateway result;
} WAN_TEST_RESULT;

typedef struct default_gateway_test_result
{
#ifdef T2_PRMSET_GUI
    char defaultGateway[T2_MAX_VC_PER_LINK][16];
#else
    char defaultGateway[MAX_VC_PER_LINK][16];
#endif
    UINT32 getDefaultGateway; // status of geting default gateway
    UINT32 numberOfDefaultGateway;
#ifdef T2_PRMSET_GUI
    UINT32 pingDefaultGateway[T2_MAX_VC_PER_LINK];
#else
    UINT32 pingDefaultGateway[MAX_VC_PER_LINK];
#endif
} DEFAULT_GATEWAY_TEST_RESULT;

typedef struct DNS_test_result
{
    UINT32 pingPrimaryDNS;
    UINT32 queryHost; /* ok or error */
    UINT32 pingHost; /*the result of ping IPAddressOfHost*/

    char host[256+1]; /* the host name used to test DNS resolver*/
    char pingHostName[256+1]; /* the host name used to test DNS resolver*/
    char primaryDNS[16]; /* ip address of Primary DNS server */
    char IPAddressOfHost[16]; /* the result from DNS server if queryResult == OK */
	char IPAddressOfPingHost[16];
} DNS_TEST_RESULT;

typedef struct diagnose_test_result
{
    UINT32  Ethernet;
    UINT32  DSL;
#ifdef T2_PRMSET_GUI
    WAN_TEST_RESULT WAN[T2_MAX_VC_PER_LINK];
#else
    WAN_TEST_RESULT WAN[MAX_VC_PER_LINK];
#endif
    DEFAULT_GATEWAY_TEST_RESULT defaultGateway;
    DNS_TEST_RESULT  DNS;
} DIAGNOSE_TEST_RESULT;

void get_ATTN1 (void *, char *);
void get_SNR1 (void *, char *);

int xdigit2i(int digit);
int i2xdigit(int digit);
int parse_macaddr(char *str, char macaddr[6]);
void format_macaddr(char buf[18], char macaddr[6]);
HTTP_STATUS get_user_wan_mac_addr(HTTP_SYM_ID,void *);
HTTP_STATUS set_user_wan_mac_addr(HTTP_SYM_ID,void *);
HTTP_STATUS route_option_set (HTTP_SYM_ID,void *);
HTTP_STATUS DHCPC_release_renew_func (HTTP_SYM_ID,void *);
HTTP_STATUS save_params ();
HTTP_STATUS clearLOG ();
HTTP_STATUS Get_OEMWEBREDIRECT_Mode ();
HTTP_STATUS get_oemwebredirect_wan (HTTP_SYM_ID,void *);
HTTP_STATUS get_wan (HTTP_SYM_ID,void *);
HTTP_STATUS set_wan (HTTP_SYM_ID,void *);
HTTP_STATUS get_lan (HTTP_SYM_ID,void *);
HTTP_STATUS set_lan (HTTP_SYM_ID,void *);
HTTP_STATUS getSNMPFlag (HTTP_REQ_ID, char *);
HTTP_STATUS get_snmp (HTTP_SYM_ID,void *);
HTTP_STATUS set_snmp (HTTP_SYM_ID,void *);
HTTP_STATUS get_snmptrapdestIP (HTTP_SYM_ID,void *);
HTTP_STATUS set_snmptrapdestIP (HTTP_SYM_ID,void *);
HTTP_STATUS get_snmptrapdestport (HTTP_SYM_ID,void *);
HTTP_STATUS set_snmptrapdestport (HTTP_SYM_ID,void *);
HTTP_STATUS get_adsl (HTTP_SYM_ID,void *);
HTTP_STATUS set_adsl (HTTP_SYM_ID,void *);
HTTP_STATUS get_adsl_bit_swapping (HTTP_SYM_ID,void *);
HTTP_STATUS set_adsl_bit_swapping (HTTP_SYM_ID,void *);
HTTP_STATUS get_gateway (HTTP_SYM_ID,void *);
HTTP_STATUS set_gateway (HTTP_SYM_ID,void *);
HTTP_STATUS get_rip (HTTP_SYM_ID,void *);
HTTP_STATUS set_rip (HTTP_SYM_ID,void *);
HTTP_STATUS get_nat (HTTP_SYM_ID,void *);
HTTP_STATUS set_nat (HTTP_SYM_ID,void *);
HTTP_STATUS get_password (HTTP_SYM_ID,void *);
HTTP_STATUS set_password (HTTP_SYM_ID,void *);
HTTP_STATUS get_misc (HTTP_SYM_ID,void *);
HTTP_STATUS set_misc (HTTP_SYM_ID,void *);
HTTP_STATUS get_gateway_mode (HTTP_SYM_ID,void *);
HTTP_STATUS set_gateway_mode (HTTP_SYM_ID,void *);
HTTP_STATUS get_dmz_state (HTTP_SYM_ID,void *);
HTTP_STATUS set_dmz_state (HTTP_SYM_ID,void *);
HTTP_STATUS get_dmz_ip (HTTP_SYM_ID,void *);
HTTP_STATUS set_dmz_ip (HTTP_SYM_ID,void *);

HTTP_STATUS getVoipFlag (HTTP_REQ_ID, char *);
HTTP_STATUS getTeslaFlag (HTTP_REQ_ID, char *);
HTTP_STATUS getTeslaControl (HTTP_REQ_ID, char *);
HTTP_STATUS setTeslaControl (HTTP_SYM_ID,void *);

void getSwVersion(void);
HTTP_STATUS DisplaySwVersion (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayRouteTable (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayAdslStatus (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayTcpStatus (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayLanStatus (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayEthernetStatus (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayUSBStatus (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayDHCPClients (HTTP_REQ_ID, char *);
//HTTP_STATUS GetNumberOfDHCPClients (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayWanStatus (HTTP_REQ_ID, char *);
HTTP_STATUS GetWanType (HTTP_REQ_ID, char *);
HTTP_STATUS GetDHCPCInfo (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayPPPStatus (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayPPPStats (HTTP_REQ_ID, char *);
HTTP_STATUS SelectSinglePVC(HTTP_REQ_ID, char *);
HTTP_STATUS DisplayMacTable(HTTP_REQ_ID, char *);
HTTP_STATUS DisplayDNS (HTTP_REQ_ID, char *);
HTTP_STATUS myshowatmvalue (
    HTTP_REQ_ID  reqId,
    char *       szArg
);

#ifdef USB_ENABLED
HTTP_STATUS DisplayDeviceDescriptor(
	HTTP_REQ_ID	reqId,
	char *		szArg
);
HTTP_STATUS DisplayConfigDescriptor(
	HTTP_REQ_ID	reqId,
	char *		szArg
);
HTTP_STATUS DisplayInterfaceDescriptor(
	HTTP_REQ_ID	reqId,
	char *		szArg
);
HTTP_STATUS DisplayEndpointDescriptor(
	HTTP_REQ_ID	reqId,
	char *		szArg
);
HTTP_STATUS DisplayUSBInformation(
	HTTP_REQ_ID	reqId,
	char *		szArg
);
#endif
HTTP_STATUS getNumOfLan(HTTP_REQ_ID, char *);
HTTP_STATUS setLanNum0(HTTP_REQ_ID, char *);
HTTP_STATUS setLanNum1(HTTP_REQ_ID, char *);
HTTP_STATUS setLanNum2(HTTP_REQ_ID, char *);

#ifdef OEM_WEBREDIRECT
HTTP_STATUS DisplayPPP2Status (HTTP_REQ_ID, char *);
#endif
HTTP_STATUS get_rt_str (void);

HTTP_STATUS http_ping(HTTP_SYM_ID,void *);
HTTP_STATUS http_ping_result(HTTP_SYM_ID,void *);
HTTP_STATUS DHCPC_release_func (HTTP_SYM_ID, void *);
HTTP_STATUS DHCPC_renew_func (HTTP_SYM_ID, void *);

STATUS get_pvc_PPP_status(short);
HTTP_STATUS getPPPActionStatus (HTTP_REQ_ID, char *);
HTTP_STATUS getPPPConnectStatus (HTTP_REQ_ID, char *);
#if 1
HTTP_STATUS getPPPReloadStatus (HTTP_REQ_ID, char *);
HTTP_STATUS getPPPDisconnectStatus (HTTP_REQ_ID, char *);
#endif
HTTP_STATUS PPP_set_virtual_circuit (HTTP_SYM_ID, void *);
HTTP_STATUS PPP_connect_disconnect (HTTP_SYM_ID, void *);
HTTP_STATUS PPP_connect_disconnect2 (HTTP_SYM_ID, void *);
HTTP_STATUS ppp_switch (HTTP_SYM_ID, void *);
HTTP_STATUS appSwitch(HTTP_REQ_ID, char *);
HTTP_STATUS GetPPPReleaseAuthStatus (HTTP_REQ_ID, char *);

void PPP_action_go();

HTTP_STATUS DisplayNatSessionInfo (HTTP_REQ_ID,	char *);
HTTP_STATUS DisplayNatEntryInfo (HTTP_REQ_ID, char *);
HTTP_STATUS session_option_set (HTTP_SYM_ID, void *);
HTTP_STATUS nat_entry_option_set (HTTP_SYM_ID, void *);

HTTP_STATUS diag_test (HTTP_SYM_ID, void *);
HTTP_STATUS getDiagTestStatus (HTTP_REQ_ID,	char *);

HTTP_STATUS get_num_DHCP_devices (HTTP_SYM_ID, void *);

HTTP_STATUS reset_factory_default();

HTTP_STATUS set_timeout (HTTP_SYM_ID,void *);
HTTP_STATUS diag_test (HTTP_SYM_ID, void *);
HTTP_STATUS getDiagTestReloadStatus (HTTP_REQ_ID, char *);

/*refresh status pages*/
HTTP_STATUS refreshAdslStatus (HTTP_REQ_ID,	char *);
HTTP_STATUS refreshAdsl1Status (HTTP_REQ_ID, char *);

HTTP_STATUS getLOG (HTTP_REQ_ID, char *);

HTTP_STATUS GetShowReleaseButton(HTTP_REQ_ID, char *);
HTTP_STATUS GetShowOptionPage(HTTP_REQ_ID, char *);

HTTP_STATUS Is_OEM_WebRedirect(HTTP_REQ_ID, char *);
HTTP_STATUS Is_K2_Supported(HTTP_REQ_ID, char *);
HTTP_STATUS Has_USB(HTTP_REQ_ID, char *);
HTTP_STATUS Has_Wireless(HTTP_REQ_ID, char *);

HTTP_STATUS get_switch_pwd (HTTP_SYM_ID, void *);

HTTP_STATUS http_force_web_redirect_on (HTTP_SYM_ID, void *);
HTTP_STATUS http_force_web_redirect_off (HTTP_SYM_ID, void *);
HTTP_STATUS http_force_web_redirect_bridge (HTTP_SYM_ID, void *);

HTTP_STATUS http_system_reboot (HTTP_SYM_ID, void *);

HTTP_STATUS http_release_pppoe(HTTP_SYM_ID, void *);

HTTP_STATUS DisplayOEMWEBREDIRECTMode(HTTP_REQ_ID, char *);
HTTP_STATUS DisplayDslUpDownStatus (HTTP_REQ_ID, char *);
HTTP_STATUS DisplayPPPoEReleaseStatus (HTTP_REQ_ID,	char *);

HTTP_STATUS getFtpDownloadStatus (HTTP_REQ_ID, char *);
HTTP_STATUS getFtpDownloadReloadStatus (HTTP_REQ_ID  reqId,	char *);

HTTP_STATUS DisplayConnectDisconnect (HTTP_REQ_ID, char *);

//#ifdef INCLUDE_WEB_VIRTUAL_SERVER
extern long WEB_VTABLE_id_delete;
extern long WEB_VTABLE_id;
extern long WEB_VTABLE_port_private;
extern long WEB_VTABLE_port_public;
extern long WEB_VTABLE_action;
extern long WEB_VTABLE_port_type;
extern char WEB_VTABLE_ip[INET_ADDR_LEN];
extern char WEB_VTABLE_host[HOST_NAME_LEN];

extern HTTP_STATUS webVSERVER_init(void);
extern STATUS goAddVServer();
extern HTTP_STATUS doVServerAction (HTTP_SYM_ID sym, void *pval);
extern HTTP_STATUS getVirtualServerTable (HTTP_REQ_ID  reqId,char *szArg);
extern HTTP_STATUS setVSId (HTTP_SYM_ID sym,void *pval);
extern HTTP_STATUS setVSIdDelete (HTTP_SYM_ID sym,void *pval);
extern HTTP_STATUS setVSPortPrivate (HTTP_SYM_ID sym,void *pval);
extern HTTP_STATUS setVSPortPublic (HTTP_SYM_ID sym,void *pval);
extern HTTP_STATUS setVSPortType (HTTP_SYM_ID sym,void *pval);
extern HTTP_STATUS setVSIp (HTTP_SYM_ID sym,void *pval);
extern HTTP_STATUS setVSId (HTTP_SYM_ID sym,void *pval);
//#endif /* INCLUDE_WEB_VIRTUAL_SERVER */

void RebootNP66(int nMillSecond);


/* mckey */
#ifdef CLIENT_FILTER_ENABLE
    STATUS goAddClientFiltering();
    HTTP_STATUS webClientFiltering_init();
    HTTP_STATUS getClientFilteringTable (HTTP_REQ_ID  reqId,char *szArg);
    HTTP_STATUS setCFIp1 (HTTP_SYM_ID sym, void *pval);
    HTTP_STATUS setCFIp2 (HTTP_SYM_ID sym, void *pval);
    HTTP_STATUS setCFport1 (HTTP_SYM_ID sym, void *pval);
    HTTP_STATUS setCFport2 (HTTP_SYM_ID sym, void *pval);
    HTTP_STATUS setCFportType (HTTP_SYM_ID sym, void *pval);
    HTTP_STATUS setCFDeleteID (HTTP_SYM_ID sym, void *pval);

    #ifdef CLIENT_FILTER_DAY_HOUR_SUPPORT
        HTTP_STATUS setCFBlock (HTTP_SYM_ID sym, void *pval);
        HTTP_STATUS setCFDayStart (HTTP_SYM_ID sym, void *pval);
        HTTP_STATUS setCFDayEnd (HTTP_SYM_ID sym, void *pval);
        HTTP_STATUS setCFTimeEnd (HTTP_SYM_ID sym, void *pval);
        HTTP_STATUS setCFTimeStart (HTTP_SYM_ID sym, void *pval);
    #endif /* CLIENT_FILTER_DAY_HOUR_SUPPORT */

#endif /* CLIENT_FILTER_ENABLE */



