/*#ifndef _HTTPD_SGH_H_
#define _HTTPD_SGH_H_
*/
#include "semlib.h"
#include "httpbasic.h"

/*
Note, when I use this macro to less the http session alive time, but it will case some delay when I 
continuous press "refresh" button to refresh the brower ". 
So I delete this macro, then I works OK. I cannt understand it ?????/
*/
//#define HTTP_ONESESSION_HTTP_ONLY    //which will make one http session with less alive time

#define HTTP_RESULT_NOT_FOUND          0 /*not find the entry */
#define HTTP_RESULT_FOUND_BUT_ERROR 1 /*found but other error, such as no memory, or other */
#define HTTP_RESULT_SECURITY_ERROR     2 /*found but security error */
#define HTTP_RESULT_FOUND_OK           3 /*OK */


/***************************************************************************
 *
 *  Defines
 *  
 ***************************************************************************/
#define MAX_SECURITY_NUM 20
typedef struct HTTPSecurityControlAttr
{
	ULONG LoginedClientIP;
	int SecurityLevel;
	ULONG ulLastloginTime; //ticks
}HTTPSecurityControlAttr;

/***************************************************************************
 *
 *  Functions Prototypes
 *  
 ***************************************************************************/
class CHTTPD
{
public:
	static int		DaemonNum ;  //record the CHTTPD/Demaon number	
	SEM_ID 			httpSemMutex;
	ULONG 			semErrorTimes;
	char           	LanPortIP[16];

	/*int 			nHttpPort; */ /*2004.02.04 del */
	int 			LocalHTTPMaxConn; /*the max number for use to connect the http server */
	HTTP_CONN  		LocalHTTPConn[HTTP_DEFAULT_MAX_CONN + 5];

	char            DefaultHttpUrl[HTTP_DEFAULT_MAX_CONN + 5];
	char            SuspendHttpUrl[HTTP_DEFAULT_MAX_CONN + 5];


	HTTPSecurityControlAttr SecurityControl[MAX_SECURITY_NUM]; /*save username/password to login for configuration */
	
	HTTP_POST_ACTION* PostActionArray; //the array of http post action 
	HTTP_FILES_SYSTEM* GetFilesArray; //the array of http files for http get 

	static BOOL 	httpDaemon(CHTTPD* pHttp, int port);

	BOOL bfHttpdNormalMode;	/*for special reason: now upgrade mode use TRUE, non-upgrade mode use FALSE to support DNS spoof's negative effects */

public:
	CHTTPD();	
	int 	HTTPInit( char *LanIP, HTTP_POST_ACTION HttpPostArray[], HTTP_FILES_SYSTEM HttpFileArray[], char *DefaultHttpPageUrl, char *SuspendHttPageUrl, BOOL NormalMode);
	BOOL    HTTPStart();
	BOOL 	HTTPDShutDown(void) ;
//private:	
	
	static void	httpSession (CHTTPD* pHttp, int sFd, u_short port,int connID);
	int 	httpNewConn( int sock );
	int 	httpFreeConn( int connID );
	void 	httpStateConn();
	int HTTPDReadInputLine (int sock, char *buffer, int bufLength);
	int HTTPDSendError(int sock, int code, char *msg);
	int HTTPDSendFile(int sock, char *url, pHTTP_CONN conn);
	int httpdHandleGetRequest (int sock, char *url, pHTTP_CONN conn) ;
	int httpdHandlePostRequest (int sock, char *url, char *postData, int dataLength, pHTTP_CONN conn);
	int HTTPDSendHeader(int sock, int contentType, int contentLength);
	BOOL HTTPDSendHeader2(int sock, int contentType, int contentLength);
	BOOL HTTPDSendData(int sock, char * pData, int dataLength);
	int HTTPDSendRedirect(int sock, char *redirectUrl);
	int httpPostExecuteAction ( char *urlName, char *postData, int dataLength, pHTTP_CONN conn);
	int HTTPDSetLoginIP (unsigned long login_ip) ;
	BOOL Free_DynMem_Private();
	unsigned long HTTPDGetLoginIP (void);
	int httpFilesGetArrayIndex_private( char *urlName );

	

	pHTTP_CONN  httpGetConn( int connID );

	

	int 		HTTPDHandleInput (int sock, pHTTP_CONN conn);
	int 		HTTPDWriteSock(int sock, char *msg);

	//int httpFilesPut ( char *urlName, char *fileData, int fileLength);
	int httpFilesPutInnerArray ( char *urlName, char *fileData, int fileLength);

	char*	httpPostGetFieldValue (char *postData, char *fieldName, char *fieldValue, int bufLength);
	int 	httpFilesForm ( char **fileData, int *fileLength, char *file_contents[]) ;
	void 	httpFilesForm_Free(char *fData);
	int 	httpdGetUrlType (char *url) ;

	BOOL    GetLanIP_String(char *IP);
	BOOL 	HttpSemCheck();
	
	ULONG    GetLanIP_ULONG(); //network;

	int     GetSecurityLevel(pHTTP_CONN conn);
	int 	SetSecurityLevel(pHTTP_CONN conn, int loginLevel);


};


//#endif
