#include "stdio.h"
#include "dhcp/dhcp.h"
#include "semlib.h"
#include "syslib.h"
#include "ticklib.h"


#include "xxxprotocol.h"
#include "xxxmempool.h"
#include "xxxmiscu.h"

#include "oneonenatconstant.h"
#include "muxlibex.h"

#define SUPPORT_ARP_MANUAL

#ifdef SUPPORT_ARP_MANUAL

//#define ARP_MANAGER_DEBUG
typedef struct ARP_ENTRY
{
	char Mac[6];
	ULONG IP; /*network byte order*/
	ULONG lastTicks; /*0-not used, non-zero: last ticks */
}ARP_ENTRY;


#define MAX_ARP_ENDTRY_NUM	    280
#define ARP_ENDTRY_VALID_TIME 100  /*seonds*/

static SEM_ID	arpSemID = NULL;
static ARP_ENTRY arpTable[MAX_ARP_ENDTRY_NUM];

void InitArpmanager()
{
	memset( arpTable, 0, sizeof(arpTable) );
	arpSemID = semBCreate(SEM_Q_FIFO, SEM_FULL);

	if( arpSemID == NULL )
	{
		printf("InitArpmanager: semBCreate fail\r\n");
		return ;
	}	
}

BOOL SearchArpTable( ULONG IP/*input*/, char *Mac/*output*/)
{
	int i;
	BOOL bfFind = FALSE;
	ULONG currentTick = tickGet();
	ULONG TimeoutTicks = sysClkRateGet() * ARP_ENDTRY_VALID_TIME;
	
	if( Mac == NULL || IP ==0 || arpSemID == NULL) return FALSE;
	
	if( semTake( arpSemID, 100 ) == ERROR)
	{	
		printf("SearchArpTable semTake timeout\r\n");
		return FALSE;
	}
	
#ifdef ARP_MANAGER_DEBUG		
	printf("SearchArpTable...\r\n");
#endif

	for( i=0; i<MAX_ARP_ENDTRY_NUM; i++)
	{
		if( arpTable[i].lastTicks == 0 ) continue; /*entry is not used */

		//check if time out
		if( currentTick - arpTable[i].lastTicks >= TimeoutTicks )
		{
			arpTable[i].lastTicks = 0; /*timeout, del it */
		}
		
		if( arpTable[i].IP == IP ) 
		{
			memcpy( Mac, arpTable[i].Mac, 6);

			bfFind = TRUE;
			break;
		}
	}

	semGive( arpSemID );
	
#ifdef ARP_MANAGER_DEBUG
	if( bfFind ) printf("SearchArpTable end ok\r\n");
	else printf("SearchArpTable end fail\r\n");
#endif	

	if( bfFind ) return TRUE;
	else return FALSE;
}

BOOL UpdateArpTable( ULONG IP/*input*/, char *Mac/*input*/)
{
	int i;
	BOOL bfFind = FALSE;
	
	ULONG OldestTicks = 0;
	int   OldestIndex = -1;	
	int   AvailbleEmptyIndex = -1;
	
	if( Mac == NULL || IP == 0 || arpSemID == NULL ) return FALSE;

	if( semTake( arpSemID, 100 ) == ERROR)
	{	
		printf("UpdateArpTable semTake timeout\r\n");
		return FALSE;
	}
	
#ifdef ARP_MANAGER_DEBUG	
	printf("UpdateArpTable ...\r\n");
#endif

	for( i=0; i<MAX_ARP_ENDTRY_NUM; i++)
	{
		if( arpTable[i].lastTicks == 0 )  //find free entry
		{
			if( AvailbleEmptyIndex < 0 ) AvailbleEmptyIndex = i;
			continue;
		}

		
		if( arpTable[i].IP == IP ) //Find
		{
			memcpy( arpTable[i].Mac, Mac, 6);
			
			arpTable[OldestIndex].lastTicks = tickGet();

			bfFind = TRUE;
			break; //stop search whole entry
		}		

		//select oldest entry
		if( arpTable[i].lastTicks > OldestTicks )
		{
			OldestTicks = arpTable[i].lastTicks;
			OldestIndex = i;
		}		
	}

	
	if( !bfFind )
	{
		if( AvailbleEmptyIndex >=0 ) //find a empty/free entry
		{
		#ifdef ARP_MANAGER_DEBUG	
			printf("UpdateArpTable AvailbleEmptyIndex = %d\r\n", AvailbleEmptyIndex );
		#endif
			memcpy( arpTable[AvailbleEmptyIndex].Mac, Mac, 6);
			arpTable[AvailbleEmptyIndex].IP = IP;
			arpTable[AvailbleEmptyIndex].lastTicks = tickGet();
			
			bfFind = TRUE;
		}
		else if( OldestIndex >= 0 )
		{ /*replace it for too oldest and no free entry*/
		#ifdef ARP_MANAGER_DEBUG	
			printf("UpdateArpTable OldestIndex = %d\r\n", OldestIndex );
		#endif
			memcpy( arpTable[OldestIndex].Mac, Mac, 6);
			arpTable[OldestIndex].IP = IP;
			arpTable[OldestIndex].lastTicks = tickGet();

			bfFind = TRUE;
		}
		else
		{
			printf("UpdateArpTable Error if enter here\r\n");
		}			
	}
#ifdef ARP_MANAGER_DEBUG
	else
	{
		printf("UpdateArpTable findIndex = %d\r\n", i );
	}
#endif
	
	semGive( arpSemID );

#ifdef ARP_MANAGER_DEBUG	
	printf("UpdateArpTable end\r\n");
#endif


	if( bfFind ) return TRUE;
	else return FALSE;

}

void ShowArpManager()
{
	int i = 0;
	if( arpSemID == NULL ) return;
	
	if( semTake( arpSemID, 100 ) == ERROR)
	{	
		printf("ShowArpManager semTake timeout\r\n");
		return ;
	}
	
#ifdef ARP_MANAGER_DEBUG	
	printf("UpdateArpTable ...\r\n");
#endif
	
	for( i=0; i<MAX_ARP_ENDTRY_NUM; i++)
	{
		if( arpTable[i].lastTicks == 0 ) 
		{
			continue;
		}

		PrintIP_LXX( arpTable[i].IP, FALSE );
		ShortMemDumpXX(arpTable[i].Mac, 6);
		printf("\r\n");
	}

	semGive( arpSemID );
}

#endif
