/*       
 *=========================================================================+
 *                 CONEXANT PROPRIETARY AND CONFIDENTIAL                   |
 *                      Conexant Systems, Inc. (C) 1999                    |
 *=========================================================================+
 *
 * Module:      if_sub.h - interface group SNMP MIB handler header file
 *
 * $Header: E:/WorkCVS/NP66/hasbani/APPS/SNMPA/if_sub.h,v 1.1.1.1 2004/04/01 09:10:04 shao-gh Exp $
 *
 * Description: This header file contains definitions used by SNMP interfaces
 *              mib handlers (if_stub.c) and supporting subroutines (if_sub.c).
 * 
 *=========================================================================+
 */

#ifndef _IF_SUB_H_
#define _IF_SUB_H_

#include "SnmpApi.h"
#include "SnmpApi_if.h"

//#define SNMP_DEBUG_IF   1

#define STRUCT_ifEntry  MIB_INTERFACE_ENTRY



typedef struct
{
    m_UINT32        ifNumber;
} STRUCT_interfaces;

int ifEntry_lookup
(
    int                 compc,
    OIDC_T              *compl,
    STRUCT_ifEntry      *data
);
BOOL 
ifEntry_firstEntry
(
    STRUCT_ifEntry  *data
);
BOOL
ifEntry_nextEntry
(
    STRUCT_ifEntry  *data
);
unsigned ifEntry_build_instance
(
    STRUCT_ifEntry  *data,
    OIDC_T          *tmp_inst
);
BOOL ifEntry_installEntry
(
    STRUCT_ifEntry   *data
);

#endif  /*  _IF_SUB_H_ */

/*       
 *=========================================================================+
 * Revision History:
 *
 * $Log: if_sub.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:58  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:48  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:14  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.1   Nov 09 2001 11:43:06   liniy
 * Moved Interface Table definitions to SnmpApi_ifTable.h.
 * 
 *    Rev 1.0   Nov 06 2001 16:00:56   liniy
 *  
 * 
 *=========================================================================+
 */
