/*       
 *=========================================================================+
 *                 CONEXANT PROPRIETARY AND CONFIDENTIAL                   |
 *                      Conexant Systems, Inc. (C) 1999                    |
 *=========================================================================+
 *
 * Module:      SNMPAPI.h - SNMP API common header file
 *
 * $Header: E:/WorkCVS/NP66/hasbani/APPS/SNMPA/SnmpApi.h,v 1.1.1.1 2004/04/01 09:10:04 shao-gh Exp $
 *
 * Description: This header file contains common definitions used by all
 *              Conexant SNMP MIB API modules.
 * 
 *=========================================================================+
 */

#ifndef _SNMPAPI_H_
#define _SNMPAPI_H_


#ifdef __cplusplus
extern "C" {
#endif

#include <vxWorks.h>

/* GLOBAL DATA TYPES AND DEFINITIONS */

typedef long          m_INT32;
typedef unsigned long m_UINT32;


typedef struct _mOctetString 
{
    m_INT32        length;
    unsigned char  *octet_ptr;
} mOctetString;

typedef struct _mOID 
{
    m_INT32        length;
    m_UINT32      *oid_ptr;
} mOID;


#define MIB_BYTES_FOR_BITS(num_bits)    ((num_bits + 7) / 8)
#define MIB_PAD_BYTES(num_bits)         (sizeof(UINT32) - (MIB_BYTES_FOR_BITS(num_bits) % sizeof(UINT32)))

/*
#define SNMPAPI_BYTES_FOR_BITS(num_bits)    ((num_bits + 7) / 8)
#define SNMPAPI_PAD_BYTES(num_bits)         (sizeof(UINT32) - (MIB_BYTES_FOR_BITS(num_bits) % sizeof(UINT32)))
 */


/*
 * The snmpTrap family.
 */
typedef struct _snmpTrap_t 
{
        mOID            *snmpTrapmOID;
        mOID            *snmpTrapEnterprise;
        char            valid[1];
} snmpTrap_t;


/*
 * The snmpSet family.
 */
typedef struct _snmpSet_t 
{
        m_INT32         snmpSetSerialNo;
        char            valid[1];
} snmpSet_t;


/*
* SNMP row status constant
*/
#define MIB_ROW_STATUS_ACTIVE           1
#define MIB_ROW_STATUS_NOT_IN_SERVICE   2
#define MIB_ROW_STATUS_NOT_READY        3    
#define MIB_ROW_STATUS_CREATE_AND_GO    4
#define MIB_ROW_STATUS_CREATE_AND_WAIT  5
#define MIB_ROW_STATUS_DESTROY          6

/* Extern global variables and function prototypes */

extern  mOID            zeroOID;
extern  mOctetString    zeroIp;
extern  mOctetString    naString;
extern  mOctetString    zeroString;

extern  BOOL            MIB_IsValidBitSet( char *pChar, int bitNumber );
extern  void            MIB_SetValidBit( char *pValid, int bitNumber );
extern  unsigned long   MIB_GetSysUpTime( void );

extern  BOOL            snmpIsValidBitSet( char *pChar, int bitNumber );
extern  void            snmpSetValidBit( char *pValid, int bitNumber );
extern  unsigned long   MIB_getSysUpTime( void );


#ifdef __cplusplus
}
#endif

#endif /* _SNMPAPI_H_ */
/*       
 *=========================================================================+
 * Revision History:
 *
 * $Log: SnmpApi.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:58  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:48  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:14  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.2   Nov 09 2001 12:54:26   liniy
 *  
 * 
 *    Rev 1.1   Nov 09 2001 11:49:14   liniy
 * Added renamed API function prototypes.
 * 
 *    Rev 1.0   Nov 06 2001 16:00:54   liniy
 *  
 * 
 *=========================================================================+
 */
