/****************************************************************************
*
*   Name:           SnmpAIfMib_sub.h
*
*   Description:    This header file contains definitions used by Interface
*                   Group mib handlers (SnmpAIfMib_stub.c) and supporting 
*                   subroutines. (if_sub.c).
*
*   Copyright:      (c) 2002 Conexant Systems Inc.
*
*****************************************************************************
*   $Author: shao-gh $
*   $Revision: 1.1.1.1 $
*   $Modtime:   Oct 03 2002 12:25:48  $
****************************************************************************/

#ifndef _SNMPA_IF_MIB_SUB_
#define _SNMPA_IF_MIB_SUB_

/****************************************************************************
*  Include files
****************************************************************************/

#include "SnmpApi.h"
#include "SnmpAIfMib.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

#define STRUCT_ifEntry  MIB_INTERFACE_ENTRY


/****************************************************************************
*  Type definitions
****************************************************************************/

typedef struct
{
    m_UINT32        ifNumber;
} STRUCT_interfaces;


/****************************************************************************
*  Function prototypes
****************************************************************************/

int ifEntry_lookup
(
    int                 compc,
    OIDC_T              *compl,
    STRUCT_ifEntry      *data
);
BOOL 
ifEntry_firstEntry
(
    STRUCT_ifEntry  *data
);
BOOL
ifEntry_nextEntry
(
    STRUCT_ifEntry  *data
);
unsigned ifEntry_build_instance
(
    STRUCT_ifEntry  *data,
    OIDC_T          *tmp_inst
);
BOOL ifEntry_installEntry
(
    STRUCT_ifEntry   *data
);

#endif  /*  _SNMPA_IF_MIB_SUB_ */

/*       
 *=========================================================================+
 * Revision History:
 *
 * $Log: SnmpAIfMib_sub.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:58  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:28:48  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:14  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.0   Oct 09 2002 11:01:00   liniy
 *  
 * 
 *    Rev 1.1   Nov 09 2001 11:43:06   liniy
 * Moved Interface Table definitions to SnmpApi_ifTable.h.
 * 
 *    Rev 1.0   Nov 06 2001 16:00:56   liniy
 *  
 * 
 *=========================================================================+
 */
