/***************************************************************************
 *   MODULE NAME    : bridge.h                                             *
 ***************************************************************************
 *   Copyright 2001 Conexant Systems, Inc. as unpublished work             *
 *   All Rights Reserved                                                   *
 *                                                                         *
 *   The information contained herein is the confidential property         *
 *   of Conexant Systems, Inc..  The use, copying, transfer or             *
 *   disclosure of such information is prohibited except by express        *
 *   written agreement with Conexant Systems, Inc..                        *
 *                                                                         *
 *   Original Written By  :    Mickey Hung                                 *
 *   Original Date        :    02/13/2001                                  *
 ***************************************************************************/
/***************************************************************************
 * This file implements all the data types and structures provided for     *
 * Bridging function in EZ-Connect project. All the APIs implementations   * 
 * are in "bridge.c" source file...										   * 
 ***************************************************************************/


#ifndef _BRIDGE_H_
#define _BRIDGE_H_



/*-------------------------------------------------------------------------*/
/*					Parameters for bridging task spawning...               */
/*-------------------------------------------------------------------------*/
#define BRDG_TASK_NAME				"BRDG_Task"
#define BRDG_TASK_PRIORITY			200
#define BRDG_TASK_PRIVATE_ENV		0x80
#define BRDG_TASK_STACK_SIZE		4000

#define BRDG_TASK_POLLING_INTERVAL	1 /* ticks, we can use sysClkRateGet() */
									  /* to get system clock rate tick/sec */


#define MAC_BUF_SIZE		20
#define MAC_BUF_BOTTOM		(MAC_BUF_SIZE-1)
#define MAC_BUF_TOP			0		/* the buffer array index starts with 0 */


/***************************************************************************/
/*                   DATA TYPE AND STRUCTURE DEFINITION                    */
/***************************************************************************/
typedef struct 
{
	UINT8	mac[6];
	BR_PORT *pPort;	/* port definition see "mac_table.h"    */
} STRUCT_MAC_BUF; 



typedef enum
{
	MY_MAC_PACKET,		/* my mac, forward to CPU */
	MY_OTHER_MAC_PACKET,		/* my mac, forward to CPU */
	IN_TBL_PACKET,		/* found in table, forward to corresponding port */
	BRDCAST_PACKET,		/* broadcast packet */
	NOT_FOUND_PACKET	/* none of above */

} FORWARD_DIRECTION;

/***************************************************************************/
/*                          GLOBAL FUNCTION DECLARATION                    */
/***************************************************************************/
void	BRDG_TaskInit(void);
void	BRDG_newMacHandling(UINT8* new_mac, BR_PORT *pPort);
FORWARD_DIRECTION		BRDG_rxPacketHandling(  UINT8* new_mac, 
                                                BR_PORT *pPort,
												BR_PORT **ppPort	  );
STATUS	macBuf_putNewMac(UINT8* new_mac, BR_PORT *pPort );


/* --------------------------------------------------- */
/*   The following global routines are for debugging   */
/* --------------------------------------------------- */  
void d_show_mac_buf(void);



#endif _BRIDGE_H_

/***************************************************************************/
/* $History$ 
 */