/*       
 *=========================================================================+
 *                 CONEXANT PROPRIETARY AND CONFIDENTIAL                   |
 *                        SOFTWARE FILE/MODULE HEADER                      |
 *                      Conexant Systems, Inc. (C) 1999                    |
 *                                San Diego, CA                            |
 *=========================================================================+
 *
 * Module:      BRDG_end.c - Bridge END Source file 
 *
 * $Header: E:/WorkCVS/NP66/hasbani/APPS/SNARF/brdg_end.c,v 1.1.1.1 2004/04/01 09:10:04 shao-gh Exp $
 *
 * Description: END style Bridge Attachment network interface driver.
 * 
 * Author:      Isabel Lin
 *
 * Modifications:
 *
 * $Log: brdg_end.c,v $
 * Revision 1.1.1.1  2004/04/01 09:10:04  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:57  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/12/23 10:29:08  SHAO-GH
 * no message
 *
 * Revision 1.1.1.1  2003/11/21 08:29:27  SHAO-GH
 * 2003.11.20 Shao Guohua use win cvs first time from sourcesafe 
 *
 * 
 *    Rev 1.16   Feb 25 2002 18:46:08   vlassog
 * NEW_PORT_INI_CLEANED
 * 
 *    Rev 1.15   Feb 09 2002 03:28:56   dinhtm
 * Modified for WEB Redirect
 * 
 *    Rev 1.13   Jan 28 2002 16:29:18   nguyenpa
 * Move pointer-alignment macros into
 * common BSP ProtoUtils.c file.
 * 
 *    Rev 1.12   Jan 03 2002 17:44:42   liniy
 * Non-NewPortStructure: Use separate calls to DHCPC and DHCPS to register interface.
 * 
 *    Rev 1.11   Dec 14 2001 17:14:58   bonakeaj
 * Cleanup: renamed WebRedirect, K2
 * 
 *    Rev 1.10   Sep 13 2001 15:20:32   nguyenpa
 * Remove new port structure test code.
 * 
 *    Rev 1.9   Aug 29 2001 09:08:24   liniy
 * Added BRIDGE_ENABLED.
 * 
 *    Rev 1.8   Aug 17 2001 17:07:06   nguyenpa
 * Fix linking error when building DHCP without
 * WebRedirect.
 * 
 *    Rev 1.7   Aug 14 2001 16:28:34   liniy
 *  
 * 
 *    Rev 1.6   Aug 10 2001 11:15:30   liniy
 * Added NEW_PORT support wrapped with #ifdef.
 * 
 *    Rev 1.5   Aug 09 2001 17:29:36   nguyenpa
 * Boot Rom does not link in Snarf so no need
 * to have any Boot rom code here.
 * 
 *    Rev 1.4   Aug 09 2001 13:23:36   nguyenpa
 * Replace BUILD_PRODUCTION with BUILD_
 * BOOTROM.
 * 
 *    Rev 1.3   Aug 02 2001 17:07:02   liniy
 * Renamed snarfOutputRcvRtn to BR_OutputRcvRtn.
 * 
 *    Rev 1.2   Jul 27 2001 18:49:10   liniy
 * Another WebRedirect's shaking feature - to disable our DHCP server when detecting an external one.
 * 
 * 
 *    Rev 1.1   Jul 25 2001 13:33:16   liniy
 * Use the pDrvCtrl passed in for muxReceive( ).
 * 
 *    Rev 1.0   Jul 12 2001 11:17:50   liniy
 *  
 * 
 *
 *=========================================================================+
 */

#include "bspcfg.h"
#ifdef BRIDGE_ENABLED
#include "brdg_end.h"
#include "string.h"

#include "cfgmgr/JxRegSrv.h"
#include "cfgmgr/JxCfgMgr.h"

BOOL brdg_GetPortConfig ( char *pRegKeyPath, BRDG_DRV_CTRL *pDrvCtrl );

//#define BRDG_DEBUG_TRAP		1

#define MAC_ADDR_SIZE           6

BRDG_DRV_CTRL   *pDrvCtrlBrdg;

/*
 * END Specific interfaces. ( LOCAL functions ) 
 *
 * MUX to END:
 * The only function exported out is the load function.
 * These are LOCAL ( =static ) functions.
 */

STATUS          brdg_Unload ( BRDG_DRV_CTRL *pDrvCtrl );
STATUS          brdg_Start ( BRDG_DRV_CTRL *pDrvCtrl );
LOCAL STATUS    brdg_Stop ( BRDG_DRV_CTRL *pDrvCtrl );

int             brdg_Ioctl ( BRDG_DRV_CTRL *pDrvCtrl, unsigned int cmd, caddr_t data );
STATUS          BRDG_Send ( BRDG_DRV_CTRL *pDrvCtrl, M_BLK *pMblk );
LOCAL STATUS    brdg_MCastAdd ( BRDG_DRV_CTRL *pDrvCtrl, char* pAddress );
LOCAL STATUS    brdg_MCastDel ( BRDG_DRV_CTRL *pDrvCtrl, char* pAddress );
LOCAL STATUS    brdg_MCastGet ( BRDG_DRV_CTRL *pDrvCtrl, MULTI_TABLE *pTable );
LOCAL STATUS    brdg_PollSend ( BRDG_DRV_CTRL *pDrvCtrl, M_BLK *pMblk );
LOCAL STATUS    brdg_PollReceive ( BRDG_DRV_CTRL *pDrvCtrl, M_BLK *pMblk );

LOCAL STATUS    brdg_ParseInitStr ( BRDG_DRV_CTRL *pDrvCtrl, char *initString, char* pInstanceId );

/*
 * functions used by the driver internally.
 */

LOCAL STATUS    brdg_PollStart ( BRDG_DRV_CTRL *pDrvCtrl );
LOCAL STATUS    brdg_PollStop ( BRDG_DRV_CTRL *pDrvCtrl );

/* 
 * Define the device function table.  This is static across all driver
 * instances.
 *
 * The driver passes this structure to the MUX at the load time.
 * The MUX calls these functions as and when required.
 *
 * These functions are not exported. The only function exported from
 * the driver is the driver entry point ( function ) that is responsible for
 * loading.
 */

LOCAL NET_FUNCS brdgFuncTable = 
{
    ( FUNCPTR ) brdg_Start,         /* start func. */                 
    ( FUNCPTR ) brdg_Stop,          /* stop func. */
    ( FUNCPTR ) brdg_Unload,        /* unload func. */                
    ( FUNCPTR ) brdg_Ioctl,         /* ioctl func. */                 
    ( FUNCPTR ) BRDG_Send,          /* send func. */                  
    ( FUNCPTR ) brdg_MCastAdd,      /* multicast add func. */         
    ( FUNCPTR ) brdg_MCastDel,      /* multicast delete func. */      
    ( FUNCPTR ) brdg_MCastGet,      /* multicast get fun. */          
    ( FUNCPTR ) brdg_PollSend,      /* polling send func. */          
    ( FUNCPTR ) brdg_PollReceive,   /* polling receive func. */       

    /* The endLib implements the following three functions.
       We'll use the same.
    */
    endEtherAddressForm,            /* put address info into a NET_BUFFER */
    endEtherPacketDataGet,          /* get pointer to data in NET_BUFFER */
    endEtherPacketAddrGet           /* Get packet addresses. */
};

/******************************************************************************
|
|  Function:    BRDG_Receive
|
|  Description: Process a receive request for an Ethernet packet
|                
|  Parameters:  
|
|  Returns:     OK on success, ERROR otherwise.
|
*******************************************************************************/

STATUS BRDG_Receive ( BRDG_DRV_CTRL *pDrvCtrl, M_BLK *pMblk ) 
{
    if ( muxReceive ( pDrvCtrl, pMblk ) == OK );
    
    return ( OK );
}


/******************************************************************************
|
|  Function:    BRDG_Load () 
|
|  Description: This routine initializes the driver and the device to the 
|               operational state.  All of the device specific parameters are 
|               passed in the initString.  This routine can be called in two modes. 
|               If it is called with an empty, but allocated string then it places
|               the name of this device into the initString and returns 0. If
|               the string is allocated then the routine attempts to perform its 
|               load functionality.
|
|  Parameters:  *initStr - String to be parse by the driver
|               *pBSP - EMAC needed stuff, from BSP
|
|  Returns:     NULL or &pDrvCtrl->endObj
|
*******************************************************************************/
END_OBJ *BRDG_Load ( signed char *initStr, void *pBSP )
{
    BRDG_DRV_CTRL   *pDrvCtrl;
    char            InstanceId[JX_REG_PATH_SIZE_MAX];
    short           unit;

    M_CL_CONFIG     *pMclBlkConfig;
    CL_DESC         *pClDescTbl;        /* cluster description */

#ifdef BRDG_DEBUG_TRAP
    int testTrap;
    testTrap = 1;
    while ( testTrap );
#endif
    
    if ( initStr == NULL ) 
        return ( NULL );

    if ( initStr[0] == NULL ) 
    {
        bcopy (( char * ) BRDG_DRV_NAME, initStr, BRDG_DRV_NAME_LEN );
        return ( NULL );
    }

    /* Allocate a driver control structure for this device. 
       The MUX passes this structure every time it calls an entry point. 
       This is the way the driver remains stateless & "multi thread safe" 
       across usage of various entry points & different driver instances.
    */
    if (( pDrvCtrl = ( BRDG_DRV_CTRL * ) calloc ( 1, sizeof ( BRDG_DRV_CTRL ) + 8 )) == NULL ) 
        return ( NULL );
    BYTE8_ALIGN_PTR ( pDrvCtrl );

    pDrvCtrlBrdg = pDrvCtrl;

    /* Parse InitString which includes the software unit number */ 
    if ( brdg_ParseInitStr ( pDrvCtrl, initStr, InstanceId ) == ERROR ) 
    {
        /* Error!*/ 

        return (NULL);
    }

    /* Get port configuration from the registry. */ 
    if ( !brdg_GetPortConfig ( InstanceId, pDrvCtrl))
    {
        /* Error!*/ 

        return (NULL);
    }
    
    /* endObject Initializations. This function call attaches our END object
       to a linked list of END objects, maintained by the MUX.
    */
    if ( END_OBJ_INIT (( END_OBJ* )     &pDrvCtrl->endObj, 
                        ( DEV_OBJ* )    pDrvCtrl,
                        ( char* )       BRDG_DRV_NAME,
                        ( int )         pDrvCtrl->unit, 
                        ( NET_FUNCS* )  &brdgFuncTable,
                        ( char* )       BRDG_DRV_DESC ) == ERROR ) 
    {
        return ( NULL );
    }
    
    /* Initialize MIB-II entries in the endObject structure */
    if ( END_MIB_INIT ( &pDrvCtrl->endObj, 
                        M2_ifType_ethernet_csmacd,
                        pDrvCtrl->PortNetAddress, 
                        EADDR_LEN,
                        ETHERMTU, 
                        10000000 ) == ERROR ) 
    {
        goto error;
    }

#if 1
    /* Allocate the pNetPool configuration structure.  Align the beginning to the cache line 
       size since this structure will be referred very frequently during run time.
    */
    if (( pDrvCtrl->endObj.pNetPool = ( NET_POOL* ) calloc ( 1, sizeof ( NET_POOL ) + 16 )) == NULL ) 
        goto error;
    BYTE16_ALIGN_PTR ( pDrvCtrl->endObj.pNetPool );

    /* Allocate the clblk/mblk configuration structure and initialize the values.  No special 
       alignment is needed since this structure is only used once in emac_InitMem.
       
       Note that VxWorks prepends 4-byte header for each Mblk, we need to include that in our 
       memSize calculation.
    */
    if (( pMclBlkConfig = ( M_CL_CONFIG* ) calloc ( 1, sizeof ( M_CL_CONFIG ))) == NULL ) 
        goto error;

    pMclBlkConfig->mBlkNum = 20;
    pMclBlkConfig->clBlkNum= 10;
    
    /* Calculate the size of the memory space we need for all the MBlks and ClBlks.  Note that
       VxWorks prepends 4-byte header for each Mblk, we need to include that in our memSize 
       calculation.
    */       
    pMclBlkConfig->memSize = 
        ( signed int )(( signed int ) pMclBlkConfig->mBlkNum * ( signed int )( M_BLK_SZ + ( signed int ) sizeof ( long ))) 
        + (( signed int ) pMclBlkConfig->clBlkNum * ( signed int ) CL_BLK_SZ );
        
    /* Allocate the data space for all the clblks and mblks.  Since ClBlks and MBlks will be
       used frequently during run time, it's preferred if they are cache line sized aligned.
       Unfortunately, due to the 4-byte header VxWorks prepends for each Mblk, we are not able
       to achieve this.
    */
    if (( pMclBlkConfig->memArea = calloc ( 1, ( unsigned int ) pMclBlkConfig->memSize )) == NULL )
        goto error;

    /* Allocate the cluster configuration structure and initialize the values.
       
       !! IMPORTANT !!
            VxWorks prepends 4 bytes (see memSize calculation below) for each cluster.  To 
            ensure that our clusters are all 8-byte aligned per P52 DMA requirement, we must 
            do two things:
            1. Make the cluser size be multiple of 4 bytes but NOT 8 bytes.
            2. Start the cluster memory space on 4-byte but NOT 8-byte boundary.
    */
    if (( pClDescTbl = ( CL_DESC* ) calloc ( 1, sizeof ( CL_DESC ))) == NULL ) 
        goto error;

    pClDescTbl->clSize     = 2048;
    pClDescTbl->clNum      = 10;
    pClDescTbl->memSize    = ( signed int )( pClDescTbl->clNum * ( signed int )(( signed int ) pClDescTbl->clSize + ( signed int ) sizeof ( long )));
    if (( pClDescTbl->memArea = calloc ( 1, ( unsigned int ) pClDescTbl->memSize + 4 )) == NULL )
        goto error;
    ( ULONG ) pClDescTbl->memArea |= 0x4;
    
    /* call the pool initialization function */
    if ( netPoolInit ( pDrvCtrl->endObj.pNetPool, pMclBlkConfig, pClDescTbl,1,NULL ) == ERROR ) 
        goto error;
    
    /* Save the cluster pool id */
    pDrvCtrl->clPoolId = clPoolIdGet ( pDrvCtrl->endObj.pNetPool, 2048, FALSE );
#endif

    /* Mark the device ready with default flags */
    if ( endObjFlagSet ( &pDrvCtrl->endObj,
                        IFF_NOTRAILERS | IFF_MULTICAST | IFF_BROADCAST ) == ERROR ) 
    {
        goto error;
    }

    JxCfgMgrRegisterObject(InstanceId, &pDrvCtrl->endObj);

    return ( &pDrvCtrl->endObj );

    /***** Handle error cases *****/
error:
    {
        ( void ) brdg_Unload ( pDrvCtrl );
        return ( NULL );
    }
}

/******************************************************************************
|
|  Function:    brdg_Start
|
|  Description: start the device
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|
|  Returns:     OK or ERROR
*******************************************************************************/
STATUS brdg_Start ( BRDG_DRV_CTRL *pDrvCtrl ) 
{
    /* Set driver flag indicating BRDG END is ready. */
    END_FLAGS_SET ( &pDrvCtrl->endObj, ( IFF_UP | IFF_RUNNING ));
    return ( OK );
}

/******************************************************************************
|
|  Function:  brdg_Stop
|
|  Description:  stop the device
|                 This routine disables interrupts, and resets the device.
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|
|  Returns:   OK or ERROR
*******************************************************************************/
LOCAL STATUS brdg_Stop ( BRDG_DRV_CTRL    *pDrvCtrl ) 
{
    return ( OK );
}

/******************************************************************************
|
|  Function:    brdg_Unload
|
|  Description: Unloads the driver from system
|               This routine deallocates lists, and free allocated memory 
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|
|  Returns:     OK
|
*******************************************************************************/
STATUS brdg_Unload ( BRDG_DRV_CTRL *pDrvCtrl ) 
{
    /* deallocate lists: multicast addr list & protocol list. */
    END_OBJ_UNLOAD ( &pDrvCtrl->endObj );
    if ( DRV_FLAGS_ISSET ( DRV_MEMOWN )) 
    {
        /* deallocate allocated shared memory */
//        if ( pDrvCtrl->memBase ) 
//          ( void ) cacheDmaFree ( pDrvCtrl->memBase );
    }
    /* 
     * No need to free pDrvCtrl because muxDevUnload frees it after calling 
     * this function ( i.e. brdg_Unload ( pEnd->devObject.pDevice )) .
     * Ref. muxLib.c code.
     */
    return ( OK );
}

/******************************************************************************
|
|  Function:  brdg_Ioctl
|
|  Description:  interface ioctl procedure
|                 Process an interface ioctl request.
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|                cmd - IOCTl Command
|                caddr_t data - data
|
|  Returns:   
*******************************************************************************/
int brdg_Ioctl ( BRDG_DRV_CTRL *pDrvCtrl, unsigned int cmd, caddr_t data ) 
{
    int        error = 0;
    long       value;
    int        savedFlags;
    END_OBJ *  pEndObj=&pDrvCtrl->endObj;

    switch ( cmd ) 
    {
        case EIOCSADDR:
            if ( data == NULL ) 
                error = EINVAL;
            else
            {
                /* Copy and install the new address */
                bcopy (( char * ) data, ( char * ) END_HADDR ( pEndObj ), END_HADDR_LEN ( pEndObj ));
            }

            break;
            
        case EIOCGADDR: 

            if ( data == NULL ) 
                error = EINVAL;
            else
            {
                bcopy ((char *)END_HADDR(pEndObj), (char *)data, END_HADDR_LEN(pEndObj));
            }
            break;

        case EIOCSFLAGS:
            value = ( long ) data;
            if ( value < 0 ) 
            {
                value = -value;
                value--;
                END_FLAGS_CLR ( pEndObj, value );
            }
            else
                END_FLAGS_SET ( pEndObj, value );

            /* handle IIF_PROMISC and IFF_ALLMULTI */

            savedFlags = DRV_FLAGS_GET ();
            if ( END_FLAGS_ISSET ( pEndObj, IFF_PROMISC )) 
                DRV_FLAGS_SET ( FLT_PROMISC );
            else
                DRV_FLAGS_CLR ( FLT_PROMISC );

            if ( END_FLAGS_GET ( pEndObj ) & ( IFF_MULTICAST | IFF_ALLMULTI )) 
                DRV_FLAGS_SET ( FLT_MCAST );
            else
                DRV_FLAGS_CLR ( FLT_MCAST );

            break;

        case EIOCGFLAGS:                     /* move to mux */
            if ( data == NULL ) 
                error = EINVAL;
            else
                * ( long * ) data = END_FLAGS_GET ( pEndObj );

            break;

        case EIOCGFBUF:                  /* get minimum first buffer for chaining */
            if ( data == NULL ) {
                return ( EINVAL );
            }
            * ( int * ) data = 64;
         
            break;

        case EIOCMULTIADD:                   /* move to mux */
            break;

        case EIOCMULTIDEL:                   /* move to mux */
            break;

        case EIOCMULTIGET:                   /* move to mux */
            break;
        
        case EIOCPOLLSTART:                  /* move to mux */
            break;

        case EIOCPOLLSTOP:                   /* move to mux */
            break;

        case EIOCGMIB2:                      /* move to mux */
            if ( data == NULL ) 
                error=EINVAL;
            else
                bcopy (( char * ) &pEndObj->mib2Tbl, ( char * ) data, sizeof ( pEndObj->mib2Tbl ));
            break;

        default:
            error = EINVAL;
    }
    return ( error );
}

/******************************************************************************
|
|  Function:    BRDG_Send
|
|  Description: Process a transmit request for an Ethernet packet
|                
|  Parameters:  
|
|  Returns:     OK on success, ERROR otherwise.
*******************************************************************************/
STATUS BRDG_Send ( BRDG_DRV_CTRL *pDrvCtrl, M_BLK *pMblk ) 
{
    M_BLK           *pNew;
    unsigned int    lenByte;

    /* Since this function can be called from multiple system tasks of different priorities,
       a semaphore is used here to avoid reentrancy.
    */

	#if 1  /*sgh add */	
	{
		extern BOOL bfIsRebootingLock;

		if( bfIsRebootingLock ) 
		{
			netMblkClChainFree ( pMblk );
            return ( OK );
		}
	}
	#endif

	
    END_TX_SEM_TAKE ( &pDrvCtrl->endObj, WAIT_FOREVER );

    pDrvCtrl->txMIB.txRequest++;
    //muxSend (( void * ) pDrvCtrl, pMblk );
    BR_OutputRcvRtn (( void * ) pDrvCtrl, 0, pMblk, NULL, NULL );
    
    END_TX_SEM_GIVE ( &pDrvCtrl->endObj );
    return ( OK );
}

/******************************************************************************
|
|  Function:    brdg_MCastAdd
|
|  Description: add a multicast address
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|               *pAddr    - Address to add to the table
|
|  Returns:     OK on success, ERROR otherwise.
*******************************************************************************/
LOCAL STATUS brdg_MCastAdd ( BRDG_DRV_CTRL *pDrvCtrl, char *pAddr ) 
{
    return ( OK );
}

/******************************************************************************
|
|  Function:    brdg_MCastDel
|
|  Description: remove a multicast address
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|               *pAddr    - Address to remove to the table
|
|  Returns:     OK on success, ERROR otherwise.
*******************************************************************************/
LOCAL STATUS brdg_MCastDel ( BRDG_DRV_CTRL *pDrvCtrl, char *pAddr ) 
{
    return ( OK );
}

/******************************************************************************
|
|  Function:    brdg_MCastGet
|
|  Description: retreive current multicast address list
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|               *pTable    - Address of table
|
|  Returns:     OK on success, ERROR otherwise.
*******************************************************************************/
LOCAL STATUS brdg_MCastGet ( BRDG_DRV_CTRL *pDrvCtrl, MULTI_TABLE *pTable ) 
{
    return ( OK );
}

/******************************************************************************
|
|  Function:    brdg_PollSend
|
|  Description: send a packet in polled mode.
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|               *PMblk    - pointer to mblk
|
|  Returns:     OK on success, EAGAIN on failure
*******************************************************************************/
LOCAL STATUS brdg_PollSend ( BRDG_DRV_CTRL *pDrvCtrl, M_BLK *pMblk ) 
{
    return ( OK );
}
/******************************************************************************
|
|  Function:    brdg_PollReceive
|
|  Description: get a packet in polled mode.
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|               *PMblk    - pointer to mblk
|
|  Returns:     OK on success, EAGAIN on failure
*******************************************************************************/
LOCAL STATUS brdg_PollReceive ( BRDG_DRV_CTRL *pDrvCtrl, M_BLK *pMblk ) 
{
    return ( OK );
}

/******************************************************************************
|
|  Function:    brdg_PollStart
|
|  Description: starting polling mode.
|               The EMAC END supports IOCTL command to set the poll start/stop flags.
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|
|  Returns:     OK
*******************************************************************************/
LOCAL STATUS brdg_PollStart ( BRDG_DRV_CTRL *    pDrvCtrl ) 
{
    return ( OK );
}
/******************************************************************************
|
|  Function:    brdg_PollStop
|
|  Description: stop polling mode.
|               The EMAC END supports IOCTL command to set the poll start/stop flags.
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|
|  Returns:     OK
*******************************************************************************/
LOCAL STATUS brdg_PollStop ( BRDG_DRV_CTRL *    pDrvCtrl ) 
{
    return ( OK );
}

/******************************************************************************
|
|  Function:    brdg_ParseInitStr
|
|  Description: Parses the init string
|
|  Parameters:  *pDrvCtrl - Pointer Driver Cntrl
|               *initString - pointer to init string
|
|  Returns:     OK
|
*******************************************************************************/
LOCAL STATUS brdg_ParseInitStr ( BRDG_DRV_CTRL *pDrvCtrl, char *initString, char* pInstanceId ) 
{
    char    *tok;               /* an initString token */
    char    *holder = NULL;     /* points to initString fragment beyond tok */
    char    *tempstr = NULL;
    int     len = 0;

    // Copy input string into temp string since the separator character will be
    // overwritten by a null character.  The input string is modified by strtok_r.
    len = strlen(initString) + 1;
    tempstr = malloc( len );
    if (tempstr == NULL)
       return ERROR;

    memcpy(tempstr, initString, len);
   
    /* 
     * First tok is always "unit#" because MUX prepends this to 
     * the initialization string used in 
     * END_TBL_ENTRY endDevTbl[] inconfigNet.h file. 
     */

    tok = strtok_r ( tempstr, ": \n\r", &holder );
    if ( tok == NULL ) 
	{
		free(tempstr); /*sgh add: It will fragment the whole memeory */
        return ERROR;
	}
    pDrvCtrl->unit = atoi ( tok );

    /* Get Port index number into port structure array */
    tok = strtok_r (NULL, ": \n\r", &holder);
    if (tok == NULL)
    {
    	free(tempstr); /*sgh add: It will fragment the whole memeory */
        return ERROR;
    }

    tok=strtok_r ( NULL, ": \n\r", &holder );
    if ( tok == NULL ) 
	{
		free(tempstr); /*sgh add: It will fragment the whole memeory */
		return ERROR;
	}
    
    // TBD: It can be added to the DRV_CTRL structure as a "common" field.
    strcpy(pInstanceId, tok);

    // TBD: Put these parameters into the config.ini if we realy need them.
//    pDrvCtrl->memBase = TRUE;
//    pDrvCtrl->memSize = 0;
    pDrvCtrl->usrFlags = 0;

	free(tempstr); /*sgh add: It will fragment the whole memeory */
    return OK;
}

/******************************************************************************
|
|  Function:    brdg_GetPortConfig
|
|  Description: Retrieve port configuration parameters from Configuration Manager.
|
|  Parameters:  
|
|  Returns:     TRUE/FALSE
|
*******************************************************************************/
BOOL brdg_GetPortConfig ( char *pRegKeyPath, BRDG_DRV_CTRL *pDrvCtrl )
{
    BOOL    bResult = FALSE;

    if ( (pRegKeyPath == NULL) || (pDrvCtrl == NULL) )
    {
       return bResult;
    }

    else
    {
        JX_REG_VAL_DESC PortConfigDesc[]    = 
            {
                {
                    "MacAddress", 
                    JX_REG_VAL_BINARY, 
                    sizeof(pDrvCtrl->PortNetAddress), 
                    &pDrvCtrl->PortNetAddress
                }
            };

        JX_REG_KEY_HANDLE   hKey    = NULL;

        if ((hKey = JxRegOpenKey(NULL, pRegKeyPath)) != NULL)
        {
            bResult = JxRegQueryStruct
                (
                    hKey, 
                    NUMBER_OF_ELEMENTS(PortConfigDesc), 
                    PortConfigDesc
                );

            JxRegCloseKey(hKey);
        }
    }

    return bResult;
}

#endif
