/****************************************************************************
* $Header: E:/WorkCVS/NP66/hasbani/APPS/SNARF/brapi.h,v 1.1.1.1 2004/04/01 09:10:04 shao-gh Exp $
*
*  Copyright(c)2001  Conexant Systems
*
*****************************************************************************/
//
// export BRIDGE(SNARF) APIs
// 

#ifndef _BRAPI_H_
#define _BRAPI_H_

 /******************************************************************************
|
|  Function:    BR_OpenMacAddrHandle
|
|  Description: This function accepts the specified interface, locates the
|               assiciated bridge port, and creates a MAC table access handle
|               which is to be used in the subsequent BR_GetNextMacAddr () calls.
|               Ref: BR_GetNextMacAddr ().
|
|  Parameters:  deviceName  the interface device name
|                             unit                     the interface unit number
|
|  Returns:     handle      the MAC table access handle to be used to retrieve
|                                           MAC addresses for the specified interface
|                        NULL        the specified interface is not a registered bridge port.
|
*******************************************************************************/
UINT32 BR_OpenMacAddrHandle ( UINT8* deviceName, int unit );

/******************************************************************************
|
|  Function:    BR_CloseMacAddrHandle
|
|  Description: This function closes the specified MAC table access handle.
|               Ref: BR_GetNextMacAddr ().
|
|  Parameters:  handle      the MAC table access handle to close
|
|  Returns:     none
|
*******************************************************************************/
void BR_CloseMacAddrHandle ( UINT32 handle );

/******************************************************************************
|
|  Function:    BR_GetNextMacAddr
|
|  Description: BR_OpenMacAddrHandle, BR_CloseMacAddrHandle, and 
|               BR_GetNextMacAddr provide an interface to sequentially 
|               retrieve learned MAC addresses on a specified bridge port.  
|
|               !! Currently, this feature only supports single user.
|
|               This function expects that an access handle has been established 
|               through BR_OpenMacAddrHandle.  Calling this function retrieves 
|               the next MAC address based on the previous access via 
|               BR_GetNextMacAddr call.
|
|  Parameters:  handle      the MAC table access handle to use
|                            pMac         where to store the retrieved mac address
|
|  Returns:     handle      the MAC table access handle used to retrieve
|                        NULL        no more MAC address entry found for this handle
|                                            the handle is automatically closed.
|
*******************************************************************************/
UINT32 BR_GetNextMacAddr ( UINT32 handle, UINT8* pMac );
#endif
