/****************************************************************************
*
*   Name:           RipApi.h
*
*   Description:    RIP API header file
*
*   Copyright:      (c) 2002 Conexant Systems Inc.
*
*****************************************************************************
*   $Author: shao-gh $
*   $Revision: 1.1.1.1 $
*   $Modtime:   Aug 06 2002 15:09:32  $
****************************************************************************/

#ifndef RIPAPI_H
#define RIPAPI_H

/****************************************************************************
*  Include files
****************************************************************************/

#include <vxWorks.h>

#include "bspcfg.h"
#include "bsptypes.h"

/****************************************************************************
*  Helper definitions
****************************************************************************/

/****************************************************************************
*  Constant definitions
****************************************************************************/

/****************************************************************************
*  Macro definitions
****************************************************************************/

/****************************************************************************
*  Type definitions
****************************************************************************/

/****************************************************************************
*  Function prototypes
****************************************************************************/

/******************************************************************************
*   APIs Called to RIP Core
*******************************************************************************/

/******************************************************************************
|
| Function:     RipApiStartRip
|
| Description:  Initialize and start RIP.
|
| Parameters:   none
|
| Returns:      none
|
*******************************************************************************/
void RipApiStartRip(void);

/******************************************************************************
|
| Function:     
|
| Description:  Shutdown RIP
|
| Parameters:   none
|
| Returns:      none
|
*******************************************************************************/
void RipApiStopRip(void);

/******************************************************************************
|
| Function:     RipApiNetIfRegister
|
| Description:  This function is called when a new Network Interface (e.g. PPP)
|               is added to the system.  It in turns calls the RIP libaray to
|               accomplish the job.
|
| Parameters:   char* pAlias - Alias of the newly added Network Interface
|
| Returns:      none
|
*******************************************************************************/
void RipApiNetIfRegister(char* pAlias);

/******************************************************************************
|
| Function:     RipApiNetIfUnregister
|
| Description:  This function is called when a Network Interface (e.g. PPP)
|               is removed to the system.  It in turns calls the RIP libaray to
|               accomplish the job.
|
| Parameters:   char* pAlias - Alias of the removed Network Interface
|
| Returns:      none
|
*******************************************************************************/
void RipApiNetIfUnregister(char* pAlias);

/******************************************************************************
|
| Function:     RipApiNetIfChange
|
| Description:  This function is called when an existing Network Interface's
|               interface address has changed.  e.g. when DHCP Client obtains 
|               a lease or release a lease.  It in turns calls the RIP libaray 
|               to accomplish the job.
|
| Parameters:   char* pAlias - Alias of the removed Network Interface
|
| Returns:      none
|
*******************************************************************************/
void RipApiNetIfChange(char* pAlias);

/******************************************************************************
*   APIs Called from RIP Core
*******************************************************************************/

/****************************************************************************** 
|
| Function:     RipApiInterfaceAdd
|
| Description:  This is function is called when RIP core adds a network 
|               interface to its insternal database.  It in turns adds this
|               interface to the interface list maintained in this module.
|               This list records the Alias-to-IfName mapping.
|
| Parameters:   char* pIfName - the IfName of the network interface to add
|
| Returns:      none
|
*******************************************************************************/
void RipApiInterfaceAdd(char* pIfName);

/******************************************************************************
|
| Function:     RipApiInterfaceDelete
|
| Description:  This is function is called when RIP core deletes a network 
|               interface to its insternal database.  It in turns deletes this
|               interface from the interface list maintained in this module.
|               This list records the Alias-to-IfName mapping.
|
| Parameters:   char* pIfName - the IfName of the network interface to delete
|
| Returns:      none
|
*******************************************************************************/
void RipApiInterfaceDelete(char* pIfName);

/******************************************************************************
|
| Function:     RipApiNetIfGetConfig
|
| Description:  This function retrieves the inteface specific configuration of 
|               the network interface specified with pIfName.
|
| Parameters:   char* pIfName - IfName of the network interface
|               unsigned long* pStatus - Enable/Disable
|               unsigned long* pListenerMode - 
|               unsigned long* pSupplierMode -
|
| Returns:      OK
|               ERROR - can't find configurations of the specified network interface
|
*******************************************************************************/
BOOL RipApiNetIfGetConfig
(
    char*           pIfName, 
    unsigned long*  pStatus, 
    unsigned long*  pListenerMode, 
    unsigned long*  pSupplierMode
);

#endif /* RIPAPI_H */ 
