/****************************************************************************
****	Copyright (c) 2001
****	Conexant Systems Inc. (formerly Rockwell Semiconductor Systems)
****	Personal Computing Division
****	All Rights Reserved
****
****	CONFIDENTIAL and PROPRIETARY --
****		No Dissemination or use without prior written permission.
****
*****************************************************************************
MODULE NAME:
		PPPoE

FILE NAME:
		pppoe.h

ABSTRACT:

DETAILS:

KEYWORDS:
        $Archive:   P:/d874/hasbani/archives/pppoe_h/pppoe.h_v  $
        $Revision: 1.1.1.1 $
        $Date: 2004/04/01 09:10:04 $
****************************************************************************/
#include <vxWorks.h>
#include <time.h>
#include <semLib.h>
#include <muxLib.h>
#include "net/mbuf.h"
#include "netBufLib.h"
#include "netinet/if_ether.h"
#include <app_conf/h/coretype.h>
#include "bspcfg.h"

//#define PPPOE_DEBUG             /* Enable debug message */
//#define PPPOE_POSIX_TIMER       /* Utilize POSIX timer routines */

#define PPPOE_TASK_PRIORITY		100
#define PPPOE_TASK_STACK_SIZE	4000

#define PPPOE_AC_MODE     0x1	/* specifies Access Concentrator mode */
#define PPPOE_HOST_MODE   0x2	/* specifies PPPOE Host/Client mode */


#define ETHERTYPE_PPPOE_DISCOVERY 0x8863    /* Ethernet type for discovery*/
#define ETHERTYPE_PPPOE_SESSION   0x8864    /* Ethernet type for session */
#define ETHER_ADDR_LEN   6                        /* Ethernet Address LEN */

#define PPPOE_HDR_VERSION 0x1
#define PPPOE_HDR_TYPE 0x1

#define PPPOE_CODE_PADI 0x09                /* PPPoE Active Discovery Initiation */
#define PPPOE_CODE_PADO 0x07                /* PPPoE Active Discovery Offer */
#define PPPOE_CODE_PADR 0x19                /* PPPoE Active Discovery Request */
#define PPPOE_CODE_PADS 0x65                /* PPPoE Active Discovery Session */
#define PPPOE_CODE_PADT 0xa7                /* PPPoE Active Session Terminate */
#define PPPOE_CODE_SESSION 0x00             /* PPPoE Session */

#define PPPOE_SESSION_DISCOVERY 0x0000
#define PPPOE_DISCOVERY_RETRIES 10          /* default number of discovery retries */
#define PPPOE_MIN_TIMEOUT 3                 /* three seconds */


#define PPPOE_MAX_PADI_SIZE 1484            /* size in bytes */

#define PPPOE_TAG_EOL                  0x0      /* End of tag list */
#define PPPOE_TAG_SVC_NAME             0x0101   /* service name tag */
#define PPPOE_TAG_AC_NAME              0x0102   /* Access Concentrator name */
#define PPPOE_TAG_HOST_UNIQ            0x0103   /* Host unique tag  */
#define PPPOE_TAG_AC_COOKIE            0x0104   /* Access Concentrator cookie */
#define PPPOE_TAG_VENDOR_INFO          0x0105   /* Vendor proprietary info */
#define PPPOE_TAG_RELAY_SESSION_ID     0x0110   /* Relay session ID */
#define PPPOE_TAG_SVC_NAME_ERROR       0x0201   /* BAD service name */
#define PPPOE_TAG_AC_SYSTEM_ERROR      0x0202   /* AC encountered an error */
#define PPPOE_TAG_GENERIC_ERROR        0x0203   /* generic error */

#define PPPOE_RELAY_SESSION_ID_SIZE    12       /* Relay session ID tag size*/

#define PPPOE_MAX_SESSIONS 0x10000              /* 16K */

#define PPPOE_FREE_PKT netMblkClChainFree


#define PPPOE_FREE_RECVD_PKT(p) \
		    if ((p)->pRecvdDiscPkt != NULL) \
			{\
			PPPOE_FREE_PKT((p)->pRecvdDiscPkt); \
			(p)->pRecvdDiscPkt = NULL; \
			}

#define PPPOE_FREE_RETRY_PKT(p) \
		    if ((p)->pRetryDiscPkt != NULL) \
			{\
			PPPOE_FREE_PKT((p)->pRetryDiscPkt); \
			(p)->pRetryDiscPkt = NULL; \
			}

#define PPPOE_STACK_ADD_DONE(state)\
		{\
		PPPOE_STACK_DATA * stack =(PPPOE_STACK_DATA *)state->stackData;\
		\
		if (stack->callbacks && stack->callbacks->stackAddComplete)\
		    (*stack->callbacks->stackAddComplete)\
					    (stack->callbacks,state);\
		}

#define PPPOE_STACK_DELETE_DONE(state)\
		{\
		PPPOE_STACK_DATA * stack =(PPPOE_STACK_DATA *)state->stackData;\
		\
		if (stack->callbacks && stack->callbacks->stackDeleteComplete)\
		    (*stack->callbacks->stackDeleteComplete)\
					    (stack->callbacks,state);\
		}

#define ADAPTER_DEST_ADDR_AND_PROTOCOL_SET(stack, protocol) \
	{\
	UINT16 pppOEProtocol = protocol;\
	ADAPTER_DESTINATION_AND_PROTOCOL_SET_INTERFACE * adapterInterface;\
	\
	if (stack->adapterInterface.interfaceObj && \
					stack->adapterInterface.state) \
	    { \
	    adapterInterface = \
		    (ADAPTER_DESTINATION_AND_PROTOCOL_SET_INTERFACE *) \
				    stack->adapterInterface.interfaceObj; \
	     \
	    adapterInterface->destAddrAndProtocolSet(\
				    stack->adapterInterface.state,\
				    (char *)stack->destEnet,\
				    ETHER_ADDR_LEN,\
				    (char *)&pppOEProtocol,\
				    sizeof(UINT16));\
	    }\
	}

enum PPPOE_STATE_E
{
    PPPOE_STATE_PADI,
    PPPOE_STATE_PADO,
    PPPOE_STATE_PADR,
    PPPOE_STATE_PADS,
    PPPOE_STATE_PADT,
    PPPOE_STATE_SESSION,
};


struct  pppoe_callout {
        int     c_time;         /* incremental time */
        caddr_t c_arg;          /* argument to routine */
        void    (*c_func)();    /* routine (changed to void (*)() */
        struct  pppoe_callout *c_next;
};

/* typedefs */

typedef struct pppOEProfileData
{
    UINT32  connectionMode;     /* mode bit flags; ACTIVE,PASSIVE etc. */
    UINT8   discoveryRetries;   /* number of retries during discovery phase */
    UINT8   minDiscTimeout;     /* duration of retries during discovery phase */
    char    svcNameTag[32];     /* Supported/Requested Service */
    char    acNameTag[32];      /* Requested/Supported Access Concentrator */
                                /* Name Tags */
    char    vendorInfo[8];      /* Proprietary info if any */
} PPPOE_PROFILE_DATA;

#define HOST_UNIQUE_LEN (ETHER_ADDR_LEN+1)
typedef struct pppOEStackData
{
    void   *discoveryCookie;
    void   *sessionCookie;
    UINT8  remPADIRetries;      /* remaining PADI retries */
    UINT8  remPADRRetries;      /* remaining PADR retries */
    UINT32 state;               /* connection state */
    BOOL   sendPADT;            /* send a PADT packet if TRUE */
    UI16_T sessionId;           /* PPPoE session ID */
    UINT32 serviceMapId;        /* set for Daemon AC connections */
    char   serviceName[16];     /* Service name for this connection */
    char   acName[16];          /* Access Concentartor name */
    char   unique[HOST_UNIQUE_LEN];    /* added for testing ... */ 
    UINT8  srcEnet[ETHER_ADDR_LEN];   /* Source(my) ethernet address */
    UINT8  destEnet[ETHER_ADDR_LEN];  /* destination ethernet address */
    NET_POOL_ID netPoolId;      /* netPool to allocate packets from */
    M_BLK_ID  pRecvdDiscPkt;    /* Received Discovery Packet */
    M_BLK_ID  pRetryDiscPkt;    /* Discovery packet that must be re-sent */
    timer_t eventTimer;
    SEM_ID  semId;
    BOOL    shutdown;           /* flag */
    BOOL    timeout;            /* timer flag for re-send */
    UINT32  time_stamp;         /* time stamp for re-send */
    struct pppoe_callout *timerCallOut; /* timer call out list */
    INT16   pppoe_unit;
    INT16   ppp_unit;
    char    devName[8];
	int		devUnit;	// device unit; 
    int     taskId;
}
 PPPOE_STACK_DATA;

/*
	used to store pppoe statitics information for diagnostic purpose.
	it is kept seperately from PPPOE_STACK_DATA because PPPOE_STACK_DATA
	will be gone once pppoe task is terminated. 
*/
typedef struct pppOEStatusData
{
	BOOL	PADOReceived;
	BOOL	PADSReceived;
} PPPOE_STATUS_DATA;

#if DISCONNECT_PREVIOUS_SESSION
typedef struct pppOESessionInfo
{
	BOOL	isValid;
	UINT16 	sessionId;
	UINT8   destEnet[ETHER_ADDR_LEN];  /* destination ethernet address */	
} PPPOE_SESSION_INFO;
#endif
typedef struct pppOEHeader
{
#if _BYTE_ORDER == _LITTLE_ENDIAN
    UINT8 pppOE_type:4,         /* type */
    pppOE_ver:4;                /* version */
#endif

#if _BYTE_ORDER == _BIG_ENDIAN
    UINT8 pppOE_ver:4,          /* version */
    pppOE_type:4;               /* type */
#endif
    UINT8    pppOE_code;        /* code */
    UINT16   pppOE_session;     /* session ID */

    UINT16 pppOE_length;        /* payload length */
} GNU_PACKED PPPOE_HEADER; /* T211_BUILD */ 

typedef struct pppOETLV
{
    UINT16 tagType;
    UINT16 tagLength;

#ifdef COMMENT_ONLY
    UINT8  tagValue[];
#endif /* COMMENT_ONLY */
} PPPOE_TLV;

#define PPPOE_TAG_TYPE(p) (UINT16)((*(UINT8 *)p << 8)|*(UINT8 *)((UINT8 *)p+1))

#define PPPOE_TAG_LENGTH(p) (UINT16)((*((UINT8 *)&p->tagLength) << 8) |\
				*(UINT8 *)(((UINT8 *)&p->tagLength)+1))

#define PPPOE_TAG_TYPE_EOL(p)(PPPOE_TAG_TYPE(p) == PPPOE_TAG_EOL &&\
						    PPPOE_TAG_LENGTH(p) == 0)
#define SET_PPPOE_TAG_TYPE(p,t) \
		    { \
		    UINT8 * cp = (UINT8 *)p; \
		    cp[0] = ((t & 0xff00) >> 8); \
		    cp[1] = (t & 0xff);\
		    }

#define SET_PPPOE_TAG_LENGTH(p,l) \
		    {\
		    UINT8 * cp = (UINT8 *)&p->tagLength; \
		    cp[0] = ((l & 0xff00) >> 8); \
		    cp[1] = (l & 0xff);\
		    }

#define PPPOE_TAG_VALUE(p) (char *)((char *)p + sizeof(PPPOE_TLV))
#define PPPOE_TLV_SIZE(p) (UINT16)(sizeof(PPPOE_TLV)+PPPOE_TAG_LENGTH(p))
#define PPPOE_NEXT_TLV(p) (PPPOE_TLV *)((char *)p + PPPOE_TLV_SIZE(p))

#define PPPOE_VALID_TLV(p,f) ((char *)p < (f->mBlkHdr.mData + f->mBlkHdr.mLen))

#ifdef SHOWTIME

#ifdef PPPOE_DEBUG
#define PPPOE_printf(x)    WriteFIFOString(x, strlen(x), 0)
#else
#define PPPOE_printf(x)
#endif  /* PPPOE_DEBUG */

#else

#ifdef PPPOE_DEBUG
#define PPPOE_printf(x) printf(x)
#else
#define PPPOE_printf(x)
#endif  /* PPPOE_DEBUG */

#endif  /* SHOWTIME */



