/****************************************************************************
****	Copyright (c) 2001
****	Conexant Systems Inc. (formerly Rockwell Semiconductor Systems)
****	Personal Computing Division
****	All Rights Reserved
****
****	CONFIDENTIAL and PROPRIETARY --
****		No Dissemination or use without prior written permission.
****
*****************************************************************************
MODULE NAME:
		PPP

FILE NAME:
		ppp_api.h

ABSTRACT:

DETAILS:

KEYWORDS:
        $Archive:   P:/d874/hasbani/archives/ppp_h/ppp_api.h_v  $
        $Revision: 1.1.1.1 $
        $Date: 2004/04/01 09:10:04 $
****************************************************************************/
#if __cplusplus
extern "C" {
#endif

#ifndef  PPP_API_H
#define  PPP_API_H

#include <vxWorks.h>
#include <semLib.h>

#include "bspcfg.h"
#include "bsptypes.h"

#include "PppCfg.h"

#define PPP_NUM_OF_TTY_UNIT 1
#define PPP_TTY_UNIT        0
/**********************************/
/* data sturcture definition      */
/**********************************/

#if (0)
#define PPP_USR_NAME_LEN      256
#define PPP_SERVICE_NAME_LEN  32
#define PPP_PASSWORD_LEN      128
#define PPP_ALIAS_NAME_LEN	  32
#define PPP_ACCOUNT_NAME_LEN  32	
#endif /* (0) */ 

#define PPP_END_NAME_LEN	  16

#define PPP_AUTH_TYPE_CHAP	  0x01
#define PPP_AUTH_TYPE_PAP 	  0x02
#define PPP_AUTH_TYPE_PAP_AND_CHAP 0x03
#define PPP_MRU_LENGTH		  10
#define PPP_MTU_LENGTH		  10

#ifdef OEM_WEBREDIRECT
#define GLOBAL_PPP_SYS_LINE_DOWN		0
#define GLOBAL_PPP_SYS_NOT_CONFIGURED		1
#define GLOBAL_PPP_SYS_INVALID_OR_NOT_UP	2
#define GLOBAL_PPP_SYS_READY			3
#endif


typedef struct 
{
	int unit;
	int enable;
	PPP_MODE_T mode; /* PPPOA, PPPOE, ...*/
    int PPP_idle_time;
	int ppp_unit;
	int endUnit;
	int autoConnectEnabled; /* TRUE: auto connect pppoe */
	int fastConnectEnabled; /* TRUE: save pppoe session info in file for faster connection after power cycle*/
	int authenticationMode; 
	unsigned int defaultMRU;
	unsigned int defaultMTU;
	unsigned int maximumMSS;
	unsigned int idleTrafficFilterEnabled;
	void *pCookie; // the end device pointer
	SEM_ID startStopSemId;// semaphore used to synchronize the start and stop of a ppp connection 
	JX_OBJ_ID_T			netAdapterId;
	char PPP_username[PPP_USER_NAME_SIZE_MAX];
	char PPP_pwd[PPP_PASSWORD_SIZE_MAX];
	char PPP_service_name[PPP_SERVICE_NAME_SIZE_MAX];
	char endName[PPP_END_NAME_LEN];
	char alias[NET_IF_ALIAS_SIZE_MAX];
	char accountName[PPP_ACCOUNT_NAME_SIZE_MAX];
	char defaultMRUString[PPP_MRU_LENGTH+1];
	char defaultMTUString[PPP_MTU_LENGTH+1];
	
} PPP_CONFIG_STRUCT;

typedef struct 
{
	u_long	ifLastChange;
} PPP_STATUS_STRUCT;



/*------------------------------------------------------*/
/*  defination                                          */
/*------------------------------------------------------*/

unsigned long ppp_Start(char *, int, int, int, unsigned long,
                        unsigned long, char *, char *, UINT32, char *);
void ppp_Stop(int unit);

STATUS ppp_TaskActivate(int, unsigned long *, unsigned long *);
void ppp_UserInfo(char *, char *, int );
void ppp_ComeUp(int);
void ppp_ModemConnectCallback(FUNCPTR *callbackF);

void ppp_IdleTimerChange(int idle, int unit);
int  ppp_IdleState(int unit);
void ppp_StartIdleTimeOut(int unit);
void ppp_Reset(int unit);
void ppp_StartShutdownTimeOut(int unit);
	extern PPP_CONFIG_STRUCT PPP_config[];
	void ppp_GetUserName(int i, char *user_name);
	void ppp_GetPassword(int i, char *password);
	void ppp_GetServiceName(int i, char *service_name);
	void ppp_SetUserName(int i, char *user_name);
	void ppp_SetPassword(int i, char *password);
	void ppp_SetServiceName(int i, char *service_name);
	void ppp_GetIdleTime(int i, UINT32 *idle);
	void ppp_SetIdleTime(int i, UINT32 idle);
	void ppp_GetFastConnectEnabled(int i, UINT32 *enabled);
	void ppp_SetFastConnectEnabled(int i, UINT32 enabled);
	UINT32 ppp_IsFastConnectEnabled(int i);
	void ppp_GetAutoConnectEnabled(int i, UINT32 *enabled);
	void ppp_SetAutoConnectEnabled(int i, UINT32 enabled);
	UINT32 ppp_IsAutoConnectEnabled(int i);
	BOOL ppp_IsCHAPEnabled(int i);
	BOOL ppp_IsPAPEnabled(int i);
	UINT32 ppp_GetAuthenticationMode(int i);
	int ppp_AllocatePPPUnit(void);
	int ppp_UnitFindByInterface(const char* endName, int endUnit);
	int ppp_UnitFindByInterfaceServiceName(const char* endName, int endUnit,const char* serviceName);
	STATUS ppp_TaskActivateByInterface(char* name,int unit, unsigned long *local_ip, unsigned long *peer_ip);
	STATUS pppoa_loadStatusByInterface(char* name,int unit);
    STATUS ppp_GetDnsByInterface(char *name, int unit, unsigned long *pDnsPrimary,
                             unsigned long *pDnsSecondary);
	UINT32 ppp_GetNumberOfPPPConfiged();
	int ppp_GetNthPPPUnit(UINT32 Nth);
	int ppp_GetNthByPPPUnit(UINT32 ppp_unit);
	STATUS ppp_GetNumberOfPacketsReceived(char* name,int unit, unsigned long *result);
	STATUS ppp_GetNumberOfPacketsSent(char* name,int unit, unsigned long *result);
	STATUS ppp_GetNumberOfBytesReceived(char* name,int unit, unsigned long *result);
	STATUS ppp_GetNumberOfBytesSent(char* name,int unit, unsigned long *result);
	SEM_ID ppp_GetStartStopSemIdByPPPUnit(int i);
	int ppp_UnitIndexFindByName(const char* name);
	int ppp_UnitFindByName(const char* name);
	int ppp_UnitIndexFindByAdapterId(JX_OBJ_ID_T Id);
	int ppp_GetNumberOfPPPByInterface(const char *name, int unit);
	const char * ppp_GetNthPPPNameByInterface(const char* name, int unit, int Nth);
	STATUS ppp_ConnectionConfigLoad(const PPP_CFG_NET_IF_T* pConnection,const PPP_CFG_ACCOUNT_T* pAccount);
	const char * ppp_GetDefaultMRUString(int index);
	const char * ppp_GetDefaultMTUString(int index);
	int ppp_GetDefaultMRU(int index);
	int ppp_GetDefaultMTU(int index);
	int ppp_GetMaximumMSS(int index);
	const char * ppp_GetDefaultMRUStringByPPPUnit(int ppp_unit);
	const char * ppp_GetDefaultMTUStringByPPPUnit(int ppp_unit);
	int ppp_GetDefaultMRUByPPPUnit(int ppp_unit);
	int ppp_GetDefaultMTUByPPPUnit(int ppp_unit);
	int ppp_GetMaximumMSSByPPPUnit(int ppp_unit);
	BOOL ppp_idleTrafficFilterEnabled(int index);
	BOOL ppp_idleTrafficFilterEnabledByPPPUnit(int ppp_unit);

#ifdef OEM_WEBREDIRECT
int Global_PPP_System_Status(void);
#endif

#endif /* Resrouce API */
#if __cplusplus
}
#endif
