/* dhcpcCommonLib.h - DHCP runtime client interface to monitor task */

/* Copyright 1984 - 1997 Wind River Systems, Inc. */
#include "copyright_wrs.h"

/*
modification history
____________________
01h,17mar99,spm  enabled dhcpcRelease() routine (SPR #25482)
01g,06oct97,spm  added relative paths to #include statements; removed warnings
01f,06aug97,spm  removed parameters linked list to reduce memory required;
                 added definitions for C++ compilation
01e,10jun97,spm  isolated incoming messages in state machine from input hooks
01d,06may97,spm  added DHCPC_OFF to align IP header on four byte boundary
01c,07apr97,spm  added shutdown return code
01b,29jan97,spm  added little-endian support and modified for coding standards
01a,03oct96,spm  created by modifying WIDE project DHCP implementation
*/

#ifndef __INCdhcpClientCommonh
#define __INCdhcpClientCommonh

#ifdef __cplusplus
extern "C" {
#endif

#include "dhcp/dhcpc.h"

/* Define sources for events. */

#define DHCP_AUTO_EVENT 0
#define DHCP_USER_EVENT 1

/*  Define types of events. */

#define DHCP_MSG_ARRIVED 0
#define DHCP_TIMEOUT 1
#define DHCP_USER_BIND 2
#define DHCP_USER_VERIFY 3
#define DHCP_USER_RELEASE 4
#define DHCP_USER_SHUTDOWN 5

/* State transition definitions (besides OK or ERROR). */

#define DHCPC_DONE 2            /* Lease relinquished or expired - exit. */
#define DHCPC_MORE 3            /* Call a second routine when processing. */
#define DHCPC_STATE_BEGIN 6     /* Initial processing after DHCPC_MORE. */

/* Return codes indicate special situations related to state machine. */

#define  DHCPC_SHUTDOWN 11
#define  DHCPC_ERROR 12

/* Classification of DHCP client leases. */

#define DHCP_MANUAL 0      /* Lease established after system boot. */
#define DHCP_BOOTP 1       /* Lease established using BOOTP reply. */
#define DHCP_NATIVE 2      /* Lease established using DHCP reply. */
#define DHCP_AUTOMATIC 3   /* Bound at boot time - lease still valid. */

#if CPU_FAMILY==I960
#pragma align 1                 /* tell gcc960 not to optimize alignments */
#endif  /* CPU_FAMILY==I960 */

typedef struct leaseData        /* Lease-specific variables. */
    {
    BOOL        initFlag;       /* Lease initialized? */
    BOOL        waitFlag;       /* Synchronous or asynchronous bind attempt? */
    BOOL        autoConfig;     /* Apply parameters to network interface? */
    SEM_ID      leaseSem;       /* Blocking semaphore for synchronous bind. */
    BOOL        leaseGood;      /* Bind attempt successful? */
    int         leaseType;      /* Boot-time or runtime lease, or BOOTP. */
    int         prevState;      /* Preceding state in state machine. */
    int         currState;      /* Current/next state in state machine. */
    WDOG_ID     timer;          /* Timeout interval for DHCP events */
    time_t      initEpoch;      /* Timestamp of last request. */
    int         timeout;        /* Current timeout interval. */
    int         numRetry;       /* Number of retransmission timeouts. */
    FUNCPTR     eventHookRtn;   /* Event notification hook */
    FUNCPTR     cacheHookRtn;   /* Data storage hook */
    struct dhcp_reqspec leaseReqSpec;   /* Options request list */
    struct if_info ifData;      /* Transmit/receive interface */
    unsigned long       xid;    /* Current transaction ID. */
    struct dhcp_param *dhcpcParam;      /* Current configuration parameters */
    }
LEASE_DATA;

/* Values for lease established during system boot. */

typedef struct dhcpLeaseData
    {
    struct in_addr yiaddr;          /* assigned IP address */
    unsigned long lease_origin;     /* start time of lease */
    unsigned long lease_duration;   /* length of lease */
    }
DHCP_LEASE_DATA;

#if CPU_FAMILY==I960
#pragma align 0                 /* turn off alignment requirement */
#endif  /* CPU_FAMILY==I960 */

IMPORT BOOL dhcpcInitialized;
IMPORT DHCP_LEASE_DATA dhcpcBootLease;  /* Settings from boot-time lease. */
IMPORT LEASE_DATA **   dhcpcLeaseList;         /* List of available cookies. */
IMPORT int     dhcpcMaxLeases;         /* Max. number of simultaneous leases. */
IMPORT struct interface dhcpif;    /* Interface-specific receive buffer. */

IMPORT void 	dhcpcParamsCopy (LEASE_DATA *, struct dhcp_param *);
IMPORT STATUS 	dhcpcEventAdd (int, int, void *, BOOL);
IMPORT void 	dhcpcLeaseCleanup (LEASE_DATA *);
#ifdef __cplusplus
}
#endif

#endif
