/* dhcpc.h - DHCP runtime client include file for shared definitions */

/* Copyright 1984 - 1997 Wind River Systems, Inc. */

/*
modification history
____________________
01f,06oct97,spm  split interface name into device name and unit number
01e,06aug97,spm  removed parameters linked list to reduce memory required;
                 added definitions for C++ compilation; renamed class field
                 of dhcp_reqspec structure to prevent C++ errors (SPR #9079)
01d,02jun97,spm  changed DHCP option tags to prevent name conflicts (SPR #8667)
01c,07apr97,spm  removed #define's now in configAll.h, changed router_solicit
                 field in parameter descriptor from pointer to structure
01b,03jan97,spm  added little-endian support and moved macros to dhcp.h
01a,03oct96,spm  created by modifying WIDE project DHCP implementation
*/

#ifndef __INCdhcpch
#define __INCdhcpch

#ifdef __cplusplus
extern "C" {
#endif

#include "wdLib.h"

#include "netinet/in.h"
#include "netinet/if_ether.h"

#include "dhcp/dhcp.h"
#include "dhcp/copyright_dhcp.h"

#define ETHERHL    sizeof(struct ether_header)
#define IPHL       sizeof(struct ip)
#define UDPHL      sizeof(struct udphdr)
#define WORD_LEN   4 	/* Multiplier for IP header length field */
#define DHCPC_OFF  2     /* 4-byte alignment offset needed by Sun BSP's */
#define DHCPC_DEBUG

/* Notification routine event types. */

#define DHCPC_LEASE_NEW 0
#define DHCPC_LEASE_INVALID 1

/* DHCP client operations to access permanent storage. */

#define DHCP_CACHE_READ 0
#define DHCP_CACHE_WRITE 1
#define DHCP_CACHE_ERASE 2

#if CPU_FAMILY==I960
#pragma align 1                 /* tell gcc960 not to optimize alignments */
#endif  /* CPU_FAMILY==I960 */

struct client_id
    {
    unsigned char       type;
    unsigned char       len;
    char *              id;
    };

struct class_id
    {
    unsigned char       len;
    char *              id;
    };

struct request_list
    {
    u_char      len;
    char        list[0xff];     /* 0xff == maximum length */
    };

struct vendor_list
    {
    u_char      len;
    char        list[255];
    };

/* Request specification for DHCP lease - filled by dhcpcOptionSet(). */

struct dhcp_reqspec
    {
    int waitsecs;       /* Duration for collecting additional lease offers. */
    u_long              lease;          /* Requested lease duration. */
    struct in_addr      ipaddr;         /* Requested IP address */
    struct in_addr      srvaddr;        /* IP address of DHCP server */
    struct vendor_list  vendlist;        /* Vendor-specific information */
    struct request_list reqlist;        /* List of requested options */
    struct client_id *  clid;           /* Client identifier */
    struct class_id *   classId;        /* Class identifier */
    char *              hostName;       /* host name */
    char *              dhcp_errmsg;
    };

struct in_addrs
    {
    unsigned char       num;
    struct in_addr *    addr;
    };

struct u_shorts
    {
    unsigned char       num;
    unsigned short *    shortnum;
    };

#define MAXTAGNUM     (_DHCP_LAST_OPTION + 1)
#define GOTOPTSIZ     (MAXTAGNUM / 8)

/* Parameter retrieval structure - used by dhcpcParamsGet (). */

struct dhcp_param
    {
    char        got_option [GOTOPTSIZ];
    char        msgtype;                /* DHCP reply or BOOTP reply? */
    char *      sname;                  /* Host name of DHCP server */
    char *      temp_sname;    /* Server host name if 'sname' holds options. */
    char *      file;                   /* Boot file name */
    char *      temp_file;      /* File name if 'file' holds options. */
    char *      hostname;               /* Host name of bootstrap server */
    char *      merit_dump;
    char *      dns_domain;
    char *      root_path;
    char *      extensions_path;
    char *      nis_domain;
    char *      nb_scope;               /* NetBIOS scope */
    char *      errmsg;
    char *      nisp_domain;            /* NIS+ domain name */
    unsigned char       ip_forward;     /* Boolean flag */
    unsigned char       nonlocal_srcroute;      /* Boolean flag */
    unsigned char       all_subnet_local;       /* Boolean flag */
    unsigned char       mask_discover;          /* Boolean flag */
    unsigned char       mask_supplier;          /* Boolean flag */
    unsigned char       router_discover;        /* Boolean flag */
    unsigned char       trailer;                /* Boolean flag */
    unsigned char       ether_encap;            /* Boolean flag */
    unsigned char       keepalive_garba;        /* Boolean flag */
    unsigned char       nb_nodetype;            /* NetBIOS node type */

#define BNODE 0x1
#define PNODE 0x2
#define MNODE 0x4
#define HNODE 0x8
    unsigned char       default_ip_ttl;         /* time to live (1 - 255) */
    unsigned char       default_tcp_ttl;
    unsigned short      bootsize;               /* bootfile size in 16 bits */
    unsigned short      max_dgram_size;         /* max dgram reassembly */
    unsigned short      intf_mtu;               /* interface mtu */
    long        time_offset;            /* 32 bits integer (network byte order)
                                                offset from UTC */
    unsigned long       lease_origin;           /* DHCP lease start time */
    unsigned long       lease_duration;         /* DHCP lease duration */
    unsigned long       dhcp_t1;
    unsigned long       dhcp_t2;
    unsigned long       mtu_aging_timeout;      /* 32 bit unsigned integer */
    unsigned long       arp_cache_timeout;
    unsigned long       keepalive_inter;
    struct u_shorts *   mtu_plateau_table;      /* array of 16 bit integers */
    struct in_addr      server_id;              /* DHCP server's IP address */
    struct in_addr      ciaddr;                 /* Client's current address */
    struct in_addr      yiaddr;                 /* Client's assigned address */
    struct in_addr      siaddr;                 /* Address of (tftp) server */
    struct in_addr      giaddr;                 /* Address of relay agent */
    struct in_addr *    subnet_mask;
    struct in_addr *    swap_server;
    struct in_addr *    brdcast_addr;
    struct in_addr      router_solicit;
    struct in_addrs *   router;
    struct in_addrs *   time_server;
    struct in_addrs *   name_server;
    struct in_addrs *   dns_server;     /* DNS server */
    struct in_addrs *   log_server;
    struct in_addrs *   cookie_server;
    struct in_addrs *   lpr_server;
    struct in_addrs *   impress_server;
    struct in_addrs *   rls_server;     /* Resource Location Server */
    struct in_addrs *   policy_filter;
    struct in_addrs *   static_route;
    struct in_addrs *   nis_server;
    struct in_addrs *   ntp_server;
    struct in_addrs *   nbn_server;     /* NetBIOS name server */
    struct in_addrs *   nbdd_server;    /* NetBIOS dgram distrib server */
    struct in_addrs *   xfont_server;   /* X font erver */
    struct in_addrs *   xdisplay_manager;       /* X display manager */
    struct in_addrs *   nisp_server;    /* NIS+ server */
    struct in_addrs *   mobileip_ha;    /* Mobile IP Home Agent */
    struct in_addrs *   smtp_server;
    struct in_addrs *   pop3_server;
    struct in_addrs *   nntp_server;
    struct in_addrs *   dflt_www_server;
    struct in_addrs *   dflt_finger_server;
    struct in_addrs *   dflt_irc_server;
    struct in_addrs *   streettalk_server;
    struct in_addrs *   stda_server;    /* StreetTalk Directory Assistance */
    struct vendor_list * vendlist;      /* Vendor-specific information */
    };

struct chaddr 
    {
    unsigned char 	htype;
    unsigned char 	hlen;
    char 		haddr[6];
    };

struct if_info 
    {
    char 		name [sizeof "enxx"];
    short 		unit;
    BOOL 		endDrvFlag;
    struct chaddr 	haddr;
    struct ifnet * 	iface;
    };

struct interface        /* Interface-specific receive buffer */
    {
    char *rbuf;
    int rbufsize;
    };

struct msg
    {
    struct ether_header *ether;
    struct ip *ip;
    struct udphdr *udp;
    struct dhcp *dhcp;
    };

typedef struct dhcpcEvent       /* External event descriptor. */
    {
    unsigned char source;       /* Automatic event or manual event? */
    unsigned char type;         /* Manual event - defines user request.
                                 * Automatic - message arrival or timeout.
                                 */
    void * leaseId;             /* Cookie assigned by dhcpcInit (). */
    int length;                 /* Length of incoming message. */
    }
EVENT_DATA;

#if CPU_FAMILY==I960
#pragma align 0                 /* turn off alignment requirement */
#endif  /* CPU_FAMILY==I960 */

#define EVENT_RING_SIZE (10 * sizeof (EVENT_DATA))

#ifdef __cplusplus
}
#endif

#endif
