/*
  $Log: message_digest_constants.h,v $
  Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
  no message

  Revision 1.1.1.1  2004/01/16 09:32:47  SHAO-GH
  no message

  Revision 1.2  2004/01/12 09:15:11  SHAO-GH
  no message

  Revision 1.1  1999/11/23 12:49:40  TTY
  Initial revision

 * 
 * 2     5/01/98 3:41p Nishit
 * Checkin in released (4.2.1) code
 * 
 * 1     4/24/98 10:29a Release Engineer
 * Added MD5 and (de)serialize  utility functions
 * RWUTILS v4.2.1
 * 
 * 1     4/14/98 11:13a Nishit
 * Moved Message Digest (MD4 & MD5) related files into rwutils
 * 
*/
/************************************************************************/
/*	Copyright (C) 1998 RouterWare, Inc.						                  */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#if !defined (__MESSAGE_DIGEST_CONSTANTS_H__)
#define __MESSAGE_DIGEST_CONSTANTS_H__

/* POINTER defines a generic pointer type */

typedef BYTE *POINTER; 

/* ROTATE_LEFT rotates x left n bits. */

#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

/* MD4 transform definitions appear here ...*/

/* Constants for MD4Transform routine.*/

#define MD4_S11 3
#define MD4_S12 7
#define MD4_S13 11
#define MD4_S14 19
#define MD4_S21 3
#define MD4_S22 5
#define MD4_S23 9
#define MD4_S24 13
#define MD4_S31 3
#define MD4_S32 9
#define MD4_S33 11
#define MD4_S34 15

/* F, G, and H are basic MD4 functions. */

#define MD4_F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define MD4_G(x, y, z) (((x) & (y)) | ((x) & (z)) | ((y) & (z)))
#define MD4_H(x, y, z) ((x) ^ (y) ^ (z))


/* FF, GG, and HH transformations for rounds 1, 2, and 3. Rotation is separate from addition to prevent recomputation. */

#define MD4_FF(a, b, c, d, x, s) { \
    (a) += MD4_F ((b), (c), (d)) + (x); \
    (a) = ROTATE_LEFT ((a), (s)); \
  }
#define MD4_GG(a, b, c, d, x, s) { \
    (a) += MD4_G ((b), (c), (d)) + (x) + (ULONG)0x5a827999; \
    (a) = ROTATE_LEFT ((a), (s)); \
  }
#define MD4_HH(a, b, c, d, x, s) { \
    (a) += MD4_H ((b), (c), (d)) + (x) + (ULONG)0x6ed9eba1; \
    (a) = ROTATE_LEFT ((a), (s)); \
  }


/* MD5 transform definitions appear here ...*/
 
/* Constants for MD5Transform routine.*/

#define MD5_S11 7
#define MD5_S12 12
#define MD5_S13 17
#define MD5_S14 22
#define MD5_S21 5
#define MD5_S22 9
#define MD5_S23 14
#define MD5_S24 20
#define MD5_S31 4
#define MD5_S32 11
#define MD5_S33 16
#define MD5_S34 23
#define MD5_S41 6
#define MD5_S42 10
#define MD5_S43 15
#define MD5_S44 21

/* F, G, H and I are basic MD5 functions. */

#define MD5_F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define MD5_G(x, y, z) (((x) & (z)) | ((y) & (~z)))
#define MD5_H(x, y, z) ((x) ^ (y) ^ (z))
#define MD5_I(x, y, z) ((y) ^ ((x) | (~z)))

/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4. Rotation is separate from addition to prevent recomputation. */

#define MD5_FF(a, b, c, d, x, s, ac) { \
	(a) += MD5_F ((b), (c), (d)) + (x) + (ULONG)(ac); \
	(a) = ROTATE_LEFT ((a), (s)); \
	(a) += (b); \
 	}
#define MD5_GG(a, b, c, d, x, s, ac) { \
	(a) += MD5_G ((b), (c), (d)) + (x) + (ULONG)(ac); \
	(a) = ROTATE_LEFT ((a), (s)); \
	(a) += (b); \
 	}
#define MD5_HH(a, b, c, d, x, s, ac) { \
	(a) += MD5_H ((b), (c), (d)) + (x) + (ULONG)(ac); \
	(a) = ROTATE_LEFT ((a), (s)); \
	(a) += (b); \
 	}
#define MD5_II(a, b, c, d, x, s, ac) { \
	(a) += MD5_I ((b), (c), (d)) + (x) + (ULONG)(ac); \
	(a) = ROTATE_LEFT ((a), (s)); \
	(a) += (b); \
 	}

#endif /* __MESSAGE_DIGEST_CONSTANTS_H__ */