/*
 * $Log: convutls.c,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:47  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:14:57  SHAO-GH
 * no message
 *
 * Revision 1.3  2001/12/11 09:16:44  TTY
 * Changed '\' to '/' in includes.
 *
 * 
 *    Revision 1.2   21 Feb 2000 13:13:02   TTY
 * Changed include files directory
 * 
 *    Revision 1.1   23 Nov 1999 12:49:36   TTY
 * Initial revision.
 * 
 * 3     5/01/98 3:41p Nishit
 * Checkin in released (4.2.1) code
 * 
 * 2     4/24/98 10:24a Release Engineer
 * Added MD5 and (de)serialize utility functions 
 * RWUTILS v4.2.1
 * 
 * 2     4/03/98 5:45p Nishit
 * Moved serialize_long, deserialize_long, serialize_short and deserialize_short to
 * serialization_utilities.c (new file)
 * 
 * 1     3/27/98 2:19p Release Engineer
 * check - in
 * 
 * 1     2/13/98 12:17a Release Engineer
 * SNMP changes to correspond with ULONG table indices.
 * Also code cleanup and code style changes.  
 * New serialize and deserialize utility functions where
 * added.
 * RWUTILS v4.2.0
 * 
 * 
 * 2     2/13/96 7:51p Ross
 * Adding version control header.
*/
/*	$Modname: convutls.c$  $version: 1.2$      $date: 08/29/95$   */
/*
* 	$lgb$
1.0 01/12/95 ross
1.1 01/12/95 ross added copyright.
1.2 08/29/95 ross cleaned up compiler warnings.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 - 1998 RouterWare, Inc. 									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "../include/kstart.h"
#include "../include/v8022str.h"
#include "../include/lslproto.h"
/*************************************************************/
#define NUMBER_OF_BITS_IN_BYTE    8

#if !defined (BIG_ENDIAN)

/*************************************************************/
USHORT host_to_net_short (USHORT host_order_short_value)
{

	BYTE *bptr_return_value;
	USHORT net_order_value;

	bptr_return_value = (BYTE *) &net_order_value;

	*bptr_return_value = (BYTE) (host_order_short_value >> NUMBER_OF_BITS_IN_BYTE);

	++bptr_return_value;

	*bptr_return_value = (BYTE) host_order_short_value;

	return (net_order_value);

}
/*****************************************************************************/
USHORT net_to_host_short (USHORT net_order_short_value)
{

	USHORT host_order_value;
	BYTE *bptr_net_order_value;

	bptr_net_order_value = (BYTE *) &net_order_short_value;

	host_order_value = *bptr_net_order_value;

	++bptr_net_order_value;

	host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

	host_order_value = (USHORT) (host_order_value | *bptr_net_order_value);

	return (host_order_value);

}											
/*****************************************************************************/
ULONG host_to_net_long (ULONG host_order_long_value)
{

	BYTE *bptr_net_order_value;
	BYTE *bptr_host_order_long_value;
	ULONG net_order_value;

	bptr_net_order_value = (BYTE *) &net_order_value + (sizeof (ULONG) - 0x0001);

	bptr_host_order_long_value = (BYTE *) &host_order_long_value;

	*bptr_net_order_value = *bptr_host_order_long_value;

	--bptr_net_order_value;

	++bptr_host_order_long_value;

	*bptr_net_order_value = *bptr_host_order_long_value;

	--bptr_net_order_value;

	++bptr_host_order_long_value;

 		*bptr_net_order_value = *bptr_host_order_long_value;

	--bptr_net_order_value;

	++bptr_host_order_long_value;

	*bptr_net_order_value = *bptr_host_order_long_value;

	return (net_order_value);

}
/*****************************************************************************/
ULONG net_to_host_long (ULONG net_order_long_value)
{

	ULONG host_order_value;
	BYTE *bptr_net_order_long_value;

	bptr_net_order_long_value = (BYTE *) &net_order_long_value;

	host_order_value = *bptr_net_order_long_value;

	++bptr_net_order_long_value;

	host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

	host_order_value = host_order_value | *bptr_net_order_long_value;

	++bptr_net_order_long_value;

	host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

	host_order_value = host_order_value | *bptr_net_order_long_value;

	++bptr_net_order_long_value;

	host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

	host_order_value = host_order_value | *bptr_net_order_long_value;

	return (host_order_value);

}
/****************************************************************************/
USHORT swap (USHORT ushort_to_swap_bytes_with)
{
	USHORT low_byte;
	USHORT high_byte;
	USHORT return_value;

	low_byte = (USHORT) low_byte_of_ushort (ushort_to_swap_bytes_with);

	high_byte = (USHORT) high_byte_of_ushort (ushort_to_swap_bytes_with);

	return_value = (USHORT) two_bytes_to_ushort (low_byte, high_byte);

	return (return_value);
}
/****************************************************************************/
ULONG swap_long (ULONG ulong_to_swap_bytes_with)
{
	ULONG return_value;
	BYTE *bptr_return_value;
	BYTE *bptr_ulong;

	bptr_return_value = (BYTE *) &return_value + 3;

	bptr_ulong = (BYTE *) &ulong_to_swap_bytes_with;

	*bptr_return_value = *bptr_ulong;

	--bptr_return_value;

	++bptr_ulong;

	*bptr_return_value = *bptr_ulong;

	--bptr_return_value;

	++bptr_ulong;

	*bptr_return_value = *bptr_ulong;

	--bptr_return_value;

	++bptr_ulong;

	*bptr_return_value = *bptr_ulong;

	return (return_value);
}
#endif

