/*
 * $Log: rw_hash_table_functions.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:46  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:19:02  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:50:20  TTY
 * Initial revision
 *
 * 
 * 5     11/13/98 9:23p Mahesh
 * bug fixes and enhancements
 * 
 * 4     9/18/98 4:31p Mahesh
 * Changed all C++ style comments to C style comments
 * 
 * 3     8/24/98 7:47p Mahesh
 * Added copyright notice.
 * 
 * 2     8/20/98 3:42p Mahesh
 * Some bugs fixed!
 * 
 * 1     8/18/98 2:30p Mahesh
 * Initial check in
 */
/************************************************************************/
/*	Copyright (C) 1998 RouterWare, Inc.	 								*/
/*	Unpublished - rights reserved under the Copyright Laws of the		*/
/*	United States.  Use, duplication, or disclosure by the 				*/
/*	Government is subject to restrictions as set forth in 				*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 		*/
/*	Computer Software clause at 252.227-7013.							*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach, CA	*/
/************************************************************************/

#if !defined (__RW_HASH_TABLE_FUNCTIONS_H__)
#define __RW_HASH_TABLE_FUNCTIONS_H__

void hash_table_free_container (RW_CONTAINER* p_hash_table);

RW_CONTAINER_ITERATOR hash_table_create_iterator (RW_CONTAINER* p_rw_container);

RW_CONTAINER_ITERATOR hash_table_create_copy_of_iterator (RW_CONTAINER_ITERATOR* p_iterator);

void hash_table_free_iterator (RW_CONTAINER_ITERATOR* p_iterator);

bool hash_table_add_at_front (RW_CONTAINER* p_hash_table, const RW_CONTAINER_ITEM* p_item);

void hash_table_remove_from_front (RW_CONTAINER* p_hash_table);

bool hash_table_add_at_back (RW_CONTAINER* p_hash_table, const RW_CONTAINER_ITEM* p_item);

void hash_table_remove_from_back (RW_CONTAINER* p_hash_table);

bool hash_table_insert_at_iterator (RW_CONTAINER_ITERATOR* p_iterator, const RW_CONTAINER_ITEM* p_item);

bool hash_table_remove_from_iterator (RW_CONTAINER_ITERATOR* p_iterator);

UINT hash_table_get_number_of_nodes (const RW_CONTAINER* p_hash_table);

RW_CONTAINER_ITEM* hash_table_get_item_at_front (const RW_CONTAINER* p_hash_table);

RW_CONTAINER_ITEM* hash_table_get_item_at_back (const RW_CONTAINER* p_hash_table);

bool hash_table_is_at_front (RW_CONTAINER_ITERATOR* p_iterator);

bool hash_table_is_at_end (RW_CONTAINER_ITERATOR* p_iterator);

void hash_table_goto_front (RW_CONTAINER_ITERATOR* p_iterator);

void hash_table_goto_end (RW_CONTAINER_ITERATOR* p_iterator);

bool hash_table_find_item (RW_CONTAINER_ITEM* p_item, RW_CONTAINER_ITERATOR* p_iterator);

bool hash_table_find (FP_RW_CONTAINER_ITEM_CRITERIA_MATCHER fp_criteria_matcher, RW_CONTAINER_CRITERIA* p_criteria,
						RW_CONTAINER_ITERATOR* p_iterator_matched_item);

bool hash_table_find_item_in_range (RW_CONTAINER_ITERATOR* p_iterator_start, RW_CONTAINER_ITERATOR* p_iterator_end,
	FP_RW_CONTAINER_ITEM_CRITERIA_MATCHER fp_criteria_matcher, RW_CONTAINER_CRITERIA* p_criteria,
	RW_CONTAINER_ITERATOR* p_matched_item_iterator);

bool hash_table_next (RW_CONTAINER_ITERATOR* p_iterator);

bool hash_table_previous (RW_CONTAINER_ITERATOR* p_iterator);

RW_CONTAINER_ITEM* hash_table_get_item_at_iterator (RW_CONTAINER_ITERATOR* p_iterator);

#endif /* __RW_HASH_TABLE_FUNCTIONS_H__ */
