/*
 * $Log: rw_container_functions.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:46  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:18:55  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:50:20  TTY
 * Initial revision
 *
 * 
 * 5     11/13/98 9:23p Mahesh
 * bug fixes and enhancements
 * 
 * 4     9/18/98 4:31p Mahesh
 * Changed all C++ style comments to C style comments
 * 
 * 3     8/24/98 7:47p Mahesh
 * Added copyright notice.
 * 
 * 2     8/20/98 3:42p Mahesh
 * Some bugs fixed!
 * 
 * 1     8/18/98 2:30p Mahesh
 * Initial check in
 */
/************************************************************************/
/*	Copyright (C) 1998 RouterWare, Inc.	 								*/
/*	Unpublished - rights reserved under the Copyright Laws of the		*/
/*	United States.  Use, duplication, or disclosure by the 				*/
/*	Government is subject to restrictions as set forth in 				*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 		*/
/*	Computer Software clause at 252.227-7013.							*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach, CA	*/
/************************************************************************/

#if !defined (__RW_CONTAINER_FUNCTIONS_H__)
#define __RW_CONTAINER_FUNCTIONS_H__

typedef RW_CONTAINER_ITERATOR (*FP_RW_CONTAINER_CREATE_ITERATOR) (RW_CONTAINER* p_rw_container);

typedef void (*FP_RW_CONTAINER_FREE_ITERATOR) (RW_CONTAINER_ITERATOR* p_iterator);

typedef RW_CONTAINER_ITERATOR (*FP_RW_CONTAINER_CREATE_COPY_OF_ITERATOR) (RW_CONTAINER_ITERATOR* p_iterator);

typedef void (*FP_RW_CONTAINER_FREE) (RW_CONTAINER* p_rw_container);

typedef bool (*FP_RW_CONTAINER_ADD_FRONT) (RW_CONTAINER* p_rw_container, const RW_CONTAINER_ITEM* p_item);

typedef void (*FP_RW_CONTAINER_REMOVE_FRONT) (RW_CONTAINER* p_rw_container);

typedef bool (*FP_RW_CONTAINER_ADD_BACK) (RW_CONTAINER* p_rw_container, const RW_CONTAINER_ITEM* p_item);

typedef void (*FP_RW_CONTAINER_REMOVE_BACK) (RW_CONTAINER* p_rw_container);

typedef bool (*FP_RW_CONTAINER_INSERT) (RW_CONTAINER_ITERATOR* p_iterator, const RW_CONTAINER_ITEM* p_item);

typedef bool (*FP_RW_CONTAINER_REMOVE) (RW_CONTAINER_ITERATOR* p_iterator);

typedef UINT (*FP_RW_CONTAINER_SIZE) (const RW_CONTAINER* p_rw_container);

typedef RW_CONTAINER_ITEM* (*FP_RW_CONTAINER_FRONT) (const RW_CONTAINER* p_rw_container);

typedef RW_CONTAINER_ITEM* (*FP_RW_CONTAINER_BACK) (const RW_CONTAINER* p_rw_container);

typedef bool (*FP_RW_CONTAINER_IS_AT_FRONT) (RW_CONTAINER_ITERATOR* p_iterator);

typedef bool (*FP_RW_CONTAINER_IS_AT_END) (RW_CONTAINER_ITERATOR* p_iterator);

typedef void (*FP_RW_CONTAINER_GOTO_FRONT) (RW_CONTAINER_ITERATOR* p_iterator);

typedef void (*FP_RW_CONTAINER_GOTO_END) (RW_CONTAINER_ITERATOR* p_iterator);	/* end == last + 1 */

typedef bool (*FP_RW_CONTAINER_FIND_BY_CONTENT) (RW_CONTAINER_ITEM* p_item, RW_CONTAINER_ITERATOR* p_iterator_matched_item);

typedef bool (*FP_RW_CONTAINER_FIND) (FP_RW_CONTAINER_ITEM_CRITERIA_MATCHER fp_criteria_matcher, RW_CONTAINER_CRITERIA* p_criteria,
						RW_CONTAINER_ITERATOR* p_iterator_matched_item);

typedef bool (*FP_RW_CONTAINER_FIND_IN_RANGE) (RW_CONTAINER_ITERATOR* p_iterator_first, RW_CONTAINER_ITERATOR* p_iterator_last,
						FP_RW_CONTAINER_ITEM_CRITERIA_MATCHER fp_criteria_matcher, RW_CONTAINER_CRITERIA* p_criteria,
						RW_CONTAINER_ITERATOR* p_iterator_matched_item);

typedef bool (*FP_RW_CONTAINER_NEXT) (RW_CONTAINER_ITERATOR* p_iterator);	/* return false if reaches the back. */

typedef bool (*FP_RW_CONTAINER_PREVIOUS) (RW_CONTAINER_ITERATOR* p_iterator);	/* return false if reaches the front */

typedef RW_CONTAINER_ITEM* (*FP_RW_CONTAINER_AT) (RW_CONTAINER_ITERATOR* p_iterator);

typedef struct RW_CONTAINER_FUNCTIONS
{
	FP_RW_CONTAINER_CREATE_ITERATOR create_iterator;

	FP_RW_CONTAINER_FREE free_container;

	FP_RW_CONTAINER_ADD_FRONT add_at_front;

	FP_RW_CONTAINER_REMOVE_FRONT remove_from_front;

	FP_RW_CONTAINER_ADD_BACK add_at_back;

	FP_RW_CONTAINER_REMOVE_BACK remove_from_back;

	FP_RW_CONTAINER_SIZE get_container_size;

	FP_RW_CONTAINER_FRONT get_item_at_front;

	FP_RW_CONTAINER_BACK get_item_at_back;

} RW_CONTAINER_FUNCTIONS;


typedef struct RW_ITERATOR_FUNCTIONS
{
	FP_RW_CONTAINER_FREE_ITERATOR free_iterator;

	FP_RW_CONTAINER_CREATE_COPY_OF_ITERATOR create_copy_of_iterator;

	FP_RW_CONTAINER_INSERT insert_at_iterator;

	FP_RW_CONTAINER_REMOVE remove_from_iterator;

	FP_RW_CONTAINER_IS_AT_FRONT iterator_is_at_front;

	FP_RW_CONTAINER_IS_AT_END iterator_is_at_end;

	FP_RW_CONTAINER_GOTO_FRONT iterator_set_at_front;

	FP_RW_CONTAINER_GOTO_END iterator_set_at_end;	/* end == last + 1 */

	FP_RW_CONTAINER_FIND_BY_CONTENT iterator_find_by_content;

	FP_RW_CONTAINER_FIND iterator_find;

	FP_RW_CONTAINER_FIND_IN_RANGE iterator_find_in_range;

	FP_RW_CONTAINER_NEXT set_iterator_to_next_item;	/* return false if reaches the back. */

	FP_RW_CONTAINER_PREVIOUS set_iterator_to_previous_item;	/* return false if reaches the front */

	FP_RW_CONTAINER_AT get_item_at_iterator;

} RW_ITERATOR_FUNCTIONS;

#endif /* __RW_CONTAINER_FUNCTIONS_H__ */
