/*
 * $Log: vtrstr.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:45  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:13:20  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:51:38  TTY
 * Initial revision
 *
 * 
 * 5     4/30/98 1:16p Rajive
 * Overwrote with INCLUDE v4.2.1
 * 
 * 3     4/27/98 11:42a Release Engineer
 * Additions into include for L2TP and RTM modules.
 * INCLUDE v4.2.1
 * 
 * 1     2/13/98 12:18a Release Engineer
 * code cleanup, code style changes, linted, system level test
 * INCLUDE v4.2.0
 * 
 * 4     9/09/96 5:10p Ross
 * Changes for spanning tree and token ring
 * 
 * 3     5/21/96 7:32p Ross
 * Fixes for token ring header files
 * 
 * 2     3/27/96 7:08p Ross
 * Initial check-in with source safe.
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1998 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca  	*/
/************************************************************************/
/*	$Modname: vtrstr.h$  $version: 1.2$      $date: 10/11/93$   */
/*
* 	$lgb$
1.0 01/17/93 ross
1.1 10/11/93 ross pragma packed added.
1.2 10/11/93 ross changed 1992 to 93.
* 	$lge$
*/
#if defined (CRC_DEFINED)

	#define CRC_DEFINED

	typedef	_struct	CRC
	{
		BYTE	crc[4];
	} _pack CRC;
#endif

typedef	_struct	FRAME_STATUS
{
#if !defined (BIG_ENDIAN)
	unsigned char	zero:2;
	unsigned char	frame_copied:1;
	unsigned char	address_recognized:1;
	unsigned char	_zero:2;
	unsigned char	frame_copied_1:1;
	unsigned char	address_recognized_1:1;
#else
	unsigned char	address_recognized_1:1;
	unsigned char	frame_copied_1:1;
	unsigned char	_zero:2;
	unsigned char	address_recognized:1;
	unsigned char	frame_copied:1;
	unsigned char	zero:2;
#endif
} _pack FRAME_STATUS;

typedef	_struct	CONTROL_REQUEST_CODE
{
	USHORT sub_command;
	USHORT command;
} _pack CONTROL_REQUEST_CODE;

typedef	union UNION_CONTROL_REQUEST_CODE
{
	CONTROL_REQUEST_CODE	_ushort;
	ULONG						_ulong;
} UNION_CONTROL_REQUEST_CODE;

typedef	_struct SOURCE_ADDRESS
{
#if !defined (BIG_ENDIAN)
	unsigned char	sr_byte:6;
	unsigned char	bit_address:1;
	unsigned char	routing_field_present:1;
#else
	unsigned char	routing_field_present:1;
	unsigned char	bit_address:1;
	unsigned char	sr_byte:6;
#endif

	unsigned char	_byte:8;
	ULONG			_ulong;
} _pack SOURCE_ADDRESS;

typedef	_struct	ROUTING_CONTROL_FIELD
{
#if !defined (BIG_ENDIAN)
	unsigned char	length_of_routing_field:5;
	unsigned char	broadcast_indicators:3;

	unsigned char	reserved:4;
	unsigned char	largest_frame:3;
	unsigned char	direction:1;
#else
	unsigned char	broadcast_indicators:3;
	unsigned char	length_of_routing_field:5;

	unsigned char	direction:1;
	unsigned char	largest_frame:3;
	unsigned char	reserved:4;
#endif
} _pack ROUTING_CONTROL_FIELD;

typedef	union UNION_ROUTING_CONTROL_FIELD
{
	ROUTING_CONTROL_FIELD	_bit;
	USHORT						_ushort;
} UNION_ROUTING_CONTROL_FIELD;

typedef	_struct	ROUTE_DESIGNATOR_FIELD
{
#if !defined (BIG_ENDIAN)
	unsigned char	ring_number_high:8;

	unsigned char	bridge_number:4;
	unsigned char	ring_number:4;
#else
	unsigned char	ring_number_high:8;

	unsigned char	ring_number:4;
	unsigned char	bridge_number:4;
#endif
} _pack ROUTE_DESIGNATOR_FIELD;

typedef	union	UNION_ROUTE_DESIGNATOR_FIELD
{
	ROUTE_DESIGNATOR_FIELD	_bit;
	USHORT 						_ushort;
} UNION_ROUTE_DESIGNATOR_FIELD;

typedef	_struct	ROUTING_INFORMATION_FIELD
{
	UNION_ROUTING_CONTROL_FIELD	control;
	UNION_ROUTE_DESIGNATOR_FIELD	path[8];
} _pack ROUTING_INFORMATION_FIELD;

typedef	_struct	ACCESS_CONTROL
{
#if !defined (BIG_ENDIAN)
	unsigned char	priority_reservation:3;
	unsigned char	monitor_count:1;
	unsigned char	not_token_indicator:1;
	unsigned char	priority:3;
#else
	unsigned char	priority:3;
	unsigned char	not_token_indicator:1;
	unsigned char	monitor_count:1;
	unsigned char	priority_reservation:3;
#endif
} _pack ACCESS_CONTROL;

typedef	union	UNION_ACCESS_CONTROL
{
	ACCESS_CONTROL	_bit;
	BYTE				_byte;
} UNION_ACCESS_CONTROL;

typedef	_struct	FRAME_CONTROL
{
#if !defined (BIG_ENDIAN)
	unsigned char	pcf_attention:4;
	unsigned char	zero:2;
	unsigned char	frame_type:2;
#else
	unsigned char	frame_type:2;
	unsigned char	zero:2;
	unsigned char	pcf_attention:4;
#endif
} _pack FRAME_CONTROL;

typedef	union UNION_FRAME_CONTROL
{
	FRAME_CONTROL	_bit;
	BYTE				_byte;
} UNION_FRAME_CONTROL;

typedef	_struct MAJOR_VECTOR
{
	USHORT									length;

#if !defined (BIG_ENDIAN)
	unsigned char							source_class:4;
	unsigned char							destination_class:4;
#else
	unsigned char							destination_class:4;
	unsigned char							source_class:4;
#endif

	BYTE_ENUM (MAJOR_VECTOR_COMMAND)	command;
} _pack MAJOR_VECTOR;

typedef	_struct	ISOLATING_ERRORS
{
	BYTE	line_error;
	BYTE	internal_error;
	BYTE	burst_error;
	BYTE	AC_error;
	BYTE	abort_delimiter_error;
	BYTE	reserved;
} _pack ISOLATING_ERRORS;

typedef	_struct	NON_ISOLATING_ERRORS
{
	BYTE	lost_frame_error;
	BYTE	receiver_congestion;
	BYTE	frame_copied_error;
	BYTE	frequency_error;
	BYTE	token_error;
	BYTE	reserved;
} _pack NON_ISOLATING_ERRORS;

typedef	_struct	RESPONSE_SUBVECTOR
{
	USHORT_ENUM (MAC_RESPONSE_SUBVECTOR_CODE_VALUES) 	value;

#if !defined (BIG_ENDIAN)
	unsigned char													source_class:4;
	unsigned char													destination_class:4;
#else
	unsigned char													destination_class:4;
	unsigned char													source_class:4;
#endif

	BYTE_ENUM (MAJOR_VECTOR_COMMAND)							major_vector_received;

} _pack RESPONSE_SUBVECTOR;

typedef	union	UNION_SUBVECTOR_VALUE
{
	BYTE													_byte[2];
	USHORT												_ushort;
	TOKEN_RING_ADDRESS								address;
	ULONG													physical_location;
	USHORT_ENUM (REPORT_MONITOR_ERROR_TYPE)	error_type;
	ISOLATING_ERRORS									isolating_error_counts;
	NON_ISOLATING_ERRORS								non_isolating_error_counts;
	RESPONSE_SUBVECTOR								response;
} UNION_SUBVECTOR_VALUE;

typedef	_struct	SUBVECTOR
{
	BYTE										length;
	BYTE_ENUM (SUBVECTOR_TYPES)		type;
	UNION_SUBVECTOR_VALUE				value;
} _pack SUBVECTOR;

typedef	_struct	SUBVECTOR_USHORT_WIDE
{
	BYTE										length;
	BYTE_ENUM (SUBVECTOR_TYPES)		type;
	USHORT									value;
} _pack SUBVECTOR_USHORT_WIDE;

typedef	_struct	SUBVECTOR_ULONG_WIDE
{
	BYTE										length;
	BYTE_ENUM (SUBVECTOR_TYPES)		type;
	ULONG										value;
} _pack SUBVECTOR_ULONG_WIDE;

typedef	_struct	LONG_SUBVECTOR
{
	BYTE										length_ff;
	BYTE_ENUM (SUBVECTOR_TYPES)		type;
	USHORT									length;
	UNION_SUBVECTOR_VALUE				value;
} _pack LONG_SUBVECTOR;

typedef	union	UNION_SUBVECTOR
{
	SUBVECTOR				*_sptr;
	BYTE						*_bptr;
} UNION_SUBVECTOR;

typedef	_struct	TOKEN_RING_HEADER
{
	ACCESS_CONTROL			access_control;
	FRAME_CONTROL			frame_control;

	TOKEN_RING_ADDRESS	destination_address;
	SOURCE_ADDRESS			source_address;
} _pack TOKEN_RING_HEADER;

typedef	_struct	TOKEN_RING_MAC_FRAME
{
	UNION_ACCESS_CONTROL	access_control;
	UNION_FRAME_CONTROL	frame_control;

	TOKEN_RING_ADDRESS	destination_address;
	SOURCE_ADDRESS			source_address;

	MAJOR_VECTOR			major_vector;
	SUBVECTOR				subvector[1];

	BYTE						data[4500]; 
} _pack TOKEN_RING_MAC_FRAME;

typedef	_struct	RESPONSE_MAC_FRAME
{
	ACCESS_CONTROL										access_control;
	FRAME_CONTROL										frame_control;
	TOKEN_RING_ADDRESS								destination_address;
	TOKEN_RING_ADDRESS								source_address;

	MAJOR_VECTOR										major_vector;
	SUBVECTOR_USHORT_WIDE  							correlator_subvector;
	SUBVECTOR											subvector;
} _pack RESPONSE_MAC_FRAME;

typedef	_struct	TOKEN_RING_PACKET
{
	ACCESS_CONTROL			access_control;
	FRAME_CONTROL			frame_control;

	TOKEN_RING_ADDRESS	destination_address;
	SOURCE_ADDRESS			source_address;

	ROUTING_INFORMATION_FIELD			routing_field;

	BYTE						data[0x2000];

	ULONG						crc;

} _pack TOKEN_RING_PACKET;

typedef	_struct	TOKEN_RING_BUFFER
{
	ACCESS_CONTROL			access_control;
	FRAME_CONTROL			frame_control;

	TOKEN_RING_ADDRESS	destination_address;
	SOURCE_ADDRESS			source_address;

	ROUTING_INFORMATION_FIELD			routing_field;

	BYTE						data[0x2000];

	ULONG						crc;

} _pack TOKEN_RING_BUFFER;

typedef	_struct	TOKEN_RING_SOURCE_ROUTED_FRAME
{
	TOKEN_RING_HEADER				mac_header;
	ROUTING_INFORMATION_FIELD	routing_information_field;
	LLC_HEADER						llc_header;
	BYTE								data[1];
} _pack TOKEN_RING_SOURCE_ROUTED_FRAME;

typedef	_struct	TOKEN_RING_SNAP_SOURCE_ROUTED_FRAME
{
	TOKEN_RING_HEADER				mac_header;
	ROUTING_INFORMATION_FIELD	routing_information_field;
	SNAP_HEADER						llc_header;
	BYTE								data[1];
} _pack TOKEN_RING_SNAP_SOURCE_ROUTED_FRAME;

typedef	_struct	TOKEN_RING_LLC_SOURCE_ROUTED_FRAME
{
	TOKEN_RING_HEADER				mac_header;
	ROUTING_INFORMATION_FIELD	routing_information_field;
	LLC_HEADER						llc_header;
	BYTE								data[1];
} _pack TOKEN_RING_LLC_SOURCE_ROUTED_FRAME;

typedef	union	UNION_TOKEN_RING_FRAME
{
	TOKEN_RING_SNAP_SOURCE_ROUTED_FRAME	snap;
	TOKEN_RING_LLC_SOURCE_ROUTED_FRAME	llc;
	TOKEN_RING_SOURCE_ROUTED_FRAME		source_routed;
	TOKEN_RING_MAC_FRAME						mac;
} UNION_TOKEN_RING_FRAME;
