/*
 * $Log: vtrsnstr.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:45  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:13:23  SHAO-GH
 * no message
 *
 * Revision 1.1  1999/11/23 12:51:38  TTY
 * Initial revision
 *
 * 
 * 5     4/30/98 1:16p Rajive
 * Overwrote with INCLUDE v4.2.1
 * 
 * 3     4/27/98 11:42a Release Engineer
 * Additions into include for L2TP and RTM modules.
 * INCLUDE v4.2.1
 * 
 * 1     2/13/98 12:18a Release Engineer
 * code cleanup, code style changes, linted, system level test
 * INCLUDE v4.2.0
 * 
 * 3     5/21/96 7:32p Ross
 * Fixes for token ring header files
 * 
 * 2     3/27/96 7:08p Ross
 * Initial check-in with source safe.
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1998 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca  	*/
/************************************************************************/
/*	$Modname: vtrsnstr.h$  $version: 1.2$      $date: 10/11/93$   */
/*
* 	$lgb$
1.0 10/11/93 ross adding version control.
1.1 10/11/93 ross
1.2 10/11/93 ross version control.
* 	$lge$
*/
typedef	_struct	TOKEN_RING_ADDRESS
{
	USHORT	_ushort;
	ULONG	_ulong;
} _pack TOKEN_RING_ADDRESS;

typedef	_struct	TOKEN_RING_USHORT_ADDRESS
{
	USHORT node[3];
} _pack TOKEN_RING_USHORT_ADDRESS;

typedef	_struct SNMP_RING_STATUS
{
#if !defined (BIG_ENDIAN)
	unsigned char	no_problems_detected:1;
	unsigned char	ring_recovery:1;
	unsigned char	single_station:1;
	unsigned char	remove_received:1;
	unsigned char	reserved:1;
	unsigned char	auto_removal_error:1;
	unsigned char	lobe_wire_fault:1;
	unsigned char	transmit_beacon:1;

	unsigned char	soft_error:1;
	unsigned char	hard_error:1;
	unsigned char	signal_loss:1;
	unsigned char	no_status_open_not_completed:1;

	unsigned char	reserved_1:4;
	unsigned short	reserved_2:16;
#else
	unsigned char	transmit_beacon:1;
	unsigned char	lobe_wire_fault:1;
	unsigned char	auto_removal_error:1;
	unsigned char	reserved:1;
	unsigned char	remove_received:1;
	unsigned char	single_station:1;
	unsigned char	ring_recovery:1;
	unsigned char	no_problems_detected:1;

	unsigned char	reserved_1:4;
	unsigned char	no_status_open_not_completed:1;
	unsigned char	signal_loss:1;
	unsigned char	hard_error:1;
	unsigned char	soft_error:1;

	unsigned short	reserved_2:16;
#endif
} _pack SNMP_RING_STATUS;

typedef	_struct	SNMP_ISOLATING_ERRORS
{
	ULONG	line_error;
	ULONG	burst_error;
	ULONG	AC_error;
	ULONG	abort_delimiter_error;
	ULONG	internal_error;
} _pack SNMP_ISOLATING_ERRORS;

typedef	_struct	SNMP_NON_ISOLATING_ERRORS
{
	ULONG	lost_frame_error;
	ULONG	receiver_congestion;
	ULONG	frame_copied_error;
	ULONG	token_error;
} _pack SNMP_NON_ISOLATING_ERRORS;

typedef	_struct	SNMP_TOKEN_RING_MIB
{
	ULONG												index;
	ULONG_ENUM (TOKEN_RING_COMMAND)			commands;
	SNMP_RING_STATUS								ring_status;
	ULONG_ENUM (RING_STATE_TYPE)				ring_state;
	ULONG_ENUM (RING_OPEN_STATUS_TYPE)		ring_open_status;
	ULONG_ENUM (RING_SPEED_TYPE)				ring_speed;
	TOKEN_RING_ADDRESS							naun;
	ULONG_ENUM (BIG_BOOLEAN)					active_monitor_participant;
	ULONG												functional_mac_address;

	ULONG												error_index;
	SNMP_ISOLATING_ERRORS						isolating_error_counts;
	SNMP_NON_ISOLATING_ERRORS					non_isolating_error_counts;
	ULONG												soft_errors;
	ULONG												hard_errors;
	ULONG												signal_loss;
	ULONG												transmit_beacon;
	ULONG												recoverys;
	ULONG												lobe_wires;
	ULONG												removes;
	ULONG												singles;
	ULONG												frequency_errors;

	ULONG												timer_index;
	ULONG												timer_return_repeat;
	ULONG												timer_holding;
	ULONG												timer_queue_PDU;
	ULONG												timer_valid_tx;
	ULONG												timer_no_token;
	ULONG												timer_active_monitor;
	ULONG												timer_standby_monitor;
	ULONG												timer_error_report;
	ULONG												timer_beacon_tx;
	ULONG												timer_beacon_rx;
} _pack SNMP_TOKEN_RING_MIB;
