/*
 $Log: vbufstr.h,v $
 Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 no message

 Revision 1.1.1.1  2004/01/16 09:32:45  SHAO-GH
 no message

 Revision 1.2  2004/01/12 09:16:17  SHAO-GH
 no message

 Revision 1.1  1999/11/23 12:51:36  TTY
 Initial revision

 * 
 * 1     11/06/98 4:07p Nishit
 * Moved from LSL to include
 * 
 * 4     4/29/98 1:16p Rajive
 * Overwrote with LSL Release v4.4.0.
 * 
 * 1     4/23/98 9:57p Release Engineer
 * code cleanup, code style changes, linted, system level test
 * Added support for LSL without header translation, added support for
 * Fast path IP, added support for queue in between fast path IP and IP, general clean up.
 * LSL v4.4.0
*/
/*	$Modname: vbufstr.h$  $version: 1.7$      $date: 02/21/95$   */
/*
* 	$lgb$
1.0 11/02/93 ross
1.1 11/29/93 ross
1.2 01/08/94 ross More LSL version 3 changes
1.3 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.4 03/09/94 ross added copyright.
1.5 09/01/94 ross added BYTE_ENUM and USHORT_ENUM support.
1.6 09/29/94 ross added BYTE_ENUM and USHORT_ENUM
1.7 02/21/95 ross add close changes.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1998 RouterWare, Inc.							*/
/*	Unpublished - rights reserved under the Copyright Laws of the		*/
/*	United States.  Use, duplication, or disclosure by the 				*/
/*	Government is subject to restrictions as set forth in 				*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 		*/
/*	Computer Software clause at 252.227-7013.							*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach, CA	*/
/************************************************************************/
#if !defined (LINK_TYPEDEF_DEFINED)

	#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

#endif

typedef	union	UNION_LLC_OR_SNAP_HEADER
{
	SNAP_HEADER				snap_header;	/* 0xaa,0xaa,0x03 */
	LLC_HEADER				llc_header;

} UNION_LLC_OR_SNAP_HEADER;

typedef struct		RAW_PACKET
{
	UNION_MAC_HEADER	 	mac_header;
	BYTE						stack_header[1];
} RAW_PACKET;

typedef	struct	CONVERTED_RAW_PACKET
{
	USHORT								length;
	MAC_ADDRESS							destination;
	MAC_ADDRESS							source;
	USHORT_ENUM (LSL_PACKET_TYPE)	packet_type;
} CONVERTED_RAW_PACKET;

typedef struct		TYPE_II_PACKET
{
	UNION_MAC_HEADER	 	mac_header;
	BYTE						stack_header[1];
} TYPE_II_PACKET;

typedef struct		CONVERTED_TYPE_II_PACKET
{
	USHORT_ENUM (SNAP_PROTOCOL_ID)	protocol_type;

	MAC_ADDRESS								destination;
	MAC_ADDRESS								source;
	USHORT_ENUM (LSL_PACKET_TYPE)		packet_type;
	BYTE										stack_header[1];
} CONVERTED_TYPE_II_PACKET;

typedef struct		_8022_PACKET
{
	UNION_MAC_HEADER	 	mac_header;
	LLC_HEADER				llc_header; 
	BYTE						stack_header[1];
} _8022_PACKET;

typedef	struct	CONVERTED_8022_PACKET
{
	LLC_HEADER							llc_header; 
	MAC_ADDRESS							destination;
	MAC_ADDRESS							source;
	USHORT_ENUM (LSL_PACKET_TYPE)	packet_type;
	BYTE									stack_header[1];
} CONVERTED_8022_PACKET;

typedef struct		_8022_SNAP_PACKET
{
	UNION_MAC_HEADER		mac_header;
	SNAP_HEADER				snap_header;	/* 0xaa,0xaa,0x03 */
	BYTE						stack_header[1];
} _8022_SNAP_PACKET;

typedef	struct	CONVERTED_8022_SNAP_PACKET
{
	SNAP_HEADER							snap_header;	/* 0xaa,0xaa,0x03 */
	MAC_ADDRESS							destination;
	MAC_ADDRESS							source;
	USHORT_ENUM (LSL_PACKET_TYPE)	packet_type;
	BYTE									stack_header[1];
} CONVERTED_8022_SNAP_PACKET;

typedef	union	PACKET
{
	RAW_PACKET			raw;
	TYPE_II_PACKET		type_ii;
	_8022_PACKET		_8022;
	_8022_SNAP_PACKET	_8022_snap;
} PACKET;

typedef	union	STACK_PACKET
{
	CONVERTED_RAW_PACKET			raw;
	CONVERTED_TYPE_II_PACKET	type_ii;
	CONVERTED_8022_PACKET		_8022;
	CONVERTED_8022_SNAP_PACKET	_8022_snap;
} STACK_PACKET;

#if defined (DEVICE_DRIVER)
	typedef	union	BUFFER_DATA
	{
		BYTE				data[1];

	} BUFFER_DATA;
#else
	typedef	union	BUFFER_DATA
	{
		STACK_PACKET	stack_packet;
		PACKET			packet;

		BYTE				data[1];

	} BUFFER_DATA;
#endif

typedef	struct	BUFFER_HEADER_LINKS
{
	struct BUFFER_HEADER *sptr_forward_link;
	struct BUFFER_HEADER *sptr_backward_link;
} BUFFER_HEADER_LINKS;

typedef	struct	BUFFER_HEADER
{
	BUFFER_HEADER_LINKS	links;

	BYTE_ENUM (BOOLEAN)	device_driver;
	BYTE_ENUM (BOOLEAN)	in_use;
	BYTE_ENUM (BOOLEAN)	auto_free_on_tx_complete;
	void 						(*fptr_tx_completion) (USHORT port_number,void *sptr_buffer);

	ULONG						rx_device_id;
	ULONG						tx_device_id;
	ULONG						protocol_stack_id;
	USHORT					buffer_number;
	USHORT					rx_virtual_port_number;
	USHORT					tx_virtual_port_number;
	USHORT					rx_real_port_number;
	USHORT					tx_real_port_number;
	USHORT					number_of_bytes;

	USHORT					number_of_broadcasts_left;

	void						*vptr_start_of_transport;

	void						*vptr_start_of_header;

	ULONG						magic_number;

	USHORT					reference_count;
	USHORT					byte_count;				
	void 						*vptr_data;			

	BYTE 						reserved[3 + 64];
} BUFFER_HEADER;

typedef	struct	BUFFER
{
	BUFFER_HEADER	header;

	BUFFER_DATA		data;
} BUFFER;


typedef	struct	LSL_BUFFER_CLASS
{
	ULONG total_size;

	ULONG size_of_device_driver_buffers;
	ULONG start_address_device_driver_buffers;
	ULONG end_address_device_driver_buffers;
	ULONG aligned_start_address_device_driver_buffers;

	ULONG	current_device_driver_buffer;
} LSL_BUFFER_CLASS;
