/*
 * $Log: lslproto.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:44  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:16:00  SHAO-GH
 * no message
 *
 * Revision 1.2  2000/02/21 14:18:46  TTY
 * Changed include files directory
 *
 * 
 *    Revision 1.1   23 Nov 1999 12:51:32   TTY
 * Initial revision.
 * 
 * 26    1/11/99 6:38p Nishit
 * Added prototypes for SNMP
 * 
 * 24    1/06/99 2:57p Nishit
 * Added prototypes for BOOTP Client and Relay Agent, DHCP Client and Server, TFTP Client, and Telnet Server
 * 
 * 23    12/23/98 3:39p Nishit
 * Since PPPOE init function name changed...
 * 
 * 22    12/02/98 7:54p Jack
 * Added __WINROUTER__ ifdef in the  enum LSL_CONTROL_OPERATION around LSL_ROUTERWARE_CONTROL - potential bug identified while
 * testing TCP on big_endian
 * 
 * 21    12/01/98 11:43a Rajive
 * Uncommented the prototypes for OPEN_VIRTUAL_PORT, CLOSE_VIRTUAL_PORT, REINITIALIZE_VIRTUAL_PORT and UNINITIALIZE_VIRTUAL_PORT
 * 
 * 20    11/30/98 4:03p Nishit
 * Added prototypes for init and close for PPPoE and RADIUS
 * 
 * 19    11/24/98 12:46p Nishit
 * Added support for NAT
 * 
 * 18    11/20/98 11:37a Nishit
 * Added init and shutdown prototypes for single build
 * 
 * 17    11/18/98 5:53p Rajive
 * Fixed syntax error
 * 
 * 16    11/18/98 5:50p Rajive
 * Added and delted new enums from the enum PROTOCOL_CONTROL_OPERATION.
 * 
 * 15    11/06/98 6:19p Nishit
 * Added prototypes for RTM, L2TP, Socket... initialize
 * 
 * 14    10/30/98 10:06a Alex
 * New prototype declaration for the initialization of the internal network.
 * 
 * 13    9/11/98 10:11a Nishit
 * Added SET_IP_ADDRESS_AND_MASK_FOR_PORT in enum PROTOCOL_CONTROL_OPERATION
 * 
 * 12    9/03/98 4:11p Nishit
 * Added VPN Interface Virtual Protocol Stack
 * 
 * 11    8/01/98 6:48p Ross
 * Added PPP_OVER_ETHERNET protocol stack type.
 * 
 * 10    7/05/98 4:12p Ross
 * Had to add __KERNEL__ in dll function if defined...a must to build the .vxd's
 * 
 * 9     6/01/98 10:55a Nishit
 * Added values for PAC
 * 
 * 8     5/14/98 1:56p Nishit
 * Added PPTP_GRE_V2_TRANSPORT in enum TRANSPORT_TYPE and PPTP_TUNNEL_CONTROL in enum APPLICATION_TYPE - for PNS
 * 
 * 7     4/30/98 1:16p Rajive
 * Overwrote with INCLUDE v4.2.1
 * 
 * 3     4/27/98 11:42a Release Engineer
 * Additions into include for L2TP and RTM modules.
 * INCLUDE v4.2.1
 * 
 * 1     2/13/98 12:18a Release Engineer
 * code cleanup, code style changes, linted, system level test
 * INCLUDE v4.2.0
 * 
 * 6     9/25/96 7:01p Ross
 * Added transport control changes
 * 
 * 5     9/09/96 5:10p Ross
 * Changes for spanning tree and token ring
 * 
 * 4     5/21/96 7:32p Ross
 * Fixes for token ring header files
 * 
 * 3     4/11/96 6:44p Ross
 * SNMP changes.
 * 
 * 2     3/27/96 7:08p Ross
 * Initial check-in with source safe.
*/
/*	$Modname: lslproto.h$  $version: 1.5$      $date: 02/02/94$   */
/*
* 	$lgb$
1.0 10/11/93 ross adding version control.
1.1 10/11/93 ross added some prototypes.
1.2 10/18/93 ross added lsl frame type and ip header.
1.3 12/03/93 ross fixes for lsl version 3.0
1.4 01/08/94 ross More LSL version 3 changes
1.5 02/02/94 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1998 RouterWare, Inc										*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca  	*/
/************************************************************************/
#ifndef _LSLPROTO_H_
#define _LSLPROTO_H_

#define ILLEGAL_DEVICE_ID 0xffffffffL

#define VIRTUAL_PORT_TYPE	(USHORT) 0x8000

#if !defined (RX_PACKET_STATE_DEFINED)

	#define RX_PACKET_STATE_DEFINED

	enum	RX_PACKET_STATE
	{
		PACKET_NOT_RECOGNIZED,
		PACKET_RECOGNIZED_BUT_NOT_FORWARDED,
		PACKET_RECOGNIZED_AND_FORWARDED
	};

#endif

#if !defined (LINK_TYPEDEF_DEFINED)

	#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

typedef	struct	SINGLE_LINK
{
	struct	SINGLE_LINK	*sptr_forward_link;
} SINGLE_LINK;

#endif

enum LINKED_LIST_COMPARISON_RESULT
{
	LESS_THAN_CURRENT_ELEMENT,
	GREATER_THAN_CURRENT_ELEMENT,
	SAME_AS_CURRENT_ELEMENT,
	ERROR_IN_COMPARISON
};

typedef	struct	LINKED_LIST_INDEX
{
	USHORT 					offset;
	USHORT 					size;
	BYTE_ENUM (BOOLEAN)	_swap;
} LINKED_LIST_INDEX;

typedef	struct	LINKED_LIST_SORT_PARAMETERS
{
	LINK					*sptr_list;
	LINK					*sptr_entry_to_add;

	LINKED_LIST_INDEX	index[5];

} LINKED_LIST_SORT_PARAMETERS;

enum SERIAL_DRIVER_TYPE
{
	ASYNCHRONOUS_SERIAL_DRIVER,
	SYNCHRONOUS_SERIAL_DRIVER
};

enum SERIAL_DRIVER_CONTROL
{
	OPEN_SERIAL_PORT,
	CLOSE_SERIAL_PORT
};

enum APPLICATION_CONTROL_OPERATION
{
	START_APPLICATION,
	TERMINATE_APPLICATION,
	IS_APPLICATION_ENABLED,
	GET_SOCKET_ERROR_VALUE,
	RUN_APPLICATION,
	CONNECTION_COMPLETED,
	CONNECTION_REQUEST_RECEIVED,
	CONNECTION_CLOSED,
	CONNECTION_CLOSED_BY_REMOTE,
	READ_DATA_FROM_SOCKET,
	WRITE_DATA_TO_SOCKET,

	INITIALIZE_FUNCTION_POINTERS,
	GET_NUMBER_OF_VIRTUAL_PORTS,
	CONNECTION_CLOSE_COMPLETED,
	TABLE_MALLOC_MEMORY,
	TABLE_FREE_MEMORY,

	PPTP_RING_INDICATION,
	PPTP_CALL_ABORTED,
	PPTP_TELCO_CALL_DROPPED,
	PPTP_LOCAL_DISCONNECT,
	PPTP_INCOMPLETE_CALL,
	PPTP_TELCO_ANSWER,
	PPTP_LOCAL_CALL_TERMINATE,
	PPTP_TELCO_DISCONNECT,

	_ACO_ULONG_FILLER = 0x10000000L
};

enum TRANSPORT_CONTROL_OPERATION
{
	OPEN_TRANSPORT,
	CLOSE_TRANSPORT,
	IS_TRANSPORT_ENABLED,
	INITIALIZE_SOCKET_TRANSPORT_INTERFACE,
	INITIALIZE_TRANSPORT_FUNCTION_POINTERS,
	GET_NUMBER_OF_TRANSPORT_VIRTUAL_PORTS,
	GET_TRANSPORT_TYPE,
	OPEN_TRANSPORT_VIRTUAL_PORT,
	CLOSE_TRANSPORT_VIRTUAL_PORT,
	CLEAR_POINTER_TO_CACHED_ROUTE,
	CLEAR_ALL_POINTERS_TO_CACHED_ROUTES
};

enum PROTOCOL_CONTROL_OPERATION
{
	OPEN_PROTOCOL_STACK,
	CLOSE_PROTOCOL_STACK,
	GET_IP_ADDRESS_FOR_PORT,

	IS_PROTOCOL_STACK_ENABLED = 0x0100,
	GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS,
	GET_PROTOCOL_STACK_TYPE,
	GET_PROTOCOL_STACK_PROTOCOL_ID,
	GET_PROTOCOL_STACK_SSAP,
	GET_PROTOCOL_STACK_DSAP,
	GET_PROTOCOL_STACK_VIRTUAL_PORT_PACKET_TYPE,
	GET_PROTOCOL_STACK_REAL_PORT_NUMBER_USING_VIRTUAL_PORT_NUMBER,

	INITIALIZE_SOCKET_PROTOCOL_STACK_INTERFACE,

	IS_TOKEN_RING_FRAME_SOURCE_ROUTED,
	IS_TOKEN_RING_FRAME_A_MAC,
	GET_LENGTH_OF_TOKEN_RING_RIF,
	CLEAR_SOURCE_ROUTED_BIT,
	MOVE_RIF_INTO_PACKET,
	IS_MAC_ADDRESS_SOURCE_ROUTED,
	REGISTER_TO_IP_FROM_UPPER_LAYER,

	INITIALIZE_STACK_FUNCTION_POINTERS,
	INITIALIZE_PROTOCOL_FUNCTION_POINTERS,
	GET_PROTOCOL_ADDRESS,
	CLEAR_CACHED_ROUTE,
	REINITIALIZE_PROTOCOL_STACK,
	PROTOCOL_STACK_ROUTERWARE_CONTROL,
	UNINITIALIZE_PROTOCOL_STACK,
	PROTOCOL_ROUTE_ADDED,
	PROTOCOL_ROUTE_DELETED,
	PROTOCOL_ROUTE_CHANGED,
	LLC_PROTOCOL_STACK,
	REGISTER_NAT_FILTER = 200, 
	DEREGISTER_NAT_FILTER,

	OPEN_PROTOCOL_STACK_PORT,
	CLOSE_PROTOCOL_STACK_PORT,
	ADD_IP_ADDRESS_AND_NETWORK_MASK_FOR_PORT,
	ADD_REMOTE_IP_ADDRESS_FOR_PORT,

	OPEN_VIRTUAL_PORT,
	CLOSE_VIRTUAL_PORT,
	REINITIALIZE_VIRTUAL_PORT,
	UNINITIALIZE_VIRTUAL_PORT
/*	SET_IP_ADDRESS_AND_MASK_FOR_PORT */
};

enum LSL_CONTROL_OPERATION
{
	REGISTER_APPLICATION,
	REGISTER_TRANSPORT,
	REGISTER_PROTOCOL_STACK,
	REGISTER_HIGH_LEVEL_DEVICE_DRIVER,
	REGISTER_LOW_LEVEL_DEVICE_DRIVER,
	LSL_REGISTER_SERIAL_DEVICE_DRIVER,

	DEREGISTER_APPLICATION,
	DEREGISTER_TRANSPORT,
	DEREGISTER_PROTOCOL_STACK,
	DEREGISTER_HIGH_LEVEL_DEVICE_DRIVER,
	DEREGISTER_LOW_LEVEL_DEVICE_DRIVER,
	DEREGISTER_SERIAL_DEVICE_DRIVER,

	GET_MAC_ADDRESS,
	GET_RANDOM_NUMBER,
	DEVICE_DRIVER_GET_MAC_ADDRESS,
	GET_REMOTE_CONSOLE_BUFFER_STRING,
	INITIALIZE_BUFFER_CLASS,
	GET_CURRENT_RX_BUFFER_LIST_SIZE,
	SET_CURRENT_RX_BUFFER_LIST_SIZE,
	LSL_GET_BUFFER_SIZE,
	LSL_PORT,
	LOW_LEVEL_DEVICE_DRIVER_PORT,
	HIGH_LEVEL_DEVICE_DRIVER_PORT,
	PROTOCOL_STACK_PORT,
	SERIAL_DRIVER_GET_DEVICE_DRIVER_ID,
	GET_DRIVER_HEADER_SIZE,
	LSL_GET_DEVICE_DRIVER_TYPE_FROM_RECEIVE_PORT,
	GET_NUMBER_OF_WAN_PORTS,
	GET_NUMBER_OF_LAN_PORTS,
	PROTOCOL_STACK_VIRTUAL_PORT,
	RESOLVE_SOCKET_API,

	ADD_LSL_MESSAGE,
	COPY_PROTECTED_MODE_LSL,
	CHECK_LSL,
	CONVERT_STACK_VIRTUAL_TO_REAL_PORT_NUMBER,
	PROTOCOL_STACK_CONTROL,
	REGISTER_LSL_TRAP_FUNCTION,

	GET_SIZE_OF_LSL_CLASS,

	INITIALIZE_LSL_FUNCTION_POINTERS,
	INITIALIZE_SOCKET_FUNCTION_POINTERS,
	INITIALIZE_IP_FUNCTION_POINTERS,
	RESOLVE_FUNCTION_POINTERS,

	INTERNAL_DEVICE_DRIVER_TRANSMIT_COMPLETE,
	GET_LSL_CLASS,

	LSL_RX_LIST_ADD,
	LSL_TX_LIST_PACKET_SENT,
	_UNUSED,
	GET_CHANNEL_OCCUPANCY,
	GET_INTERFACE_ERROR_RATE,

	INFORM_TRANSPORT_PROTOCOL_ON_PORT_STATUS,

	GET_SYSTEM_TIMER,
	GET_ROUTER_TIMER,
	GET_BRIDGE_TIMER,

	SET_PRINTF_BUFFER_ADDRESS,
	VPRINTF,

	CONFIGURE_MODULE_VARIABLE,

	ALLOCATE_LSL_MESSAGE,
	PASS_PARAMETERS,

#if defined (__WINROUTER__)
	LSL_ROUTERWARE_CONTROL,
#endif

	LSL_GET_PACKET_TYPE,

	LSL_SNMP_MIB_ACCESS,

	SET_DEVICE_DRIVER_BUFFER_REFERENCE_COUNT,
	DECREMENT_DEVICE_DRIVER_BUFFER_REFERENCE_COUNT,
	RETURN_DEVICE_DRIVER_RX_BUFFER,
	CALL_MANAGER_AND_DIALER_INTERFACE,

	NUMBER_OF_LSL_CONTROL_OPERATIONS
};

enum DEVICE_CONTROL_OPERATION
{
	OPEN_DEVICE_DRIVER,
	STACK_HAS_REGISTERED,
	CLOSE_DEVICE_DRIVER,
	OPEN_DEVICE_DRIVER_PORT,
	CLOSE_DEVICE_DRIVER_PORT,
	DEVICE_QUERY,
	GET_DEVICE_MAC_ADDRESS,
	LOWER_DEVICE_DRIVER_UP,
	LOWER_DEVICE_DRIVER_DOWN,
	IS_CLASS_ENABLED,
	REGISTER_SERIAL_DEVICE_DRIVER,
	PASSWORD_VERIFICATION,
	PROTOCOL_DOWN,
	PROTOCOL_UP,
	ASYNC_PORT_RESERVE,
	ASYNC_PORT_DIALOUT,
	ASYNC_PORT_WAIT_RING,
	ASYNC_PORT_FREE,
	ADD_PPP_PORT_TO_BUNDLE_NUMBER, 
	REMOVE_PPP_PORT_FROM_BUNDLE_NUMBER
	
};

enum ROUTERWARE_CONTROL_OPERATION
{
	RW_INITIALIZE,
	RW_GET_CLASS_ADDRESS,
	RW_GET_CLASS_SIZE,
	RW_GET_CONFIGURATION_TABLE_ADDRESS,
	RW_LSL_INTERNAL_SEND,
	RW_LSL_INTERNAL_RECEIVE,
	RW_LSL_INTERNAL_PACKET_TRANSMITTED,
	RW_LSL_INTERNAL_RX_BUFFER_RETURN,
	RW_LSL_CLOSE,
	RW_LSL_POLL,
	RW_CLOSE,
	RW_GET_EXPORT_TABLE,
	RW_GET_IMPORT_TABLE,

	RW_MODULE_DEFINED_OPERATION,
	RW_SPECIAL_CONFIGURATION_FUNCTION,
	RW_DYNAMIC_INITIALIZE,
	RW_HALT,
	RW_CLOSE_EVENT,
	RW_SNMP_CONTROL
};

enum DEVICE_DRIVER_TYPE
{
	ETHERNET_DEVICE_DRIVER,
	TOKEN_RING_DEVICE_DRIVER,
	SYNC_DEVICE_DRIVER,
	FRAME_RELAY_DEVICE_DRIVER,
	ASYNC_DEVICE_DRIVER,
	PPP_DEVICE_DRIVER,
	FDDI_DEVICE_DRIVER,
	VIRTUAL_DEVICE_DRIVER
};

enum LSL_PACKET_TYPE
{
	RAW_8023,
	ETHERNET_TYPE_II,
	LLC_PACKET,
	SNAP_PACKET,
	WAN_PACKET,
	SAME_TYPE_AS_RX_PACKET_, /* for future use, DO NOT ALLOW AS A CONFIGURATION OPTION */

	__ENUM_USHORT_FILLER_ = 0x1000
};

enum PROTOCOL_STACK_TYPE
{
	IP_PROTOCOL_STACK,
	IPX_PROTOCOL_STACK,
	SPANNING_TREE_STACK,
	SOURCE_ROUTING_STACK,
	NLSP_PROTOCOL_STACK,
	DLSW_PROTOCOL_STACK,
	OSPF_PROTOCOL_STACK,
	APPLETALK_PROTOCOL_STACK,
	NETBIOS_PROTOCOL_STACK,
	VINES_PROTOCOL_STACK,
	CONSOLE_PROTOCOL_STACK,
	L2TP_PROTOCOL_STACK,
	RTM_PROTOCOL_STACK,
	PPTP_DATA_TUNNEL,
	PPP_OVER_ETHERNET_PROTOCOL_STACK,
	VPN_INTERFACE_VIRTUAL_PROTOCOL_STACK
};

enum TRANSPORT_TYPE
{
	SPX_TRANSPORT,
	TCP_TRANSPORT,
	IGRP_ROUTING,
	BOOTP_CONFIGURATOR,
	RSVP_TRANSPORT,
	DHCP_CLIENT,
	DHCP_SERVER,
	PPTP_GRE_V2_TRANSPORT
};

enum APPLICATION_TYPE
{
	SOCKETS_INTERFACE,
	CONSOLE_APPLICATION,
	DLSW_APPLICATION,
	TFTP_APPLICATION,
	TELNET_APPLICATION,
	DNS_SERVER_APPLICATION,
	DNS_RESOLVER_APPLICATION,
	RAPI_APPLICATION,
	RSVP_APPLICATION,

	TEST_SOCKET_TCP_APPLICATION,
	TEST_SOCKET_UDP_APPLICATION,
	TEST_SOCKET_IPX_APPLICATION,
	TEST_SOCKET_SPX_APPLICATION,
	NAT_APPLICATION,		
	BGP_APPLICATION,
	RADIUS_APPLICATION,
	TACACS_PLUS_APPLICATION,
	SNMP_MANAGEMENT,
	L2TP_PPP_APPLICATION,
	L2TP_CORE_APPLICATION,
	L2TP_TRANSPORT_APPLICATION,
	L2TP_LNS_SERIAL_DRIVER,
	PPTP_TUNNEL_CONTROL
};

typedef union UNION_MODULE_TYPE
{
	enum DEVICE_DRIVER_TYPE		device_driver;
	enum PROTOCOL_STACK_TYPE	protocol_stack;
	enum TRANSPORT_TYPE			transport;
	enum APPLICATION_TYPE		application;
} UNION_MODULE_TYPE;

enum ISO_LAYER_TYPE
{
	PHYSICAL_LAYER_TYPE,
	DATA_LINK_LAYER_TYPE,
	NETWORK_LAYER_TYPE,
	TRANSPORT_LAYER_TYPE,
	SESSION_LAYER_TYPE,
	PRESENTATION_LAYER_TYPE,
	APPLICATION_LAYER_TYPE,
	LINK_SERVICES_LAYER_TYPE,
	OPERATING_SYSTEM_TYPE
};

enum _LSL_CONTROL_OPERATION
{
	IS_LSL_ENABLED,
	ADD_MESSAGE_TO_QUEUE
};


typedef	struct	LSL_MESSAGE_LINK
{
	struct LSL_MESSAGE_LINK	*sptr_forward_link;
	struct LSL_MESSAGE_LINK	*sptr_backward_link;
} LSL_MESSAGE_LINK;


typedef struct LSL_MESSAGE
{
	LSL_MESSAGE_LINK 										links;
	USHORT 													port_number;
	ULONG_ENUM (APPLICATION_CONTROL_OPERATION)	command;
	ULONG 													socket_descriptor;
	void 														*vptr_buffer;
	USHORT 													buffer_size;
	void 														*vptr_context;
	ULONG 													destination_id;
	enum ISO_LAYER_TYPE 									destination_iso_layer_type;
	ULONG 													source_id;
	enum ISO_LAYER_TYPE 									source_iso_layer_type;
	ULONG 													priority;
} LSL_MESSAGE;

typedef _struct LSL_FRAME_RELAY_HEADER
{
	ULONG										virtual_port_number;
	USHORT_ENUM (SNAP_PROTOCOL_ID)	protocol_type;

	MAC_ADDRESS								destination_address;
	MAC_ADDRESS								source_address;
	USHORT_ENUM (LSL_PACKET_TYPE)		lsl_packet_type;
} _pack LSL_FRAME_RELAY_HEADER;

typedef _struct LSL_IP_HEADER
{
	USHORT_ENUM (SNAP_PROTOCOL_ID)	protocol_type;

	MAC_ADDRESS								destination_address;
	MAC_ADDRESS								source_address;
	USHORT_ENUM (LSL_PACKET_TYPE)		lsl_packet_type;
} _pack LSL_IP_HEADER;

typedef	struct	LOW_LEVEL_DEVICE_DRIVER_API
{
	LINK										links;

	USHORT 									port_number;
	char 										*cptr_device_name;
	BYTE_ENUM (SERIAL_DRIVER_TYPE) 	device_driver_type;
	enum TEST 								(*fptr_tx_routine) (USHORT port_number,USHORT virtual_port_number,void *vptr_tx_buffer,
													USHORT number_of_bytes,enum BOOLEAN bridged_packet,enum BOOLEAN protocol_packet,
													void (*fptr_tx_completion)	(USHORT port_number,void *vptr_tx_buffer),void *vptr_original_tx_buffer);
	void 										(*fptr_tx_complete) (USHORT port_number);
	enum BOOLEAN 							(*fptr_rx_routine) (USHORT port_number,void **vptr_buffer,USHORT *usptr_number_of_bytes_rxed);
	void 										(*fptr_timer_routine) (void);
	enum TEST 								(*fptr_control_routine) (enum SERIAL_DRIVER_CONTROL command,ULONG parameter_0,
													ULONG parameter_1);
	void 										(*fptr_rx_buffer_return) (USHORT port_number,void *vptr_buffer);
} LOW_LEVEL_DEVICE_DRIVER_API;

enum SNMP_BOOLEAN
{
	SNMP_BOOLEAN_ENABLED = 0x01,
	SNMP_BOOLEAN_DISABLED = 0x02
};

/* snmp */

#if !defined (__MIB_OPERATION_DEFINED__)
	#define __MIB_OPERATION_DEFINED__

	enum MIB_OPERATION
	{
		GET_OPERATION,
		GET_NEXT_OPERATION,
		SET_OPERATION,
		VERIFY_OPERATION
	};
#endif


/************************************************************************/
#include "rwutils.h"
/************************************************************************/

enum TEST initialize_lsl (ULONG clock_ticks_per_second);
enum TEST close_lsl (void);

extern enum TEST initialize_snmp (ULONG clock_ticks_per_second);
extern enum TEST initialize_vjc (ULONG clock_ticks_per_second);
extern enum TEST initialize_cipx (ULONG clock_ticks_per_second);
extern enum TEST initialize_appletalk_router (ULONG clock_ticks_per_second);
extern enum TEST initialize_console (ULONG clock_ticks_per_second);
extern enum TEST initialize_dlsw_application (ULONG clock_ticks_per_second);
extern enum TEST initialize_server_console (ULONG clock_ticks_per_second);
extern enum TEST initialize_remote_console (ULONG clock_ticks_per_second);
extern enum TEST initialize_netbios_gateway (ULONG clock_ticks_per_second);
extern enum TEST initialize_nvram (char *cptr_file_name,ULONG location_of_ini_file,char *cptr_section_name,
	void *vptr_location_of_configuration_table);
extern enum TEST initialize_internal_network (ULONG clock_ticks_per_second);

/* device drivers */
extern enum TEST initialize_odi (ULONG clock_ticks_per_second);
extern enum TEST initialize_ndis (ULONG clock_ticks_per_second);
extern enum TEST initialize_serial_controller (ULONG clock_ticks_per_second);
extern enum TEST initialize_async_controller (ULONG clock_ticks_per_second);
extern enum TEST initialize_wan_odi_driver (ULONG clock_ticks_per_second);
extern enum TEST initialize_wan_ndis (ULONG clock_ticks_per_second);
extern enum TEST initialize_ppp (ULONG clock_ticks_per_second);
extern enum TEST initialize_pppoe_ac_protocol_stack (ULONG clock_ticks_per_second);
extern enum TEST initialize_frame_relay (ULONG clock_ticks_per_second);
extern void close_ppp (void);

/* protocol stacks */
extern enum TEST initialize_bridge (ULONG clock_ticks_per_second); 
extern enum TEST initialize_source_routing (ULONG clock_ticks_per_second);
extern enum TEST initialize_IPX_router (ULONG clock_ticks_per_second);
extern enum TEST initialize_ip (ULONG ticks_per_second);
extern enum TEST rtm_initialize (ULONG ticks_per_second);
extern enum TEST initialize_igrp (ULONG ticks_per_second);
extern enum TEST initialize_NLSP_router (ULONG clock_ticks_per_second);
extern enum TEST initialize_DLSW_router (ULONG clock_ticks_per_second);
extern enum TEST shut_down_ip_router (void);
extern enum TEST rtm_cleanup_all_protocols (void);

/* transports */
extern enum TEST initialize_spx (ULONG clock_ticks_per_second);
extern enum TEST initialize_tcp (ULONG clock_ticks_per_second);
extern enum TEST initialize_bootp_client (ULONG clock_ticks_per_second);
extern enum TEST initialize_bootp_relay_agent (ULONG clock_ticks_per_second);
extern enum TEST initialize_dhcp_client (ULONG clock_ticks_per_second);
extern enum TEST initialize_dhcp_server (ULONG clock_ticks_per_second);

extern enum TEST close_tcp_transport (void);
extern void close_bootp_client (void);
extern void close_bootp_relay_agent (void);
extern void close_dhcp_client (void);
extern void close_dhcp_server (void);

/* sockets */
extern enum TEST initialize_sockets (ULONG clock_ticks_per_second);
extern void sockets_shutdown (void);

/* applications */

extern enum TEST initialize_nat (ULONG clock_ticks_per_second);
extern enum TEST initialize_radius (ULONG clock_ticks_per_second);
extern enum TEST initialize_telnet (ULONG clock_ticks_per_second);
extern enum TEST initialize_tftp (ULONG clock_ticks_per_second);
extern enum TEST initialize_snmp (ULONG clock_ticks_per_second);

extern void terminate_nat (void);
extern void terminate_radius (void);
extern void close_telnet (void);
extern void close_tftp (void);
extern void close_snmp (void);

/* tunnels related */
extern enum TEST initialize_ppp_tunnel_ep (ULONG clock_ticks_per_second); /* PPP Tunnel Endpoint */
extern enum TEST initialize_l2tp_core (ULONG clock_ticks_per_second);
extern enum TEST initialize_l2tp_ppp (ULONG clock_ticks_per_second);
extern enum TEST initialize_l2tp_transport (ULONG clock_ticks_per_second);
extern enum TEST initialize_lns_serial_driver (ULONG clock_ticks_per_second);

extern void close_l2tp (void);
extern void close_l2tp_ppp (void);
extern void close_l2tp_transport (void);
extern void close_lns_sdd (void);

/* lsltx.c */

enum TEST send_packet (ULONG protocol_stack_id,USHORT port_number,void *sptr_tx_packet,USHORT number_of_bytes,
	enum BOOLEAN do_not_calculate_new_crc,enum BOOLEAN device_driver_buffer,
	void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer));

/* lslbuff.c */

void *device_driver_malloc (USHORT real_port_number,ULONG device_driver_id,USHORT number_of_bytes);
enum TEST device_driver_free (USHORT real_port_number,ULONG device_driver_id,void *vptr_buffer);
enum TEST packet_forward_device_driver_free (USHORT real_tx_port_number,ULONG tx_device_driver_id,void *vptr_buffer_data);

/* lslctrl.c */

#if defined (__WINROUTER__) && !defined (__KERNEL__)
	__declspec(dllexport) ULONG lsl_control (enum LSL_CONTROL_OPERATION command,...);
	__declspec(dllexport) ULONG poll_for_packet_received (enum BOOLEAN return_from_poll);
	__declspec(dllexport) void polling_timer_interrupt (ULONG timer_tick);
	__declspec(dllexport) ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...);
	void routerware_set_event (ULONG event_handle);
#else
	ULONG lsl_control (enum LSL_CONTROL_OPERATION command,...);
	ULONG poll_for_packet_received (enum BOOLEAN return_from_poll);
	void polling_timer_interrupt (ULONG timer_tick);
	ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...);
#endif

/* lsl_old_socket_compatibility.c */

int associate_application_with_socket (int socket_descriptor, ULONG application_id);

#endif /* _LSLPROTO_H_ */
