/*
 * $Log: nat_configuration.h,v $
 * Revision 1.1.1.1  2004/04/01 09:10:05  shao-gh
 * no message
 *
 * Revision 1.1.1.1  2004/01/16 09:32:41  SHAO-GH
 * no message
 *
 * Revision 1.2  2004/01/12 09:16:28  SHAO-GH
 * no message
 *
 * Revision 1.3  2001/03/01 17:59:30  TTY
 * Modified due to change in NAT_PORT_STATIC_ENTRY structure.
 *
 * 
 *    Revision 1.2   21 Feb 2000 15:31:32   TTY
 * Updated to Routerware's NAT release dated 28-Oct-1999
 * 
 *    Revision 1.1   23 Nov 1999 12:47:20   TTY
 * Initial revision.
 * 
 * 6     12/10/98 9:49a Nishit
 * Configurable booleans now use set_enum_enable
 * 
 * 5     10/02/98 9:34a Nishit
 * Setting default value is done now while configuration, instead of setting a boolean while
 * configuration and then while initialization
 * 
 * 4     9/23/98 5:47p Nishit
 * the translation for packet received on local side is now done on local rx as against global tx
 * for NATS (NATG will follow); modified local rx filters,  changes for making code work on SENS
 * (VxWorks); added functionality for dial on demand global port; Upon rx, the first forking is
 * based on global/local rx port (used to be packet type) and then according to packet type; added
 * support for IP fragments
 * 
 * 3     9/08/98 5:04p Nishit
 * Updated copyright notice
 * 
*/
/************************************************************************/
/*	Copyright (C) 1997 - 1998 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
enum TEST set_nat_default_values (char *cptr_value_string);

CONFIGURATION_TABLE nat_configuration_table =
{
	TRUE,
/* _____________________________________________________________________________________________ */

	{
	/* NAT Configuration parameters */

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT =",
		(ULONG) offsetof (NAT_CLASS, enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_nat_default_values,
		NULL,
	"NAT Set Default Values =",
		(ULONG) offsetof (NAT_CLASS, set_default_values),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Single Global Address =",
		(ULONG) offsetof (NAT_CLASS, single_global_address_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT CuSeeMe Handling =",
		(ULONG) offsetof (NAT_CLASS, cuseeme_handling_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{		
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"NAT local class A address =",
		(ULONG) offsetof (NAT_CLASS, local_class_a_address[0]),
		(ULONG) &nat,
		sizeof (IP_ADDRESS)
	},
/* _____________________________________________________________________________________________ */
	{		
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"NAT local class A address mask =",
		(ULONG) offsetof (NAT_CLASS, local_class_a_address_mask[0]),
		(ULONG) &nat,
		sizeof (IP_ADDRESS)
	},
/* _____________________________________________________________________________________________ */
	{		
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ip_address,
		NULL,
	"NAT ICMP Default Address =",
		(ULONG) offsetof (NAT_CLASS, nats.icmp_default_entry.local_ip_address),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"NAT IP Entry Timer =",
		(ULONG) offsetof (NAT_CLASS, ip_translation_entry_timer),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{		
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ip_address,
		NULL,
	"NAT IP global address =",
		(ULONG) offsetof (NAT_CLASS, global_ip_address),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{		
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ip_address,
		NULL,
	"NAT IP global address mask =",
		(ULONG) offsetof (NAT_CLASS, global_ip_address_mask),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Inactivity Timeout on Global Port =",
		(ULONG) offsetof (NAT_CLASS, dial_on_demand.inactivity_timeout_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_uint_decimal_value,
		NULL,
	"NAT IP Inactivity Timeout Timer =",
		(ULONG) offsetof (NAT_CLASS, dial_on_demand.port_deactivation_timeout_value),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"NAT IP Port Enable =",
		(ULONG) offsetof (NAT_CLASS, port[0].enable),
		(ULONG) &nat,
		sizeof (NAT_IP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"NAT IP Port Default Translate Enable =",
		(ULONG) offsetof (NAT_CLASS, port[0].default_translate_enable),
		(ULONG) &nat,
		sizeof (NAT_IP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_string,
		NULL,
	"NAT IP Port Type =",
		(ULONG) offsetof (NAT_CLASS, port[0].type_string[0]),
		(ULONG) &nat,
		sizeof (NAT_IP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"NAT IP Port Address =",
		(ULONG) offsetof (NAT_CLASS, port[0].ip_address),
		(ULONG) &nat,
		sizeof (NAT_IP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"NAT IP Port Mask =",
		(ULONG) offsetof (NAT_CLASS, port[0].mask),
		(ULONG) &nat,
		sizeof (NAT_IP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"NAT TCP Connecting Timer =",
		(ULONG) offsetof (NAT_CLASS, tcp_connecting_timer),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"NAT TCP Connected Timer =",
		(ULONG) offsetof (NAT_CLASS, tcp_connected_timer),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"NAT TCP Closing Timer =",
		(ULONG) offsetof (NAT_CLASS, tcp_closing_timer),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"NAT TCP Disconnected Timer =",
		(ULONG) offsetof (NAT_CLASS, tcp_disconnected_timer),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"NAT TCP Sequence Delta Timer =",
		(ULONG) offsetof (NAT_CLASS, sequence_entry_timer),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"NAT UDP Timer =",
		(ULONG) offsetof (NAT_CLASS, udp_translation_entry_timer),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"NAT ICMP Timer =",
		(ULONG) offsetof (NAT_CLASS, icmp_translation_entry_timer),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Filter Non Corporate Addresses =",
		(ULONG) offsetof (NAT_CLASS, filter_non_corporate_addresses),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Static Entries Enabled =",
		(ULONG) offsetof (NAT_CLASS, static_entries_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"NAT Static Entry Local Address =",
		(ULONG) offsetof (NAT_CLASS, static_entries[0].local_ip_address),
		(ULONG) &nat,
		sizeof (NAT_IP_STATIC_ENTRY)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"NAT Static Entry Global Address =",
		(ULONG) offsetof (NAT_CLASS, static_entries[0].global_ip_address),
		(ULONG) &nat,
		sizeof (NAT_IP_STATIC_ENTRY)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"NAT Static TCP Server Port =",
		(ULONG) offsetof (NAT_CLASS, tcp_static_entries[0].server_port_number_from),
		(ULONG) &nat,
		sizeof (NAT_PORT_STATIC_ENTRY)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"NAT Static TCP Server Address =",
		(ULONG) offsetof (NAT_CLASS, tcp_static_entries[0].local_ip_address),
		(ULONG) &nat,
		sizeof (NAT_PORT_STATIC_ENTRY)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"NAT Static UDP Server Port =",
		(ULONG) offsetof (NAT_CLASS, udp_static_entries[0].server_port_number_from),
		(ULONG) &nat,
		sizeof (NAT_PORT_STATIC_ENTRY)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"NAT Static UDP Server Address =",
		(ULONG) offsetof (NAT_CLASS, udp_static_entries[0].local_ip_address),
		(ULONG) &nat,
		sizeof (NAT_PORT_STATIC_ENTRY)
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Printf =",
		(ULONG) offsetof (NAT_CLASS, printing_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Printf Initialization =",
		(ULONG) offsetof (NAT_CLASS, initialization_printing_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Printf Data =",
		(ULONG) offsetof (NAT_CLASS, data_printing_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Printf Trace =",
		(ULONG) offsetof (NAT_CLASS, trace_printing_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Printf Error =",
		(ULONG) offsetof (NAT_CLASS, error_printing_enabled),
		(ULONG) &nat,
		(ULONG) NULL
	},
#if defined (__NAT_BREAKPOINT__)
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Initialization Breakpoint =",
		(ULONG) offsetof (NAT_CLASS, initialization_breakpoint),
		(ULONG) &nat,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Runtime Breakpoint =",
		(ULONG) offsetof (NAT_CLASS, runtime_breakpoint),
		(ULONG) &nat,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Configuration Breakpoint =",
		(ULONG) offsetof (NAT_CLASS, configuration_breakpoint),
		(ULONG) &nat,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_enum_enable,
		NULL,
	"NAT Shutdown Breakpoint =",
		(ULONG) offsetof (NAT_CLASS, shutdown_breakpoint),
		(ULONG) &nat,
		(ULONG) NULL
	},
#endif /* __NAT_BREAKPOINT__ */
/* _____________________________________________________________________________________________ */
	{
		NULL,
		NULL,
	"",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	}

	}
 };
